/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.encryption;

import java.io.Serializable;
import java.security.KeyException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.crypto.SealedObject;
import org.alfresco.encryption.FallbackEncryptor;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataEncryptor {
    private DictionaryService dictionaryService;
    private FallbackEncryptor encryptor;

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setEncryptor(FallbackEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    public Serializable encrypt(QName propertyQName, Serializable inbound) {
        PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyQName);
        if (inbound == null || propertyDef == null || !propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.ENCRYPTED)) {
            return inbound;
        }
        if (inbound instanceof SealedObject) {
            return inbound;
        }
        Serializable outbound = this.encryptor.sealObject("metadata", null, inbound);
        return outbound;
    }

    public Serializable decrypt(QName propertyQName, Serializable inbound) {
        PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyQName);
        if (inbound == null || propertyDef == null || !propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.ENCRYPTED)) {
            return inbound;
        }
        if (!(inbound instanceof SealedObject)) {
            return inbound;
        }
        try {
            Serializable outbound = this.encryptor.unsealObject("metadata", inbound);
            return outbound;
        }
        catch (KeyException e) {
            throw new AlfrescoRuntimeException("Invalid metadata decryption key", (Throwable)e);
        }
    }

    public Map<QName, Serializable> encrypt(Map<QName, Serializable> inbound) {
        Serializable value;
        HashSet<QName> encryptedProperties = new HashSet<QName>(5);
        for (Map.Entry<QName, Serializable> entry : inbound.entrySet()) {
            QName qname = entry.getKey();
            value = entry.getValue();
            PropertyDefinition propertyDef = this.dictionaryService.getProperty(qname);
            if (propertyDef == null || !propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.ENCRYPTED) || value == null || value instanceof SealedObject) continue;
            encryptedProperties.add(qname);
        }
        if (encryptedProperties.isEmpty()) {
            return inbound;
        }
        HashMap<QName, Serializable> outbound = new HashMap<QName, Serializable>(inbound);
        for (QName propertyQName : encryptedProperties) {
            value = inbound.get(propertyQName);
            Serializable encryptedValue = this.encryptor.sealObject("metadata", null, value);
            outbound.put(propertyQName, encryptedValue);
        }
        return outbound;
    }

    public Map<QName, Serializable> decrypt(Map<QName, Serializable> inbound) {
        Serializable value;
        HashSet<QName> encryptedProperties = new HashSet<QName>(5);
        for (Map.Entry<QName, Serializable> entry : inbound.entrySet()) {
            QName qname = entry.getKey();
            value = entry.getValue();
            PropertyDefinition propertyDef = this.dictionaryService.getProperty(qname);
            if (propertyDef == null || !propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.ENCRYPTED) || value == null || !(value instanceof SealedObject)) continue;
            encryptedProperties.add(qname);
        }
        if (encryptedProperties.isEmpty()) {
            return inbound;
        }
        HashMap<QName, Serializable> outbound = new HashMap<QName, Serializable>(inbound);
        for (QName propertyQName : encryptedProperties) {
            value = inbound.get(propertyQName);
            try {
                Serializable unencryptedValue = this.encryptor.unsealObject("metadata", value);
                outbound.put(propertyQName, unencryptedValue);
            }
            catch (KeyException e) {
                throw new AlfrescoRuntimeException("Invalid metadata decryption key", (Throwable)e);
            }
        }
        return outbound;
    }

    public boolean keyAvailable(String keyAlias) {
        return this.encryptor.keyAvailable(keyAlias);
    }

    public boolean backupKeyAvailable(String keyAlias) {
        return this.encryptor.backupKeyAvailable(keyAlias);
    }
}

