/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.index;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.node.Transaction;
import org.alfresco.repo.node.index.IndexRecovery;
import org.alfresco.repo.search.Indexer;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneQueryParser;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParser;
import org.alfresco.repo.search.impl.lucene.LuceneResultSetRow;
import org.alfresco.repo.search.impl.lucene.fts.FullTextSearchIndexer;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.repo.transaction.TransactionServiceImpl;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.VmShutdownListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReindexComponent
implements IndexRecovery {
    private static Log logger = LogFactory.getLog(AbstractReindexComponent.class);
    private static Log loggerOnThread = LogFactory.getLog((String)(AbstractReindexComponent.class.getName() + ".threads"));
    private static VmShutdownListener vmShutdownListener = new VmShutdownListener("IndexRecovery");
    protected TransactionServiceImpl transactionService;
    protected Indexer indexer;
    protected FullTextSearchIndexer ftsIndexer;
    protected SearchService searcher;
    protected NodeService nodeService;
    protected NodeDAO nodeDAO;
    private ThreadPoolExecutor threadPoolExecutor;
    private TenantService tenantService;
    private Set<String> storeProtocolsToIgnore = new HashSet<String>(7);
    private Set<StoreRef> storesToIgnore = new HashSet<StoreRef>(7);
    private volatile boolean shutdown = false;
    private final ReentrantReadWriteLock.WriteLock indexerWriteLock;
    private static final String KEY_STORE_REFS = "StoreRefCacheMethodInterceptor.StoreRefs";
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger();
    private LinkedBlockingQueue<ReindexWorkerRunnable> reindexThreadQueue = new LinkedBlockingQueue();
    private ReentrantReadWriteLock reindexThreadLock = new ReentrantReadWriteLock(true);

    public AbstractReindexComponent() {
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.indexerWriteLock = readWriteLock.writeLock();
    }

    protected ReentrantReadWriteLock.WriteLock getIndexerWriteLock() {
        return this.indexerWriteLock;
    }

    public void setShutdown(boolean shutdown) {
        this.shutdown = shutdown;
    }

    protected boolean isShuttingDown() {
        return this.shutdown || vmShutdownListener.isVmShuttingDown();
    }

    public void setAuthenticationComponent(AuthenticationComponent authenticationComponent) {
        logger.warn((Object)"Bean property 'authenticationComponent' is no longer required on 'AbstractReindexComponent'.");
    }

    public void setTransactionService(TransactionServiceImpl transactionService) {
        this.transactionService = transactionService;
    }

    public void setIndexer(Indexer indexer) {
        this.indexer = indexer;
    }

    public void setFtsIndexer(FullTextSearchIndexer ftsIndexer) {
        this.ftsIndexer = ftsIndexer;
    }

    public void setSearcher(SearchService searcher) {
        this.searcher = searcher;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setThreadPoolExecutor(ThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolExecutor = threadPoolExecutor;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setStoreProtocolsToIgnore(List<String> storeProtocolsToIgnore) {
        for (String storeProtocolToIgnore : storeProtocolsToIgnore) {
            this.storeProtocolsToIgnore.add(storeProtocolToIgnore);
        }
    }

    public void setStoresToIgnore(List<String> storesToIgnore) {
        for (String storeToIgnore : storesToIgnore) {
            StoreRef storeRef = new StoreRef(storeToIgnore);
            this.storesToIgnore.add(storeRef);
        }
    }

    public boolean isIgnorableStore(StoreRef storeRef) {
        return this.storesToIgnore.contains(storeRef = this.tenantService.getBaseName(storeRef)) || this.storeProtocolsToIgnore.contains(storeRef.getProtocol());
    }

    protected boolean requireTransaction() {
        return true;
    }

    protected abstract void reindexImpl();

    /*
     * Loose catch block
     */
    @Override
    public final void reindex() {
        PropertyCheck.mandatory((Object)this, (String)"ftsIndexer", (Object)this.ftsIndexer);
        PropertyCheck.mandatory((Object)this, (String)"indexer", (Object)this.indexer);
        PropertyCheck.mandatory((Object)this, (String)"searcher", (Object)this.searcher);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"nodeDaoService", (Object)this.nodeDAO);
        PropertyCheck.mandatory((Object)this, (String)"transactionComponent", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"storesToIgnore", this.storesToIgnore);
        PropertyCheck.mandatory((Object)this, (String)"storeProtocolsToIgnore", this.storeProtocolsToIgnore);
        if (this.indexerWriteLock.tryLock()) {
            block14: {
                block13: {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Reindex work started: " + this));
                    }
                    AuthenticationUtil.pushAuthentication();
                    AuthenticationUtil.setRunAsUserSystem();
                    RetryingTransactionHelper.RetryingTransactionCallback<Object> reindexWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                        @Override
                        public Object execute() throws Exception {
                            AbstractReindexComponent.this.reindexImpl();
                            return null;
                        }
                    };
                    if (this.requireTransaction()) {
                        this.transactionService.getRetryingTransactionHelper().doInTransaction(reindexWork, true);
                        break block13;
                    }
                    reindexWork.execute();
                }
                Object var3_3 = null;
                try {
                    this.indexerWriteLock.unlock();
                    break block14;
                }
                catch (Throwable e) {
                    // empty catch block
                }
                {
                    break block14;
                    catch (Throwable e) {
                        throw new AlfrescoRuntimeException("Reindex failure for " + this.getClass().getName(), e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    try {
                        this.indexerWriteLock.unlock();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    AuthenticationUtil.popAuthentication();
                    throw throwable;
                }
            }
            AuthenticationUtil.popAuthentication();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Reindex work completed: " + this));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Bypassed reindex work - already busy: " + this));
        }
    }

    private Set<StoreRef> getAdmStoreRefs() {
        StoreRef storeRef;
        HashSet<StoreRef> storeRefs = (HashSet<StoreRef>)AlfrescoTransactionSupport.getResource(KEY_STORE_REFS);
        if (storeRefs != null) {
            return storeRefs;
        }
        storeRefs = new HashSet<StoreRef>(this.nodeService.getStores());
        Iterator storeRefsIterator = storeRefs.iterator();
        while (storeRefsIterator.hasNext()) {
            storeRef = (StoreRef)storeRefsIterator.next();
            if (!storeRef.getProtocol().equals("avm")) continue;
            storeRefsIterator.remove();
        }
        storeRefsIterator = storeRefs.iterator();
        while (storeRefsIterator.hasNext()) {
            storeRef = (StoreRef)storeRefsIterator.next();
            if (!this.isIgnorableStore(storeRef)) continue;
            storeRefsIterator.remove();
        }
        AlfrescoTransactionSupport.bindResource(KEY_STORE_REFS, storeRefs);
        return storeRefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InIndex isTxnPresentInIndex(Transaction txn) {
        if (txn == null) {
            return InIndex.YES;
        }
        Long txnId = txn.getId();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Checking for transaction in index: " + txnId));
        }
        List<NodeRef.Status> nodeStatuses = this.nodeDAO.getTxnChanges(txnId);
        Set<StoreRef> admStoreRefs = this.getAdmStoreRefs();
        HashMap storeStatusMap = new HashMap(admStoreRefs.size() * 2);
        for (NodeRef.Status nodeStatus : nodeStatuses) {
            void var9_9;
            StoreRef storeRef = nodeStatus.getNodeRef().getStoreRef();
            if (!admStoreRefs.contains(storeRef)) continue;
            List list = (List)storeStatusMap.get(storeRef);
            if (list == null) {
                LinkedList linkedList = new LinkedList();
                storeStatusMap.put(storeRef, linkedList);
            }
            var9_9.add(nodeStatus);
        }
        InIndex result = InIndex.INDETERMINATE;
        for (Map.Entry entry : storeStatusMap.entrySet()) {
            List list = (List)entry.getValue();
            if (list.isEmpty()) continue;
            StoreRef storeRef = (StoreRef)entry.getKey();
            LinkedList<NodeRef> deletedNodes = new LinkedList<NodeRef>();
            boolean hasUpdates = false;
            for (NodeRef.Status nodeStatus : list) {
                if (nodeStatus.isDeleted()) {
                    deletedNodes.add(nodeStatus.getNodeRef());
                    continue;
                }
                if (hasUpdates) continue;
                Serializable serIsIndexed = this.nodeService.getProperty(nodeStatus.getNodeRef(), ContentModel.PROP_IS_INDEXED);
                if (serIsIndexed == null) {
                    hasUpdates = true;
                    continue;
                }
                Boolean isIndexed = (Boolean)DefaultTypeConverter.INSTANCE.convert(Boolean.class, (Object)serIsIndexed);
                if (isIndexed == null) {
                    hasUpdates = true;
                    continue;
                }
                if (!isIndexed.booleanValue()) continue;
                hasUpdates = true;
            }
            if (!deletedNodes.isEmpty() && !this.haveNodesBeenRemovedFromIndex(storeRef, deletedNodes, txn)) {
                result = InIndex.NO;
                break;
            }
            if (!hasUpdates) continue;
            if (this.isTxnIdPresentInIndex(storeRef, txn)) {
                result = InIndex.YES;
                continue;
            }
            result = InIndex.NO;
            break;
        }
        if (!logger.isDebugEnabled()) return result;
        if (result == InIndex.NO) {
            logger.debug((Object)("Transaction " + txnId + " not present in indexes"));
            logger.debug((Object)(nodeStatuses.size() + " nodes in DB transaction"));
            for (NodeRef.Status nodeStatus : nodeStatuses) {
                Object var21_27;
                Field field;
                Iterator fields;
                Document lrsDoc;
                StringBuilder builder;
                SearchParameters sp;
                ResultSet results;
                NodeRef nodeRef;
                block28: {
                    Object var19_26;
                    nodeRef = nodeStatus.getNodeRef();
                    if (nodeStatus.isDeleted()) {
                        logger.debug((Object)("  DELETED TX " + nodeStatus.getChangeTxnId() + ": " + nodeRef));
                    } else {
                        logger.debug((Object)("  UPDATED / MOVED TX " + nodeStatus.getChangeTxnId() + ": " + nodeRef));
                        logger.debug((Object)("    " + this.nodeService.getProperties(nodeRef)));
                    }
                    results = null;
                    sp = new SearchParameters();
                    sp.setLanguage("lucene");
                    sp.addStore(nodeRef.getStoreRef());
                    try {
                        sp.setQuery("ID:" + LuceneQueryParser.escape((String)nodeRef.toString()));
                        results = this.searcher.query(sp);
                        for (ResultSetRow row : results) {
                            builder = new StringBuilder(1024).append("  STILL INDEXED: {");
                            lrsDoc = ((LuceneResultSetRow)row).getDocument();
                            fields = lrsDoc.getFields().iterator();
                            if (fields.hasNext()) {
                                field = (Field)fields.next();
                                builder.append(field.name()).append("=").append(field.stringValue());
                                while (fields.hasNext()) {
                                    field = (Field)fields.next();
                                    builder.append(", ").append(field.name()).append("=").append(field.stringValue());
                                }
                            }
                            builder.append("}");
                            logger.debug((Object)builder.toString());
                        }
                        var19_26 = null;
                        if (results == null) break block28;
                    }
                    catch (Throwable throwable) {
                        var19_26 = null;
                        if (results == null) throw throwable;
                        results.close();
                        throw throwable;
                    }
                    results.close();
                }
                try {
                    sp.setQuery("FTSREF:" + LuceneQueryParser.escape((String)nodeRef.toString()));
                    results = this.searcher.query(sp);
                    for (ResultSetRow row : results) {
                        builder = new StringBuilder(1024).append("  FTSREF: {");
                        lrsDoc = ((LuceneResultSetRow)row).getDocument();
                        fields = lrsDoc.getFields().iterator();
                        if (fields.hasNext()) {
                            field = (Field)fields.next();
                            builder.append(field.name()).append("=").append(field.stringValue());
                            while (fields.hasNext()) {
                                field = (Field)fields.next();
                                builder.append(", ").append(field.name()).append("=").append(field.stringValue());
                            }
                        }
                        builder.append("}");
                        logger.debug((Object)builder.toString());
                    }
                    var21_27 = null;
                    if (results == null) continue;
                }
                catch (Throwable throwable) {
                    var21_27 = null;
                    if (results == null) throw throwable;
                    results.close();
                    throw throwable;
                }
                results.close();
            }
            return result;
        }
        if (!logger.isTraceEnabled()) return result;
        logger.trace((Object)("Transaction " + txnId + " present in indexes: " + (Object)((Object)result)));
        return result;
    }

    public InIndex isTxnPresentInIndex(final Transaction txn, boolean readThrough) {
        return this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<InIndex>(){

            @Override
            public InIndex execute() throws Throwable {
                return AbstractReindexComponent.this.isTxnPresentInIndex(txn);
            }
        }, true, readThrough);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTxnIdPresentInIndex(StoreRef storeRef, Transaction txn) {
        boolean bl;
        block7: {
            ResultSet results;
            long txnId;
            block5: {
                boolean bl2;
                block6: {
                    txnId = txn.getId();
                    String changeTxnId = txn.getChangeTxnId();
                    results = null;
                    try {
                        SearchParameters sp = new SearchParameters();
                        sp.addStore(storeRef);
                        sp.setLanguage("lucene");
                        sp.setQuery("TX:" + AbstractLuceneQueryParser.escape((String)changeTxnId));
                        sp.setLimit(1);
                        results = this.searcher.query(sp);
                        if (results.length() <= 0) break block5;
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("Index has results for txn " + txnId + " for store " + storeRef));
                        }
                        bl2 = true;
                        Object var10_9 = null;
                        if (results == null) break block6;
                    }
                    catch (Throwable throwable) {
                        block8: {
                            Object var10_11 = null;
                            if (results == null) break block8;
                            results.close();
                        }
                        throw throwable;
                    }
                    results.close();
                }
                return bl2;
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Transaction " + txnId + " not in index for store " + storeRef + ".  Possibly out of date."));
            }
            bl = false;
            Object var10_10 = null;
            if (results == null) break block7;
            results.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean haveNodesBeenRemovedFromIndex(StoreRef storeRef, List<NodeRef> nodeRefs, Transaction txn) {
        Long txnId = txn.getId();
        boolean foundNodeRef = false;
        for (NodeRef nodeRef : nodeRefs) {
            Object var11_10;
            ResultSet results;
            block9: {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Searching for node in index: \n   node: " + nodeRef + "\n" + "   txn: " + txnId));
                }
                results = null;
                try {
                    SearchParameters sp = new SearchParameters();
                    sp.addStore(storeRef);
                    sp.setLanguage("lucene");
                    sp.setQuery("ID:" + AbstractLuceneQueryParser.escape((String)nodeRef.toString()));
                    sp.setLimit(1);
                    results = this.searcher.query(sp);
                    if (results.length() <= 0) break block9;
                    foundNodeRef = true;
                    var11_10 = null;
                    if (results == null) break;
                }
                catch (Throwable throwable) {
                    var11_10 = null;
                    if (results != null) {
                        results.close();
                    }
                    throw throwable;
                }
                results.close();
                {
                    break;
                }
            }
            var11_10 = null;
            if (results == null) continue;
            results.close();
            {
            }
        }
        if (foundNodeRef) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)" --> Node found (Index out of date)");
            }
        } else if (logger.isTraceEnabled()) {
            logger.trace((Object)" --> Node not found (OK)");
        }
        return !foundNodeRef;
    }

    protected void reindexTransaction(Long txnId, boolean isFull) {
        this.reindexTransaction(txnId, null, isFull);
    }

    protected void reindexTransaction(final long txnId, ReindexNodeCallback callback, boolean isFull) {
        ParameterCheck.mandatory((String)"txnId", (Object)txnId);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Reindexing transaction: " + txnId));
        }
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_READ_ONLY) {
            throw new AlfrescoRuntimeException("Reindex work must be done in the context of a read-only transaction");
        }
        this.indexer.setReadThrough(true);
        List<Pair<NodeRef.Status, ChildAssociationRef>> nodePairs = this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<List<Pair<NodeRef.Status, ChildAssociationRef>>>(){

            @Override
            public List<Pair<NodeRef.Status, ChildAssociationRef>> execute() throws Throwable {
                List<NodeRef.Status> nodeStatuses = AbstractReindexComponent.this.nodeDAO.getTxnChanges(txnId);
                ArrayList<Pair<NodeRef.Status, ChildAssociationRef>> nodePairs = new ArrayList<Pair<NodeRef.Status, ChildAssociationRef>>(nodeStatuses.size());
                for (NodeRef.Status nodeStatus : nodeStatuses) {
                    if (nodeStatus == null) continue;
                    ChildAssociationRef parent = nodeStatus.isDeleted() ? null : AbstractReindexComponent.this.nodeService.getPrimaryParent(nodeStatus.getNodeRef());
                    nodePairs.add((Pair<NodeRef.Status, ChildAssociationRef>)new Pair((Object)nodeStatus, (Object)parent));
                }
                return nodePairs;
            }
        }, true, true);
        int nodeCount = 0;
        for (Pair<NodeRef.Status, ChildAssociationRef> nodePair : nodePairs) {
            ChildAssociationRef assocRef;
            NodeRef.Status nodeStatus = (NodeRef.Status)nodePair.getFirst();
            NodeRef nodeRef = nodeStatus.getNodeRef();
            if (nodeStatus.isDeleted()) {
                if (!isFull) {
                    assocRef = new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, null, null, nodeRef);
                    this.indexer.deleteNode(assocRef);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("DELETE: " + nodeRef));
                    }
                }
            } else if (isFull) {
                assocRef = new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, null, null, nodeRef);
                this.indexer.createNode(assocRef);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("CREATE: " + nodeRef));
                }
            } else {
                ChildAssociationRef parent = (ChildAssociationRef)nodePair.getSecond();
                if (parent == null) {
                    this.indexer.updateNode(nodeRef);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("UPDATE: " + nodeRef));
                    }
                } else {
                    this.indexer.createChildRelationship(parent);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("MOVE: " + nodeRef + ", " + parent));
                    }
                }
            }
            if (callback != null) {
                callback.reindexedNode(nodeRef);
            }
            if (++nodeCount % 100 != 0 || !this.isShuttingDown()) continue;
            logger.info((Object)("Reindexing of transaction " + txnId + " terminated by VM shutdown."));
            throw new ReindexTerminatedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReindexWorkerRunnable peekHeadReindexWorker() {
        try {
            this.reindexThreadLock.readLock().lock();
            ReindexWorkerRunnable reindexWorkerRunnable = this.reindexThreadQueue.peek();
            Object var3_2 = null;
            this.reindexThreadLock.readLock().unlock();
            return reindexWorkerRunnable;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.reindexThreadLock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reindexTransactionAsynchronously(final List<Long> txnIds, final boolean isFull) {
        if (this.threadPoolExecutor == null || this.threadPoolExecutor.getMaximumPoolSize() < 2) {
            if (loggerOnThread.isDebugEnabled()) {
                String msg = String.format("Reindexing inline: %s.", txnIds.toString());
                loggerOnThread.debug((Object)msg);
            }
            RetryingTransactionHelper.RetryingTransactionCallback<Object> reindexCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                @Override
                public Object execute() throws Throwable {
                    for (Long txnId : txnIds) {
                        if (loggerOnThread.isDebugEnabled()) {
                            String msg = String.format("Reindex %10d.", (long)txnId);
                            loggerOnThread.debug((Object)msg);
                        }
                        AbstractReindexComponent.this.reindexTransaction(txnId, null, isFull);
                    }
                    return null;
                }
            };
            this.transactionService.getRetryingTransactionHelper().doInTransaction(reindexCallback, true, true);
            return;
        }
        ReindexWorkerRunnable runnable = new ReindexWorkerRunnable(txnIds, isFull);
        try {
            this.reindexThreadLock.writeLock().lock();
            this.reindexThreadQueue.add(runnable);
            Object var5_5 = null;
            this.reindexThreadLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.reindexThreadLock.writeLock().unlock();
            throw throwable;
        }
        this.threadPoolExecutor.execute(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void waitForAsynchronousReindexing() {
        ReindexWorkerRunnable lastRunnable = null;
        long lastTimestamp = Long.MAX_VALUE;
        ReindexWorkerRunnable currentRunnable = this.peekHeadReindexWorker();
        while (currentRunnable != null && !this.isShuttingDown()) {
            currentRunnable.setAtHeadOfQueue();
            AbstractReindexComponent abstractReindexComponent = this;
            synchronized (abstractReindexComponent) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            long currentTimestamp = currentRunnable.getLastIndexedTimestamp();
            if (lastRunnable == currentRunnable) {
                if ((double)(currentTimestamp - lastTimestamp) > 6.0E11) {
                    Object var9_9;
                    try {
                        this.reindexThreadLock.writeLock().lock();
                        ReindexWorkerRunnable checkCurrentRunnable = this.reindexThreadQueue.peek();
                        if (lastRunnable == checkCurrentRunnable) {
                            loggerOnThread.warn((Object)("Detected reindex thread inactivity: " + currentRunnable));
                        }
                        lastRunnable = null;
                        lastTimestamp = Long.MAX_VALUE;
                        currentRunnable = this.reindexThreadQueue.peek();
                        var9_9 = null;
                        this.reindexThreadLock.writeLock().unlock();
                        continue;
                    }
                    catch (Throwable throwable) {
                        var9_9 = null;
                        this.reindexThreadLock.writeLock().unlock();
                        throw throwable;
                    }
                }
                lastRunnable = currentRunnable;
                lastTimestamp = currentTimestamp;
            } else {
                lastRunnable = currentRunnable;
                lastTimestamp = currentTimestamp;
            }
            currentRunnable = this.peekHeadReindexWorker();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReindexWorkerRunnable
    extends TransactionListenerAdapter
    implements Runnable,
    ReindexNodeCallback {
        private final int id = AbstractReindexComponent.access$000().addAndGet(1);
        private final int uidHashCode;
        private final List<Long> txnIds;
        private long lastIndexedTimestamp;
        private boolean atHeadOfQueue;
        private boolean isFull;

        private ReindexWorkerRunnable(List<Long> txnIds, boolean isFull) {
            if (ID_GENERATOR.get() > 1000) {
                ID_GENERATOR.set(0);
            }
            this.uidHashCode = this.id * 13 + 11;
            this.txnIds = txnIds;
            this.isFull = isFull;
            this.atHeadOfQueue = false;
            this.recordTimestamp();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("ReindexWorkerRunnable").append("[id=").append(this.id).append("[txnIds=").append(this.txnIds).append("]");
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ReindexWorkerRunnable)) {
                return false;
            }
            ReindexWorkerRunnable that = (ReindexWorkerRunnable)obj;
            return this.id == that.id;
        }

        public int hashCode() {
            return this.uidHashCode;
        }

        public synchronized long getLastIndexedTimestamp() {
            return this.lastIndexedTimestamp;
        }

        private synchronized void recordTimestamp() {
            this.lastIndexedTimestamp = System.nanoTime();
        }

        private synchronized boolean isAtHeadOfQueue() {
            return this.atHeadOfQueue;
        }

        private synchronized void waitForHeadOfQueue() {
            try {
                this.wait(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public synchronized void setAtHeadOfQueue() {
            this.notifyAll();
            this.atHeadOfQueue = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block6: {
                RetryingTransactionHelper.RetryingTransactionCallback<Object> reindexCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                    @Override
                    public Object execute() throws Throwable {
                        AlfrescoTransactionSupport.bindListener(ReindexWorkerRunnable.this);
                        for (Long txnId : ReindexWorkerRunnable.this.txnIds) {
                            if (loggerOnThread.isDebugEnabled()) {
                                String msg = String.format("   -> Reindexer %5d reindexing %10d", ReindexWorkerRunnable.this.id, (long)txnId);
                                loggerOnThread.debug((Object)msg);
                            }
                            AbstractReindexComponent.this.reindexTransaction(txnId, ReindexWorkerRunnable.this, ReindexWorkerRunnable.this.isFull);
                        }
                        return null;
                    }
                };
                this.recordTimestamp();
                try {
                    try {
                        if (loggerOnThread.isDebugEnabled()) {
                            int txnIdsSize = this.txnIds.size();
                            String msg = String.format("Reindexer %5d starting [%10d, %10d] on %s.", this.id, txnIdsSize == 0 ? -1L : this.txnIds.get(0), txnIdsSize == 0 ? -1L : this.txnIds.get(txnIdsSize - 1), Thread.currentThread().getName());
                            loggerOnThread.debug((Object)msg);
                        }
                        AbstractReindexComponent.this.transactionService.getRetryingTransactionHelper().doInTransaction(reindexCallback, true, true);
                    }
                    catch (ReindexTerminatedException e) {
                        String msg = String.format("Reindexer %5d terminated: %s.", this.id, e.getMessage());
                        loggerOnThread.warn((Object)msg);
                        loggerOnThread.warn((Object)this.getStackTrace(e));
                        Object var5_9 = null;
                        this.removeFromQueueAndProdHead();
                        break block6;
                    }
                    catch (Throwable e) {
                        String msg = String.format("Reindexer %5d failed with error: %s.", this.id, e.getMessage());
                        loggerOnThread.error((Object)msg);
                        loggerOnThread.warn((Object)this.getStackTrace(e));
                        Object var5_10 = null;
                        this.removeFromQueueAndProdHead();
                    }
                    Object var5_8 = null;
                    this.removeFromQueueAndProdHead();
                }
                catch (Throwable throwable) {
                    Object var5_11 = null;
                    this.removeFromQueueAndProdHead();
                    throw throwable;
                }
            }
        }

        public String getStackTrace(Throwable t) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            t.printStackTrace(pw);
            pw.flush();
            sw.flush();
            return sw.toString();
        }

        @Override
        public synchronized void reindexedNode(NodeRef nodeRef) {
            this.recordTimestamp();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeFromQueueAndProdHead() {
            try {
                AbstractReindexComponent.this.reindexThreadLock.writeLock().lock();
                AbstractReindexComponent.this.reindexThreadQueue.remove(this);
                Object var2_1 = null;
                AbstractReindexComponent.this.reindexThreadLock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                AbstractReindexComponent.this.reindexThreadLock.writeLock().unlock();
                throw throwable;
            }
            ReindexWorkerRunnable newPeek = AbstractReindexComponent.this.peekHeadReindexWorker();
            if (newPeek != null) {
                newPeek.setAtHeadOfQueue();
            }
            if (loggerOnThread.isDebugEnabled()) {
                String msg = String.format("Reindexer %5d removed from queue.  Current HEAD is %s.", this.id, newPeek);
                loggerOnThread.debug((Object)msg);
            }
        }

        @Override
        public void beforeCommit(boolean readOnly) {
            AbstractReindexComponent.this.indexer.flushPending();
            this.handleQueue();
        }

        @Override
        public void afterCommit() {
            this.recordTimestamp();
        }

        @Override
        public void afterRollback() {
            this.handleQueue();
            this.recordTimestamp();
        }

        private void handleQueue() {
            while (true) {
                ReindexWorkerRunnable peek;
                if ((peek = AbstractReindexComponent.this.peekHeadReindexWorker()) != null) {
                    peek.setAtHeadOfQueue();
                }
                if (peek == null || this.isAtHeadOfQueue()) break;
                this.waitForHeadOfQueue();
            }
        }
    }

    protected static interface ReindexNodeCallback {
        public void reindexedNode(NodeRef var1);
    }

    public static class ReindexTerminatedException
    extends RuntimeException {
        private static final long serialVersionUID = -7928720932368892814L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InIndex {
        YES,
        NO,
        INDETERMINATE;

    }
}

