/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.index;

import org.alfresco.repo.search.Indexer;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class NodeIndexer
extends AbstractLifecycleBean {
    private static Log logger = LogFactory.getLog(NodeIndexer.class);
    private Indexer indexer;
    private volatile boolean started = false;
    private boolean enabled = true;

    public void setDisabled(boolean disabled) {
        this.enabled = !disabled;
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected void onBootstrap(ApplicationEvent event) {
        this.indexer = (Indexer)super.getApplicationContext().getBean("indexerComponent");
        this.started = true;
    }

    protected void onShutdown(ApplicationEvent event) {
        this.started = false;
    }

    public void indexDeleteStore(StoreRef storeRef) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"indexDeleteNode", (Throwable)new Exception("Stack Trace"));
        }
        this.indexer.deleteIndex(storeRef);
    }

    public void indexCreateNode(ChildAssociationRef childAssocRef) {
        if (this.enabled && this.started) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("indexCreateNode: " + childAssocRef), (Throwable)new Exception("Stack Trace"));
            }
            this.indexer.createNode(childAssocRef);
        }
    }

    public void indexUpdateNode(NodeRef nodeRef) {
        if (this.enabled && this.started) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("indexUpdateNode: " + nodeRef), (Throwable)new Exception("Stack Trace"));
            }
            this.indexer.updateNode(nodeRef);
        }
    }

    public void indexDeleteNode(ChildAssociationRef childAssocRef) {
        if (this.enabled && this.started) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("indexDeleteNode: " + childAssocRef), (Throwable)new Exception("Stack Trace"));
            }
            this.indexer.deleteNode(childAssocRef);
        }
    }

    public void indexCreateChildAssociation(ChildAssociationRef childAssocRef) {
        if (this.enabled && this.started) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("indexCreateChildAssociation: " + childAssocRef), (Throwable)new Exception("Stack Trace"));
            }
            this.indexer.createChildRelationship(childAssocRef);
        }
    }

    public void indexDeleteChildAssociation(ChildAssociationRef childAssocRef) {
        if (this.enabled && this.started) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("indexDeleteChildAssociation: " + childAssocRef), (Throwable)new Exception("Stack Trace"));
            }
            this.indexer.deleteChildRelationship(childAssocRef);
        }
    }

    public void indexUpdateChildAssociation(ChildAssociationRef oldChildAssocRef, ChildAssociationRef newChildAssocRef) {
        if (this.enabled && this.started) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("indexUpdateChildAssociation: " + oldChildAssocRef + " -> " + newChildAssocRef), (Throwable)new Exception("Stack Trace"));
            }
            this.indexer.updateChildRelationship(oldChildAssocRef, newChildAssocRef);
        }
    }
}

