/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.preference.script;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.preference.PreferenceService;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptPreferenceService
extends BaseScopableProcessorExtension {
    private ServiceRegistry services;
    private PreferenceService preferenceService;

    public void setServiceRegistry(ServiceRegistry services) {
        this.services = services;
    }

    public void setPreferenceService(PreferenceService preferenceService) {
        this.preferenceService = preferenceService;
    }

    public NativeObject getPreferences(String userName) {
        return this.getPreferences(userName, null);
    }

    public NativeObject getPreferences(String userName, String preferenceFilter) {
        Map<String, Serializable> prefs = this.preferenceService.getPreferences(userName, preferenceFilter);
        NativeObject result = new NativeObject();
        for (Map.Entry<String, Serializable> entry : prefs.entrySet()) {
            String[] keys = entry.getKey().replace(".", "+").split("\\+");
            this.setPrefValue(keys, entry.getValue(), result);
        }
        return result;
    }

    private void setPrefValue(String[] keys, Serializable value, NativeObject object) {
        NativeObject currentObject = object;
        int index = 0;
        for (String key : keys) {
            if (index == keys.length - 1) {
                currentObject.put(key, (Scriptable)currentObject, (Object)value);
            } else {
                NativeObject newObject = null;
                Object temp = currentObject.get(key, (Scriptable)currentObject);
                if (temp == null || !(temp instanceof NativeObject)) {
                    newObject = new NativeObject();
                    currentObject.put(key, (Scriptable)currentObject, (Object)newObject);
                } else {
                    newObject = (NativeObject)temp;
                }
                currentObject = newObject;
            }
            ++index;
        }
    }

    public void setPreferences(String userName, NativeObject preferences) {
        HashMap<String, Serializable> values = new HashMap<String, Serializable>(10);
        this.getPrefValues(preferences, null, values);
        this.preferenceService.setPreferences(userName, values);
    }

    private void getPrefValues(NativeObject currentObject, String currentKey, Map<String, Serializable> values) {
        Object[] ids;
        for (Object id : ids = currentObject.getIds()) {
            String key = this.getAppendedKey(currentKey, id.toString());
            Object value = currentObject.get(id.toString(), (Scriptable)currentObject);
            if (value instanceof NativeObject) {
                this.getPrefValues((NativeObject)value, key, values);
                continue;
            }
            values.put(key, (Serializable)value);
        }
    }

    public void clearPreferences(String userName) {
        this.preferenceService.clearPreferences(userName, null);
    }

    public void clearPreferences(String userName, String preferenceFilter) {
        this.preferenceService.clearPreferences(userName, preferenceFilter);
    }

    private String getAppendedKey(String currentKey, String key) {
        StringBuffer buffer = new StringBuffer(64);
        if (currentKey != null && currentKey.length() != 0) {
            buffer.append(currentKey).append(".").append(key);
        } else {
            buffer.append(key);
        }
        return buffer.toString();
    }
}

