/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.xml.AbstractXmlHttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxbHttpMessageConverter
extends AbstractXmlHttpMessageConverter<Object> {
    private static Log log = LogFactory.getLog(JaxbHttpMessageConverter.class);
    private JAXBContext defaultJaxbContext = null;
    private final ConcurrentMap<Class<?>, JAXBContext> jaxbContexts = new ConcurrentHashMap();

    public JaxbHttpMessageConverter() {
    }

    public JaxbHttpMessageConverter(String packagesToInclude) {
        try {
            this.defaultJaxbContext = JAXBContext.newInstance((String)packagesToInclude);
        }
        catch (JAXBException e) {
            log.error((Object)("Failed to instantiate JAXB context with supplied context path " + packagesToInclude), (Throwable)e);
        }
    }

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return (clazz.isAnnotationPresent(XmlRootElement.class) || clazz.isAnnotationPresent(XmlType.class)) && this.canRead(mediaType);
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return AnnotationUtils.findAnnotation(clazz, XmlRootElement.class) != null && this.canWrite(mediaType);
    }

    protected boolean supports(Class<?> clazz) {
        throw new UnsupportedOperationException();
    }

    protected boolean canWrite(MediaType mediaType) {
        return super.canWrite(mediaType) || MediaType.TEXT_XML.equals((Object)mediaType);
    }

    protected Object readFromSource(Class<?> clazz, HttpHeaders headers, Source source) throws IOException {
        try {
            Unmarshaller unmarshaller = this.createUnmarshaller(clazz);
            if (clazz.isAnnotationPresent(XmlRootElement.class)) {
                return unmarshaller.unmarshal(source);
            }
            JAXBElement jaxbElement = unmarshaller.unmarshal(source, clazz);
            return jaxbElement.getValue();
        }
        catch (UnmarshalException ex) {
            throw new HttpMessageNotReadableException("Could not unmarshal to [" + clazz + "]: " + ex.getMessage(), (Throwable)ex);
        }
        catch (JAXBException ex) {
            throw new HttpMessageConversionException("Could not instantiate JAXBContext: " + ex.getMessage(), (Throwable)ex);
        }
    }

    protected void writeToResult(Object o, HttpHeaders headers, Result result) throws IOException {
        try {
            Class clazz = ClassUtils.getUserClass((Object)o);
            Marshaller marshaller = this.createMarshaller(clazz);
            this.setCharset(headers.getContentType(), marshaller);
            marshaller.marshal(o, result);
        }
        catch (MarshalException ex) {
            throw new HttpMessageNotWritableException("Could not marshal [" + o + "]: " + ex.getMessage(), (Throwable)ex);
        }
        catch (JAXBException ex) {
            throw new HttpMessageConversionException("Could not instantiate JAXBContext: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private void setCharset(MediaType contentType, Marshaller marshaller) throws PropertyException {
        if (contentType != null && contentType.getCharSet() != null) {
            marshaller.setProperty("jaxb.encoding", (Object)contentType.getCharSet().name());
        }
    }

    protected final Marshaller createMarshaller(Class<?> clazz) {
        try {
            JAXBContext jaxbContext = this.getJaxbContext(clazz);
            return jaxbContext.createMarshaller();
        }
        catch (JAXBException ex) {
            throw new HttpMessageConversionException("Could not create Marshaller for class [" + clazz + "]: " + ex.getMessage(), (Throwable)ex);
        }
    }

    protected final Unmarshaller createUnmarshaller(Class<?> clazz) throws JAXBException {
        try {
            JAXBContext jaxbContext = this.getJaxbContext(clazz);
            return jaxbContext.createUnmarshaller();
        }
        catch (JAXBException ex) {
            throw new HttpMessageConversionException("Could not create Unmarshaller for class [" + clazz + "]: " + ex.getMessage(), (Throwable)ex);
        }
    }

    protected final JAXBContext getJaxbContext(Class<?> clazz) {
        Assert.notNull(clazz, (String)"'clazz' must not be null");
        JAXBContext result = null;
        if (this.defaultJaxbContext != null) {
            result = this.defaultJaxbContext;
        } else {
            result = (JAXBContext)this.jaxbContexts.get(clazz);
            if (result == null) {
                try {
                    result = JAXBContext.newInstance((Class[])new Class[]{clazz});
                    this.jaxbContexts.putIfAbsent(clazz, result);
                }
                catch (JAXBException ex) {
                    throw new HttpMessageConversionException("Could not instantiate JAXBContext for class [" + clazz + "]: " + ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return result;
    }
}

