/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.publishing.PublishingEventHelper;
import org.alfresco.repo.publishing.PublishingRootObject;
import org.alfresco.service.cmr.publishing.NodePublishStatus;
import org.alfresco.service.cmr.publishing.PublishingDetails;
import org.alfresco.service.cmr.publishing.PublishingEvent;
import org.alfresco.service.cmr.publishing.PublishingQueue;
import org.alfresco.service.cmr.publishing.PublishingService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublishServiceImpl
implements PublishingService {
    public static final String NAME = "PublishingService";
    private PublishingEventHelper publishingEventHelper;
    private PublishingRootObject rootObject;

    public void setPublishingRootObject(PublishingRootObject rootObject) {
        this.rootObject = rootObject;
    }

    public void setPublishingEventHelper(PublishingEventHelper publishingEventHelper) {
        this.publishingEventHelper = publishingEventHelper;
    }

    @Override
    public PublishingEvent getPublishingEvent(String id) {
        return this.publishingEventHelper.getPublishingEvent(id);
    }

    @Override
    public List<PublishingEvent> getPublishEventsForNode(NodeRef publishedNode) {
        NodeRef queueNode = this.rootObject.getPublishingQueue().getNodeRef();
        List<NodeRef> eventNodes = this.publishingEventHelper.getEventNodesForPublishedNode(queueNode, publishedNode);
        return this.publishingEventHelper.getPublishingEvents(eventNodes);
    }

    @Override
    public List<PublishingEvent> getUnpublishEventsForNode(NodeRef unpublishedNode) {
        NodeRef queueNode = this.rootObject.getPublishingQueue().getNodeRef();
        List<NodeRef> eventNodes = this.publishingEventHelper.getEventNodesForUnpublishedNode(queueNode, unpublishedNode);
        return this.publishingEventHelper.getPublishingEvents(eventNodes);
    }

    @Override
    public void cancelPublishingEvent(String id) {
        ParameterCheck.mandatory((String)"id", (Object)id);
        this.publishingEventHelper.cancelEvent(id);
    }

    private PublishingQueue getPublishingQueue() {
        return this.rootObject.getPublishingQueue();
    }

    public Map<NodeRef, NodePublishStatus> checkPublishStatus(String channelId, Collection<NodeRef> nodes) {
        return null;
    }

    public Map<NodeRef, NodePublishStatus> checkPublishStatus(String channelId, NodeRef ... nodes) {
        return null;
    }

    @Override
    public PublishingDetails createPublishingDetails() {
        return this.getPublishingQueue().createPublishingDetails();
    }

    @Override
    public String scheduleNewEvent(PublishingDetails publishingDetails) {
        return this.getPublishingQueue().scheduleNewEvent(publishingDetails);
    }
}

