/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing;

import java.io.Serializable;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.executer.ActionExecuter;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.publishing.PublishingModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionDefinition;
import org.alfresco.service.cmr.publishing.Status;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public abstract class PublishWebContentProcessTest
extends BaseSpringTest {
    protected ServiceRegistry serviceRegistry;
    protected Repository repositoryHelper;
    protected ActionExecuter publishEventAction;
    protected NodeService nodeService;
    protected WorkflowService workflowService;
    protected RetryingTransactionHelper transactionHelper;
    protected NodeRef event;
    protected String instanceId;
    protected long threadId;

    protected abstract String getWorkflowDefinitionName();

    @Test
    public void testProcessTimers() throws Exception {
        Calendar scheduledTime = Calendar.getInstance();
        scheduledTime.add(13, 5);
        this.startWorkflowAndCommit(scheduledTime);
        this.checkNode("waitForScheduledTime");
        Thread.sleep(10000L);
        this.checkEnded(this.instanceId);
        ((ActionExecuter)Mockito.verify((Object)this.publishEventAction)).execute((Action)Matchers.any(Action.class), (NodeRef)Matchers.any(NodeRef.class));
        PublishWebContentProcessTest.assertFalse((String)"The action should be run from a different Thread!", (Thread.currentThread().getId() == this.threadId ? 1 : 0) != 0);
    }

    public void testProcessNoSchedule() throws Exception {
        this.startWorkflowAndCommit(null);
        Thread.sleep(500L);
        this.checkEnded(this.instanceId);
        ((ActionExecuter)Mockito.verify((Object)this.publishEventAction)).execute((Action)Matchers.any(Action.class), (NodeRef)Matchers.any(NodeRef.class));
        PublishWebContentProcessTest.assertFalse((String)"The action should be run from a different Thread!", (Thread.currentThread().getId() == this.threadId ? 1 : 0) != 0);
    }

    private void checkEnded(String instanceId2) {
        WorkflowInstance instance = this.workflowService.getWorkflowById(instanceId2);
        if (instance.isActive()) {
            List<WorkflowPath> paths = this.workflowService.getWorkflowPaths(instance.getId());
            String nodeName = paths.get(0).getNode().getName();
            PublishWebContentProcessTest.fail((String)("Workflow should have ended! At node: " + nodeName));
        }
    }

    private void startWorkflowAndCommit(final Calendar scheduledTime) {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> startWorkflowCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                WorkflowPath path = PublishWebContentProcessTest.this.startWorkflow(scheduledTime);
                WorkflowTask startTask = PublishWebContentProcessTest.this.workflowService.getStartTask(path.getInstance().getId());
                PublishWebContentProcessTest.this.workflowService.endTask(startTask.getId(), null);
                return null;
            }
        };
        this.transactionHelper.doInTransaction(startWorkflowCallback);
    }

    private WorkflowPath startWorkflow(Calendar scheduledTime) {
        WorkflowDefinition definition = this.workflowService.getDefinitionByName(this.getWorkflowDefinitionName());
        PublishWebContentProcessTest.assertNotNull((String)"The definition is null!", (Object)definition);
        NodeRef pckg = this.workflowService.createPackage(null);
        HashMap<QName, Serializable> params = new HashMap<QName, Serializable>();
        params.put(PublishingModel.PROP_WF_PUBLISHING_EVENT, (Serializable)this.event);
        params.put(PublishingModel.PROP_WF_SCHEDULED_PUBLISH_DATE, scheduledTime);
        params.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)pckg);
        WorkflowPath path = this.workflowService.startWorkflow(definition.getId(), params);
        PublishWebContentProcessTest.assertNotNull((Object)path);
        this.instanceId = path.getInstance().getId();
        return path;
    }

    protected void checkNode(String expNode) {
        List<WorkflowPath> paths = this.workflowService.getWorkflowPaths(this.instanceId);
        PublishWebContentProcessTest.assertEquals((int)1, (int)paths.size());
        WorkflowPath path = paths.get(0);
        PublishWebContentProcessTest.assertEquals((String)expNode, (String)path.getNode().getName());
    }

    @Before
    public void onSetUp() {
        this.serviceRegistry = (ServiceRegistry)this.getApplicationContext().getBean("ServiceRegistry");
        this.repositoryHelper = (Repository)this.getApplicationContext().getBean("repositoryHelper");
        this.publishEventAction = (ActionExecuter)this.getApplicationContext().getBean("pub_publishEvent");
        Mockito.reset((Object[])new ActionExecuter[]{this.publishEventAction});
        ActionDefinition actionDef = (ActionDefinition)Mockito.mock(ActionDefinition.class);
        Mockito.when((Object)this.publishEventAction.getActionDefinition()).thenReturn((Object)actionDef);
        ((ActionExecuter)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                PublishWebContentProcessTest.this.threadId = Thread.currentThread().getId();
                return null;
            }
        }).when((Object)this.publishEventAction)).execute((Action)Matchers.any(Action.class), (NodeRef)Matchers.any(NodeRef.class));
        this.workflowService = this.serviceRegistry.getWorkflowService();
        this.nodeService = this.serviceRegistry.getNodeService();
        this.transactionHelper = this.serviceRegistry.getRetryingTransactionHelper();
        AuthenticationUtil.setRunAsUser((String)AuthenticationUtil.getSystemUserName());
        NodeRef companyHome = this.repositoryHelper.getCompanyHome();
        String name = GUID.generate();
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(ContentModel.PROP_NAME, name);
        props.put(PublishingModel.PROP_PUBLISHING_EVENT_STATUS, Status.SCHEDULED.name());
        QName assocName = QName.createQNameWithValidLocalName((String)"http://www.alfresco.org/model/publishing/1.0", (String)name);
        ChildAssociationRef eventAssoc = this.nodeService.createNode(companyHome, ContentModel.ASSOC_CONTAINS, assocName, PublishingModel.TYPE_PUBLISHING_EVENT, props);
        this.event = eventAssoc.getChildRef();
    }

    protected String[] getConfigLocations() {
        return new String[]{ApplicationContextHelper.CONFIG_LOCATIONS[0], "classpath:test/alfresco/test-web-publishing--workflow-context.xml"};
    }

    @After
    public void onTearDown() {
        try {
            this.workflowService.cancelWorkflow(this.instanceId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.nodeService.deleteNode(this.event);
        AuthenticationUtil.clearCurrentSecurityContext();
    }
}

