/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.service.cmr.publishing.PublishingPackage;
import org.alfresco.service.cmr.publishing.PublishingPackageEntry;
import org.alfresco.service.cmr.repository.NodeRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublishingPackageImpl
implements PublishingPackage {
    private final Map<NodeRef, PublishingPackageEntry> entries;
    private final Set<NodeRef> nodesToPublish;
    private final Set<NodeRef> nodesToUnpublish;

    public PublishingPackageImpl(Map<NodeRef, PublishingPackageEntry> entries) {
        HashSet<NodeRef> toPublish = new HashSet<NodeRef>();
        HashSet<NodeRef> toUnpublish = new HashSet<NodeRef>();
        for (PublishingPackageEntry entry : entries.values()) {
            NodeRef node = entry.getNodeRef();
            if (entry.isPublish()) {
                toPublish.add(node);
                continue;
            }
            toUnpublish.add(node);
        }
        HashMap<NodeRef, PublishingPackageEntry> entryMap = new HashMap<NodeRef, PublishingPackageEntry>(entries);
        this.entries = Collections.unmodifiableMap(entryMap);
        this.nodesToPublish = Collections.unmodifiableSet(toPublish);
        this.nodesToUnpublish = Collections.unmodifiableSet(toUnpublish);
    }

    @Override
    public Collection<PublishingPackageEntry> getEntries() {
        return this.entries.values();
    }

    @Override
    public Map<NodeRef, PublishingPackageEntry> getEntryMap() {
        return this.entries;
    }

    @Override
    public Set<NodeRef> getNodesToPublish() {
        return this.nodesToPublish;
    }

    @Override
    public Set<NodeRef> getNodesToUnpublish() {
        return this.nodesToUnpublish;
    }
}

