/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.publishing.AbstractPublishingIntegrationTest;
import org.alfresco.repo.publishing.PublishingModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.publishing.PublishingDetails;
import org.alfresco.service.cmr.publishing.PublishingEvent;
import org.alfresco.service.cmr.publishing.PublishingPackage;
import org.alfresco.service.cmr.publishing.PublishingPackageEntry;
import org.alfresco.service.cmr.publishing.PublishingService;
import org.alfresco.service.cmr.publishing.Status;
import org.alfresco.service.cmr.publishing.StatusUpdate;
import org.alfresco.service.cmr.publishing.channels.Channel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.junit.Test;

public class PublishingQueueImplTest
extends AbstractPublishingIntegrationTest {
    private static final String channelId = "test://channel/node";
    private static final String comment = "The Comment";
    private PublishingService publishingService;
    private WorkflowService workflowService;

    @Test
    public void testScheduleNewPublishingEvent() throws Exception {
        NodeRef firstNode = this.createContent("First");
        NodeRef secondNode = this.createContent("second");
        PublishingQueueImplTest.assertNull((Object)this.nodeService.getProperty(firstNode, ContentModel.PROP_VERSION_LABEL));
        PublishingQueueImplTest.assertNull((Object)this.nodeService.getProperty(firstNode, ContentModel.PROP_VERSION_LABEL));
        Calendar schedule = Calendar.getInstance();
        schedule.add(10, 2);
        PublishingDetails details = this.publishingService.createPublishingDetails().addNodesToPublish(firstNode, secondNode).setPublishChannelId(channelId).setSchedule(schedule).setComment(comment);
        String eventId = this.testHelper.scheduleEvent(details);
        Serializable version = this.nodeService.getProperty(firstNode, ContentModel.PROP_VERSION_LABEL);
        PublishingQueueImplTest.assertNotNull((Object)version);
        PublishingEvent event = this.publishingService.getPublishingEvent(eventId);
        PublishingQueueImplTest.assertEquals((String)eventId, (String)event.getId());
        PublishingQueueImplTest.assertEquals((String)comment, (String)event.getComment());
        PublishingQueueImplTest.assertEquals((Object)((Object)Status.SCHEDULED), (Object)((Object)event.getStatus()));
        PublishingQueueImplTest.assertEquals((String)AuthenticationUtil.getAdminUserName(), (String)event.getCreator());
        PublishingQueueImplTest.assertEquals((Object)schedule, (Object)event.getScheduledTime());
        PublishingQueueImplTest.assertEquals((String)channelId, (String)event.getChannelId());
        PublishingQueueImplTest.assertNull((Object)event.getStatusUpdate());
        PublishingPackage pckg = event.getPackage();
        ArrayList<NodeRef> toPublish = new ArrayList<NodeRef>(2);
        ArrayList<NodeRef> toUnpublish = new ArrayList<NodeRef>(1);
        for (PublishingPackageEntry entry : pckg.getEntries()) {
            if (entry.isPublish()) {
                PublishingQueueImplTest.assertNotNull((Object)entry.getSnapshot());
                toPublish.add(entry.getNodeRef());
                continue;
            }
            toUnpublish.add(entry.getNodeRef());
        }
        PublishingQueueImplTest.assertEquals((int)2, (int)toPublish.size());
        PublishingQueueImplTest.assertTrue((boolean)toPublish.contains(firstNode));
        PublishingQueueImplTest.assertTrue((boolean)toPublish.contains(secondNode));
        PublishingQueueImplTest.assertEquals((int)0, (int)toUnpublish.size());
        PublishingPackageEntry entry = pckg.getEntryMap().get(firstNode);
        PublishingQueueImplTest.assertEquals((Object)version, (Object)entry.getSnapshot().getVersion());
        NodeRef eventNode = new NodeRef(eventId);
        String wfId = (String)((Object)this.nodeService.getProperty(eventNode, PublishingModel.PROP_PUBLISHING_EVENT_WORKFLOW_ID));
        WorkflowInstance instance = this.workflowService.getWorkflowById(wfId);
        PublishingQueueImplTest.assertNotNull((Object)instance);
        List<WorkflowPath> paths = this.workflowService.getWorkflowPaths(wfId);
        PublishingQueueImplTest.assertEquals((int)2, (int)paths.size());
        Map<QName, Serializable> props = this.workflowService.getPathProperties(paths.get(0).getId());
        PublishingQueueImplTest.assertEquals((Object)eventNode, (Object)props.get(PublishingModel.PROP_WF_PUBLISHING_EVENT));
        PublishingQueueImplTest.assertEquals((Object)schedule, (Object)props.get(PublishingModel.PROP_WF_SCHEDULED_PUBLISH_DATE));
    }

    @Test
    public void testScheduleNewPublishingEventWithStatusUpdate() throws Exception {
        NodeRef firstNode = this.createContent("First");
        NodeRef secondNode = this.createContent("Second");
        List<String> statusChannels = Arrays.asList("test://channel/Channel1", "test://channel/Channel2", "test://channel/Channel3");
        String message = "The message";
        PublishingDetails details = this.publishingService.createPublishingDetails().setPublishChannelId(channelId).addNodesToPublish(firstNode, secondNode).setStatusMessage(message).setStatusNodeToLinkTo(secondNode).addStatusUpdateChannels(statusChannels);
        String eventId = this.testHelper.scheduleEvent1Year(details);
        PublishingEvent event = this.publishingService.getPublishingEvent(eventId);
        StatusUpdate actualUpdate = event.getStatusUpdate();
        PublishingQueueImplTest.assertEquals((String)message, (String)actualUpdate.getMessage());
        PublishingQueueImplTest.assertEquals((Object)secondNode, (Object)actualUpdate.getNodeToLinkTo());
        Set<String> names = actualUpdate.getChannelIds();
        PublishingQueueImplTest.assertEquals((int)3, (int)names.size());
        PublishingQueueImplTest.assertTrue((boolean)names.containsAll(statusChannels));
    }

    @Test
    public void testScheduleNewEventPermissions() throws Exception {
        this.testHelper.mockChannelType("MockChannelType");
        Channel publishChannel = this.testHelper.createChannel("MockChannelType");
        Channel statusChannel = this.testHelper.createChannel("MockChannelType");
        NodeRef firstNode = this.createContent("First");
        NodeRef secondNode = this.createContent("Second");
        String user1 = GUID.generate();
        this.personManager.createPerson(user1);
        this.testHelper.setChannelPermission(user1, publishChannel.getId(), "Read");
        this.testHelper.setChannelPermission(user1, statusChannel.getId(), "Read");
        this.personManager.setUser(user1);
        PublishingDetails details = this.publishingService.createPublishingDetails();
        details.addNodesToPublish(firstNode, secondNode);
        details.setPublishChannelId(publishChannel.getId());
        try {
            this.testHelper.scheduleEvent1Year(details);
            PublishingQueueImplTest.fail((String)"shceduleNewEvent should have thrown an AccessDeniedException!");
        }
        catch (AlfrescoRuntimeException e) {
            // empty catch block
        }
        this.testHelper.allowChannelAccess(user1, publishChannel.getId());
        String eventId = this.testHelper.scheduleEvent1Year(details);
        PublishingQueueImplTest.assertNotNull((Object)eventId);
        String message = "The message";
        details.setStatusMessage(message).setStatusNodeToLinkTo(secondNode).addStatusUpdateChannels(statusChannel.getId());
        try {
            eventId = this.testHelper.scheduleEvent1Year(details);
            PublishingQueueImplTest.fail((String)"shceduleNewEvent with status update should have thrown an AccessDeniedException!");
        }
        catch (AlfrescoRuntimeException e) {
            // empty catch block
        }
        this.testHelper.allowChannelAccess(user1, statusChannel.getId());
        eventId = this.testHelper.scheduleEvent1Year(details);
        PublishingQueueImplTest.assertNotNull((Object)eventId);
    }

    private NodeRef createContent(String name) {
        return this.testHelper.createContentNode(name);
    }

    public void onSetUp() throws Exception {
        super.onSetUp();
        this.workflowService = this.serviceRegistry.getWorkflowService();
        this.publishingService = (PublishingService)this.getApplicationContext().getBean("publishingService");
    }
}

