/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing;

import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.NodeUtils;
import org.alfresco.repo.publishing.Environment;
import org.alfresco.repo.publishing.PublishingEventHelper;
import org.alfresco.repo.publishing.PublishingModel;
import org.alfresco.repo.publishing.PublishingQueueImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.springframework.beans.BeansException;

public class PublishingRootObject {
    public static final String NAME = "publishingRootObject";
    protected static final QName CHANNELS_QNAME = QName.createQName((String)"http://www.alfresco.org/model/publishing/1.0", (String)"channels");
    private NodeService nodeService;
    private PublishingEventHelper publishingEventHelper;
    private NamespaceService namespaceService;
    private SearchService searchService;
    private RetryingTransactionHelper retryingTransactionHelper;
    private PermissionService permissionService;
    private StoreRef publishingStore;
    private String publishingRootPath;

    public Environment getEnvironment() throws BeansException {
        return this.createEnvironment();
    }

    public NodeRef getChannelContainer() {
        return this.getEnvironment().getChannelsContainer();
    }

    public PublishingQueueImpl getPublishingQueue() {
        return this.getEnvironment().getPublishingQueue();
    }

    private Environment createEnvironment() {
        return (Environment)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Environment>(){

            public Environment doWork() throws Exception {
                NodeRef environmentNode = PublishingRootObject.this.getEnvironmentNode();
                PublishingQueueImpl queue = PublishingRootObject.this.createPublishingQueue(environmentNode);
                NodeRef channelsContainer = PublishingRootObject.this.getChannelsContainer(environmentNode);
                return new Environment(environmentNode, queue, channelsContainer);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private NodeRef getChannelsContainer(NodeRef environmentNode) {
        List childAssocs = this.nodeService.getChildAssocs(environmentNode, (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)CHANNELS_QNAME);
        NodeRef channels = NodeUtils.getSingleChildAssocNode(childAssocs, true);
        if (channels == null) {
            channels = this.nodeService.createNode(environmentNode, ContentModel.ASSOC_CONTAINS, CHANNELS_QNAME, ContentModel.TYPE_FOLDER).getChildRef();
        }
        return channels;
    }

    private PublishingQueueImpl createPublishingQueue(NodeRef environmentNode) {
        NodeRef queueNode = this.getPublishingQueueNode(environmentNode);
        return new PublishingQueueImpl(queueNode, this.publishingEventHelper);
    }

    private NodeRef getPublishingQueueNode(NodeRef environmentNode) {
        List childAssocs = this.nodeService.getChildAssocs(environmentNode, (QNamePattern)PublishingModel.ASSOC_PUBLISHING_QUEUE, RegexQNamePattern.MATCH_ALL);
        NodeRef queueNode = NodeUtils.getSingleChildAssocNode(childAssocs, true);
        if (queueNode == null) {
            queueNode = this.nodeService.createNode(environmentNode, PublishingModel.ASSOC_PUBLISHING_QUEUE, QName.createQName((String)"http://www.alfresco.org/model/publishing/1.0", (String)"publishingQueue"), PublishingModel.TYPE_PUBLISHING_QUEUE).getChildRef();
            this.permissionService.setPermission(queueNode, "GROUP_EVERYONE", "AddChildren", true);
        }
        return queueNode;
    }

    private NodeRef getEnvironmentNode() {
        return this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Exception {
                return PublishingRootObject.this.findEnvrionmentNode();
            }
        }, true);
    }

    private NodeRef findEnvrionmentNode() {
        NodeRef rootNode = this.nodeService.getRootNode(this.publishingStore);
        List refs = this.searchService.selectNodes(rootNode, this.publishingRootPath, null, (NamespacePrefixResolver)this.namespaceService, false);
        if (refs.size() != 1) {
            String msg = "Invalid publishing root path: " + this.publishingRootPath + " - found: " + refs.size();
            throw new IllegalStateException(msg);
        }
        return (NodeRef)refs.get(0);
    }

    public void setPublishingStore(String publishingStore) {
        this.publishingStore = new StoreRef(publishingStore);
    }

    public void setPublishingRootPath(String publishingRootPath) {
        this.publishingRootPath = publishingRootPath;
    }

    public void setRetryingTransactionHelper(RetryingTransactionHelper retryingTransactionHelper) {
        this.retryingTransactionHelper = retryingTransactionHelper;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPublishingEventHelper(PublishingEventHelper publishingEventHelper) {
        this.publishingEventHelper = publishingEventHelper;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }
}

