/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing;

import javax.annotation.Resource;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.publishing.AbstractPublishingIntegrationTest;
import org.alfresco.repo.publishing.Environment;
import org.alfresco.repo.publishing.PublishingModel;
import org.alfresco.repo.publishing.PublishingQueueImpl;
import org.alfresco.repo.publishing.PublishingRootObject;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.junit.Test;

public class PublishingRootObjectTest
extends AbstractPublishingIntegrationTest {
    @Resource(name="publishingRootObject")
    private PublishingRootObject rootObject;

    @Test
    public void testGetEnvironment() throws Exception {
        Environment theEnvironment = this.rootObject.getEnvironment();
        PublishingRootObjectTest.assertNotNull((Object)theEnvironment);
        PublishingRootObjectTest.assertTrue((boolean)this.nodeService.exists(theEnvironment.getNodeRef()));
        PublishingRootObjectTest.assertEquals((Object)PublishingModel.TYPE_ENVIRONMENT, (Object)this.nodeService.getType(theEnvironment.getNodeRef()));
    }

    @Test
    public void testGetPublishingQueue() throws Exception {
        PublishingQueueImpl theQueue = this.rootObject.getPublishingQueue();
        PublishingRootObjectTest.assertNotNull((Object)theQueue);
        NodeRef queueNode = theQueue.getNodeRef();
        PublishingRootObjectTest.assertTrue((boolean)this.nodeService.exists(queueNode));
        PublishingRootObjectTest.assertEquals((Object)PublishingModel.TYPE_PUBLISHING_QUEUE, (Object)this.nodeService.getType(queueNode));
        ChildAssociationRef parentAssoc = this.nodeService.getPrimaryParent(queueNode);
        PublishingRootObjectTest.assertEquals((Object)PublishingModel.ASSOC_PUBLISHING_QUEUE, (Object)parentAssoc.getTypeQName());
        PublishingRootObjectTest.assertEquals((Object)this.rootObject.getEnvironment().getNodeRef(), (Object)parentAssoc.getParentRef());
    }

    @Test
    public void testGetChannelContainer() throws Exception {
        NodeRef channels = this.rootObject.getChannelContainer();
        PublishingRootObjectTest.assertNotNull((Object)channels);
        PublishingRootObjectTest.assertTrue((boolean)this.nodeService.exists(channels));
        PublishingRootObjectTest.assertEquals((Object)ContentModel.TYPE_FOLDER, (Object)this.nodeService.getType(channels));
        ChildAssociationRef parentAssoc = this.nodeService.getPrimaryParent(channels);
        PublishingRootObjectTest.assertEquals((Object)PublishingRootObject.CHANNELS_QNAME, (Object)parentAssoc.getQName());
        PublishingRootObjectTest.assertEquals((Object)this.rootObject.getEnvironment().getNodeRef(), (Object)parentAssoc.getParentRef());
    }

    public void onSetUp() throws Exception {
        super.onSetUp();
        this.rootObject = (PublishingRootObject)this.getApplicationContext().getBean("publishingRootObject");
    }
}

