/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing;

import java.io.File;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.publishing.AbstractChannelType;
import org.alfresco.repo.publishing.PublishingModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.publishing.PublishingDetails;
import org.alfresco.service.cmr.publishing.PublishingEvent;
import org.alfresco.service.cmr.publishing.PublishingService;
import org.alfresco.service.cmr.publishing.Status;
import org.alfresco.service.cmr.publishing.channels.Channel;
import org.alfresco.service.cmr.publishing.channels.ChannelService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.mockito.Mockito;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublishingTestHelper {
    private final ChannelService channelService;
    private final PublishingService publishingService;
    private final SiteService siteService;
    private final FileFolderService fileFolderService;
    private final PermissionService permissionService;
    private final NodeRef docLib;
    private final String siteId = GUID.generate();
    private final List<Channel> channels = new LinkedList<Channel>();
    private final List<String> events = new LinkedList<String>();

    public PublishingTestHelper(ChannelService channelService, PublishingService publishingService, SiteService siteService, FileFolderService fileFolderService, PermissionService permissionService) {
        this.channelService = channelService;
        this.publishingService = publishingService;
        this.siteService = siteService;
        this.fileFolderService = fileFolderService;
        this.permissionService = permissionService;
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        siteService.createSite("test", this.siteId, "Test site created by ChannelServiceImplIntegratedTest", "Test site created by ChannelServiceImplIntegratedTest", SiteVisibility.PUBLIC);
        this.docLib = siteService.createContainer(this.siteId, "documentLibrary", ContentModel.TYPE_FOLDER, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() throws Exception {
        Object v1;
        block5: {
            AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
            try {
                this.cancelAllEvents();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object v0;
                Object var2_2 = null;
                try {
                    this.deleteAllChannels();
                    v0 = null;
                }
                catch (Throwable throwable2) {
                    v0 = null;
                }
                Object var4_6 = v0;
                this.deleteSite();
                throw throwable;
            }
            try {
                this.deleteAllChannels();
                v1 = null;
                break block5;
            }
            catch (Throwable throwable) {
                v1 = null;
            }
            {
            }
        }
        Object var4_5 = v1;
        this.deleteSite();
    }

    private void deleteSite() {
        try {
            this.siteService.deleteSite(this.siteId);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void deleteAllChannels() {
        for (Channel channel : this.channels) {
            try {
                this.channelService.deleteChannel(channel);
            }
            catch (Throwable throwable) {}
        }
    }

    private void cancelAllEvents() {
        for (String event : this.events) {
            try {
                this.publishingService.cancelPublishingEvent(event);
            }
            catch (Throwable throwable) {}
        }
    }

    public AbstractChannelType mockChannelType(String channelTypeId) {
        AbstractChannelType channelType = (AbstractChannelType)this.channelService.getChannelType(channelTypeId);
        if (channelType != null) {
            Mockito.reset((Object[])new AbstractChannelType[]{channelType});
            Mockito.when((Object)channelType.getId()).thenReturn((Object)channelTypeId);
        } else {
            channelType = (AbstractChannelType)Mockito.mock(AbstractChannelType.class);
            Mockito.when((Object)channelType.getId()).thenReturn((Object)channelTypeId);
            this.channelService.register(channelType);
        }
        Mockito.when((Object)channelType.getChannelNodeType()).thenReturn((Object)PublishingModel.TYPE_DELIVERY_CHANNEL);
        return channelType;
    }

    public Channel createChannel(String typeId) {
        String channelName = GUID.generate();
        return this.createChannel(typeId, channelName);
    }

    public Channel createChannel(String typeId, String channelName) {
        return this.createChannel(typeId, channelName, true);
    }

    public Channel createChannel(String typeId, String channelName, boolean isAuthorised) {
        Channel channel = this.channelService.createChannel(typeId, channelName, null);
        this.channels.add(channel);
        Map<QName, Serializable> properties = Collections.singletonMap(PublishingModel.PROP_AUTHORISATION_COMPLETE, isAuthorised);
        this.channelService.updateChannel(channel, properties);
        return channel;
    }

    public void allowChannelAccess(String username, String channelId) {
        this.setChannelPermission(username, channelId, "AddChildren");
    }

    public void setChannelPermission(final String username, String channelId, final String permission) {
        final NodeRef channel = new NodeRef(channelId);
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                PublishingTestHelper.this.permissionService.setPermission(channel, username, permission, true);
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    public String scheduleEvent1Year(PublishingDetails details) {
        Calendar schedule = Calendar.getInstance();
        schedule.add(1, 1);
        details.setSchedule(schedule);
        return this.scheduleEvent(details);
    }

    public String scheduleEvent(PublishingDetails details) {
        String eventId = this.publishingService.scheduleNewEvent(details);
        this.events.add(eventId);
        return eventId;
    }

    public void addEvent(String eventId) {
        this.events.add(eventId);
    }

    public void addEvents(Collection<String> eventIds) {
        this.events.addAll(eventIds);
    }

    public NodeRef createContentNode(String name) {
        return this.fileFolderService.create(this.docLib, name, ContentModel.TYPE_CONTENT).getNodeRef();
    }

    public NodeRef createContentNode(String name, File theContent, String mimetype) {
        NodeRef source = this.createContentNode(name);
        this.writeContent(source, theContent, mimetype);
        return source;
    }

    public NodeRef createContentNode(String name, String theContent, String mimetype) {
        NodeRef source = this.fileFolderService.create(this.docLib, name, ContentModel.TYPE_CONTENT).getNodeRef();
        this.writeContent(source, theContent, mimetype);
        return source;
    }

    public void writeContent(NodeRef source, String theContent, String mimetype) {
        ContentWriter writer = this.fileFolderService.getWriter(source);
        writer.setEncoding("UTF-8");
        writer.putContent(theContent);
        writer.setMimetype(mimetype);
    }

    public void writeContent(NodeRef source, File theContent, String mimetype) {
        ContentWriter writer = this.fileFolderService.getWriter(source);
        writer.setMimetype(mimetype);
        writer.setEncoding("UTF-8");
        writer.putContent(theContent);
    }

    public PublishingEvent publishAndWait(final PublishingDetails details, RetryingTransactionHelper transactionHelper) throws InterruptedException {
        RetryingTransactionHelper.RetryingTransactionCallback<String> startWorkflowCallback = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

            @Override
            public String execute() throws Throwable {
                return PublishingTestHelper.this.scheduleEvent(details);
            }
        };
        String eventId = transactionHelper.doInTransaction(startWorkflowCallback);
        for (int i = 0; i < 100; ++i) {
            Thread.sleep(200L);
            PublishingEvent event = this.publishingService.getPublishingEvent(eventId);
            Status status = event.getStatus();
            if (Status.IN_PROGRESS == status || Status.SCHEDULED == status) continue;
            return event;
        }
        throw new IllegalStateException("The publishing event did not complete after 20s!");
    }
}

