/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing.flickr;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.publishing.AbstractOAuth1ChannelType;
import org.alfresco.repo.publishing.PublishingModel;
import org.alfresco.repo.publishing.flickr.FlickrPublishingHelper;
import org.alfresco.repo.publishing.flickr.FlickrPublishingModel;
import org.alfresco.repo.publishing.flickr.springsocial.api.Flickr;
import org.alfresco.repo.publishing.flickr.springsocial.api.MediaOperations;
import org.alfresco.repo.publishing.flickr.springsocial.api.PhotoInfo;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.TempFileProvider;
import org.alfresco.util.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.social.connect.Connection;
import org.springframework.social.oauth1.OAuth1Parameters;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlickrChannelType
extends AbstractOAuth1ChannelType<Flickr> {
    public static final String ID = "flickr";
    private static final Set<String> DEFAULT_SUPPORTED_MIME_TYPES = CollectionUtils.unmodifiableSet((Object[])new String[]{"image/gif", "image/jpeg", "image/png"});
    private static Log log = LogFactory.getLog(FlickrChannelType.class);
    private ContentService contentService;
    private TaggingService taggingService;
    private FlickrPublishingHelper flickrHelper;
    private Set<String> supportedMimeTypes = DEFAULT_SUPPORTED_MIME_TYPES;

    public void setSupportedMimeTypes(Set<String> mimeTypes) {
        this.supportedMimeTypes = Collections.unmodifiableSet(new TreeSet<String>(mimeTypes));
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setTaggingService(TaggingService taggingService) {
        this.taggingService = taggingService;
    }

    public void setFlickrHelper(FlickrPublishingHelper flickrHelper) {
        this.flickrHelper = flickrHelper;
    }

    @Override
    public boolean canPublish() {
        return true;
    }

    @Override
    public boolean canPublishStatusUpdates() {
        return false;
    }

    @Override
    public boolean canUnpublish() {
        return true;
    }

    @Override
    public QName getChannelNodeType() {
        return FlickrPublishingModel.TYPE_DELIVERY_CHANNEL;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public Set<String> getSupportedMimeTypes() {
        return this.supportedMimeTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(NodeRef nodeToPublish, Map<QName, Serializable> channelProperties) {
        block8: {
            NodeService nodeService = this.getNodeService();
            ContentReader reader = this.contentService.getReader(nodeToPublish, ContentModel.PROP_CONTENT);
            if (reader.exists()) {
                File contentFile;
                boolean deleteContentFileOnCompletion = false;
                if (FileContentReader.class.isAssignableFrom(reader.getClass())) {
                    contentFile = ((FileContentReader)reader).getFile();
                } else {
                    File tempDir = TempFileProvider.getLongLifeTempDir((String)ID);
                    contentFile = TempFileProvider.createTempFile((String)ID, (String)"", (File)tempDir);
                    reader.getContent(contentFile);
                    deleteContentFileOnCompletion = true;
                }
                try {
                    String description;
                    FileSystemResource res = new FileSystemResource(contentFile);
                    Connection<Flickr> connection = this.flickrHelper.getConnectionFromChannelProps(channelProperties);
                    String name = (String)((Object)nodeService.getProperty(nodeToPublish, ContentModel.PROP_NAME));
                    String title = (String)((Object)nodeService.getProperty(nodeToPublish, ContentModel.PROP_TITLE));
                    if (title == null || title.length() == 0) {
                        title = name;
                    }
                    if ((description = (String)((Object)nodeService.getProperty(nodeToPublish, ContentModel.PROP_DESCRIPTION))) == null || description.length() == 0) {
                        description = title;
                    }
                    List<String> tags = this.taggingService.getTags(nodeToPublish);
                    String[] tagArray = tags.toArray(new String[tags.size()]);
                    MediaOperations mediaOps = ((Flickr)connection.getApi()).mediaOperations();
                    String id = mediaOps.postPhoto((Resource)res, title, description, tagArray);
                    nodeService.addAspect(nodeToPublish, FlickrPublishingModel.ASPECT_ASSET, null);
                    log.info((Object)("Posted image " + name + " to Flickr with id " + id));
                    nodeService.setProperty(nodeToPublish, PublishingModel.PROP_ASSET_ID, (Serializable)((Object)id));
                    PhotoInfo photoInfo = mediaOps.getPhoto(id);
                    String url = photoInfo.getPrimaryUrl();
                    log.info((Object)("Photo url = " + url));
                    nodeService.setProperty(nodeToPublish, PublishingModel.PROP_ASSET_URL, (Serializable)((Object)url));
                    Object var19_18 = null;
                    if (!deleteContentFileOnCompletion) break block8;
                    contentFile.delete();
                }
                catch (Throwable throwable) {
                    Object var19_19 = null;
                    if (deleteContentFileOnCompletion) {
                        contentFile.delete();
                    }
                    throw throwable;
                }
                {
                }
            }
        }
    }

    @Override
    public void unpublish(NodeRef nodeToUnpublish, Map<QName, Serializable> channelProperties) {
        String assetId;
        NodeService nodeService = this.getNodeService();
        if (nodeService.hasAspect(nodeToUnpublish, FlickrPublishingModel.ASPECT_ASSET) && (assetId = (String)((Object)nodeService.getProperty(nodeToUnpublish, PublishingModel.PROP_ASSET_ID))) != null) {
            Connection<Flickr> connection = this.flickrHelper.getConnectionFromChannelProps(channelProperties);
            MediaOperations mediaOps = ((Flickr)connection.getApi()).mediaOperations();
            mediaOps.deletePhoto(assetId);
            nodeService.removeAspect(nodeToUnpublish, FlickrPublishingModel.ASPECT_ASSET);
            nodeService.removeAspect(nodeToUnpublish, PublishingModel.ASPECT_ASSET);
        }
    }

    @Override
    protected OAuth1Parameters getOAuth1Parameters(String callbackUrl) {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"perms", (Object)"delete");
        return new OAuth1Parameters(callbackUrl, (MultiValueMap)params);
    }
}

