/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing.flickr.springsocial.api.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.social.ExpiredAuthorizationException;
import org.springframework.social.InsufficientPermissionException;
import org.springframework.social.InternalServerErrorException;
import org.springframework.social.InvalidAuthorizationException;
import org.springframework.social.MissingAuthorizationException;
import org.springframework.social.NotAuthorizedException;
import org.springframework.social.OperationNotPermittedException;
import org.springframework.social.ResourceNotFoundException;
import org.springframework.social.RevokedAuthorizationException;
import org.springframework.social.UncategorizedApiException;
import org.springframework.social.facebook.api.NotAFriendException;
import org.springframework.social.facebook.api.ResourceOwnershipException;
import org.springframework.web.client.DefaultResponseErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FlickrErrorHandler
extends DefaultResponseErrorHandler {
    FlickrErrorHandler() {
    }

    public void handleError(ClientHttpResponse response) throws IOException {
        Map<String, String> errorDetails = this.extractErrorDetailsFromResponse(response);
        if (errorDetails == null) {
            this.handleUncategorizedError(response, errorDetails);
        }
        this.handleFlickrError(response.getStatusCode(), errorDetails);
        this.handleUncategorizedError(response, errorDetails);
    }

    public boolean hasError(ClientHttpResponse response) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(response.getBody()));
        return super.hasError(response) || reader.ready() && reader.readLine().startsWith("{\"error\":");
    }

    void handleFlickrError(HttpStatus statusCode, Map<String, String> errorDetails) {
        String message = errorDetails.get("message");
        if (statusCode == HttpStatus.OK) {
            if (message.contains("Some of the aliases you requested do not exist")) {
                throw new ResourceNotFoundException(message);
            }
        } else if (statusCode == HttpStatus.BAD_REQUEST) {
            if (message.contains("Unknown path components")) {
                throw new ResourceNotFoundException(message);
            }
            if (message.equals("An access token is required to request this resource.")) {
                throw new MissingAuthorizationException();
            }
            if (message.equals("An active access token must be used to query information about the current user.")) {
                throw new MissingAuthorizationException();
            }
            if (message.startsWith("Error validating access token")) {
                if (message.contains("Session has expired at unix time")) {
                    throw new ExpiredAuthorizationException();
                }
                if (message.contains("The session has been invalidated because the user has changed the password.")) {
                    throw new RevokedAuthorizationException();
                }
                if (message.contains("The session is invalid because the user logged out.")) {
                    throw new RevokedAuthorizationException();
                }
                if (message.contains("has not authorized application")) {
                    throw new RevokedAuthorizationException();
                }
                throw new InvalidAuthorizationException(message);
            }
            if (message.equals("Error validating application.")) {
                throw new InvalidAuthorizationException(message);
            }
            if (message.equals("Invalid access token signature.")) {
                throw new InvalidAuthorizationException(message);
            }
        } else {
            if (statusCode == HttpStatus.UNAUTHORIZED) {
                throw new NotAuthorizedException(message);
            }
            if (statusCode == HttpStatus.FORBIDDEN) {
                if (message.contains("Requires extended permission")) {
                    String requiredPermission = message.split(": ")[1];
                    throw new InsufficientPermissionException(requiredPermission);
                }
                throw new OperationNotPermittedException(message);
            }
            if (statusCode == HttpStatus.INTERNAL_SERVER_ERROR) {
                if (message.equals("User must be an owner of the friendlist")) {
                    throw new ResourceOwnershipException(message);
                }
                if (message.equals("The member must be a friend of the current user.")) {
                    throw new NotAFriendException(message);
                }
                throw new InternalServerErrorException(message);
            }
        }
    }

    private void handleUncategorizedError(ClientHttpResponse response, Map<String, String> errorDetails) {
        try {
            super.handleError(response);
        }
        catch (Exception e) {
            if (errorDetails != null) {
                throw new UncategorizedApiException(errorDetails.get("message"), (Throwable)e);
            }
            throw new UncategorizedApiException("No error details from Facebook", (Throwable)e);
        }
    }

    private Map<String, String> extractErrorDetailsFromResponse(ClientHttpResponse response) throws IOException {
        return null;
    }
}

