/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing.test;

import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.service.cmr.publishing.channels.ChannelService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SiteType {
    private static final Log log = LogFactory.getLog(SiteType.class);
    private PolicyComponent policyComponent;
    private ChannelService channelService;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnCreateNodePolicy.QNAME, SiteModel.TYPE_SITE, (Behaviour)new JavaBehaviour(this, "onCreateNode", Behaviour.NotificationFrequency.TRANSACTION_COMMIT));
    }

    public void onCreateNode(ChildAssociationRef childAssocRef) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("onCreateNode " + childAssocRef));
        }
        String siteId = childAssocRef.getQName().getLocalName();
        this.channelService.createChannel("TestChannelType1", "Test Channel One", null);
        this.channelService.createChannel("TestChannelType2", "Test Channel Two", null);
        this.channelService.createChannel("TestChannelType3", "Test Channel Three", null);
    }
}

