/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing.twitter;

import org.alfresco.repo.publishing.AbstractOAuth1ChannelType;
import org.alfresco.repo.publishing.twitter.TwitterPublishingModel;
import org.alfresco.service.cmr.publishing.channels.Channel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.social.connect.Connection;
import org.springframework.social.twitter.api.Twitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwitterChannelType
extends AbstractOAuth1ChannelType<Twitter> {
    private static final Log log = LogFactory.getLog(TwitterChannelType.class);
    public static final String ID = "twitter";

    @Override
    public boolean canPublish() {
        return false;
    }

    @Override
    public boolean canPublishStatusUpdates() {
        return true;
    }

    @Override
    public boolean canUnpublish() {
        return false;
    }

    @Override
    public QName getChannelNodeType() {
        return TwitterPublishingModel.TYPE_DELIVERY_CHANNEL;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public int getMaximumStatusLength() {
        return 140;
    }

    @Override
    public void sendStatusUpdate(Channel channel, String status) {
        Connection connection = this.getConnectionForChannel(channel.getNodeRef());
        if (log.isInfoEnabled()) {
            log.info((Object)("Posting update to Twitter channel " + channel.getName() + ": " + status));
        }
        ((Twitter)connection.getApi()).timelineOperations().updateStatus(status);
    }

    @Override
    public String getNodeUrl(NodeRef node) {
        return null;
    }
}

