/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing.youtube;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.publishing.Environment;
import org.alfresco.repo.publishing.PublishingModel;
import org.alfresco.repo.publishing.PublishingQueueImpl;
import org.alfresco.repo.publishing.youtube.YouTubeChannelType;
import org.alfresco.repo.publishing.youtube.YouTubePublishingModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.publishing.channels.Channel;
import org.alfresco.service.cmr.publishing.channels.ChannelService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.junit.Assert;
import org.springframework.core.io.ClassPathResource;

public class YouTubeTest
extends BaseSpringTest {
    protected ServiceRegistry serviceRegistry;
    protected SiteService siteService;
    protected FileFolderService fileFolderService;
    protected NodeService nodeService;
    protected String siteId;
    protected PublishingQueueImpl queue;
    protected Environment environment;
    protected NodeRef docLib;
    private ChannelService channelService;
    private RetryingTransactionHelper transactionHelper;

    public void onSetUp() throws Exception {
        this.serviceRegistry = (ServiceRegistry)this.getApplicationContext().getBean("ServiceRegistry");
        this.channelService = (ChannelService)this.getApplicationContext().getBean("channelService");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.siteService = this.serviceRegistry.getSiteService();
        this.fileFolderService = this.serviceRegistry.getFileFolderService();
        this.nodeService = this.serviceRegistry.getNodeService();
        this.transactionHelper = this.serviceRegistry.getRetryingTransactionHelper();
        this.siteId = GUID.generate();
        this.siteService.createSite("test", this.siteId, "Site created by publishing test", "Site created by publishing test", SiteVisibility.PUBLIC);
        this.docLib = this.siteService.createContainer(this.siteId, "documentLibrary", ContentModel.TYPE_FOLDER, null);
    }

    public void onTearDown() {
        this.siteService.deleteSite(this.siteId);
    }

    public void testBlank() {
    }

    public void xtestYouTubePublishAndUnpublishActions() throws Exception {
        final String channelName = GUID.generate();
        final YouTubeChannelType channelType = (YouTubeChannelType)this.channelService.getChannelType("youtube");
        final NodeRef vidNode = this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                HashMap<QName, Serializable> props = new HashMap<QName, Serializable>();
                props.put(PublishingModel.PROP_CHANNEL_USERNAME, (Serializable)((Object)"YOUR_USER_NAME"));
                props.put(PublishingModel.PROP_CHANNEL_PASSWORD, (Serializable)((Object)"YOUR_PASSWORD"));
                Channel channel = YouTubeTest.this.channelService.createChannel("youtube", channelName, props);
                NodeRef channelNode = channel.getNodeRef();
                ClassPathResource videoFile = new ClassPathResource("test/alfresco/TestVideoFile.MP4");
                HashMap<QName, String> vidProps = new HashMap<QName, String>();
                vidProps.put(ContentModel.PROP_NAME, "Test Video");
                NodeRef vidNode = YouTubeTest.this.nodeService.createNode(channelNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testVideo"), ContentModel.TYPE_CONTENT, vidProps).getChildRef();
                ContentService contentService = YouTubeTest.this.serviceRegistry.getContentService();
                ContentWriter writer = contentService.getWriter(vidNode, ContentModel.PROP_CONTENT, true);
                writer.setMimetype("video/mpg");
                writer.putContent(videoFile.getFile());
                return vidNode;
            }
        });
        this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                channelType.publish(vidNode, YouTubeTest.this.channelService.getChannelByName(channelName).getProperties());
                Map props = YouTubeTest.this.nodeService.getProperties(vidNode);
                Assert.assertTrue((boolean)YouTubeTest.this.nodeService.hasAspect(vidNode, YouTubePublishingModel.ASPECT_ASSET));
                Assert.assertNotNull(props.get(PublishingModel.PROP_ASSET_ID));
                Assert.assertNotNull(props.get(PublishingModel.PROP_ASSET_URL));
                System.out.println("YouTube video: " + props.get(PublishingModel.PROP_ASSET_ID));
                channelType.unpublish(vidNode, YouTubeTest.this.channelService.getChannelByName(channelName).getProperties());
                props = YouTubeTest.this.nodeService.getProperties(vidNode);
                Assert.assertFalse((boolean)YouTubeTest.this.nodeService.hasAspect(vidNode, YouTubePublishingModel.ASPECT_ASSET));
                Assert.assertNull(props.get(PublishingModel.PROP_ASSET_ID));
                Assert.assertNull(props.get(PublishingModel.PROP_ASSET_URL));
                return null;
            }
        });
        this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                YouTubeTest.this.nodeService.deleteNode(vidNode);
                return null;
            }
        });
    }
}

