/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.remote;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.remote.AVMRemoteInputStream;
import org.alfresco.repo.remote.AVMRemoteOutputStream;
import org.alfresco.repo.remote.ClientTicketHolder;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.alfresco.service.cmr.avm.LayeringDescriptor;
import org.alfresco.service.cmr.avm.VersionDescriptor;
import org.alfresco.service.cmr.remote.AVMRemote;
import org.alfresco.service.cmr.remote.AVMRemoteTransport;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVMRemoteImpl
implements AVMRemote {
    private AVMRemoteTransport fTransport;
    private ClientTicketHolder fTicketHolder;

    public void setAvmRemoteTransport(AVMRemoteTransport transport) {
        this.fTransport = transport;
    }

    public void setClientTicketHolder(ClientTicketHolder ticketHolder) {
        this.fTicketHolder = ticketHolder;
    }

    @Override
    public void createStore(String name) {
        this.fTransport.createStore(this.fTicketHolder.getTicket(), name);
    }

    @Override
    public void createBranch(int version, String srcPath, String dstPath, String name) {
        this.fTransport.createBranch(this.fTicketHolder.getTicket(), version, srcPath, dstPath, name);
    }

    @Override
    public void createDirectory(String path, String name) {
        this.fTransport.createDirectory(this.fTicketHolder.getTicket(), path, name);
    }

    @Override
    public OutputStream createFile(String path, String name) {
        return new AVMRemoteOutputStream(this.fTransport.createFile(this.fTicketHolder.getTicket(), path, name), this.fTransport, this.fTicketHolder);
    }

    @Override
    public void createLayeredDirectory(String targetPath, String parent, String name) {
        this.fTransport.createLayeredDirectory(this.fTicketHolder.getTicket(), targetPath, parent, name);
    }

    @Override
    public void createLayeredFile(String targetPath, String parent, String name) {
        this.fTransport.createLayeredFile(this.fTicketHolder.getTicket(), targetPath, parent, name);
    }

    @Override
    public Map<String, Integer> createSnapshot(String store, String label, String comment) {
        return this.fTransport.createSnapshot(this.fTicketHolder.getTicket(), store, label, comment);
    }

    @Override
    public void deleteNodeProperties(String path) {
        this.fTransport.deleteNodeProperties(this.fTicketHolder.getTicket(), path);
    }

    @Override
    public void deleteNodeProperty(String path, QName name) {
        this.fTransport.deleteNodeProperty(this.fTicketHolder.getTicket(), path, name);
    }

    @Override
    public void deleteStoreProperty(String store, QName name) {
        this.fTransport.deleteStoreProperty(this.fTicketHolder.getTicket(), store, name);
    }

    @Override
    public AVMStoreDescriptor getStore(String name) {
        return this.fTransport.getStore(this.fTicketHolder.getTicket(), name);
    }

    @Override
    public AVMNodeDescriptor getStoreRoot(int version, String name) {
        return this.fTransport.getStoreRoot(this.fTicketHolder.getTicket(), version, name);
    }

    @Override
    public List<VersionDescriptor> getStoreVersions(String name) {
        return this.fTransport.getStoreVersions(this.fTicketHolder.getTicket(), name);
    }

    @Override
    public List<VersionDescriptor> getStoreVersions(String name, Date from, Date to) {
        return this.fTransport.getStoreVersions(this.fTicketHolder.getTicket(), name);
    }

    @Override
    public List<AVMStoreDescriptor> getStores() {
        return this.fTransport.getStores(this.fTicketHolder.getTicket());
    }

    @Override
    public AVMNodeDescriptor getCommonAncestor(AVMNodeDescriptor left, AVMNodeDescriptor right) {
        return this.fTransport.getCommonAncestor(this.fTicketHolder.getTicket(), left, right);
    }

    @Override
    public List<String> getDeleted(int version, String path) {
        return this.fTransport.getDeleted(this.fTicketHolder.getTicket(), version, path);
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getDirectoryListing(int version, String path) {
        return this.fTransport.getDirectoryListing(this.fTicketHolder.getTicket(), version, path);
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getDirectoryListing(AVMNodeDescriptor dir) {
        return this.fTransport.getDirectoryListing(this.fTicketHolder.getTicket(), dir);
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getDirectoryListingDirect(int version, String path) {
        return this.fTransport.getDirectoryListing(this.fTicketHolder.getTicket(), version, path);
    }

    @Override
    public InputStream getFileInputStream(int version, String path) {
        return new AVMRemoteInputStream(this.fTransport.getInputHandle(this.fTicketHolder.getTicket(), version, path), this.fTransport, this.fTicketHolder);
    }

    @Override
    public InputStream getFileInputStream(AVMNodeDescriptor desc) {
        return new AVMRemoteInputStream(this.fTransport.getInputHandle(this.fTicketHolder.getTicket(), desc), this.fTransport, this.fTicketHolder);
    }

    @Override
    public OutputStream getFileOutputStream(String path) {
        return new AVMRemoteOutputStream(this.fTransport.getOutputHandle(this.fTicketHolder.getTicket(), path), this.fTransport, this.fTicketHolder);
    }

    @Override
    public List<AVMNodeDescriptor> getHistory(AVMNodeDescriptor desc, int count) {
        return this.fTransport.getHistory(this.fTicketHolder.getTicket(), desc, count);
    }

    @Override
    public String getIndirectionPath(int version, String path) {
        return this.fTransport.getIndirectionPath(this.fTicketHolder.getTicket(), version, path);
    }

    @Override
    public int getLatestSnapshotID(String storeName) {
        return this.fTransport.getLatestSnapshotID(this.fTicketHolder.getTicket(), storeName);
    }

    @Override
    public int getNextVersionID(String storeName) {
        return this.fTransport.getNextVersionID(this.fTicketHolder.getTicket(), storeName);
    }

    @Override
    public LayeringDescriptor getLayeringInfo(int version, String path) {
        return this.fTransport.getLayeringInfo(this.fTicketHolder.getTicket(), version, path);
    }

    @Override
    public Map<QName, PropertyValue> getNodeProperties(int version, String path) {
        return this.fTransport.getNodeProperties(this.fTicketHolder.getTicket(), version, path);
    }

    @Override
    public PropertyValue getNodeProperty(int version, String path, QName name) {
        return this.fTransport.getNodeProperty(this.fTicketHolder.getTicket(), version, path, name);
    }

    @Override
    public Map<QName, PropertyValue> getStoreProperties(String store) {
        return this.fTransport.getStoreProperties(this.fTicketHolder.getTicket(), store);
    }

    @Override
    public PropertyValue getStoreProperty(String store, QName name) {
        return this.fTransport.getStoreProperty(this.fTicketHolder.getTicket(), store, name);
    }

    @Override
    public AVMNodeDescriptor lookup(int version, String path) {
        return this.fTransport.lookup(this.fTicketHolder.getTicket(), version, path);
    }

    @Override
    public AVMNodeDescriptor lookup(int version, String path, boolean includeDeleted) {
        return this.fTransport.lookup(this.fTicketHolder.getTicket(), version, path, includeDeleted);
    }

    @Override
    public AVMNodeDescriptor lookup(AVMNodeDescriptor dir, String name) {
        return this.fTransport.lookup(this.fTicketHolder.getTicket(), dir, name);
    }

    @Override
    public AVMNodeDescriptor lookup(AVMNodeDescriptor dir, String name, boolean includeDeleted) {
        return this.fTransport.lookup(this.fTicketHolder.getTicket(), dir, name, includeDeleted);
    }

    @Override
    public void makePrimary(String path) {
        this.fTransport.makePrimary(this.fTicketHolder.getTicket(), path);
    }

    @Override
    public void purgeStore(String name) {
        this.fTransport.purgeStore(this.fTicketHolder.getTicket(), name);
    }

    @Override
    public void purgeVersion(int version, String name) {
        this.fTransport.purgeVersion(this.fTicketHolder.getTicket(), version, name);
    }

    @Override
    public Map<QName, PropertyValue> queryStorePropertyKey(String store, QName keyPattern) {
        return this.fTransport.queryStorePropertyKey(this.fTicketHolder.getTicket(), store, keyPattern);
    }

    @Override
    public Map<String, Map<QName, PropertyValue>> queryStoresPropertyKey(QName keyPattern) {
        return this.fTransport.queryStoresPropertyKey(this.fTicketHolder.getTicket(), keyPattern);
    }

    @Override
    public void removeNode(String parent, String name) {
        this.fTransport.removeNode(this.fTicketHolder.getTicket(), parent, name);
    }

    @Override
    public void rename(String srcParent, String srcName, String dstParent, String dstName) {
        this.fTransport.rename(this.fTicketHolder.getTicket(), srcParent, srcName, dstParent, dstName);
    }

    @Override
    public void retargetLayeredDirectory(String path, String target) {
        this.fTransport.retargetLayeredDirectory(this.fTicketHolder.getTicket(), path, target);
    }

    @Override
    public void setNodeProperties(String path, Map<QName, PropertyValue> properties) {
        this.fTransport.setNodeProperties(this.fTicketHolder.getTicket(), path, properties);
    }

    @Override
    public void setNodeProperty(String path, QName name, PropertyValue value) {
        this.fTransport.setNodeProperty(this.fTicketHolder.getTicket(), path, name, value);
    }

    @Override
    public void setOpacity(String path, boolean opacity) {
        this.fTransport.setOpacity(this.fTicketHolder.getTicket(), path, opacity);
    }

    @Override
    public void setStoreProperties(String store, Map<QName, PropertyValue> props) {
        this.fTransport.setStoreProperties(this.fTicketHolder.getTicket(), store, props);
    }

    @Override
    public void setStoreProperty(String store, QName name, PropertyValue value) {
        this.fTransport.setStoreProperty(this.fTicketHolder.getTicket(), store, name, value);
    }

    @Override
    public void uncover(String dirPath, String name) {
        this.fTransport.uncover(this.fTicketHolder.getTicket(), dirPath, name);
    }

    @Override
    public void renameStore(String sourceName, String destName) {
        this.fTransport.renameStore(this.fTicketHolder.getTicket(), sourceName, destName);
    }

    @Override
    public void addAspect(String path, QName aspectName) {
        this.fTransport.addAspect(this.fTicketHolder.getTicket(), path, aspectName);
    }

    @Override
    public Set<QName> getAspects(int version, String path) {
        return this.fTransport.getAspects(this.fTicketHolder.getTicket(), version, path);
    }

    @Override
    public boolean hasAspect(int version, String path, QName aspectName) {
        return this.fTransport.hasAspect(this.fTicketHolder.getTicket(), version, path, aspectName);
    }

    @Override
    public void removeAspect(String path, QName aspectName) {
        this.fTransport.removeAspect(this.fTicketHolder.getTicket(), path, aspectName);
    }

    @Override
    public void revert(String path, AVMNodeDescriptor toRevertTo) {
        this.fTransport.revert(this.fTicketHolder.getTicket(), path, toRevertTo);
    }

    @Override
    public Pair<Integer, String> getAPath(AVMNodeDescriptor desc) {
        return this.fTransport.getAPath(this.fTicketHolder.getTicket(), desc);
    }

    @Override
    public void setGuid(String path, String guid) {
        this.fTransport.setGuid(this.fTicketHolder.getTicket(), path, guid);
    }

    @Override
    public void setEncoding(String path, String encoding) {
        this.fTransport.setEncoding(this.fTicketHolder.getTicket(), path, encoding);
    }

    @Override
    public void setMimeType(String path, String mimeType) {
        this.fTransport.setMimeType(this.fTicketHolder.getTicket(), path, mimeType);
    }
}

