/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.remote;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.cmr.remote.RepoRemote;
import org.alfresco.service.cmr.remote.RepoRemoteTransport;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepoRemoteTransportService
implements RepoRemoteTransport,
Runnable {
    private Map<String, InputStream> fInputStreams = new HashMap<String, InputStream>();
    private Map<String, Long> fInputLastAccessTimes = new HashMap<String, Long>();
    private Map<String, Boolean> fInputBusy = new HashMap<String, Boolean>();
    private Map<String, OutputStream> fOutputStreams = new HashMap<String, OutputStream>();
    private Map<String, Long> fOutputLastAccessTimes = new HashMap<String, Long>();
    private Map<String, Boolean> fOutputBusy = new HashMap<String, Boolean>();
    private long fIdleTimeout = 30000L;
    private Thread fThread;
    private boolean fDone;
    private RepoRemote fRepoRemote;
    private AuthenticationService fAuthService;

    public void setIdleTimeout(long timeout) {
        this.fIdleTimeout = timeout;
    }

    public void setRepoRemote(RepoRemote remote) {
        this.fRepoRemote = remote;
    }

    public void setAuthenticationService(AuthenticationService service) {
        this.fAuthService = service;
    }

    public void init() {
        this.fThread = new Thread(this);
        this.fDone = false;
        this.fThread.start();
    }

    @Override
    public synchronized void run() {
        while (!this.fDone) {
            try {
                this.wait(this.fIdleTimeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            long now = System.currentTimeMillis();
            ArrayList<String> toClose = new ArrayList<String>();
            for (String handle : this.fInputLastAccessTimes.keySet()) {
                if (this.fInputBusy.get(handle).booleanValue() || now - this.fInputLastAccessTimes.get(handle) <= this.fIdleTimeout) continue;
                toClose.add(handle);
            }
            for (String handle : toClose) {
                try {
                    this.fInputStreams.get(handle).close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.fInputStreams.remove(handle);
                this.fInputLastAccessTimes.remove(handle);
                this.fInputBusy.remove(handle);
            }
            toClose.clear();
            for (String handle : this.fOutputLastAccessTimes.keySet()) {
                if (this.fOutputBusy.get(handle).booleanValue() || now - this.fOutputLastAccessTimes.get(handle) <= this.fIdleTimeout) continue;
                toClose.add(handle);
            }
            for (String handle : toClose) {
                try {
                    this.fOutputStreams.get(handle).close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.fOutputStreams.remove(handle);
                this.fOutputLastAccessTimes.remove(handle);
                this.fOutputBusy.remove(handle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        RepoRemoteTransportService repoRemoteTransportService = this;
        synchronized (repoRemoteTransportService) {
            this.fDone = true;
            this.notifyAll();
        }
        try {
            this.fThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void closeInputHandle(String ticket, String handle) {
        this.fAuthService.validate(ticket);
        InputStream in = this.fInputStreams.get(handle);
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.fInputStreams.remove(handle);
            this.fInputLastAccessTimes.remove(handle);
            this.fInputBusy.remove(handle);
        }
    }

    @Override
    public synchronized void closeOutputHandle(String ticket, String handle) {
        this.fAuthService.validate(ticket);
        OutputStream out = this.fOutputStreams.get(handle);
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.fOutputStreams.remove(handle);
            this.fOutputLastAccessTimes.remove(handle);
            this.fOutputBusy.remove(handle);
        }
    }

    @Override
    public NodeRef createDirectory(String ticket, NodeRef base, String path) {
        this.fAuthService.validate(ticket);
        return this.fRepoRemote.createDirectory(base, path);
    }

    @Override
    public String createFile(String ticket, NodeRef base, String path) {
        this.fAuthService.validate(ticket);
        OutputStream out = this.fRepoRemote.createFile(base, path);
        return this.getOutputHandle(out);
    }

    @Override
    public Map<String, Pair<NodeRef, Boolean>> getListing(String ticket, NodeRef dir) {
        this.fAuthService.validate(ticket);
        return this.fRepoRemote.getListing(dir);
    }

    @Override
    public NodeRef getRoot(String ticket) {
        this.fAuthService.validate(ticket);
        return this.fRepoRemote.getRoot();
    }

    @Override
    public Pair<NodeRef, Boolean> lookup(String ticket, NodeRef base, String path) {
        this.fAuthService.validate(ticket);
        return this.fRepoRemote.lookup(base, path);
    }

    @Override
    public String readFile(String ticket, NodeRef base, String path) {
        this.fAuthService.validate(ticket);
        InputStream in = this.fRepoRemote.readFile(base, path);
        return this.getInputHandle(in);
    }

    @Override
    public String readFile(String ticket, NodeRef fileRef) {
        this.fAuthService.validate(ticket);
        InputStream in = this.fRepoRemote.readFile(fileRef);
        return this.getInputHandle(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readInput(String ticket, String handle, int count) {
        RepoRemoteTransportService repoRemoteTransportService;
        byte[] byArray;
        byte[] buff;
        block18: {
            this.fAuthService.validate(ticket);
            InputStream in = null;
            RepoRemoteTransportService repoRemoteTransportService2 = this;
            synchronized (repoRemoteTransportService2) {
                in = this.fInputStreams.get(handle);
                if (in == null) {
                    throw new AlfrescoRuntimeException("Invalid Input Handle.");
                }
                this.fInputBusy.put(handle, true);
                this.fInputLastAccessTimes.put(handle, System.currentTimeMillis());
            }
            buff = new byte[count];
            int read = in.read(buff);
            if (read == -1) {
                read = 0;
            }
            if (read == count) break block18;
            byte[] newBuff = new byte[read];
            for (int i = 0; i < read; ++i) {
                newBuff[i] = buff[i];
            }
            byte[] byArray2 = newBuff;
            Object var10_13 = null;
            RepoRemoteTransportService repoRemoteTransportService3 = this;
            synchronized (repoRemoteTransportService3) {
                this.fInputBusy.put(handle, false);
            }
            return byArray2;
        }
        try {
            byArray = buff;
            Object var10_14 = null;
            repoRemoteTransportService = this;
        }
        catch (IOException e) {
            try {
                throw new AlfrescoRuntimeException("I/O Error.");
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                RepoRemoteTransportService repoRemoteTransportService4 = this;
                synchronized (repoRemoteTransportService4) {
                    this.fInputBusy.put(handle, false);
                }
                throw throwable;
            }
        }
        synchronized (repoRemoteTransportService) {
            this.fInputBusy.put(handle, false);
        }
        return byArray;
    }

    @Override
    public void removeNode(String ticket, NodeRef base, String path) {
        this.fAuthService.validate(ticket);
        this.fRepoRemote.removeNode(base, path);
    }

    @Override
    public void removeNode(String ticket, NodeRef toRemove) {
        this.fAuthService.validate(ticket);
        this.fRepoRemote.removeNode(toRemove);
    }

    @Override
    public void rename(String ticket, NodeRef base, String src, String dst) {
        this.fAuthService.validate(ticket);
        this.fRepoRemote.rename(base, src, dst);
    }

    @Override
    public String writeFile(String ticket, NodeRef base, String path) {
        this.fAuthService.validate(ticket);
        OutputStream out = this.fRepoRemote.writeFile(base, path);
        return this.getOutputHandle(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void writeOutput(String ticket, String handle, byte[] buff, int count) {
        RepoRemoteTransportService repoRemoteTransportService;
        this.fAuthService.validate(ticket);
        OutputStream out = null;
        RepoRemoteTransportService repoRemoteTransportService2 = this;
        synchronized (repoRemoteTransportService2) {
            out = this.fOutputStreams.get(handle);
            if (out == null) {
                throw new AlfrescoRuntimeException("Invalid Output Handle.");
            }
            this.fOutputBusy.put(handle, true);
            this.fOutputLastAccessTimes.put(handle, System.currentTimeMillis());
        }
        try {
            try {
                out.write(buff, 0, count);
            }
            catch (IOException e) {
                throw new AlfrescoRuntimeException("I/O Errror.");
            }
            Object var9_8 = null;
            repoRemoteTransportService = this;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            RepoRemoteTransportService repoRemoteTransportService3 = this;
            synchronized (repoRemoteTransportService3) {
                this.fOutputBusy.put(handle, false);
                throw throwable;
            }
        }
        synchronized (repoRemoteTransportService) {
            this.fOutputBusy.put(handle, false);
            return;
        }
    }

    private synchronized String getOutputHandle(OutputStream out) {
        String handle = GUID.generate();
        this.fOutputStreams.put(handle, out);
        this.fOutputLastAccessTimes.put(handle, System.currentTimeMillis());
        this.fOutputBusy.put(handle, false);
        return handle;
    }

    private synchronized String getInputHandle(InputStream in) {
        String handle = GUID.generate();
        this.fInputStreams.put(handle, in);
        this.fInputLastAccessTimes.put(handle, System.currentTimeMillis());
        this.fInputBusy.put(handle, false);
        return handle;
    }
}

