/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.model.RenditionModel;
import org.alfresco.repo.rendition.CompositeRenditionDefinitionImpl;
import org.alfresco.repo.rendition.RenditionDefinitionImpl;
import org.alfresco.repo.rendition.RenditionDefinitionPersister;
import org.alfresco.repo.rendition.RenditionDefinitionPersisterImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.ActionDefinition;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.rendition.CompositeRenditionDefinition;
import org.alfresco.service.cmr.rendition.RenderCallback;
import org.alfresco.service.cmr.rendition.RenderingEngineDefinition;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.rendition.RenditionServiceException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenditionServiceImpl
implements RenditionService,
RenditionDefinitionPersister {
    private static final Log log = LogFactory.getLog(RenditionServiceImpl.class);
    private ActionService actionService;
    private ContentService contentService;
    private DictionaryService dictionaryService;
    private NodeService nodeService;
    private RenditionDefinitionPersisterImpl renditionDefinitionPersister;

    public void setRenditionDefinitionPersister(RenditionDefinitionPersisterImpl renditionDefinitionPersister) {
        this.renditionDefinitionPersister = renditionDefinitionPersister;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.contentService = serviceRegistry.getContentService();
        this.nodeService = serviceRegistry.getNodeService();
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    @Override
    public RenderingEngineDefinition getRenderingEngineDefinition(String name) {
        ActionDefinition actionDefinition = this.actionService.getActionDefinition(name);
        if (actionDefinition instanceof RenderingEngineDefinition) {
            return (RenderingEngineDefinition)actionDefinition;
        }
        return null;
    }

    @Override
    public List<RenderingEngineDefinition> getRenderingEngineDefinitions() {
        ArrayList<RenderingEngineDefinition> results = new ArrayList<RenderingEngineDefinition>();
        List<ActionDefinition> actionDefs = this.actionService.getActionDefinitions();
        for (ActionDefinition actionDef : actionDefs) {
            if (!(actionDef instanceof RenderingEngineDefinition)) continue;
            RenderingEngineDefinition renderingDef = (RenderingEngineDefinition)actionDef;
            results.add(renderingDef);
        }
        return results;
    }

    @Override
    public RenditionDefinition createRenditionDefinition(QName renditionDefinitionName, String renderingEngineName) {
        if (log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Creating rendition definition ").append(renditionDefinitionName).append(" ").append(renderingEngineName);
            log.debug((Object)msg.toString());
        }
        return new RenditionDefinitionImpl(GUID.generate(), renditionDefinitionName, renderingEngineName);
    }

    @Override
    public CompositeRenditionDefinition createCompositeRenditionDefinition(QName renditionName) {
        if (log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Creating composite rendition definition ").append(renditionName);
            log.debug((Object)msg.toString());
        }
        return new CompositeRenditionDefinitionImpl(GUID.generate(), renditionName);
    }

    @Override
    public ChildAssociationRef render(NodeRef sourceNode, RenditionDefinition definition) {
        ChildAssociationRef result = this.executeRenditionAction(sourceNode, definition, false);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Produced rendition " + result));
        }
        return result;
    }

    @Override
    public void render(NodeRef sourceNode, RenditionDefinition definition, RenderCallback callback) {
        definition.setCallback(callback);
        this.executeRenditionAction(sourceNode, definition, true);
    }

    @Override
    public ChildAssociationRef render(NodeRef sourceNode, final QName renditionDefinitionQName) {
        RenditionDefinition rendDefn = (RenditionDefinition)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<RenditionDefinition>(){

            public RenditionDefinition doWork() throws Exception {
                return RenditionServiceImpl.this.loadRenditionDefinition(renditionDefinitionQName);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        if (rendDefn == null) {
            throw new RenditionServiceException("Rendition Definition " + renditionDefinitionQName + " was not found.");
        }
        return this.render(sourceNode, rendDefn);
    }

    @Override
    public void render(NodeRef sourceNode, final QName renditionDefinitionQName, RenderCallback callback) {
        RenditionDefinition rendDefn = (RenditionDefinition)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<RenditionDefinition>(){

            public RenditionDefinition doWork() throws Exception {
                return RenditionServiceImpl.this.loadRenditionDefinition(renditionDefinitionQName);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        if (rendDefn == null) {
            throw new RenditionServiceException("Rendition Definition " + renditionDefinitionQName + " was not found.");
        }
        this.render(sourceNode, rendDefn, callback);
    }

    private ChildAssociationRef executeRenditionAction(NodeRef sourceNode, RenditionDefinition definition, boolean asynchronous) {
        if (log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            if (asynchronous) {
                msg.append("Asynchronously");
            } else {
                msg.append("Synchronously");
            }
            msg.append(" rendering node ").append(sourceNode).append(" with ").append(definition.getRenditionName());
            log.debug((Object)msg.toString());
        }
        boolean checkConditions = true;
        this.actionService.executeAction(definition, sourceNode, true, asynchronous);
        ChildAssociationRef result = (ChildAssociationRef)definition.getParameterValue("result");
        return result;
    }

    @Override
    public void saveRenditionDefinition(RenditionDefinition renderingAction) {
        this.renditionDefinitionPersister.saveRenditionDefinition(renderingAction);
    }

    @Override
    public RenditionDefinition loadRenditionDefinition(QName renditionDefinitionName) {
        return this.renditionDefinitionPersister.loadRenditionDefinition(renditionDefinitionName);
    }

    @Override
    public List<RenditionDefinition> loadRenditionDefinitions() {
        return this.renditionDefinitionPersister.loadRenditionDefinitions();
    }

    @Override
    public List<RenditionDefinition> loadRenditionDefinitions(String renditionEngineName) {
        return this.renditionDefinitionPersister.loadRenditionDefinitions(renditionEngineName);
    }

    @Override
    public List<ChildAssociationRef> getRenditions(NodeRef node) {
        List<ChildAssociationRef> result = Collections.emptyList();
        if (this.nodeService.hasAspect(node, RenditionModel.ASPECT_RENDITIONED)) {
            result = this.nodeService.getChildAssocs(node, (QNamePattern)RenditionModel.ASSOC_RENDITION, RegexQNamePattern.MATCH_ALL);
            result = this.removeArchivedRenditionsFrom(result);
        }
        return result;
    }

    private List<ChildAssociationRef> removeArchivedRenditionsFrom(List<ChildAssociationRef> renditionAssocs) {
        ArrayList<ChildAssociationRef> result = new ArrayList<ChildAssociationRef>();
        for (ChildAssociationRef chAssRef : renditionAssocs) {
            if (chAssRef.getChildRef().getStoreRef().equals((Object)StoreRef.STORE_REF_ARCHIVE_SPACESSTORE)) continue;
            result.add(chAssRef);
        }
        return result;
    }

    @Override
    public List<ChildAssociationRef> getRenditions(NodeRef node, String mimeTypePrefix) {
        List<ChildAssociationRef> allRenditions = this.getRenditions(node);
        List<ChildAssociationRef> filteredResults = new ArrayList<ChildAssociationRef>();
        for (ChildAssociationRef chAssRef : allRenditions) {
            String readerMimeType;
            ContentReader reader;
            NodeRef renditionNode = chAssRef.getChildRef();
            QName contentProperty = ContentModel.PROP_CONTENT;
            Serializable contentPropertyName = this.nodeService.getProperty(renditionNode, ContentModel.PROP_CONTENT_PROPERTY_NAME);
            if (contentPropertyName != null) {
                contentProperty = (QName)contentPropertyName;
            }
            if ((reader = this.contentService.getReader(renditionNode, contentProperty)) == null || !reader.exists() || !(readerMimeType = reader.getMimetype()).startsWith(mimeTypePrefix)) continue;
            filteredResults.add(chAssRef);
        }
        filteredResults = this.removeArchivedRenditionsFrom(filteredResults);
        return filteredResults;
    }

    @Override
    public ChildAssociationRef getRenditionByName(NodeRef node, QName renditionName) {
        List<ChildAssociationRef> renditions = Collections.emptyList();
        if (this.nodeService.hasAspect(node, RenditionModel.ASPECT_RENDITIONED)) {
            renditions = this.nodeService.getChildAssocs(node, (QNamePattern)RenditionModel.ASSOC_RENDITION, (QNamePattern)renditionName);
            renditions = this.removeArchivedRenditionsFrom(renditions);
        }
        if (renditions.isEmpty()) {
            return null;
        }
        if (renditions.size() > 1 && log.isDebugEnabled()) {
            log.debug((Object)("Unexpectedly found " + renditions.size() + " renditions of name " + renditionName + " on node " + node));
        }
        return (ChildAssociationRef)renditions.get(0);
    }

    @Override
    public boolean isRendition(NodeRef node) {
        QName aspectToCheckFor = RenditionModel.ASPECT_RENDITION;
        Set existingAspects = this.nodeService.getAspects(node);
        for (QName nextAspect : existingAspects) {
            if (!nextAspect.equals((Object)aspectToCheckFor) && !this.dictionaryService.isSubClass(nextAspect, aspectToCheckFor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ChildAssociationRef getSourceNode(NodeRef renditionNode) {
        List parents = this.nodeService.getParentAssocs(renditionNode, (QNamePattern)RenditionModel.ASSOC_RENDITION, RegexQNamePattern.MATCH_ALL);
        if (parents.size() > 1) {
            StringBuilder msg = new StringBuilder();
            msg.append("NodeRef ").append(renditionNode).append(" unexpectedly has ").append(parents.size()).append(" rendition parents.");
            if (log.isWarnEnabled()) {
                log.warn((Object)msg.toString());
            }
            throw new RenditionServiceException(msg.toString());
        }
        return parents.isEmpty() ? null : (ChildAssociationRef)parents.get(0);
    }
}

