/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.replication;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.transaction.UserTransaction;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.jscript.ClasspathScriptLocation;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.replication.ReplicationActionExecutor;
import org.alfresco.repo.replication.ReplicationDefinitionPersisterImpl;
import org.alfresco.repo.replication.ReplicationParams;
import org.alfresco.repo.replication.script.ScriptReplicationDefinition;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transfer.TransferServiceImpl2;
import org.alfresco.repo.transfer.UnitTestInProcessTransmitterImpl;
import org.alfresco.repo.transfer.UnitTestTransferManifestNodeFactory;
import org.alfresco.repo.transfer.manifest.TransferManifestNodeFactory;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.ActionStatus;
import org.alfresco.service.cmr.action.ActionTrackingService;
import org.alfresco.service.cmr.action.scheduled.SchedulableAction;
import org.alfresco.service.cmr.action.scheduled.ScheduledPersistedActionService;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.UnableToReleaseLockException;
import org.alfresco.service.cmr.replication.ReplicationDefinition;
import org.alfresco.service.cmr.replication.ReplicationService;
import org.alfresco.service.cmr.replication.ReplicationServiceException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.ScriptService;
import org.alfresco.service.cmr.transfer.TransferDefinition;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.cmr.transfer.TransferReceiver;
import org.alfresco.service.cmr.transfer.TransferService2;
import org.alfresco.service.cmr.transfer.TransferTarget;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.springframework.context.ConfigurableApplicationContext;

public class ReplicationServiceIntegrationTest
extends TestCase {
    private static ConfigurableApplicationContext ctx = (ConfigurableApplicationContext)ApplicationContextHelper.getApplicationContext();
    private ReplicationActionExecutor replicationActionExecutor;
    private ReplicationService replicationService;
    private ReplicationParams replicationParams;
    private TransactionService transactionService;
    private TransferService2 transferService;
    private ContentService contentService;
    private JobLockService jobLockService;
    private ScriptService scriptService;
    private ActionService actionService;
    private NodeService nodeService;
    private LockService lockService;
    private Repository repositoryHelper;
    private ActionTrackingService actionTrackingService;
    private ScheduledPersistedActionService scheduledPersistedActionService;
    private NodeRef replicationRoot;
    private NodeRef destinationFolder;
    private NodeRef folder1;
    private NodeRef folder2;
    private NodeRef folder2a;
    private NodeRef folder2b;
    private NodeRef content1_1;
    private NodeRef content1_2;
    private NodeRef thumbnail1_3;
    private NodeRef authority1_4;
    private NodeRef content2a_1;
    private NodeRef thumbnail2a_2;
    private NodeRef zone2a_3;
    private NodeRef deletedFolder;
    private final String ACTION_NAME = "testName";
    private final String ACTION_NAME2 = "testName2";
    private final String ACTION_NAME3 = "testName3";
    private final QName ACTION_QNAME = QName.createQName(null, (String)"testName");
    private final QName ACTION_QNAME2 = QName.createQName(null, (String)"testName2");
    private final String TRANSFER_TARGET = "TestTransferTarget";

    protected void setUp() throws Exception {
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            ReplicationServiceIntegrationTest.fail((String)"Dangling transaction detected, left by a previous test.");
        }
        this.replicationActionExecutor = (ReplicationActionExecutor)ctx.getBean("replicationActionExecutor");
        this.replicationService = (ReplicationService)ctx.getBean("replicationService");
        this.replicationParams = (ReplicationParams)ctx.getBean("replicationParams");
        this.transactionService = (TransactionService)ctx.getBean("transactionService");
        this.transferService = (TransferService2)ctx.getBean("transferService2");
        this.contentService = (ContentService)ctx.getBean("contentService");
        this.jobLockService = (JobLockService)ctx.getBean("jobLockService");
        this.actionService = (ActionService)ctx.getBean("actionService");
        this.scriptService = (ScriptService)ctx.getBean("scriptService");
        this.nodeService = (NodeService)ctx.getBean("nodeService");
        this.lockService = (LockService)ctx.getBean("lockService");
        this.repositoryHelper = (Repository)ctx.getBean("repositoryHelper");
        this.actionTrackingService = (ActionTrackingService)ctx.getBean("actionTrackingService");
        this.scheduledPersistedActionService = (ScheduledPersistedActionService)ctx.getBean("scheduledPersistedActionService");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.replicationParams.setEnabled(true);
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        this.replicationRoot = ReplicationDefinitionPersisterImpl.REPLICATION_ACTION_ROOT_NODE_REF;
        for (ChildAssociationRef child : this.nodeService.getChildAssocs(this.replicationRoot)) {
            QName type = this.nodeService.getType(child.getChildRef());
            if (!ReplicationDefinitionPersisterImpl.ACTION_TYPES.contains(type)) continue;
            this.nodeService.deleteNode(child.getChildRef());
        }
        this.destinationFolder = this.makeNode(this.repositoryHelper.getCompanyHome(), ContentModel.TYPE_FOLDER, "ReplicationTransferDestination");
        this.folder1 = this.makeNode(this.repositoryHelper.getCompanyHome(), ContentModel.TYPE_FOLDER);
        this.folder2 = this.makeNode(this.repositoryHelper.getCompanyHome(), ContentModel.TYPE_FOLDER);
        this.folder2a = this.makeNode(this.folder2, ContentModel.TYPE_FOLDER);
        this.folder2b = this.makeNode(this.folder2, ContentModel.TYPE_FOLDER);
        this.content1_1 = this.makeNode(this.folder1, ContentModel.TYPE_CONTENT);
        this.content1_2 = this.makeNode(this.folder1, ContentModel.TYPE_CONTENT);
        this.thumbnail1_3 = this.makeNode(this.folder1, ContentModel.TYPE_THUMBNAIL);
        this.authority1_4 = this.makeNode(this.folder1, ContentModel.TYPE_AUTHORITY);
        this.content2a_1 = this.makeNode(this.folder2a, ContentModel.TYPE_CONTENT);
        this.thumbnail2a_2 = this.makeNode(this.folder2a, ContentModel.TYPE_THUMBNAIL);
        this.zone2a_3 = this.makeNode(this.folder2a, ContentModel.TYPE_ZONE);
        this.deletedFolder = this.makeNode(this.repositoryHelper.getCompanyHome(), ContentModel.TYPE_FOLDER);
        this.nodeService.deleteNode(this.deletedFolder);
        this.makeTransferServiceLocal();
        txn.commit();
    }

    protected void tearDown() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> cleanupCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                if (ReplicationServiceIntegrationTest.this.folder1 != null) {
                    ReplicationServiceIntegrationTest.this.nodeService.deleteNode(ReplicationServiceIntegrationTest.this.folder1);
                }
                if (ReplicationServiceIntegrationTest.this.folder2 != null) {
                    ReplicationServiceIntegrationTest.this.nodeService.deleteNode(ReplicationServiceIntegrationTest.this.folder2);
                }
                if (ReplicationServiceIntegrationTest.this.destinationFolder != null) {
                    ReplicationServiceIntegrationTest.this.lockService.unlock(ReplicationServiceIntegrationTest.this.destinationFolder, true);
                    ReplicationServiceIntegrationTest.this.nodeService.deleteNode(ReplicationServiceIntegrationTest.this.destinationFolder);
                }
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(cleanupCallback);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> cleanupTargetCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ReplicationServiceIntegrationTest.this.transferService.deleteTransferTarget("TestTransferTarget");
                return null;
            }
        };
        try {
            this.transactionService.getRetryingTransactionHelper().doInTransaction(cleanupTargetCallback);
        }
        catch (TransferException transferException) {
            // empty catch block
        }
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            ReplicationServiceIntegrationTest.fail((String)"Dangling transaction detected, current test failed to tidy up.");
        }
    }

    public void testCreation() throws Exception {
        ReplicationDefinition replicationAction = this.replicationService.createReplicationDefinition("testName", "Test Definition");
        ReplicationServiceIntegrationTest.assertNotNull((Object)replicationAction);
        ReplicationServiceIntegrationTest.assertEquals((String)"Test Definition", (String)replicationAction.getDescription());
        ReplicationServiceIntegrationTest.assertEquals((String)"testName", (String)replicationAction.getReplicationName());
        ReplicationServiceIntegrationTest.assertEquals((Object)this.ACTION_QNAME, (Object)replicationAction.getReplicationQName());
        String id = replicationAction.getId();
        ReplicationServiceIntegrationTest.assertNotNull((Object)id);
        ReplicationServiceIntegrationTest.assertTrue((id.length() > 0 ? 1 : 0) != 0);
        ReplicationServiceIntegrationTest.assertNotNull(replicationAction.getPayload());
        ReplicationServiceIntegrationTest.assertEquals((int)0, (int)replicationAction.getPayload().size());
        ReplicationServiceIntegrationTest.assertNull((Object)replicationAction.getLocalTransferReport());
        ReplicationServiceIntegrationTest.assertNull((Object)replicationAction.getRemoteTransferReport());
    }

    public void testCreateSaveLoad() throws Exception {
        ReplicationDefinition replicationAction = this.replicationService.createReplicationDefinition("testName", "Test Definition");
        String initialId = replicationAction.getId();
        replicationAction.getPayload().add(new NodeRef("workspace://SpacesStore/Testing"));
        replicationAction.getPayload().add(new NodeRef("workspace://SpacesStore/Testing2"));
        ReplicationServiceIntegrationTest.assertEquals((int)2, (int)replicationAction.getPayload().size());
        this.replicationService.saveReplicationDefinition(replicationAction);
        ReplicationDefinition retrieved = this.replicationService.loadReplicationDefinition("testName");
        ReplicationServiceIntegrationTest.assertNotNull((Object)retrieved);
        ReplicationServiceIntegrationTest.assertEquals((String)initialId, (String)retrieved.getId());
        ReplicationServiceIntegrationTest.assertEquals((String)"testName", (String)retrieved.getReplicationName());
        ReplicationServiceIntegrationTest.assertEquals((Object)this.ACTION_QNAME, (Object)retrieved.getReplicationQName());
        ReplicationServiceIntegrationTest.assertEquals((String)"Test Definition", (String)retrieved.getDescription());
        ReplicationServiceIntegrationTest.assertEquals((int)2, (int)retrieved.getPayload().size());
        ReplicationDefinition second = this.replicationService.loadReplicationDefinition("testName");
        ReplicationServiceIntegrationTest.assertNotNull((Object)second);
        ReplicationServiceIntegrationTest.assertEquals((String)initialId, (String)second.getId());
        ReplicationServiceIntegrationTest.assertEquals((String)"testName", (String)second.getReplicationName());
        ReplicationServiceIntegrationTest.assertEquals((Object)this.ACTION_QNAME, (Object)second.getReplicationQName());
        ReplicationServiceIntegrationTest.assertEquals((String)"Test Definition", (String)second.getDescription());
        ReplicationServiceIntegrationTest.assertEquals((int)2, (int)second.getPayload().size());
    }

    public void testLoadList() throws Exception {
        ReplicationServiceIntegrationTest.assertEquals((int)0, (int)this.replicationService.loadReplicationDefinitions().size());
        ReplicationDefinition rd1 = this.replicationService.createReplicationDefinition("testName", "Test 1");
        ReplicationDefinition rd2 = this.replicationService.createReplicationDefinition("testName2", "Test 2");
        ReplicationServiceIntegrationTest.assertEquals((int)0, (int)this.replicationService.loadReplicationDefinitions().size());
        this.replicationService.saveReplicationDefinition(rd1);
        ReplicationServiceIntegrationTest.assertEquals((int)1, (int)this.replicationService.loadReplicationDefinitions().size());
        ReplicationServiceIntegrationTest.assertEquals((String)"testName", (String)this.replicationService.loadReplicationDefinitions().get(0).getReplicationName());
        this.replicationService.saveReplicationDefinition(rd2);
        ReplicationServiceIntegrationTest.assertEquals((int)2, (int)this.replicationService.loadReplicationDefinitions().size());
    }

    public void testLoadByTarget() throws Exception {
        ReplicationServiceIntegrationTest.assertEquals((int)0, (int)this.replicationService.loadReplicationDefinitions().size());
        ReplicationServiceIntegrationTest.assertEquals((int)0, (int)this.replicationService.loadReplicationDefinitions("TestTarget").size());
        ReplicationServiceIntegrationTest.assertEquals((int)0, (int)this.replicationService.loadReplicationDefinitions("TestTarget2").size());
        ReplicationDefinition rdTT = this.replicationService.createReplicationDefinition("testName", "Test");
        rdTT.setTargetName("TestTarget");
        this.replicationService.saveReplicationDefinition(rdTT);
        ReplicationServiceIntegrationTest.assertEquals((int)1, (int)this.replicationService.loadReplicationDefinitions().size());
        ReplicationServiceIntegrationTest.assertEquals((int)1, (int)this.replicationService.loadReplicationDefinitions("TestTarget").size());
        ReplicationServiceIntegrationTest.assertEquals((int)0, (int)this.replicationService.loadReplicationDefinitions("TestTarget2").size());
    }

    public void testDeletion() throws Exception {
        ReplicationServiceIntegrationTest.assertEquals((int)0, (int)this.replicationService.loadReplicationDefinitions().size());
        ReplicationDefinition rd1 = this.replicationService.createReplicationDefinition("testName", "Test");
        ReplicationServiceIntegrationTest.assertEquals((int)0, (int)this.replicationService.loadReplicationDefinitions().size());
        this.replicationService.deleteReplicationDefinition(rd1);
        ReplicationServiceIntegrationTest.assertEquals((int)0, (int)this.replicationService.loadReplicationDefinitions().size());
        ReplicationDefinition rd2 = this.replicationService.createReplicationDefinition("testName2", "Test2");
        this.replicationService.saveReplicationDefinition(rd1);
        this.replicationService.saveReplicationDefinition(rd2);
        ReplicationServiceIntegrationTest.assertEquals((int)2, (int)this.replicationService.loadReplicationDefinitions().size());
        this.replicationService.deleteReplicationDefinition(rd2);
        ReplicationServiceIntegrationTest.assertEquals((int)1, (int)this.replicationService.loadReplicationDefinitions().size());
        ReplicationServiceIntegrationTest.assertEquals((String)"testName", (String)this.replicationService.loadReplicationDefinitions().get(0).getReplicationName());
        ReplicationServiceIntegrationTest.assertNotNull((Object)this.replicationService.loadReplicationDefinition("testName"));
        ReplicationServiceIntegrationTest.assertNull((Object)this.replicationService.loadReplicationDefinition("testName2"));
        this.replicationService.deleteReplicationDefinition(rd2);
        ReplicationServiceIntegrationTest.assertEquals((int)1, (int)this.replicationService.loadReplicationDefinitions().size());
        ReplicationServiceIntegrationTest.assertEquals((String)"testName", (String)this.replicationService.loadReplicationDefinitions().get(0).getReplicationName());
        ReplicationServiceIntegrationTest.assertNotNull((Object)this.replicationService.loadReplicationDefinition("testName"));
        ReplicationServiceIntegrationTest.assertNull((Object)this.replicationService.loadReplicationDefinition("testName2"));
        this.replicationService.deleteReplicationDefinition(rd1);
        ReplicationServiceIntegrationTest.assertEquals((int)0, (int)this.replicationService.loadReplicationDefinitions().size());
        ReplicationServiceIntegrationTest.assertNull((Object)this.replicationService.loadReplicationDefinition("testName"));
        ReplicationServiceIntegrationTest.assertNull((Object)this.replicationService.loadReplicationDefinition("testName2"));
        this.replicationService.saveReplicationDefinition(rd1);
        ReplicationServiceIntegrationTest.assertEquals((int)1, (int)this.replicationService.loadReplicationDefinitions().size());
        ReplicationServiceIntegrationTest.assertEquals((String)"testName", (String)this.replicationService.loadReplicationDefinitions().get(0).getReplicationName());
    }

    public void testEditing() throws Exception {
        ReplicationDefinition rdTT = this.replicationService.createReplicationDefinition("testName", "Test");
        rdTT.setTargetName("TestTarget");
        this.replicationService.saveReplicationDefinition(rdTT);
        rdTT = this.replicationService.loadReplicationDefinition("testName");
        ReplicationServiceIntegrationTest.assertEquals((String)"testName", (String)rdTT.getReplicationName());
        ReplicationServiceIntegrationTest.assertEquals((String)"Test", (String)rdTT.getDescription());
        ReplicationServiceIntegrationTest.assertEquals((String)"TestTarget", (String)rdTT.getTargetName());
        ReplicationServiceIntegrationTest.assertEquals((boolean)true, (boolean)rdTT.isEnabled());
        ReplicationServiceIntegrationTest.assertEquals((int)0, (int)rdTT.getPayload().size());
        this.replicationService.saveReplicationDefinition(rdTT);
        rdTT = this.replicationService.loadReplicationDefinition("testName");
        ReplicationServiceIntegrationTest.assertEquals((String)"testName", (String)rdTT.getReplicationName());
        ReplicationServiceIntegrationTest.assertEquals((String)"Test", (String)rdTT.getDescription());
        ReplicationServiceIntegrationTest.assertEquals((String)"TestTarget", (String)rdTT.getTargetName());
        ReplicationServiceIntegrationTest.assertEquals((boolean)true, (boolean)rdTT.isEnabled());
        ReplicationServiceIntegrationTest.assertEquals((int)0, (int)rdTT.getPayload().size());
        rdTT.setDescription("Test Description");
        rdTT.getPayload().add(this.folder2a);
        rdTT.setEnabled(false);
        this.replicationService.saveReplicationDefinition(rdTT);
        rdTT = this.replicationService.loadReplicationDefinition("testName");
        ReplicationServiceIntegrationTest.assertEquals((String)"testName", (String)rdTT.getReplicationName());
        ReplicationServiceIntegrationTest.assertEquals((String)"Test Description", (String)rdTT.getDescription());
        ReplicationServiceIntegrationTest.assertEquals((String)"TestTarget", (String)rdTT.getTargetName());
        ReplicationServiceIntegrationTest.assertEquals((boolean)false, (boolean)rdTT.isEnabled());
        ReplicationServiceIntegrationTest.assertEquals((int)1, (int)rdTT.getPayload().size());
        ReplicationServiceIntegrationTest.assertEquals((Object)this.folder2a, (Object)rdTT.getPayload().get(0));
        rdTT.setDescription("Another One");
        rdTT.getPayload().clear();
        rdTT.getPayload().add(this.folder1);
        rdTT.getPayload().add(this.folder2b);
        ReplicationServiceIntegrationTest.assertEquals((int)2, (int)rdTT.getPayload().size());
        this.replicationService.saveReplicationDefinition(rdTT);
        rdTT = this.replicationService.loadReplicationDefinition("testName");
        ReplicationServiceIntegrationTest.assertEquals((String)"testName", (String)rdTT.getReplicationName());
        ReplicationServiceIntegrationTest.assertEquals((String)"Another One", (String)rdTT.getDescription());
        ReplicationServiceIntegrationTest.assertEquals((String)"TestTarget", (String)rdTT.getTargetName());
        ReplicationServiceIntegrationTest.assertEquals((boolean)false, (boolean)rdTT.isEnabled());
        ReplicationServiceIntegrationTest.assertEquals((int)2, (int)rdTT.getPayload().size());
        ReplicationServiceIntegrationTest.assertEquals((Object)this.folder1, (Object)rdTT.getPayload().get(0));
        ReplicationServiceIntegrationTest.assertEquals((Object)this.folder2b, (Object)rdTT.getPayload().get(1));
        rdTT.getPayload().clear();
        rdTT.getPayload().add(this.content1_1);
        ReplicationServiceIntegrationTest.assertEquals((int)1, (int)rdTT.getPayload().size());
        rdTT.setEnabled(true);
        this.replicationService.saveReplicationDefinition(rdTT);
        rdTT = this.replicationService.loadReplicationDefinition("testName");
        ReplicationServiceIntegrationTest.assertEquals((String)"testName", (String)rdTT.getReplicationName());
        ReplicationServiceIntegrationTest.assertEquals((String)"Another One", (String)rdTT.getDescription());
        ReplicationServiceIntegrationTest.assertEquals((String)"TestTarget", (String)rdTT.getTargetName());
        ReplicationServiceIntegrationTest.assertEquals((boolean)true, (boolean)rdTT.isEnabled());
        ReplicationServiceIntegrationTest.assertEquals((int)1, (int)rdTT.getPayload().size());
        ReplicationServiceIntegrationTest.assertEquals((Object)this.content1_1, (Object)rdTT.getPayload().get(0));
    }

    public void testRenaming() throws Exception {
        ReplicationDefinition rdTT = this.replicationService.createReplicationDefinition("testName", "Test");
        rdTT.setTargetName("TestTarget");
        this.replicationService.saveReplicationDefinition(rdTT);
        ReplicationServiceIntegrationTest.assertEquals((int)1, (int)this.replicationService.loadReplicationDefinitions().size());
        this.replicationService.renameReplicationDefinition("testName", "testName2");
        ReplicationServiceIntegrationTest.assertEquals((int)1, (int)this.replicationService.loadReplicationDefinitions().size());
        ReplicationServiceIntegrationTest.assertEquals(null, (Object)this.replicationService.loadReplicationDefinition("testName"));
        rdTT = this.replicationService.loadReplicationDefinition("testName2");
        ReplicationServiceIntegrationTest.assertNotNull((Object)rdTT);
        ReplicationServiceIntegrationTest.assertEquals((String)"testName2", (String)rdTT.getReplicationName());
        ReplicationServiceIntegrationTest.assertEquals((Object)this.ACTION_QNAME2, (Object)rdTT.getReplicationQName());
        this.replicationService.renameReplicationDefinition("testName", "testName2");
        ReplicationServiceIntegrationTest.assertEquals((int)1, (int)this.replicationService.loadReplicationDefinitions().size());
        ReplicationServiceIntegrationTest.assertEquals(null, (Object)this.replicationService.loadReplicationDefinition("testName"));
        rdTT = this.replicationService.loadReplicationDefinition("testName2");
        ReplicationServiceIntegrationTest.assertNotNull((Object)rdTT);
        ReplicationServiceIntegrationTest.assertEquals((String)"testName2", (String)rdTT.getReplicationName());
        ReplicationServiceIntegrationTest.assertEquals((Object)this.ACTION_QNAME2, (Object)rdTT.getReplicationQName());
        rdTT = this.replicationService.createReplicationDefinition("testName", "Test");
        rdTT.setTargetName("TestTarget");
        this.replicationService.saveReplicationDefinition(rdTT);
        ReplicationServiceIntegrationTest.assertEquals((int)2, (int)this.replicationService.loadReplicationDefinitions().size());
        try {
            this.replicationService.renameReplicationDefinition("testName", "testName2");
            ReplicationServiceIntegrationTest.fail((String)"Shouldn't be able to rename onto a duplicate name");
        }
        catch (ReplicationServiceException replicationServiceException) {
            // empty catch block
        }
    }

    public void testBasicExecution() throws Exception {
        this.makeTransferTarget();
        ReplicationServiceIntegrationTest.assertEquals((int)0, (int)this.nodeService.getChildAssocs(this.destinationFolder).size());
        ReplicationDefinition rd = this.replicationService.createReplicationDefinition("testName", "Test");
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        try {
            this.actionService.executeAction(rd, this.replicationRoot);
            ReplicationServiceIntegrationTest.fail((String)"Shouldn't be permitted with no Target defined");
        }
        catch (ReplicationServiceException e) {
            // empty catch block
        }
        txn.rollback();
        rd.setTargetName("TestTransferTarget");
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        try {
            this.actionService.executeAction(rd, this.replicationRoot);
            ReplicationServiceIntegrationTest.fail((String)"Shouldn't be permitted with no payload defined");
        }
        catch (ReplicationServiceException e) {
            // empty catch block
        }
        txn.rollback();
        ReplicationServiceIntegrationTest.assertEquals((boolean)true, (boolean)rd.isEnabled());
        rd.setEnabled(false);
        ReplicationServiceIntegrationTest.assertEquals((boolean)false, (boolean)rd.isEnabled());
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        try {
            this.actionService.executeAction(rd, this.replicationRoot);
            ReplicationServiceIntegrationTest.fail((String)"Shouldn't be permitted when disabled");
        }
        catch (ReplicationServiceException e) {
            // empty catch block
        }
        txn.rollback();
        rd = this.replicationService.createReplicationDefinition("testName", "Test");
        rd.setTargetName("I am an invalid target that isn't there");
        rd.getPayload().add(this.folder1);
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        try {
            this.actionService.executeAction(rd, this.replicationRoot);
            ReplicationServiceIntegrationTest.fail((String)"Shouldn't be permitted with an invalid transfer target");
        }
        catch (ReplicationServiceException e) {
            // empty catch block
        }
        txn.rollback();
        rd = this.replicationService.createReplicationDefinition("testName", "Test");
        rd.setTargetName("TestTransferTarget");
        rd.getPayload().add(this.folder2a);
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        try {
            this.actionService.executeAction(rd, this.replicationRoot);
            ReplicationServiceIntegrationTest.fail((String)"Shouldn't be able to send Folder2a when Folder2 is missing!");
        }
        catch (ReplicationServiceException e) {
            // empty catch block
        }
        txn.rollback();
        rd = this.replicationService.createReplicationDefinition("testName", "Test");
        rd.setTargetName("TestTransferTarget");
        rd.getPayload().add(this.folder1);
        rd.getPayload().add(this.deletedFolder);
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        try {
            this.actionService.executeAction(rd, this.replicationRoot);
        }
        catch (ReplicationServiceException e) {
            txn.rollback();
            throw e;
        }
        txn.commit();
        ReplicationDefinition rd2 = this.replicationService.createReplicationDefinition("testName2", "Test");
        rd2.setTargetName("TestTransferTarget");
        rd2.getPayload().add(this.folder2);
        this.replicationService.saveReplicationDefinition(rd2);
        rd2 = this.replicationService.loadReplicationDefinition("testName2");
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        this.actionService.executeAction(rd2, this.replicationRoot);
        txn.commit();
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        ((ActionImpl)((Object)rd2)).setExecutionStatus(ActionStatus.New);
        this.replicationService.enableScheduling(rd2);
        rd2.setScheduleStart(new Date(System.currentTimeMillis() + 500L));
        this.replicationService.saveReplicationDefinition(rd2);
        txn.commit();
        Thread.sleep(2000L);
        for (int i = 0; i < 100; ++i) {
            txn = this.transactionService.getUserTransaction();
            txn.begin();
            rd2 = this.replicationService.loadReplicationDefinition("testName2");
            txn.commit();
            if (!rd2.getExecutionStatus().equals((Object)ActionStatus.New) && !rd2.getExecutionStatus().equals((Object)ActionStatus.Pending) && !rd2.getExecutionStatus().equals((Object)ActionStatus.Running)) continue;
            Thread.sleep(50L);
        }
        ReplicationServiceIntegrationTest.assertEquals((Object)((Object)ActionStatus.Completed), (Object)((Object)rd2.getExecutionStatus()));
    }

    public void testReplicationExecutionLocking() throws Exception {
        this.makeTransferTarget();
        ReplicationDefinition rd = this.replicationService.createReplicationDefinition("testName", "Test");
        rd.setTargetName("TestTransferTarget");
        rd.getPayload().add(this.folder1);
        rd.getPayload().add(this.folder2);
        long start = System.currentTimeMillis();
        String token = this.jobLockService.getLock(rd.getReplicationQName(), 10000L, 1L, 1);
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        try {
            this.actionService.executeAction(rd, this.replicationRoot);
        }
        catch (ReplicationServiceException e) {
            txn.rollback();
            throw e;
        }
        txn.commit();
        long end = System.currentTimeMillis();
        ReplicationServiceIntegrationTest.assertTrue((String)("Should wait for the lock, but didn't (waited " + (double)(end - start) / 1000.0 + " seconds, not 10)"), (end - start > 10000L ? 1 : 0) != 0);
    }

    public void testReplicationExecutionCancelling() throws Exception {
        int i;
        this.makeTransferTarget();
        ReplicationDefinition rd = this.replicationService.createReplicationDefinition("testName", "Test");
        rd.setTargetName("TestTransferTarget");
        rd.getPayload().add(this.folder1);
        rd.getPayload().add(this.folder2);
        String token = this.jobLockService.getLock(rd.getReplicationQName(), 2000L, 1L, 1);
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        this.actionService.executeAction(rd, this.replicationRoot, false, true);
        ReplicationServiceIntegrationTest.assertEquals((Object)((Object)ActionStatus.Pending), (Object)((Object)rd.getExecutionStatus()));
        ReplicationServiceIntegrationTest.assertEquals((boolean)false, (boolean)this.actionTrackingService.isCancellationRequested(rd));
        this.actionTrackingService.requestActionCancellation(rd);
        ReplicationServiceIntegrationTest.assertEquals((boolean)true, (boolean)this.actionTrackingService.isCancellationRequested(rd));
        txn.commit();
        for (i = 0; i < 100; ++i) {
            this.actionTrackingService.requestActionCancellation(rd);
            if (rd.getExecutionStatus().equals((Object)ActionStatus.Running)) break;
            Thread.sleep(10L);
        }
        ReplicationServiceIntegrationTest.assertEquals((Object)((Object)ActionStatus.Running), (Object)((Object)rd.getExecutionStatus()));
        ReplicationServiceIntegrationTest.assertEquals((boolean)true, (boolean)this.actionTrackingService.isCancellationRequested(rd));
        this.jobLockService.releaseLock(token, rd.getReplicationQName());
        for (i = 0; i < 10 && rd.getExecutionStatus() == ActionStatus.Running; ++i) {
            Thread.sleep(1000L);
        }
        ReplicationServiceIntegrationTest.assertEquals(null, (String)rd.getExecutionFailureMessage());
        ReplicationServiceIntegrationTest.assertNotNull((Object)rd.getLocalTransferReport());
        ReplicationServiceIntegrationTest.assertNotNull((Object)rd.getRemoteTransferReport());
        ReplicationServiceIntegrationTest.assertEquals((Object)((Object)ActionStatus.Cancelled), (Object)((Object)rd.getExecutionStatus()));
    }

    public void testExecutionResult() throws Exception {
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        ReplicationServiceIntegrationTest.assertEquals((int)0, (int)this.nodeService.getChildAssocs(this.destinationFolder).size());
        this.makeTransferTarget();
        String folder2Name = (String)this.nodeService.getProperties(this.folder2).get(ContentModel.PROP_NAME);
        NodeRef folderT2 = this.makeNode(this.destinationFolder, ContentModel.TYPE_FOLDER, folder2Name);
        txn.commit();
        ReplicationDefinition rd = this.replicationService.createReplicationDefinition("testName", "Test");
        rd.setTargetName("TestTransferTarget");
        rd.getPayload().add(this.folder1);
        rd.getPayload().add(this.folder2a);
        ReplicationServiceIntegrationTest.assertEquals(null, (Object)rd.getLocalTransferReport());
        ReplicationServiceIntegrationTest.assertEquals(null, (Object)rd.getRemoteTransferReport());
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        try {
            this.actionService.executeAction(rd, this.replicationRoot);
        }
        catch (ReplicationServiceException e) {
            txn.rollback();
            throw e;
        }
        txn.commit();
        ReplicationServiceIntegrationTest.assertEquals((int)2, (int)this.nodeService.getChildAssocs(this.destinationFolder).size());
        NodeRef c1 = ((ChildAssociationRef)this.nodeService.getChildAssocs(this.destinationFolder).get(0)).getChildRef();
        NodeRef c2 = ((ChildAssociationRef)this.nodeService.getChildAssocs(this.destinationFolder).get(1)).getChildRef();
        NodeRef folderT1 = null;
        boolean foundT1 = false;
        boolean foundT2 = false;
        if (this.nodeService.getProperty(this.folder1, ContentModel.PROP_NAME).equals(this.nodeService.getProperty(c1, ContentModel.PROP_NAME))) {
            folderT1 = c1;
            foundT1 = true;
        }
        if (this.nodeService.getProperty(this.folder1, ContentModel.PROP_NAME).equals(this.nodeService.getProperty(c2, ContentModel.PROP_NAME))) {
            folderT1 = c2;
            foundT1 = true;
        }
        if (c1.equals((Object)folderT2) || c2.equals((Object)folderT2)) {
            foundT2 = true;
        }
        if (!foundT1) {
            ReplicationServiceIntegrationTest.fail((String)"Folder 1 not found in the destination");
        }
        if (!foundT2) {
            ReplicationServiceIntegrationTest.fail((String)"Folder 2 not found in the destination");
        }
        ReplicationServiceIntegrationTest.assertEquals((int)3, (int)this.nodeService.getChildAssocs(folderT1).size());
        for (ChildAssociationRef r : this.nodeService.getChildAssocs(folderT1)) {
            if (!this.nodeService.getType(r.getChildRef()).equals((Object)ContentModel.TYPE_AUTHORITY)) continue;
            ReplicationServiceIntegrationTest.fail((String)("Found authority as " + r.getChildRef() + " but it shouldn't be transfered!"));
        }
        ReplicationServiceIntegrationTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(folderT2).size());
        NodeRef folderT2a = ((ChildAssociationRef)this.nodeService.getChildAssocs(folderT2).get(0)).getChildRef();
        ReplicationServiceIntegrationTest.assertEquals((Object)this.nodeService.getProperty(this.folder2a, ContentModel.PROP_NAME), (Object)this.nodeService.getProperty(folderT2a, ContentModel.PROP_NAME));
        for (ChildAssociationRef r : this.nodeService.getChildAssocs(folderT2)) {
            ReplicationServiceIntegrationTest.assertNotSame((Object)this.nodeService.getProperty(this.folder2b, ContentModel.PROP_NAME), (Object)this.nodeService.getProperty(r.getChildRef(), ContentModel.PROP_NAME));
        }
        ReplicationServiceIntegrationTest.assertEquals((int)2, (int)this.nodeService.getChildAssocs(folderT2a).size());
        for (ChildAssociationRef r : this.nodeService.getChildAssocs(folderT2a)) {
            if (!this.nodeService.getType(r.getChildRef()).equals((Object)ContentModel.TYPE_ZONE)) continue;
            ReplicationServiceIntegrationTest.fail((String)("Found zone as " + r.getChildRef() + " but it shouldn't be transfered!"));
        }
        NodeRef localReport = rd.getLocalTransferReport();
        ReplicationServiceIntegrationTest.assertNotNull((Object)localReport);
        NodeRef remoteReport = rd.getRemoteTransferReport();
        ReplicationServiceIntegrationTest.assertNotNull((Object)remoteReport);
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        ContentReader localReader = this.contentService.getReader(localReport, ContentModel.PROP_CONTENT);
        String localReportContent = localReader.getContentString();
        ReplicationServiceIntegrationTest.assertTrue((String)("XML not found in:\n" + localReportContent), (boolean)localReportContent.contains("<?xml"));
        ReplicationServiceIntegrationTest.assertTrue((String)("Report XML not found in:\n" + localReportContent), (boolean)localReportContent.contains("<report:transferReport"));
        ContentReader remoteReader = this.contentService.getReader(remoteReport, ContentModel.PROP_CONTENT);
        String remoteReportContent = remoteReader.getContentString();
        ReplicationServiceIntegrationTest.assertTrue((String)("XML not found in:\n" + remoteReportContent), (boolean)remoteReportContent.contains("<?xml"));
        ReplicationServiceIntegrationTest.assertTrue((String)("Report Status not found in:\n" + remoteReportContent), (boolean)remoteReportContent.contains("state=\"COMPLETE\""));
        txn.commit();
    }

    public void testReplicationPayloadExpansion() throws Exception {
        ReplicationDefinition rd = this.replicationService.createReplicationDefinition("testName", "Test");
        rd.getPayload().clear();
        rd.getPayload().add(this.folder2b);
        Set<NodeRef> expanded = this.replicationActionExecutor.expandPayload(rd);
        ReplicationServiceIntegrationTest.assertEquals((int)1, (int)expanded.size());
        ReplicationServiceIntegrationTest.assertTrue((boolean)expanded.contains(this.folder2b));
        rd.getPayload().clear();
        rd.getPayload().add(this.folder1);
        expanded = this.replicationActionExecutor.expandPayload(rd);
        ReplicationServiceIntegrationTest.assertEquals((int)4, (int)expanded.size());
        ReplicationServiceIntegrationTest.assertTrue((boolean)expanded.contains(this.folder1));
        ReplicationServiceIntegrationTest.assertTrue((boolean)expanded.contains(this.content1_1));
        ReplicationServiceIntegrationTest.assertTrue((boolean)expanded.contains(this.content1_2));
        ReplicationServiceIntegrationTest.assertTrue((boolean)expanded.contains(this.thumbnail1_3));
        ReplicationServiceIntegrationTest.assertFalse((boolean)expanded.contains(this.authority1_4));
        rd.getPayload().clear();
        rd.getPayload().add(this.folder2);
        expanded = this.replicationActionExecutor.expandPayload(rd);
        ReplicationServiceIntegrationTest.assertEquals((int)5, (int)expanded.size());
        ReplicationServiceIntegrationTest.assertTrue((boolean)expanded.contains(this.folder2));
        ReplicationServiceIntegrationTest.assertTrue((boolean)expanded.contains(this.folder2a));
        ReplicationServiceIntegrationTest.assertTrue((boolean)expanded.contains(this.content2a_1));
        ReplicationServiceIntegrationTest.assertTrue((boolean)expanded.contains(this.thumbnail2a_2));
        ReplicationServiceIntegrationTest.assertFalse((boolean)expanded.contains(this.zone2a_3));
        ReplicationServiceIntegrationTest.assertTrue((boolean)expanded.contains(this.folder2b));
        rd.getPayload().clear();
        rd.getPayload().add(this.folder1);
        rd.getPayload().add(this.folder2);
        expanded = this.replicationActionExecutor.expandPayload(rd);
        ReplicationServiceIntegrationTest.assertEquals((int)9, (int)expanded.size());
        ReplicationServiceIntegrationTest.assertTrue((boolean)expanded.contains(this.folder1));
        ReplicationServiceIntegrationTest.assertTrue((boolean)expanded.contains(this.content1_1));
        ReplicationServiceIntegrationTest.assertTrue((boolean)expanded.contains(this.content1_2));
        ReplicationServiceIntegrationTest.assertTrue((boolean)expanded.contains(this.thumbnail1_3));
        ReplicationServiceIntegrationTest.assertTrue((boolean)expanded.contains(this.folder2));
        ReplicationServiceIntegrationTest.assertTrue((boolean)expanded.contains(this.folder2a));
        ReplicationServiceIntegrationTest.assertTrue((boolean)expanded.contains(this.content2a_1));
        ReplicationServiceIntegrationTest.assertTrue((boolean)expanded.contains(this.thumbnail2a_2));
        ReplicationServiceIntegrationTest.assertTrue((boolean)expanded.contains(this.folder2b));
    }

    public void testTransferDefinitionBuilding() throws Exception {
        ReplicationDefinition rd = this.replicationService.createReplicationDefinition("testName", "Test");
        HashSet<NodeRef> nodes = new HashSet<NodeRef>();
        nodes.add(this.folder1);
        nodes.add(this.content1_1);
        TransferDefinition td = this.replicationActionExecutor.buildTransferDefinition(rd, nodes);
        ReplicationServiceIntegrationTest.assertEquals((boolean)true, (boolean)td.isSync());
        ReplicationServiceIntegrationTest.assertEquals((boolean)this.replicationParams.getTransferReadOnly(), (boolean)td.isReadOnly());
        ReplicationServiceIntegrationTest.assertEquals((int)2, (int)td.getNodes().size());
        ReplicationServiceIntegrationTest.assertEquals((boolean)true, (boolean)td.getNodes().contains(this.folder1));
        ReplicationServiceIntegrationTest.assertEquals((boolean)true, (boolean)td.getNodes().contains(this.content1_1));
    }

    public void testScheduling() throws Exception {
        ReplicationDefinition rd = this.replicationService.createReplicationDefinition("testName", "Test");
        rd.setTargetName("Target");
        ReplicationServiceIntegrationTest.assertFalse((boolean)rd.isSchedulingEnabled());
        this.replicationService.disableScheduling(rd);
        ReplicationServiceIntegrationTest.assertFalse((boolean)rd.isSchedulingEnabled());
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new DoInTransaction(rd){

            public Void execute() throws Throwable {
                ReplicationServiceIntegrationTest.this.replicationService.saveReplicationDefinition(this.replicationDefinition);
                ReplicationServiceIntegrationTest.this.replicationService.enableScheduling(this.replicationDefinition);
                Assert.assertTrue((boolean)this.replicationDefinition.isSchedulingEnabled());
                return null;
            }
        }, false, true);
        ReplicationServiceIntegrationTest.assertTrue((boolean)rd.isSchedulingEnabled());
        this.replicationService.enableScheduling(rd);
        ReplicationServiceIntegrationTest.assertTrue((boolean)rd.isSchedulingEnabled());
        ReplicationServiceIntegrationTest.assertNull((Object)rd.getScheduleStart());
        ReplicationServiceIntegrationTest.assertNull((Object)rd.getScheduleIntervalCount());
        ReplicationServiceIntegrationTest.assertNull((Object)((Object)rd.getScheduleIntervalPeriod()));
        rd.setScheduleStart(new Date(1L));
        ReplicationServiceIntegrationTest.assertEquals((long)1L, (long)rd.getScheduleStart().getTime());
        ReplicationServiceIntegrationTest.assertEquals(null, (Object)rd.getScheduleIntervalCount());
        ReplicationServiceIntegrationTest.assertEquals(null, (Object)((Object)rd.getScheduleIntervalPeriod()));
        ReplicationDefinition rd2 = this.replicationService.loadReplicationDefinition("testName");
        ReplicationServiceIntegrationTest.assertEquals((boolean)false, (boolean)rd2.isSchedulingEnabled());
        ReplicationServiceIntegrationTest.assertEquals(null, (Object)rd2.getScheduleStart());
        ReplicationServiceIntegrationTest.assertEquals(null, (Object)rd2.getScheduleIntervalCount());
        ReplicationServiceIntegrationTest.assertEquals(null, (Object)((Object)rd2.getScheduleIntervalPeriod()));
        ReplicationServiceIntegrationTest.assertEquals((boolean)true, (boolean)rd.isSchedulingEnabled());
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new DoInTransaction(rd){

            public Void execute() throws Throwable {
                ReplicationServiceIntegrationTest.this.replicationService.saveReplicationDefinition(this.replicationDefinition);
                return null;
            }
        }, false, true);
        ReplicationServiceIntegrationTest.assertEquals((boolean)true, (boolean)rd.isSchedulingEnabled());
        ReplicationServiceIntegrationTest.assertEquals((long)1L, (long)rd.getScheduleStart().getTime());
        ReplicationServiceIntegrationTest.assertEquals(null, (Object)rd.getScheduleIntervalCount());
        ReplicationServiceIntegrationTest.assertEquals(null, (Object)((Object)rd.getScheduleIntervalPeriod()));
        rd = this.replicationService.loadReplicationDefinition("testName");
        ReplicationServiceIntegrationTest.assertEquals((boolean)true, (boolean)rd.isSchedulingEnabled());
        ReplicationServiceIntegrationTest.assertEquals((long)1L, (long)rd.getScheduleStart().getTime());
        ReplicationServiceIntegrationTest.assertEquals(null, (Object)rd.getScheduleIntervalCount());
        ReplicationServiceIntegrationTest.assertEquals(null, (Object)((Object)rd.getScheduleIntervalPeriod()));
        rd.setScheduleIntervalCount(2);
        rd.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Hour);
        ReplicationServiceIntegrationTest.assertEquals((boolean)true, (boolean)rd.isSchedulingEnabled());
        ReplicationServiceIntegrationTest.assertEquals((long)1L, (long)rd.getScheduleStart().getTime());
        ReplicationServiceIntegrationTest.assertEquals((int)2, (int)rd.getScheduleIntervalCount());
        ReplicationServiceIntegrationTest.assertEquals((Object)((Object)SchedulableAction.IntervalPeriod.Hour), (Object)((Object)rd.getScheduleIntervalPeriod()));
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new DoInTransaction(rd){

            public Void execute() throws Throwable {
                ReplicationServiceIntegrationTest.this.replicationService.saveReplicationDefinition(this.replicationDefinition);
                return null;
            }
        }, false, true);
        ReplicationServiceIntegrationTest.assertEquals((boolean)true, (boolean)rd.isSchedulingEnabled());
        ReplicationServiceIntegrationTest.assertEquals((long)1L, (long)rd.getScheduleStart().getTime());
        ReplicationServiceIntegrationTest.assertEquals((int)2, (int)rd.getScheduleIntervalCount());
        ReplicationServiceIntegrationTest.assertEquals((Object)((Object)SchedulableAction.IntervalPeriod.Hour), (Object)((Object)rd.getScheduleIntervalPeriod()));
        rd = this.replicationService.loadReplicationDefinition("testName");
        ReplicationServiceIntegrationTest.assertEquals((boolean)true, (boolean)rd.isSchedulingEnabled());
        ReplicationServiceIntegrationTest.assertEquals((long)1L, (long)rd.getScheduleStart().getTime());
        ReplicationServiceIntegrationTest.assertEquals((int)2, (int)rd.getScheduleIntervalCount());
        ReplicationServiceIntegrationTest.assertEquals((Object)((Object)SchedulableAction.IntervalPeriod.Hour), (Object)((Object)rd.getScheduleIntervalPeriod()));
        rd2 = this.replicationService.loadReplicationDefinition("testName");
        ReplicationServiceIntegrationTest.assertEquals((boolean)true, (boolean)rd2.isSchedulingEnabled());
        this.replicationService.enableScheduling(rd2);
        ReplicationServiceIntegrationTest.assertEquals((boolean)true, (boolean)rd2.isSchedulingEnabled());
        ReplicationServiceIntegrationTest.assertEquals((int)1, (int)this.replicationService.loadReplicationDefinitions().size());
        rd = this.replicationService.loadReplicationDefinitions().get(0);
        ReplicationServiceIntegrationTest.assertEquals((boolean)true, (boolean)rd.isSchedulingEnabled());
        ReplicationServiceIntegrationTest.assertEquals((long)1L, (long)rd.getScheduleStart().getTime());
        ReplicationServiceIntegrationTest.assertEquals((int)2, (int)rd.getScheduleIntervalCount());
        ReplicationServiceIntegrationTest.assertEquals((Object)((Object)SchedulableAction.IntervalPeriod.Hour), (Object)((Object)rd.getScheduleIntervalPeriod()));
        ReplicationServiceIntegrationTest.assertEquals((int)1, (int)this.replicationService.loadReplicationDefinitions("Target").size());
        rd = this.replicationService.loadReplicationDefinitions("Target").get(0);
        ReplicationServiceIntegrationTest.assertEquals((boolean)true, (boolean)rd.isSchedulingEnabled());
        ReplicationServiceIntegrationTest.assertEquals((long)1L, (long)rd.getScheduleStart().getTime());
        ReplicationServiceIntegrationTest.assertEquals((int)2, (int)rd.getScheduleIntervalCount());
        ReplicationServiceIntegrationTest.assertEquals((Object)((Object)SchedulableAction.IntervalPeriod.Hour), (Object)((Object)rd.getScheduleIntervalPeriod()));
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new DoInTransaction(rd){

            public Void execute() throws Throwable {
                ReplicationServiceIntegrationTest.this.replicationService.disableScheduling(this.replicationDefinition);
                return null;
            }
        });
        ReplicationServiceIntegrationTest.assertEquals((boolean)false, (boolean)rd.isSchedulingEnabled());
        rd = this.replicationService.loadReplicationDefinitions().get(0);
        ReplicationServiceIntegrationTest.assertEquals((boolean)false, (boolean)rd.isSchedulingEnabled());
        rd = this.replicationService.loadReplicationDefinitions("Target").get(0);
        ReplicationServiceIntegrationTest.assertEquals((boolean)false, (boolean)rd.isSchedulingEnabled());
        final int count = this.scheduledPersistedActionService.listSchedules().size();
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new DoInTransaction(rd){

            public Void execute() throws Throwable {
                ReplicationServiceIntegrationTest.this.replicationService.enableScheduling(this.replicationDefinition);
                ReplicationServiceIntegrationTest.this.replicationService.saveReplicationDefinition(this.replicationDefinition);
                Assert.assertEquals((int)(count + 1), (int)ReplicationServiceIntegrationTest.this.scheduledPersistedActionService.listSchedules().size());
                return null;
            }
        }, false, true);
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ReplicationDefinition replicationDefinition = ReplicationServiceIntegrationTest.this.replicationService.loadReplicationDefinition("testName");
                ReplicationServiceIntegrationTest.this.replicationService.deleteReplicationDefinition(replicationDefinition);
                Assert.assertEquals((int)count, (int)ReplicationServiceIntegrationTest.this.scheduledPersistedActionService.listSchedules().size());
                return null;
            }
        }, false, true);
        ReplicationServiceIntegrationTest.assertEquals((int)count, (int)this.scheduledPersistedActionService.listSchedules().size());
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ReplicationDefinition replicationDefinition = ReplicationServiceIntegrationTest.this.replicationService.createReplicationDefinition("testName", "Test");
                ReplicationServiceIntegrationTest.this.replicationService.enableScheduling(replicationDefinition);
                replicationDefinition.setScheduleStart(new Date(System.currentTimeMillis() + 50L));
                ReplicationServiceIntegrationTest.this.replicationService.saveReplicationDefinition(replicationDefinition);
                Assert.assertEquals((Object)((Object)ActionStatus.New), (Object)((Object)replicationDefinition.getExecutionStatus()));
                return null;
            }
        }, false, true);
        for (int i = 0; i < 150 && !(rd = this.replicationService.loadReplicationDefinition("testName")).getExecutionStatus().equals((Object)ActionStatus.Failed) && !rd.getExecutionStatus().equals((Object)ActionStatus.Completed); ++i) {
            Thread.sleep(10L);
        }
        ReplicationServiceIntegrationTest.assertEquals((Object)((Object)ActionStatus.Failed), (Object)((Object)rd.getExecutionStatus()));
    }

    public void testJavascriptAPI() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        ReplicationDefinition empty = this.replicationService.createReplicationDefinition("testName", "Empty");
        ReplicationDefinition persisted = this.replicationService.createReplicationDefinition("testName2", "Persisted");
        persisted.setTargetName("TestTransferTarget");
        persisted.getPayload().add(new NodeRef("workspace://SpacesStore/Testing"));
        persisted.getPayload().add(new NodeRef("workspace://SpacesStore/Testing2"));
        this.replicationService.saveReplicationDefinition(persisted);
        ReplicationDefinition persisted2 = this.replicationService.createReplicationDefinition("testName3", "Persisted2");
        persisted2.setTargetName("AnotherTarget");
        this.replicationService.saveReplicationDefinition(persisted2);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("Empty", new ScriptReplicationDefinition(serviceRegistry, this.replicationService, null, empty));
        model.put("EmptyName", "testName");
        model.put("Persisted", new ScriptReplicationDefinition(serviceRegistry, this.replicationService, null, persisted));
        model.put("PersistedName", "testName2");
        model.put("PersistedNodeRef", persisted.getNodeRef().toString());
        model.put("PersistedTarget", persisted.getTargetName());
        model.put("Persisted2", new ScriptReplicationDefinition(serviceRegistry, this.replicationService, null, persisted2));
        model.put("Persisted2Name", "testName3");
        model.put("Persisted2NodeRef", persisted2.getNodeRef().toString());
        model.put("Persisted2Target", persisted2.getTargetName());
        ClasspathScriptLocation location = new ClasspathScriptLocation("org/alfresco/repo/replication/script/test_replicationService.js");
        this.scriptService.executeScript(location, model);
    }

    private NodeRef makeNode(NodeRef parent, QName nodeType) {
        String uuid = GUID.generate();
        return this.makeNode(parent, nodeType, uuid);
    }

    private NodeRef makeNode(NodeRef parent, QName nodeType, String name) {
        HashMap<QName, String> props = new HashMap<QName, String>();
        QName newName = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)name);
        NodeRef existing = this.nodeService.getChildByName(parent, ContentModel.ASSOC_CONTAINS, name);
        if (existing != null) {
            System.err.println("Zapped existing node " + existing + " for name " + name);
            try {
                this.lockService.unlock(existing, true);
            }
            catch (UnableToReleaseLockException e) {
                // empty catch block
            }
            this.nodeService.deleteNode(existing);
        }
        props.put(ContentModel.PROP_NAME, name);
        ChildAssociationRef assoc = this.nodeService.createNode(parent, ContentModel.ASSOC_CONTAINS, newName, nodeType, props);
        return assoc.getChildRef();
    }

    private void makeTransferTarget() {
        String name = "TestTransferTarget";
        String title = "title";
        String description = "description";
        String endpointProtocol = "http";
        String endpointHost = "localhost";
        int endpointPort = 8080;
        String endpointPath = "rhubarb";
        String username = "admin";
        char[] password = "password".toCharArray();
        TransferTarget ret = this.transferService.createAndSaveTransferTarget(name, title, description, endpointProtocol, endpointHost, endpointPort, endpointPath, username, password);
        ReplicationServiceIntegrationTest.assertNotNull((String)"Transfer Target not correctly built", (Object)ret);
    }

    private void makeTransferServiceLocal() {
        TransferReceiver receiver = (TransferReceiver)ctx.getBean("transferReceiver");
        TransferManifestNodeFactory transferManifestNodeFactory = (TransferManifestNodeFactory)ctx.getBean("transferManifestNodeFactory");
        TransferServiceImpl2 transferServiceImpl = (TransferServiceImpl2)ctx.getBean("transferService2");
        ContentService contentService = (ContentService)ctx.getBean("contentService");
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(receiver, contentService, this.transactionService);
        transferServiceImpl.setTransmitter(transmitter);
        UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(transferManifestNodeFactory);
        transferServiceImpl.setTransferManifestNodeFactory(testNodeFactory);
        List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        pathMap.add((Pair<Path, Path>)new Pair((Object)this.nodeService.getPath(this.repositoryHelper.getCompanyHome()), (Object)this.nodeService.getPath(this.destinationFolder)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class DoInTransaction
    implements RetryingTransactionHelper.RetryingTransactionCallback<Void> {
        protected final ReplicationDefinition replicationDefinition;

        private DoInTransaction(ReplicationDefinition rd) {
            this.replicationDefinition = rd;
        }
    }
}

