/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.replication.script;

import java.util.List;
import org.alfresco.repo.jscript.ScriptAction;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.replication.ReplicationDefinition;
import org.alfresco.service.cmr.replication.ReplicationService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.mozilla.javascript.Scriptable;

public final class ScriptReplicationDefinition
extends ScriptAction {
    private static final long serialVersionUID = -6729144733846247372L;
    private ReplicationService replicationService;

    public ScriptReplicationDefinition(ServiceRegistry serviceRegistry, ReplicationService replicationService, Scriptable scope, ReplicationDefinition replicationDefinition) {
        super(serviceRegistry, replicationDefinition, null);
        this.replicationService = replicationService;
    }

    public String getReplicationName() {
        return this.getReplicationDefinition().getReplicationName();
    }

    public String getDescription() {
        return this.getReplicationDefinition().getDescription();
    }

    public String getTargetName() {
        return this.getReplicationDefinition().getTargetName();
    }

    public void setTargetName(String target) {
        this.getReplicationDefinition().setTargetName(target);
    }

    public ScriptNode[] getPayload() {
        List<NodeRef> payload = this.getReplicationDefinition().getPayload();
        ScriptNode[] nodes = new ScriptNode[payload.size()];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = new ScriptNode(payload.get(i), this.services);
        }
        return nodes;
    }

    public void setPayload(ScriptNode[] payloadNodes) {
        List<NodeRef> payload = this.getReplicationDefinition().getPayload();
        payload.clear();
        for (ScriptNode payloadNode : payloadNodes) {
            payload.add(payloadNode.getNodeRef());
        }
    }

    public String toString() {
        StringBuilder msg = new StringBuilder();
        msg.append(this.getClass().getSimpleName()).append("[").append(this.getReplicationName()).append("]");
        return msg.toString();
    }

    ReplicationDefinition getReplicationDefinition() {
        return (ReplicationDefinition)this.action;
    }

    public void replicate() {
        this.executeImpl(null);
    }

    protected void executeImpl(ScriptNode node) {
        ReplicationDefinition replicationDefinition = this.getReplicationDefinition();
        this.replicationService.replicate(replicationDefinition);
    }
}

