/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule.ruletrigger;

import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.rule.ruletrigger.RuleTriggerAbstractBase;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.namespace.QName;

public class OnMoveNodeRuleTrigger
extends RuleTriggerAbstractBase
implements NodeServicePolicies.OnMoveNodePolicy {
    private static final String POLICY_NAME = NodeServicePolicies.OnMoveNodePolicy.QNAME.getLocalName();
    private boolean isClassBehaviour = false;

    public void setIsClassBehaviour(boolean isClassBehaviour) {
        this.isClassBehaviour = isClassBehaviour;
    }

    public void registerRuleTrigger() {
        if (this.isClassBehaviour) {
            this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)POLICY_NAME), this, (Behaviour)new JavaBehaviour(this, POLICY_NAME));
        } else {
            this.policyComponent.bindAssociationBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)POLICY_NAME), this, (Behaviour)new JavaBehaviour(this, POLICY_NAME));
        }
    }

    public void onMoveNode(ChildAssociationRef oldChildAssocRef, ChildAssociationRef newChildAssocRef) {
        if (!this.areRulesEnabled()) {
            return;
        }
        if (!oldChildAssocRef.getParentRef().equals((Object)newChildAssocRef.getParentRef())) {
            this.triggerChildrenRules(newChildAssocRef, newChildAssocRef);
        }
    }

    private void triggerChildrenRules(ChildAssociationRef oldChildAssocRef, ChildAssociationRef newChildAssocRef) {
        if (!this.areRulesEnabled()) {
            return;
        }
        this.triggerRules(newChildAssocRef.getParentRef(), newChildAssocRef.getChildRef());
        for (ChildAssociationRef ref : this.nodeService.getChildAssocs(newChildAssocRef.getChildRef())) {
            this.triggerChildrenRules(ref, ref);
        }
    }
}

