/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.search.AVMSnapShotTriggeredIndexingMethodInterceptor;
import org.alfresco.repo.search.IndexMode;
import org.alfresco.repo.search.Indexer;
import org.alfresco.repo.search.IndexerAndSearcher;
import org.alfresco.repo.search.impl.lucene.AVMLuceneIndexer;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVMSnapShotTriggeredIndexingMethodInterceptorImpl
implements AVMSnapShotTriggeredIndexingMethodInterceptor {
    private static Log logger = LogFactory.getLog(AVMSnapShotTriggeredIndexingMethodInterceptorImpl.class);
    private AVMService avmService;
    private IndexerAndSearcher indexerAndSearcher;
    private boolean enableIndexing = true;
    private IndexMode defaultMode = IndexMode.ASYNCHRONOUS;
    private Map<String, IndexMode> modeCache = new HashMap<String, IndexMode>();
    private List<IndexingDefinition> indexingDefinitions = new ArrayList<IndexingDefinition>();

    @Override
    public Object invoke(MethodInvocation mi) throws Throwable {
        if (this.enableIndexing) {
            if (mi.getMethod().getName().equals("createSnapshot")) {
                Object returnValue = mi.proceed();
                Map snapShots = (Map)returnValue;
                for (String store : snapShots.keySet()) {
                    int after = (Integer)snapShots.get(store);
                    this.indexSnapshot(store, after);
                }
                return returnValue;
            }
            if (mi.getMethod().getName().equals("purgeStore")) {
                AVMLuceneIndexer avmIndexer;
                String store = (String)mi.getArguments()[0];
                Object returnValue = mi.proceed();
                if (this.getIndexMode(store) != IndexMode.UNINDEXED && (avmIndexer = this.getIndexer(store)) != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("purgeStore " + store), (Throwable)new Exception("Stack Trace"));
                    }
                    avmIndexer.deleteIndex(store, IndexMode.SYNCHRONOUS);
                }
                return returnValue;
            }
            if (mi.getMethod().getName().equals("createStore")) {
                String store = (String)mi.getArguments()[0];
                Object returnValue = mi.proceed();
                if (this.getIndexMode(store) != IndexMode.UNINDEXED) {
                    this.createIndex(store);
                }
                return returnValue;
            }
            if (mi.getMethod().getName().equals("renameStore")) {
                AVMLuceneIndexer avmIndexer;
                String from = (String)mi.getArguments()[0];
                String to = (String)mi.getArguments()[1];
                Object returnValue = mi.proceed();
                int after = this.avmService.getLatestSnapshotID(to);
                if (this.getIndexMode(from) != IndexMode.UNINDEXED && (avmIndexer = this.getIndexer(from)) != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("renameStore deleteIndex " + from), (Throwable)new Exception("Stack Trace"));
                    }
                    avmIndexer.deleteIndex(from, IndexMode.SYNCHRONOUS);
                }
                if (this.getIndexMode(to) != IndexMode.UNINDEXED && (avmIndexer = this.getIndexer(to)) != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("renameStore createIndex " + to + "(0, " + after + ")"), (Throwable)new Exception("Stack Trace"));
                    }
                    avmIndexer.createIndex(to, IndexMode.SYNCHRONOUS);
                    avmIndexer.index(to, 0, after, this.getIndexMode(to));
                }
                return returnValue;
            }
            return mi.proceed();
        }
        return mi.proceed();
    }

    @Override
    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    @Override
    public void setIndexerAndSearcher(IndexerAndSearcher indexerAndSearcher) {
        this.indexerAndSearcher = indexerAndSearcher;
    }

    @Override
    public void setEnableIndexing(boolean enableIndexing) {
        this.enableIndexing = enableIndexing;
    }

    @Override
    public void setIndexingDefinitions(List<String> definitions) {
        this.indexingDefinitions.clear();
        for (String def : definitions) {
            IndexingDefinition id = new IndexingDefinition(def);
            this.indexingDefinitions.add(id);
        }
    }

    @Override
    public void setDefaultMode(IndexMode defaultMode) {
        this.defaultMode = defaultMode;
    }

    @Override
    public boolean isIndexingEnabled() {
        return this.enableIndexing;
    }

    @Override
    public void indexSnapshot(String store, int before, int after) {
        this.indexSnapshotImpl(store, before, after);
    }

    @Override
    public void indexSnapshot(String store, int after) {
        this.indexSnapshotImpl(store, -1, after);
    }

    private void indexSnapshotImpl(String store, int before, int after) {
        AVMLuceneIndexer avmIndexer;
        if (this.getIndexMode(store) != IndexMode.UNINDEXED && (avmIndexer = this.getIndexer(store)) != null) {
            int from;
            int last = this.getLastIndexedSnapshot(avmIndexer, store);
            if (last == -1 && !this.hasIndexBeenCreated(store)) {
                this.createIndex(store);
                last = this.getLastIndexedSnapshot(avmIndexer, store);
            }
            int n = from = before != -1 ? before : last;
            if (from > after) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("skip indexSnapshotImpl " + store + " (" + (before == -1 ? "-1, " : "") + from + ", " + after + ")"), (Throwable)new Exception("Stack Trace"));
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("indexSnapshotImpl " + store + " (" + (before == -1 ? "-1, " : "") + from + ", " + after + ")"), (Throwable)new Exception("Stack Trace"));
                }
                avmIndexer.index(store, from, after, this.getIndexMode(store));
            }
        }
    }

    @Override
    public int getLastIndexedSnapshot(String store) {
        AVMLuceneIndexer avmIndexer = this.getIndexer(store);
        if (avmIndexer != null) {
            return this.getLastIndexedSnapshot(avmIndexer, store);
        }
        return -1;
    }

    private int getLastIndexedSnapshot(AVMLuceneIndexer avmIndexer, String store) {
        return avmIndexer.getLastIndexedSnapshot(store);
    }

    @Override
    public boolean isSnapshotIndexed(String store, int id) {
        AVMLuceneIndexer avmIndexer = this.getIndexer(store);
        if (avmIndexer != null) {
            return avmIndexer.isSnapshotIndexed(store, id);
        }
        return false;
    }

    @Override
    public boolean isIndexUpToDateAndSearchable(String store) {
        switch (this.getIndexMode(store)) {
            case UNINDEXED: {
                return false;
            }
            case SYNCHRONOUS: 
            case ASYNCHRONOUS: {
                int last = this.avmService.getLatestSnapshotID(store);
                AVMLuceneIndexer avmIndexer = this.getIndexer(store);
                if (avmIndexer != null) {
                    avmIndexer.flushPending();
                    return avmIndexer.isSnapshotSearchable(store, last);
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isIndexUpToDate(String store) {
        switch (this.getIndexMode(store)) {
            case UNINDEXED: {
                return true;
            }
            case SYNCHRONOUS: 
            case ASYNCHRONOUS: {
                int last = this.avmService.getLatestSnapshotID(store);
                AVMLuceneIndexer avmIndexer = this.getIndexer(store);
                if (avmIndexer != null) {
                    avmIndexer.flushPending();
                    return avmIndexer.isSnapshotIndexed(store, last);
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public synchronized IndexMode getIndexMode(String store) {
        IndexMode mode = this.modeCache.get(store);
        if (mode == null) {
            for (IndexingDefinition def : this.indexingDefinitions) {
                String storeType;
                if (def.definitionType == DefinitionType.NAME) {
                    if (!def.pattern.matcher(store).matches()) continue;
                    mode = def.indexMode;
                    this.modeCache.put(store, mode);
                    break;
                }
                AVMStoreDescriptor avmStoreDescriptor = this.avmService.getStore(store);
                Map<QName, PropertyValue> storeProperties = null;
                if (avmStoreDescriptor != null) {
                    storeProperties = this.avmService.getStoreProperties(store);
                }
                if (!def.pattern.matcher(storeType = StoreType.getStoreType(store, avmStoreDescriptor, storeProperties).toString()).matches()) continue;
                mode = def.indexMode;
                this.modeCache.put(store, mode);
                break;
            }
        }
        if (mode == null) {
            mode = this.defaultMode;
            this.modeCache.put(store, mode);
        }
        return mode;
    }

    @Override
    public boolean hasIndexBeenCreated(String store) {
        AVMLuceneIndexer avmIndexer = this.getIndexer(store);
        if (avmIndexer != null) {
            avmIndexer.flushPending();
            return avmIndexer.hasIndexBeenCreated(store);
        }
        return false;
    }

    @Override
    public void createIndex(String store) {
        AVMLuceneIndexer avmIndexer = this.getIndexer(store);
        if (avmIndexer != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("createIndex " + store), (Throwable)new Exception("Stack Trace"));
            }
            avmIndexer.createIndex(store, IndexMode.SYNCHRONOUS);
        }
    }

    @Override
    public AVMLuceneIndexer getIndexer(String store) {
        StoreRef storeRef = AVMNodeConverter.ToStoreRef(store);
        Indexer indexer = this.indexerAndSearcher.getIndexer(storeRef);
        if (indexer instanceof AVMLuceneIndexer) {
            AVMLuceneIndexer avmIndexer = (AVMLuceneIndexer)indexer;
            return avmIndexer;
        }
        return null;
    }

    @Override
    public void deleteIndex(String store) {
        StoreRef storeRef = AVMNodeConverter.ToStoreRef(store);
        Indexer indexer = this.indexerAndSearcher.getIndexer(storeRef);
        if (indexer instanceof AVMLuceneIndexer) {
            AVMLuceneIndexer avmIndexer = (AVMLuceneIndexer)indexer;
            avmIndexer.deleteIndex(storeRef);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StoreType {
        STAGING,
        STAGING_PREVIEW,
        AUTHOR,
        AUTHOR_PREVIEW,
        WORKFLOW,
        WORKFLOW_PREVIEW,
        AUTHOR_WORKFLOW,
        AUTHOR_WORKFLOW_PREVIEW,
        UNKNOWN;


        public static StoreType getStoreType(String name, AVMStoreDescriptor storeDescriptor, Map<QName, PropertyValue> storeProperties) {
            if (storeDescriptor != null) {
                if (storeProperties.containsKey(AVMSnapShotTriggeredIndexingMethodInterceptor.PROP_SANDBOX_STAGING_MAIN)) {
                    return STAGING;
                }
                if (storeProperties.containsKey(AVMSnapShotTriggeredIndexingMethodInterceptor.PROP_SANDBOX_STAGING_PREVIEW)) {
                    return STAGING_PREVIEW;
                }
                if (storeProperties.containsKey(AVMSnapShotTriggeredIndexingMethodInterceptor.PROP_SANDBOX_AUTHOR_MAIN)) {
                    return AUTHOR;
                }
                if (storeProperties.containsKey(AVMSnapShotTriggeredIndexingMethodInterceptor.PROP_SANDBOX_AUTHOR_PREVIEW)) {
                    return AUTHOR_PREVIEW;
                }
                if (storeProperties.containsKey(AVMSnapShotTriggeredIndexingMethodInterceptor.PROP_SANDBOX_WORKFLOW_MAIN)) {
                    return WORKFLOW;
                }
                if (storeProperties.containsKey(AVMSnapShotTriggeredIndexingMethodInterceptor.PROP_SANDBOX_WORKFLOW_PREVIEW)) {
                    return WORKFLOW_PREVIEW;
                }
                if (storeProperties.containsKey(AVMSnapShotTriggeredIndexingMethodInterceptor.PROP_SANDBOX_AUTHOR_WORKFLOW_MAIN)) {
                    return AUTHOR_WORKFLOW;
                }
                if (storeProperties.containsKey(AVMSnapShotTriggeredIndexingMethodInterceptor.PROP_SANDBOX_AUTHOR_WORKFLOW_PREVIEW)) {
                    return AUTHOR_WORKFLOW_PREVIEW;
                }
                return UNKNOWN;
            }
            return UNKNOWN;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DefinitionType {
        NAME,
        TYPE;

    }

    private class IndexingDefinition {
        IndexMode indexMode;
        DefinitionType definitionType;
        Pattern pattern;

        IndexingDefinition(String definition) {
            String[] split = definition.split(":", 3);
            if (split.length != 3) {
                throw new AlfrescoRuntimeException("Invalid index defintion. Must be of of the form IndexMode:DefinitionType:regular expression");
            }
            this.indexMode = IndexMode.valueOf(split[0].toUpperCase());
            this.definitionType = DefinitionType.valueOf(split[1].toUpperCase());
            this.pattern = Pattern.compile(split[2]);
        }
    }
}

