/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.repo.dictionary.IndexTokenisationMode;
import org.alfresco.repo.search.IndexerException;
import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.repo.search.impl.lucene.ADMLuceneIndexer;
import org.alfresco.repo.search.impl.lucene.ADMLuceneNoActionIndexerImpl;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneIndexerImpl;
import org.alfresco.repo.search.impl.lucene.ClosingIndexSearcher;
import org.alfresco.repo.search.impl.lucene.LuceneConfig;
import org.alfresco.repo.search.impl.lucene.LuceneIndexException;
import org.alfresco.repo.search.impl.lucene.MultiReader;
import org.alfresco.repo.search.impl.lucene.analysis.DateTimeAnalyser;
import org.alfresco.repo.search.impl.lucene.analysis.MLTokenDuplicator;
import org.alfresco.repo.search.impl.lucene.analysis.VerbatimAnalyser;
import org.alfresco.repo.search.impl.lucene.fts.FTSIndexerAware;
import org.alfresco.repo.search.impl.lucene.fts.FullTextSearchIndexer;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.TypeConversionException;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.CachingDateFormat;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.ISO9075;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADMLuceneIndexerImpl
extends AbstractLuceneIndexerImpl<NodeRef>
implements ADMLuceneIndexer {
    private static final int PATH_GENERATION_FACTOR = 5;
    static Log s_logger = LogFactory.getLog(ADMLuceneIndexerImpl.class);
    NodeService nodeService;
    TenantService tenantService;
    ContentService contentService;
    private TransformerDebug transformerDebug;
    FTSIndexerAware callBack;
    int remainingCount = 0;
    private Map<String, Deque<Helper>> toFTSIndex = Collections.emptyMap();
    FullTextSearchIndexer fullTextSearchIndexer;

    ADMLuceneIndexerImpl() {
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setTransformerDebug(TransformerDebug transformerDebug) {
        this.transformerDebug = transformerDebug;
    }

    @Override
    public void createNode(ChildAssociationRef relationshipRef) throws LuceneIndexException {
        if (s_logger.isDebugEnabled()) {
            NodeRef parentRef = relationshipRef.getParentRef();
            Path path = parentRef == null ? new Path() : this.nodeService.getPath(parentRef);
            path.append((Path.Element)new Path.ChildAssocElement(relationshipRef));
            s_logger.debug((Object)("Create node " + path + " " + relationshipRef.getChildRef()));
        }
        this.checkAbleToDoWork(AbstractLuceneIndexerImpl.IndexUpdateStatus.SYNCRONOUS);
        try {
            NodeRef childRef = relationshipRef.getChildRef();
            if (!childRef.getStoreRef().equals((Object)this.store)) {
                throw new LuceneIndexException("Create node failed - node is not in the required store");
            }
            if (relationshipRef.getParentRef() == null && this.tenantService.getBaseName(childRef).equals((Object)this.nodeService.getRootNode(childRef.getStoreRef()))) {
                this.addRootNodesToDeletionList();
                s_logger.warn((Object)"Detected root node addition: deleting all nodes from the index");
            }
            this.index(childRef);
        }
        catch (LuceneIndexException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException("Create node failed", (Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRootNodesToDeletionList() {
        block12: {
            IndexReader mainReader = null;
            try {
                try {
                    mainReader = this.getReader();
                    TermDocs td = mainReader.termDocs(new Term("ISROOT", "T"));
                    while (td.next()) {
                        int doc = td.doc();
                        Document document = mainReader.document(doc);
                        String id = document.get("ID");
                        NodeRef ref = new NodeRef(id);
                        this.deleteImpl(ref.toString(), this.getDeltaReader(), mainReader);
                    }
                    td.close();
                }
                catch (IOException e) {
                    throw new LuceneIndexException("Failed to delete all primary nodes", e);
                }
                Object var8_8 = null;
                if (mainReader == null) break block12;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (mainReader != null) {
                    try {
                        mainReader.close();
                    }
                    catch (IOException e) {
                        throw new LuceneIndexException("Filed to close main reader", e);
                    }
                }
                try {
                    this.closeDeltaReader();
                }
                catch (Exception e) {
                    s_logger.warn((Object)"Failed to close delta reader", (Throwable)e);
                }
                throw throwable;
            }
            try {
                mainReader.close();
            }
            catch (IOException e) {
                throw new LuceneIndexException("Filed to close main reader", e);
            }
        }
        try {
            this.closeDeltaReader();
        }
        catch (Exception e) {
            s_logger.warn((Object)"Failed to close delta reader", (Throwable)e);
        }
    }

    @Override
    public void updateNode(NodeRef nodeRef) throws LuceneIndexException {
        nodeRef = this.tenantService.getName(nodeRef);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Update node " + this.nodeService.getPath(nodeRef) + " " + nodeRef));
        }
        this.checkAbleToDoWork(AbstractLuceneIndexerImpl.IndexUpdateStatus.SYNCRONOUS);
        try {
            if (!nodeRef.getStoreRef().equals((Object)this.store)) {
                throw new LuceneIndexException("Update node failed - node is not in the required store");
            }
            this.reindex(nodeRef, false);
        }
        catch (LuceneIndexException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException("Update node failed", (Throwable)((Object)e));
        }
    }

    @Override
    public void deleteNode(ChildAssociationRef relationshipRef) throws LuceneIndexException {
        if (s_logger.isDebugEnabled()) {
            NodeRef parentRef = relationshipRef.getParentRef();
            Path path = parentRef == null ? new Path() : this.nodeService.getPath(parentRef);
            path.append((Path.Element)new Path.ChildAssocElement(relationshipRef));
            s_logger.debug((Object)("Delete node " + path + " " + relationshipRef.getChildRef()));
        }
        this.checkAbleToDoWork(AbstractLuceneIndexerImpl.IndexUpdateStatus.SYNCRONOUS);
        try {
            if (!relationshipRef.getChildRef().getStoreRef().equals((Object)this.store)) {
                throw new LuceneIndexException("Delete node failed - node is not in the required store");
            }
            this.delete(relationshipRef.getChildRef());
        }
        catch (LuceneIndexException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException("Delete node failed", (Throwable)((Object)e));
        }
    }

    private void childRelationshipEvent(ChildAssociationRef relationshipRef, String event) throws LuceneIndexException {
        NodeRef parentRef;
        if (s_logger.isDebugEnabled()) {
            parentRef = relationshipRef.getParentRef();
            Path path = parentRef == null ? new Path() : this.nodeService.getPath(parentRef);
            path.append((Path.Element)new Path.ChildAssocElement(relationshipRef));
            s_logger.debug((Object)(event + " " + path + " " + relationshipRef.getChildRef()));
        }
        this.checkAbleToDoWork(AbstractLuceneIndexerImpl.IndexUpdateStatus.SYNCRONOUS);
        try {
            if (!relationshipRef.getChildRef().getStoreRef().equals((Object)this.store)) {
                throw new LuceneIndexException(event + " failed - node is not in the required store");
            }
            parentRef = relationshipRef.getParentRef();
            final NodeRef childRef = relationshipRef.getChildRef();
            if (parentRef != null) {
                if (this.doInReadthroughTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Boolean>(){

                    @Override
                    public Boolean execute() throws Throwable {
                        try {
                            return ADMLuceneIndexerImpl.this.nodeService.getParentAssocs(childRef).size() > 5;
                        }
                        catch (InvalidNodeRefException e) {
                            return false;
                        }
                    }
                }).booleanValue()) {
                    this.reindex(parentRef, true);
                    this.reindex(childRef, false);
                } else {
                    this.reindex(childRef, true);
                }
            } else {
                this.reindex(childRef, true);
            }
        }
        catch (LuceneIndexException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException(event + " failed", (Throwable)((Object)e));
        }
    }

    @Override
    public void createChildRelationship(ChildAssociationRef relationshipRef) throws LuceneIndexException {
        this.childRelationshipEvent(relationshipRef, "Create child relationship");
    }

    @Override
    public void updateChildRelationship(ChildAssociationRef relationshipBeforeRef, ChildAssociationRef relationshipAfterRef) throws LuceneIndexException {
        this.childRelationshipEvent(relationshipBeforeRef, "Update child relationship");
        this.childRelationshipEvent(relationshipAfterRef, "Update child relationship");
    }

    @Override
    public void deleteChildRelationship(ChildAssociationRef relationshipRef) throws LuceneIndexException {
        this.childRelationshipEvent(relationshipRef, "Delete child relationship");
    }

    @Override
    public boolean getDeleteOnlyNodes() {
        return true;
    }

    public static ADMLuceneIndexerImpl getUpdateIndexer(StoreRef storeRef, String deltaId, LuceneConfig config) throws LuceneIndexException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)"Creating indexer");
        }
        ADMLuceneIndexerImpl indexer = new ADMLuceneIndexerImpl();
        indexer.setLuceneConfig(config);
        indexer.initialise(storeRef, deltaId);
        return indexer;
    }

    public static ADMLuceneNoActionIndexerImpl getNoActionIndexer(StoreRef storeRef, String deltaId, LuceneConfig config) throws LuceneIndexException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)"Creating indexer");
        }
        ADMLuceneNoActionIndexerImpl indexer = new ADMLuceneNoActionIndexerImpl();
        indexer.setLuceneConfig(config);
        indexer.initialise(storeRef, deltaId);
        return indexer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doFTSIndexCommit() throws LuceneIndexException {
        IndexReader mainReader = null;
        IndexReader deltaReader = null;
        IndexSearcher mainSearcher = null;
        IndexSearcher deltaSearcher = null;
        try {
            try {
                Object e22;
                block26: {
                    try {
                        mainReader = this.getReader();
                        deltaReader = this.getDeltaReader();
                        mainSearcher = new IndexSearcher(mainReader);
                        deltaSearcher = new IndexSearcher(deltaReader);
                        for (Map.Entry<String, Deque<Helper>> entry : this.toFTSIndex.entrySet()) {
                            this.deletions.add(entry.getKey());
                            for (Helper helper : entry.getValue()) {
                                this.deletions.add(helper.id);
                            }
                        }
                        Object var10_11 = null;
                        if (deltaSearcher == null) break block26;
                    }
                    catch (Throwable throwable) {
                        Object e22;
                        Object var10_12 = null;
                        if (deltaSearcher != null) {
                            try {
                                deltaSearcher.close();
                            }
                            catch (IOException e22) {
                                s_logger.warn((Object)"Failed to close delta searcher", (Throwable)e22);
                            }
                        }
                        if (mainSearcher != null) {
                            try {
                                mainSearcher.close();
                            }
                            catch (IOException e22) {
                                s_logger.warn((Object)"Failed to close main searcher", (Throwable)e22);
                            }
                        }
                        try {
                            this.closeDeltaReader();
                        }
                        catch (LuceneIndexException e22) {
                            s_logger.warn((Object)"Failed to close delta reader", (Throwable)e22);
                        }
                        if (mainReader != null) {
                            try {
                                mainReader.close();
                            }
                            catch (IOException e22) {
                                s_logger.warn((Object)"Failed to close main reader", (Throwable)e22);
                            }
                        }
                        throw throwable;
                    }
                    try {
                        deltaSearcher.close();
                    }
                    catch (IOException e22) {
                        s_logger.warn((Object)"Failed to close delta searcher", (Throwable)e22);
                    }
                }
                if (mainSearcher != null) {
                    try {
                        mainSearcher.close();
                    }
                    catch (IOException e22) {
                        s_logger.warn((Object)"Failed to close main searcher", (Throwable)e22);
                    }
                }
                try {
                    this.closeDeltaReader();
                }
                catch (LuceneIndexException e22) {
                    s_logger.warn((Object)"Failed to close delta reader", (Throwable)e22);
                }
                if (mainReader != null) {
                    try {
                        mainReader.close();
                    }
                    catch (IOException e22) {
                        s_logger.warn((Object)"Failed to close main reader", (Throwable)e22);
                    }
                }
                this.setInfo(this.docs, this.getDeletions(), this.getContainerDeletions(), this.getDeleteOnlyNodes());
            }
            catch (IOException e) {
                this.rollback();
                throw new LuceneIndexException("Commit failed", e);
            }
            catch (LuceneIndexException e) {
                this.rollback();
                throw new LuceneIndexException("Commit failed", (Throwable)((Object)e));
            }
            Object var13_16 = null;
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            throw throwable;
        }
    }

    protected Set<String> deleteImpl(String nodeRef, IndexReader deltaReader, IndexReader mainReader) throws LuceneIndexException, IOException {
        LinkedHashSet<String> containerRefs = new LinkedHashSet<String>();
        Set<String> temp = ADMLuceneIndexerImpl.deleteContainerAndBelow(nodeRef, deltaReader, true, true);
        containerRefs.addAll(temp);
        temp = ADMLuceneIndexerImpl.deleteContainerAndBelow(nodeRef, mainReader, false, true);
        containerRefs.addAll(temp);
        if (!temp.isEmpty()) {
            this.containerDeletions.add(nodeRef);
        }
        LinkedHashSet<String> leafrefs = new LinkedHashSet<String>();
        temp = ADMLuceneIndexerImpl.deletePrimary(containerRefs, deltaReader, true);
        leafrefs.addAll(temp);
        temp = ADMLuceneIndexerImpl.deletePrimary(containerRefs, mainReader, false);
        leafrefs.addAll(temp);
        LinkedHashSet<String> refs = new LinkedHashSet<String>();
        refs.addAll(containerRefs);
        refs.addAll(leafrefs);
        this.deletions.addAll(refs);
        for (String id : refs) {
            this.deleteLeafOnly(id, deltaReader, true);
        }
        return refs;
    }

    public List<Document> createDocuments(final String stringNodeRef, final AbstractLuceneIndexerImpl.FTSStatus ftsStatus, final boolean indexAllProperties, final boolean includeDirectoryDocuments, final boolean cascade, final Set<Path> pathsProcessedSinceFlush, final Map<NodeRef, List<ChildAssociationRef>> childAssociationsSinceFlush, final IndexReader deltaReader, final IndexReader mainReader) {
        if (this.tenantService.isEnabled() && (AuthenticationUtil.getRunAsUser() == null || AuthenticationUtil.isRunAsUserTheSystemUser())) {
            return (List)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<List<Document>>(){

                public List<Document> doWork() {
                    return ADMLuceneIndexerImpl.this.createDocumentsImpl(stringNodeRef, ftsStatus, indexAllProperties, includeDirectoryDocuments, cascade, pathsProcessedSinceFlush, childAssociationsSinceFlush, deltaReader, mainReader);
                }
            }, (String)this.tenantService.getDomainUser(AuthenticationUtil.getSystemUserName(), this.tenantService.getDomain(new NodeRef(stringNodeRef).getStoreRef().getIdentifier())));
        }
        return this.createDocumentsImpl(stringNodeRef, ftsStatus, indexAllProperties, includeDirectoryDocuments, cascade, pathsProcessedSinceFlush, childAssociationsSinceFlush, deltaReader, mainReader);
    }

    private List<Document> createDocumentsImpl(String stringNodeRef, AbstractLuceneIndexerImpl.FTSStatus ftsStatus, boolean indexAllProperties, boolean includeDirectoryDocuments, final boolean cascade, final Set<Path> pathsProcessedSinceFlush, final Map<NodeRef, List<ChildAssociationRef>> childAssociationsSinceFlush, final IndexReader deltaReader, final IndexReader mainReader) {
        Boolean isIndexed;
        Serializable sValue;
        Boolean isIndexed2;
        Serializable sValue2;
        final NodeRef nodeRef = new NodeRef(stringNodeRef);
        NodeRef.Status nodeStatus = this.nodeService.getNodeStatus(nodeRef);
        final LinkedList<Document> docs = new LinkedList<Document>();
        if (nodeStatus == null) {
            throw new InvalidNodeRefException("Node does not exist: " + nodeRef, nodeRef);
        }
        if (nodeStatus.isDeleted()) {
            this.addFtsStatusDoc(docs, ftsStatus, nodeRef, nodeStatus);
            return docs;
        }
        Map properties = this.nodeService.getProperties(nodeRef);
        boolean isRoot = nodeRef.equals((Object)this.tenantService.getName(this.nodeService.getRootNode(nodeRef.getStoreRef())));
        if (includeDirectoryDocuments) {
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() throws Exception {
                    for (ChildAssociationRef assocRef : ADMLuceneIndexerImpl.this.nodeService.getParentAssocs(nodeRef)) {
                        String parentRefSString;
                        NodeRef parentRef = ADMLuceneIndexerImpl.this.tenantService.getName(assocRef.getParentRef());
                        if (childAssociationsSinceFlush.containsKey(parentRef) || ADMLuceneIndexerImpl.this.locateContainer(parentRefSString = parentRef.toString(), deltaReader) || ADMLuceneIndexerImpl.this.locateContainer(parentRefSString, mainReader)) continue;
                        ADMLuceneIndexerImpl.this.generateContainersAndBelow(ADMLuceneIndexerImpl.this.nodeService.getPaths(parentRef, false), docs, false, pathsProcessedSinceFlush, childAssociationsSinceFlush);
                    }
                    if (ADMLuceneIndexerImpl.this.isCategory(ADMLuceneIndexerImpl.this.getDictionaryService().getType(ADMLuceneIndexerImpl.this.nodeService.getType(nodeRef))) || ADMLuceneIndexerImpl.this.mayHaveChildren(nodeRef) && !ADMLuceneIndexerImpl.this.getCachedChildren(childAssociationsSinceFlush, nodeRef).isEmpty()) {
                        ADMLuceneIndexerImpl.this.generateContainersAndBelow(ADMLuceneIndexerImpl.this.nodeService.getPaths(nodeRef, false), docs, cascade, pathsProcessedSinceFlush, childAssociationsSinceFlush);
                    }
                    return null;
                }
            }, (String)this.tenantService.getDomainUser(AuthenticationUtil.getSystemUserName(), this.tenantService.getDomain(nodeRef.getStoreRef().getIdentifier())));
        }
        if (properties.containsKey(ContentModel.PROP_IS_INDEXED) && (sValue2 = (Serializable)properties.get(ContentModel.PROP_IS_INDEXED)) != null && (isIndexed2 = (Boolean)DefaultTypeConverter.INSTANCE.convert(Boolean.class, (Object)sValue2)) != null && !isIndexed2.booleanValue()) {
            return docs;
        }
        boolean isContentIndexedForNode = true;
        if (properties.containsKey(ContentModel.PROP_IS_CONTENT_INDEXED) && (sValue = (Serializable)properties.get(ContentModel.PROP_IS_CONTENT_INDEXED)) != null && (isIndexed = (Boolean)DefaultTypeConverter.INSTANCE.convert(Boolean.class, (Object)sValue)) != null && !isIndexed.booleanValue()) {
            isContentIndexedForNode = false;
        }
        Document xdoc = new Document();
        xdoc.add((Fieldable)new Field("ID", stringNodeRef, Field.Store.YES, Field.Index.NO_NORMS, Field.TermVector.NO));
        xdoc.add((Fieldable)new Field("TX", nodeStatus.getChangeTxnId(), Field.Store.YES, Field.Index.NO_NORMS, Field.TermVector.NO));
        boolean isAtomic = true;
        for (QName propertyName : properties.keySet()) {
            Serializable value = (Serializable)properties.get(propertyName);
            value = this.convertForMT(propertyName, value);
            if (indexAllProperties) {
                this.indexProperty(nodeRef, propertyName, value, xdoc, false, isContentIndexedForNode);
                continue;
            }
            isAtomic &= this.indexProperty(nodeRef, propertyName, value, xdoc, true, isContentIndexedForNode);
        }
        StringBuilder qNameBuffer = new StringBuilder(64);
        StringBuilder assocTypeQNameBuffer = new StringBuilder(64);
        if (!isRoot) {
            for (Pair<ChildAssociationRef, QName> pair : this.getAllParents(nodeRef, properties)) {
                ChildAssociationRef qNameRef = this.tenantService.getName(pair.getFirst());
                if (qNameRef == null || qNameRef.getParentRef() == null || qNameRef.getQName() == null) continue;
                if (qNameBuffer.length() > 0) {
                    qNameBuffer.append(";/");
                    assocTypeQNameBuffer.append(";/");
                }
                qNameBuffer.append(ISO9075.getXPathName((QName)qNameRef.getQName()));
                assocTypeQNameBuffer.append(ISO9075.getXPathName((QName)qNameRef.getTypeQName()));
                xdoc.add((Fieldable)new Field("PARENT", qNameRef.getParentRef().toString(), Field.Store.YES, Field.Index.NO_NORMS, Field.TermVector.NO));
                xdoc.add((Fieldable)new Field("LINKASPECT", pair.getSecond() == null ? "" : ISO9075.getXPathName((QName)pair.getSecond()), Field.Store.YES, Field.Index.NO_NORMS, Field.TermVector.NO));
            }
        }
        if (isRoot) {
            xdoc.add((Fieldable)new Field("ISCONTAINER", "T", Field.Store.YES, Field.Index.NO_NORMS, Field.TermVector.NO));
            xdoc.add((Fieldable)new Field("PATH", "", Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.NO));
            xdoc.add((Fieldable)new Field("QNAME", "", Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.NO));
            xdoc.add((Fieldable)new Field("ISROOT", "T", Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
            xdoc.add((Fieldable)new Field("PRIMARYASSOCTYPEQNAME", ISO9075.getXPathName((QName)ContentModel.ASSOC_CHILDREN), Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.NO));
            xdoc.add((Fieldable)new Field("ISNODE", "T", Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
            docs.add(xdoc);
        } else {
            xdoc.add((Fieldable)new Field("QNAME", qNameBuffer.toString(), Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.NO));
            xdoc.add((Fieldable)new Field("ASSOCTYPEQNAME", assocTypeQNameBuffer.toString(), Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.NO));
            ChildAssociationRef primary = this.nodeService.getPrimaryParent(nodeRef);
            xdoc.add((Fieldable)new Field("PRIMARYPARENT", this.tenantService.getName(primary.getParentRef()).toString(), Field.Store.YES, Field.Index.NO_NORMS, Field.TermVector.NO));
            xdoc.add((Fieldable)new Field("PRIMARYASSOCTYPEQNAME", ISO9075.getXPathName((QName)primary.getTypeQName()), Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.NO));
            QName typeQName = this.nodeService.getType(nodeRef);
            xdoc.add((Fieldable)new Field("TYPE", ISO9075.getXPathName((QName)typeQName), Field.Store.YES, Field.Index.NO_NORMS, Field.TermVector.NO));
            for (QName classRef : this.nodeService.getAspects(nodeRef)) {
                xdoc.add((Fieldable)new Field("ASPECT", ISO9075.getXPathName((QName)classRef), Field.Store.YES, Field.Index.NO_NORMS, Field.TermVector.NO));
            }
            xdoc.add((Fieldable)new Field("ISROOT", "F", Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
            xdoc.add((Fieldable)new Field("ISNODE", "T", Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
            if (!isAtomic && !indexAllProperties) {
                this.addFtsStatusDoc(docs, ftsStatus, nodeRef, nodeStatus);
            }
            docs.add(xdoc);
        }
        return docs;
    }

    private void generateContainersAndBelow(List<Path> paths, List<Document> docs, boolean cascade, Set<Path> pathsProcessedSinceFlush, Map<NodeRef, List<ChildAssociationRef>> childAssociationsSinceFlush) {
        if (paths.isEmpty()) {
            return;
        }
        for (Path path : paths) {
            NodeRef nodeRef = this.tenantService.getName(((Path.ChildAssocElement)path.last()).getRef().getChildRef());
            if (pathsProcessedSinceFlush.add(path)) {
                boolean isCategory = this.isCategory(this.getDictionaryService().getType(this.nodeService.getType(nodeRef)));
                if (!isCategory && (!this.mayHaveChildren(nodeRef) || this.getCachedChildren(childAssociationsSinceFlush, nodeRef).isEmpty())) continue;
                if (path.size() > 1) {
                    String pathString = path.toString();
                    if (pathString.length() > 0 && pathString.charAt(0) == '/') {
                        pathString = pathString.substring(1);
                    }
                    Document directoryEntry = new Document();
                    directoryEntry.add((Fieldable)new Field("ID", nodeRef.toString(), Field.Store.YES, Field.Index.NO_NORMS, Field.TermVector.NO));
                    directoryEntry.add((Fieldable)new Field("PATH", pathString, Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.NO));
                    for (NodeRef parent : this.getParents(path)) {
                        directoryEntry.add((Fieldable)new Field("ANCESTOR", this.tenantService.getName(parent).toString(), Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
                    }
                    directoryEntry.add((Fieldable)new Field("ISCONTAINER", "T", Field.Store.YES, Field.Index.NO_NORMS, Field.TermVector.NO));
                    if (isCategory) {
                        directoryEntry.add((Fieldable)new Field("ISCATEGORY", "T", Field.Store.YES, Field.Index.NO_NORMS, Field.TermVector.NO));
                    }
                    docs.add(directoryEntry);
                }
            }
            if (!cascade) continue;
            LinkedList<Path> childPaths = new LinkedList<Path>();
            for (ChildAssociationRef childRef : this.getCachedChildren(childAssociationsSinceFlush, nodeRef)) {
                childPaths.add(new Path().append(path).append((Path.Element)new Path.ChildAssocElement(childRef)));
            }
            this.generateContainersAndBelow(childPaths, docs, true, pathsProcessedSinceFlush, childAssociationsSinceFlush);
        }
    }

    private List<ChildAssociationRef> getCachedChildren(Map<NodeRef, List<ChildAssociationRef>> childAssociationsSinceFlush, NodeRef nodeRef) {
        List children = childAssociationsSinceFlush.get(nodeRef);
        if (children == null) {
            children = this.nodeService.getChildAssocs(nodeRef);
            for (ChildAssociationRef childRef : children) {
                childRef.setNthSibling(-1);
            }
            childAssociationsSinceFlush.put(nodeRef, children);
        }
        return children;
    }

    private void addFtsStatusDoc(List<Document> docs, AbstractLuceneIndexerImpl.FTSStatus ftsStatus, NodeRef nodeRef, NodeRef.Status nodeStatus) {
        if (ftsStatus == AbstractLuceneIndexerImpl.FTSStatus.Clean) {
            return;
        }
        Document doc = new Document();
        doc.add((Fieldable)new Field("ID", GUID.generate(), Field.Store.YES, Field.Index.NO_NORMS, Field.TermVector.NO));
        doc.add((Fieldable)new Field("FTSREF", nodeRef.toString(), Field.Store.YES, Field.Index.NO_NORMS, Field.TermVector.NO));
        doc.add((Fieldable)new Field("TX", nodeStatus.getChangeTxnId(), Field.Store.YES, Field.Index.NO_NORMS, Field.TermVector.NO));
        doc.add((Fieldable)new Field("FTSSTATUS", ftsStatus.name(), Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
        docs.add(doc);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void flushPending() throws LuceneIndexException {
        block51: {
            block46: {
                block50: {
                    block44: {
                        block45: {
                            mainReader = null;
                            try {
                                try {
                                    this.saveDelta();
                                    if (this.commandList.isEmpty()) {
                                        var12_2 = null;
                                        if (mainReader == null) break block44;
                                        break block45;
                                    }
                                    nodeActionMap = new LinkedHashMap<String, AbstractLuceneIndexerImpl.Action>(this.commandList.size() * 2);
                                    mainReader = this.getReader();
                                    deltaReader = this.getDeltaReader();
                                    block31: for (AbstractLuceneIndexerImpl.Command command : this.commandList) {
                                        if (ADMLuceneIndexerImpl.s_logger.isDebugEnabled()) {
                                            ADMLuceneIndexerImpl.s_logger.debug((Object)((Object)command.action + ": " + command.ref));
                                        }
                                        nodeRef = ((NodeRef)command.ref).toString();
                                        switch (5.$SwitchMap$org$alfresco$repo$search$impl$lucene$AbstractLuceneIndexerImpl$Action[command.action.ordinal()]) {
                                            case 1: {
                                                if (nodeActionMap.get(nodeRef) == AbstractLuceneIndexerImpl.Action.CASCADEREINDEX) break;
                                                nodeActionMap.put(nodeRef, AbstractLuceneIndexerImpl.Action.INDEX);
                                                break;
                                            }
                                            case 2: {
                                                this.deleteLeafOnly(nodeRef, deltaReader, true);
                                                if (this.deleteLeafOnly(nodeRef, mainReader, false)) {
                                                    // empty if block
                                                }
                                                this.deletions.add(nodeRef);
                                                if (nodeActionMap.containsKey(nodeRef)) break;
                                                nodeActionMap.put(nodeRef, AbstractLuceneIndexerImpl.Action.REINDEX);
                                                break;
                                            }
                                            case 3: {
                                                nodeRefSet = Collections.singleton(nodeRef);
                                                ADMLuceneIndexerImpl.deleteReference(nodeRefSet, deltaReader, true);
                                                temp = ADMLuceneIndexerImpl.deleteReference(nodeRefSet, mainReader, false);
                                                if (!temp.isEmpty()) {
                                                    this.deletions.addAll(temp);
                                                    for (String ref : temp) {
                                                        if (nodeActionMap.containsKey(ref)) continue;
                                                        nodeActionMap.put(ref, AbstractLuceneIndexerImpl.Action.REINDEX);
                                                    }
                                                }
                                            }
                                            case 4: {
                                                ADMLuceneIndexerImpl.deleteContainerAndBelow(nodeRef, deltaReader, true, true);
                                                temp = ADMLuceneIndexerImpl.deleteContainerAndBelow(nodeRef, mainReader, false, true);
                                                if (!temp.isEmpty()) {
                                                    this.containerDeletions.add(nodeRef);
                                                }
                                                if (temp.contains(nodeRef)) {
                                                    this.deletions.add(nodeRef);
                                                }
                                                nodeActionMap.put(nodeRef, AbstractLuceneIndexerImpl.Action.CASCADEREINDEX);
                                                continue block31;
                                            }
                                        }
                                    }
                                    pathsProcessedSinceFlush = new HashSet<Path>(97);
                                    childAssociationsSinceFlush = new HashMap<NodeRef, List<ChildAssociationRef>>(97);
                                    docs = new LinkedList<Document>();
                                    block33: for (Map.Entry<K, V> entry : nodeActionMap.entrySet()) {
                                        nodeRef = (String)entry.getKey();
                                        try {
                                            switch (5.$SwitchMap$org$alfresco$repo$search$impl$lucene$AbstractLuceneIndexerImpl$Action[((AbstractLuceneIndexerImpl.Action)entry.getValue()).ordinal()]) {
                                                case 1: {
                                                    docs.addAll(this.readDocuments(nodeRef, AbstractLuceneIndexerImpl.FTSStatus.New, false, true, false, pathsProcessedSinceFlush, childAssociationsSinceFlush, deltaReader, mainReader));
                                                    break;
                                                }
                                                case 2: {
                                                    docs.addAll(this.readDocuments(nodeRef, AbstractLuceneIndexerImpl.FTSStatus.Dirty, false, false, false, pathsProcessedSinceFlush, childAssociationsSinceFlush, deltaReader, mainReader));
                                                    break;
                                                }
                                                case 4: {
                                                    docs.addAll(this.readDocuments(nodeRef, AbstractLuceneIndexerImpl.FTSStatus.Dirty, false, true, true, pathsProcessedSinceFlush, childAssociationsSinceFlush, deltaReader, mainReader));
                                                    continue block33;
                                                }
                                            }
                                        }
                                        catch (InvalidNodeRefException e) {}
                                    }
                                    this.closeDeltaReader();
                                    writer = this.getDeltaWriter();
                                    for (Document doc : docs) {
                                        try {
                                            writer.addDocument(doc);
                                        }
                                        catch (IOException e) {
                                            throw new LuceneIndexException("Failed to add document to index", e);
                                        }
                                    }
                                    this.commandList.clear();
                                    this.docs = writer.docCount();
                                    break block46;
                                }
                                catch (IOException e) {
                                    throw new LuceneIndexException("Failed to flush index", e);
                                }
                            }
                            catch (Throwable var11_23) {
                                var12_4 = null;
                                if (mainReader != null) {
                                    try {
                                        mainReader.close();
                                    }
                                    catch (IOException e) {
                                        throw new LuceneIndexException("Filed to close main reader", e);
                                    }
                                }
                                try {
                                    this.closeDeltaReader();
                                }
                                catch (IOException e) {
                                    // empty catch block
                                }
                                try {
                                    this.closeDeltaWriter();
                                    throw var11_23;
                                }
                                catch (IOException e) {
                                    // empty catch block
                                }
                                throw var11_23;
                            }
                        }
                        try {}
                        catch (IOException e) {
                            throw new LuceneIndexException("Filed to close main reader", e);
                        }
                        mainReader.close();
                    }
                    ** try [egrp 5[TRYBLOCK] [8 : 818->825)] { 
lbl126:
                    // 1 sources

                    this.closeDeltaReader();
                    break block50;
lbl128:
                    // 1 sources

                    catch (IOException e) {
                        // empty catch block
                    }
                }
                ** try [egrp 6[TRYBLOCK] [9 : 827->834)] { 
lbl132:
                // 1 sources

                this.closeDeltaWriter();
                return;
lbl134:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return;
            }
            var12_3 = null;
            if (mainReader != null) {
                try {}
                catch (IOException e) {
                    throw new LuceneIndexException("Filed to close main reader", e);
                }
                mainReader.close();
            }
            ** try [egrp 5[TRYBLOCK] [8 : 818->825)] { 
lbl147:
            // 1 sources

            this.closeDeltaReader();
            break block51;
lbl149:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
        }
        try {}
        catch (IOException e) {}
        this.closeDeltaWriter();
        return;
    }

    private Serializable convertForMT(QName propertyName, Serializable inboundValue) {
        if (!this.tenantService.isEnabled()) {
            return inboundValue;
        }
        PropertyDefinition propertyDef = this.getDictionaryService().getProperty(propertyName);
        if (propertyDef != null && (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.NODE_REF) || propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CATEGORY))) {
            if (inboundValue instanceof Collection) {
                Collection in = (Collection)((Object)inboundValue);
                ArrayList<NodeRef> out = new ArrayList<NodeRef>(in.size());
                for (NodeRef o : in) {
                    out.add(this.tenantService.getName(o));
                }
                return out;
            }
            return this.tenantService.getName((NodeRef)inboundValue);
        }
        return inboundValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean indexProperty(NodeRef nodeRef, QName propertyName, Serializable value, Document doc, boolean indexAtomicPropertiesOnly, boolean isContentIndexedForNode) {
        String attributeName = "@" + QName.createQName((String)propertyName.getNamespaceURI(), (String)ISO9075.encode((String)propertyName.getLocalName()));
        boolean store = true;
        boolean index = true;
        IndexTokenisationMode tokenise = IndexTokenisationMode.TRUE;
        boolean atomic = true;
        boolean isContent = false;
        boolean isMultiLingual = false;
        boolean isText = false;
        boolean isDateTime = false;
        PropertyDefinition propertyDef = this.getDictionaryService().getProperty(propertyName);
        if (propertyDef != null) {
            index = propertyDef.isIndexed();
            store = propertyDef.isStoredInIndex();
            tokenise = propertyDef.getIndexTokenisationMode();
            atomic = propertyDef.isIndexedAtomically();
            isContent = propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT);
            isMultiLingual = propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.MLTEXT);
            isText = propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.TEXT);
            if (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.DATETIME)) {
                DataTypeDefinition dataType = propertyDef.getDataType();
                String analyserClassName = propertyDef.resolveAnalyserClassName();
                isDateTime = analyserClassName.equals(DateTimeAnalyser.class.getCanonicalName());
            }
        }
        if (value == null) {
            return true;
        }
        if (indexAtomicPropertiesOnly && !atomic) {
            return false;
        }
        if (!indexAtomicPropertiesOnly) {
            doc.removeFields(propertyName.toString());
        }
        boolean wereAllAtomic = true;
        block36: for (Serializable serializableValue : DefaultTypeConverter.INSTANCE.getCollection(Serializable.class, (Object)value)) {
            Field.Index fieldIndex;
            Field.Store fieldStore;
            String strValue = null;
            try {
                strValue = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)serializableValue);
            }
            catch (TypeConversionException e) {
                doc.add((Fieldable)new Field(attributeName, "nintc", Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
                continue;
            }
            if (strValue == null) continue;
            if (isContent) {
                Serializable localeProperty;
                ContentData contentData = (ContentData)DefaultTypeConverter.INSTANCE.convert(ContentData.class, (Object)serializableValue);
                if (!index || contentData.getMimetype() == null) continue;
                doc.add((Fieldable)new Field(attributeName + ".mimetype", contentData.getMimetype(), Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
                doc.add((Fieldable)new Field(attributeName + ".size", Long.toString(contentData.getSize()), Field.Store.NO, Field.Index.TOKENIZED, Field.TermVector.NO));
                Locale locale = contentData.getLocale();
                if (locale == null && (localeProperty = this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCALE)) != null) {
                    locale = (Locale)DefaultTypeConverter.INSTANCE.convert(Locale.class, (Object)localeProperty);
                }
                if (locale == null) {
                    locale = I18NUtil.getLocale();
                }
                doc.add((Fieldable)new Field(attributeName + ".locale", locale.toString().toLowerCase(), Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
                if (this.getLuceneConfig().isContentIndexingEnabled() && isContentIndexedForNode) {
                    ContentReader reader;
                    boolean avoidReader = this.maxAtomicTransformationTime <= 0L && indexAtomicPropertiesOnly;
                    ContentReader contentReader = reader = avoidReader ? null : this.contentService.getReader(nodeRef, propertyName);
                    if (reader != null && reader.exists()) {
                        boolean readerReady = true;
                        if (!EqualsHelper.nullSafeEquals((Object)reader.getMimetype(), (Object)"text/plain") || !EqualsHelper.nullSafeEquals((Object)reader.getEncoding(), (Object)"UTF-8")) {
                            Object var33_58;
                            try {
                                this.transformerDebug.pushAvailable(reader.getContentUrl(), reader.getMimetype(), "text/plain");
                                long sourceSize = reader.getSize();
                                List<ContentTransformer> transformers = this.contentService.getActiveTransformers(reader.getMimetype(), sourceSize, "text/plain", new TransformationOptions());
                                this.transformerDebug.availableTransformers(transformers, sourceSize, "ADMLuceneIndexer");
                                if (transformers.isEmpty()) {
                                    if (s_logger.isInfoEnabled()) {
                                        s_logger.info((Object)("Not indexed: No transformation: \n   source: " + reader + "\n" + "   target: " + "text/plain" + " at " + this.nodeService.getPath(nodeRef)));
                                    }
                                    readerReady = false;
                                    doc.add((Fieldable)new Field(attributeName, "nint", Field.Store.NO, Field.Index.TOKENIZED, Field.TermVector.NO));
                                } else if (indexAtomicPropertiesOnly && transformers.get(0).getTransformationTime() > this.maxAtomicTransformationTime) {
                                    wereAllAtomic = false;
                                    readerReady = false;
                                    if (this.transformerDebug.isEnabled()) {
                                        this.transformerDebug.debug("Run later. Transformer average (" + transformers.get(0).getTransformationTime() + " ms) > " + this.maxAtomicTransformationTime + " ms");
                                    }
                                } else {
                                    ContentTransformer transformer = transformers.get(0);
                                    ContentWriter writer = this.contentService.getTempWriter();
                                    writer.setMimetype("text/plain");
                                    writer.setEncoding("UTF-8");
                                    try {
                                        transformer.transform(reader, writer);
                                        reader = writer.getReader();
                                        if (!reader.exists()) {
                                            throw new ContentIOException("The transformation did not write any content, yet: \n   transformer:     " + transformer + "\n" + "   temp writer:     " + writer);
                                        }
                                    }
                                    catch (ContentIOException e) {
                                        if (s_logger.isInfoEnabled()) {
                                            s_logger.info((Object)("Not indexed: Transformation failed at " + this.nodeService.getPath(nodeRef)), (Throwable)e);
                                        }
                                        readerReady = false;
                                        doc.add((Fieldable)new Field(attributeName, "nitf", Field.Store.NO, Field.Index.TOKENIZED, Field.TermVector.NO));
                                    }
                                }
                                var33_58 = null;
                                this.transformerDebug.popAvailable();
                            }
                            catch (Throwable throwable) {
                                var33_58 = null;
                                this.transformerDebug.popAvailable();
                                throw throwable;
                            }
                        }
                        if (!readerReady) continue;
                        InputStreamReader isr = null;
                        InputStream ris = reader.getReader().getContentInputStream();
                        try {
                            isr = new InputStreamReader(ris, "UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            isr = new InputStreamReader(ris);
                        }
                        StringBuilder builder = new StringBuilder();
                        builder.append("\u0000").append(locale.toString()).append("\u0000");
                        StringReader prefix = new StringReader(builder.toString());
                        MultiReader multiReader = new MultiReader((Reader)prefix, (Reader)isr);
                        doc.add((Fieldable)new Field(attributeName, (Reader)multiReader, Field.TermVector.NO));
                        continue;
                    }
                    if (avoidReader) {
                        wereAllAtomic = false;
                        continue;
                    }
                    if (s_logger.isInfoEnabled()) {
                        s_logger.info((Object)("Not indexed: Content Missing \n   node: " + nodeRef + " at " + this.nodeService.getPath(nodeRef) + "\n" + "   reader: " + reader + "\n" + "   content exists: " + (reader == null ? " --- " : Boolean.toString(reader.exists()))));
                    }
                    doc.add((Fieldable)new Field(attributeName, "nicm", Field.Store.NO, Field.Index.TOKENIZED, Field.TermVector.NO));
                    continue;
                }
                wereAllAtomic = false;
                continue;
            }
            Field.Store store2 = fieldStore = store ? Field.Store.YES : Field.Store.NO;
            if (index) {
                switch (tokenise) {
                    default: {
                        fieldIndex = Field.Index.TOKENIZED;
                        break;
                    }
                    case FALSE: {
                        fieldIndex = Field.Index.UN_TOKENIZED;
                        break;
                    }
                }
            } else {
                fieldIndex = Field.Index.NO;
            }
            if (fieldIndex == Field.Index.NO && fieldStore == Field.Store.NO) continue;
            if (isMultiLingual) {
                MLText mlText = (MLText)DefaultTypeConverter.INSTANCE.convert(MLText.class, (Object)serializableValue);
                block37: for (Locale locale : mlText.getLocales()) {
                    String localeString = mlText.getValue(locale);
                    if (localeString == null) continue;
                    switch (tokenise) {
                        case TRUE: {
                            StringBuilder builder = new StringBuilder();
                            builder.append("\u0000").append(locale.toString()).append("\u0000").append(localeString);
                            doc.add((Fieldable)new Field(attributeName, builder.toString(), fieldStore, fieldIndex, Field.TermVector.NO));
                            break;
                        }
                        case FALSE: {
                            int end;
                            String localeText;
                            Token t;
                            MLAnalysisMode analysisMode = this.getLuceneConfig().getDefaultMLIndexAnalysisMode();
                            VerbatimAnalyser vba = new VerbatimAnalyser(false);
                            MLTokenDuplicator duplicator = new MLTokenDuplicator(vba.tokenStream(attributeName, (Reader)new StringReader(localeString)), locale, null, analysisMode);
                            try {
                                while ((t = duplicator.next()) != null) {
                                    localeText = "";
                                    if (t.termText().indexOf(123) == 0 && (end = t.termText().indexOf(125, 1)) != -1) {
                                        localeText = t.termText().substring(1, end);
                                    }
                                    if (localeText.length() > 0) {
                                        doc.add((Fieldable)new Field(attributeName + "." + localeText + ".sort", t.termText(), Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
                                    }
                                    doc.add((Fieldable)new Field(attributeName, t.termText(), fieldStore, Field.Index.NO_NORMS, Field.TermVector.NO));
                                }
                                continue block37;
                            }
                            catch (IOException e) {
                                break;
                            }
                        }
                        case BOTH: {
                            int end;
                            String localeText;
                            Token t;
                            StringBuilder builder = new StringBuilder();
                            builder.append("\u0000").append(locale.toString()).append("\u0000").append(localeString);
                            doc.add((Fieldable)new Field(attributeName, builder.toString(), fieldStore, fieldIndex, Field.TermVector.NO));
                            MLAnalysisMode analysisMode = this.getLuceneConfig().getDefaultMLIndexAnalysisMode();
                            VerbatimAnalyser vba = new VerbatimAnalyser(false);
                            MLTokenDuplicator duplicator = new MLTokenDuplicator(vba.tokenStream(attributeName, (Reader)new StringReader(localeString)), locale, null, analysisMode);
                            try {
                                while ((t = duplicator.next()) != null) {
                                    localeText = "";
                                    if (t.termText().indexOf(123) == 0 && (end = t.termText().indexOf(125, 1)) != -1) {
                                        localeText = t.termText().substring(1, end);
                                    }
                                    if (localeText.length() > 0) {
                                        doc.add((Fieldable)new Field(attributeName + "." + localeText + ".sort", t.termText(), Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
                                        continue;
                                    }
                                    doc.add((Fieldable)new Field(attributeName + ".no_locale", t.termText(), Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
                                }
                                continue block37;
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                    }
                }
                continue;
            }
            if (isText) {
                if (propertyName.equals((Object)ContentModel.PROP_USER_USERNAME) || propertyName.equals((Object)ContentModel.PROP_USERNAME) || propertyName.equals((Object)ContentModel.PROP_AUTHORITY_NAME)) {
                    doc.add((Fieldable)new Field(attributeName, strValue, fieldStore, fieldIndex, Field.TermVector.NO));
                }
                Locale locale = null;
                Serializable localeProperty = this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCALE);
                if (localeProperty != null) {
                    locale = (Locale)DefaultTypeConverter.INSTANCE.convert(Locale.class, (Object)localeProperty);
                }
                if (locale == null) {
                    locale = I18NUtil.getLocale();
                }
                switch (tokenise) {
                    default: {
                        StringBuilder builder = new StringBuilder();
                        builder.append("\u0000").append(locale.toString()).append("\u0000").append(strValue);
                        doc.add((Fieldable)new Field(attributeName, builder.toString(), fieldStore, fieldIndex, Field.TermVector.NO));
                        break;
                    }
                    case FALSE: {
                        String localeText;
                        Token t;
                        MLAnalysisMode analysisMode = this.getLuceneConfig().getDefaultMLIndexAnalysisMode();
                        VerbatimAnalyser vba = new VerbatimAnalyser(false);
                        MLTokenDuplicator duplicator = new MLTokenDuplicator(vba.tokenStream(attributeName, (Reader)new StringReader(strValue)), locale, null, analysisMode);
                        try {
                            while ((t = duplicator.next()) != null) {
                                int end;
                                localeText = "";
                                if (t.termText().indexOf(123) == 0 && (end = t.termText().indexOf(125, 1)) != -1) {
                                    localeText = t.termText().substring(1, end);
                                }
                                if (localeText.length() > 0) {
                                    doc.add((Fieldable)new Field(attributeName + "." + localeText + ".sort", t.termText(), Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
                                }
                                doc.add((Fieldable)new Field(attributeName, t.termText(), fieldStore, Field.Index.NO_NORMS, Field.TermVector.NO));
                            }
                            continue block36;
                        }
                        catch (IOException e) {
                            break;
                        }
                    }
                    case BOTH: {
                        String localeText;
                        Token t;
                        StringBuilder builder = new StringBuilder();
                        builder.append("\u0000").append(locale.toString()).append("\u0000").append(strValue);
                        doc.add((Fieldable)new Field(attributeName, builder.toString(), fieldStore, fieldIndex, Field.TermVector.NO));
                        MLAnalysisMode analysisMode = this.getLuceneConfig().getDefaultMLIndexAnalysisMode();
                        VerbatimAnalyser vba = new VerbatimAnalyser(false);
                        MLTokenDuplicator duplicator = new MLTokenDuplicator(vba.tokenStream(attributeName, (Reader)new StringReader(strValue)), locale, null, analysisMode);
                        try {
                            while ((t = duplicator.next()) != null) {
                                int end;
                                localeText = "";
                                if (t.termText().indexOf(123) == 0 && (end = t.termText().indexOf(125, 1)) != -1) {
                                    localeText = t.termText().substring(1, end);
                                }
                                if (localeText.length() > 0) {
                                    doc.add((Fieldable)new Field(attributeName + "." + localeText + ".sort", t.termText(), Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
                                    continue;
                                }
                                doc.add((Fieldable)new Field(attributeName + ".no_locale", t.termText(), Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
                            }
                            continue block36;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                }
                continue;
            }
            if (isDateTime) {
                switch (tokenise) {
                    default: {
                        doc.add((Fieldable)new Field(attributeName, strValue, fieldStore, fieldIndex, Field.TermVector.NO));
                        break;
                    }
                    case FALSE: {
                        Date date;
                        SimpleDateFormat df = CachingDateFormat.getDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss.SSS", (boolean)true);
                        try {
                            date = df.parse(strValue);
                            doc.add((Fieldable)new Field(attributeName, df.format(date), fieldStore, Field.Index.NO_NORMS, Field.TermVector.NO));
                        }
                        catch (ParseException e) {}
                        break;
                    }
                    case BOTH: {
                        Date date;
                        doc.add((Fieldable)new Field(attributeName, strValue, fieldStore, fieldIndex, Field.TermVector.NO));
                        SimpleDateFormat df = CachingDateFormat.getDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss.SSS", (boolean)true);
                        try {
                            date = df.parse(strValue);
                            doc.add((Fieldable)new Field(attributeName + ".sort", df.format(date), Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
                        }
                        catch (ParseException e) {}
                        break;
                    }
                }
                continue;
            }
            doc.add((Fieldable)new Field(attributeName, strValue, fieldStore, fieldIndex, Field.TermVector.NO));
        }
        return wereAllAtomic;
    }

    private boolean mayHaveChildren(NodeRef nodeRef) {
        QName nodeTypeRef = this.nodeService.getType(nodeRef);
        TypeDefinition nodeTypeDef = this.getDictionaryService().getType(nodeTypeRef);
        if (nodeTypeDef != null && nodeTypeDef.getChildAssociations().size() > 0) {
            return true;
        }
        Set aspects = this.nodeService.getAspects(nodeRef);
        for (QName aspect : aspects) {
            AspectDefinition aspectDef = this.getDictionaryService().getAspect(aspect);
            if (aspectDef == null || aspectDef.getChildAssociations().size() <= 0) continue;
            return true;
        }
        return false;
    }

    private ArrayList<NodeRef> getParents(Path path) {
        ArrayList<NodeRef> parentsInDepthOrderStartingWithSelf = new ArrayList<NodeRef>(8);
        for (Path.Element element : path) {
            if (!(element instanceof Path.ChildAssocElement)) {
                throw new IndexerException("Confused path: " + path);
            }
            Path.ChildAssocElement cae = (Path.ChildAssocElement)element;
            parentsInDepthOrderStartingWithSelf.add(0, this.tenantService.getName(cae.getRef().getChildRef()));
        }
        return parentsInDepthOrderStartingWithSelf;
    }

    private Collection<Pair<ChildAssociationRef, QName>> getAllParents(NodeRef nodeRef, Map<QName, Serializable> properties) {
        LinkedList<Pair<ChildAssociationRef, QName>> allParents = new LinkedList<Pair<ChildAssociationRef, QName>>();
        StoreRef storeRef = nodeRef.getStoreRef();
        Set allRootNodes = this.nodeService.getAllRootNodes(storeRef);
        for (ChildAssociationRef assocRef : this.nodeService.getParentAssocs(nodeRef)) {
            NodeRef rootNodeRef;
            allParents.add(new Pair<ChildAssociationRef, Object>(assocRef, null));
            NodeRef parentRef = this.tenantService.getBaseName(assocRef.getParentRef());
            if (!allRootNodes.contains(parentRef) || parentRef.equals((Object)(rootNodeRef = this.nodeService.getRootNode(parentRef.getStoreRef())))) continue;
            allParents.add(new Pair<ChildAssociationRef, Object>(new ChildAssociationRef(assocRef.getTypeQName(), rootNodeRef, assocRef.getQName(), nodeRef), null));
        }
        for (QName classRef : this.nodeService.getAspects(nodeRef)) {
            AspectDefinition aspDef = this.getDictionaryService().getAspect(classRef);
            if (!this.isCategorised(aspDef)) continue;
            for (PropertyDefinition propDef : aspDef.getProperties().values()) {
                if (!propDef.getDataType().getName().equals((Object)DataTypeDefinition.CATEGORY)) continue;
                for (NodeRef catRef : DefaultTypeConverter.INSTANCE.getCollection(NodeRef.class, (Object)properties.get(propDef.getName()))) {
                    if (catRef == null) continue;
                    catRef = this.tenantService.getName(nodeRef, catRef);
                    try {
                        for (ChildAssociationRef assocRef : this.nodeService.getParentAssocs(catRef)) {
                            allParents.add(new Pair<ChildAssociationRef, QName>(new ChildAssociationRef(assocRef.getTypeQName(), assocRef.getChildRef(), QName.createQName((String)"member"), nodeRef), aspDef.getName()));
                        }
                    }
                    catch (InvalidNodeRefException e) {
                    }
                }
            }
        }
        return allParents;
    }

    private boolean isCategorised(AspectDefinition aspDef) {
        if (aspDef == null) {
            return false;
        }
        AspectDefinition current = aspDef;
        while (current != null) {
            if (current.getName().equals((Object)ContentModel.ASPECT_CLASSIFIABLE)) {
                return true;
            }
            QName parentName = current.getParentName();
            if (parentName == null) break;
            current = this.getDictionaryService().getAspect(parentName);
        }
        return false;
    }

    private boolean isCategory(TypeDefinition typeDef) {
        if (typeDef == null) {
            return false;
        }
        TypeDefinition current = typeDef;
        while (current != null) {
            if (current.getName().equals((Object)ContentModel.TYPE_CATEGORY)) {
                return true;
            }
            QName parentName = current.getParentName();
            if (parentName == null) break;
            current = this.getDictionaryService().getType(parentName);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int updateFullTextSearch(int size) throws LuceneIndexException {
        if (!this.getLuceneConfig().isContentIndexingEnabled()) {
            return 0;
        }
        this.checkAbleToDoWork(AbstractLuceneIndexerImpl.IndexUpdateStatus.ASYNCHRONOUS);
        try {
            int n;
            ClosingIndexSearcher searcher;
            int count;
            block25: {
                int n2;
                block24: {
                    this.toFTSIndex = new LinkedHashMap<String, Deque<Helper>>(size * 2);
                    BooleanQuery booleanQuery = new BooleanQuery();
                    booleanQuery.add((Query)new TermQuery(new Term("FTSSTATUS", "Dirty")), BooleanClause.Occur.SHOULD);
                    booleanQuery.add((Query)new TermQuery(new Term("FTSSTATUS", "New")), BooleanClause.Occur.SHOULD);
                    count = 0;
                    searcher = null;
                    try {
                        Hits hits;
                        searcher = this.getSearcher(null);
                        if (searcher == null) {
                            this.remainingCount = size;
                            n2 = 0;
                            Object var14_9 = null;
                            if (searcher == null) return n2;
                            break block24;
                        }
                        try {
                            hits = searcher.search((Query)booleanQuery);
                        }
                        catch (IOException e) {
                            throw new LuceneIndexException("Failed to execute query to find content which needs updating in the index", e);
                        }
                        for (int i = 0; i < hits.length(); ++i) {
                            Document doc = hits.doc(i);
                            Field ftsRef = doc.getField("FTSREF");
                            String id = doc.getField("ID").stringValue();
                            String ref = ftsRef == null ? id : ftsRef.stringValue();
                            Helper helper = new Helper(id, doc.getField("TX").stringValue());
                            Deque<Helper> helpers = this.toFTSIndex.get(ref);
                            if (helpers == null) {
                                helpers = new LinkedList<Helper>();
                                this.toFTSIndex.put(ref, helpers);
                                ++count;
                            }
                            helpers.add(helper);
                            if (count >= size) break;
                        }
                        count = hits.length();
                        break block25;
                    }
                    catch (Throwable throwable) {
                        Object var14_11 = null;
                        if (searcher == null) throw throwable;
                        try {
                            searcher.close();
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new LuceneIndexException("Failed to close searcher", e);
                        }
                    }
                }
                try {}
                catch (IOException e) {
                    throw new LuceneIndexException("Failed to close searcher", e);
                }
                searcher.close();
                return n2;
            }
            Object var14_10 = null;
            if (searcher != null) {
                try {}
                catch (IOException e) {
                    throw new LuceneIndexException("Failed to close searcher", e);
                }
                searcher.close();
            }
            if (this.toFTSIndex.size() <= 0) return 0;
            this.checkAbleToDoWork(AbstractLuceneIndexerImpl.IndexUpdateStatus.ASYNCHRONOUS);
            IndexWriter writer = null;
            try {
                writer = this.getDeltaWriter();
                int done = 0;
                for (Map.Entry<String, Deque<Helper>> entry : this.toFTSIndex.entrySet()) {
                    List<Document> docs;
                    NodeRef ref = new NodeRef(entry.getKey());
                    done += entry.getValue().size();
                    try {
                        docs = this.readDocuments(ref.toString(), AbstractLuceneIndexerImpl.FTSStatus.Clean, true, false, false, null, null, null, null);
                    }
                    catch (Throwable t) {
                        s_logger.error((Object)("FTS index of " + ref + " failed. Reindexing without FTS"), t);
                        docs = this.readDocuments(ref.toString(), AbstractLuceneIndexerImpl.FTSStatus.Clean, false, false, false, null, null, null, null);
                    }
                    for (Document doc : docs) {
                        try {
                            writer.addDocument(doc);
                        }
                        catch (IOException e) {
                            throw new LuceneIndexException("Failed to add document while updating fts index", e);
                        }
                    }
                    if (writer.docCount() <= size) continue;
                }
                this.remainingCount = count - done;
                n = done;
                Object var17_27 = null;
                if (writer == null) return n;
            }
            catch (Throwable throwable) {
                Object var17_28 = null;
                if (writer == null) throw throwable;
                this.closeDeltaWriter();
                throw throwable;
            }
            this.closeDeltaWriter();
            return n;
        }
        catch (IOException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException("Failed FTS update", e);
        }
        catch (LuceneIndexException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException("Failed FTS update", (Throwable)((Object)e));
        }
    }

    protected List<Document> readDocuments(final String stringNodeRef, final AbstractLuceneIndexerImpl.FTSStatus ftsStatus, final boolean indexAllProperties, final boolean includeDirectoryDocuments, final boolean cascade, final Set<Path> pathsProcessedSinceFlush, final Map<NodeRef, List<ChildAssociationRef>> childAssociationsSinceFlush, final IndexReader deltaReader, final IndexReader mainReader) {
        return this.doInReadthroughTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<List<Document>>(){

            @Override
            public List<Document> execute() throws Throwable {
                return ADMLuceneIndexerImpl.this.createDocuments(stringNodeRef, ftsStatus, indexAllProperties, includeDirectoryDocuments, cascade, pathsProcessedSinceFlush, childAssociationsSinceFlush, deltaReader, mainReader);
            }
        });
    }

    @Override
    public void registerCallBack(FTSIndexerAware callBack) {
        this.callBack = callBack;
    }

    @Override
    public void setFullTextSearchIndexer(FullTextSearchIndexer fullTextSearchIndexer) {
        this.fullTextSearchIndexer = fullTextSearchIndexer;
    }

    @Override
    protected void doPrepare() throws IOException {
        this.flushPending();
    }

    @Override
    protected void doCommit() throws IOException {
        if (this.indexUpdateStatus == AbstractLuceneIndexerImpl.IndexUpdateStatus.ASYNCHRONOUS) {
            this.doFTSIndexCommit();
        } else {
            this.setInfo(this.docs, this.getDeletions(), this.getContainerDeletions(), this.getDeleteOnlyNodes());
            this.fullTextSearchIndexer.requiresIndex(this.store);
        }
        if (this.callBack != null) {
            this.callBack.indexCompleted(this.store, this.remainingCount, null);
        }
    }

    @Override
    protected void doRollBack() throws IOException {
        if (this.callBack != null) {
            this.callBack.indexCompleted(this.store, 0, null);
        }
    }

    @Override
    protected void doSetRollbackOnly() throws IOException {
    }

    @Override
    public void deleteIndex(StoreRef storeRef) {
        this.deleteIndex();
    }

    private static class Helper {
        String id;
        String tx;

        Helper(String id, String tx) {
            this.id = id;
            this.tx = tx;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Pair<F, S> {
        private F first;
        private S second;

        public Pair(F first, S second) {
            this.first = first;
            this.second = second;
        }

        public F getFirst() {
            return this.first;
        }

        public S getSecond() {
            return this.second;
        }
    }
}

