/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.repo.search.AVMSnapShotTriggeredIndexingMethodInterceptor;
import org.alfresco.repo.search.IndexMode;
import org.alfresco.repo.search.SearcherException;
import org.alfresco.repo.search.SupportsBackgroundIndexing;
import org.alfresco.repo.search.impl.lucene.ADMLuceneSearcherImpl;
import org.alfresco.repo.search.impl.lucene.AVMLuceneIndexerImpl;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneIndexerAndSearcherFactory;
import org.alfresco.repo.search.impl.lucene.LuceneIndexer;
import org.alfresco.repo.search.impl.lucene.LuceneSearcher;
import org.alfresco.repo.search.impl.lucene.fts.FullTextSearchIndexer;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.alfresco.service.cmr.avmsync.AVMSyncService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.transaction.TransactionService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVMLuceneIndexerAndSearcherFactory
extends AbstractLuceneIndexerAndSearcherFactory
implements SupportsBackgroundIndexing {
    private DictionaryService dictionaryService;
    private NamespaceService nameSpaceService;
    private ContentService contentService;
    protected TransactionService transactionService;
    private AVMService avmService;
    private AVMSyncService avmSyncService;
    private NodeService nodeService;
    private ContentStore contentStore;
    private TransformerDebug transformerDebug;
    private FullTextSearchIndexer fullTextSearchIndexer;
    private AVMSnapShotTriggeredIndexingMethodInterceptor avmSnapShotTriggeredIndexingMethodInterceptor;

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNameSpaceService(NamespaceService nameSpaceService) {
        this.nameSpaceService = nameSpaceService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    public void setAvmSyncService(AVMSyncService avmSyncService) {
        this.avmSyncService = avmSyncService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentStore(ContentStore contentStore) {
        this.contentStore = contentStore;
    }

    public void setTransformerDebug(TransformerDebug transformerDebug) {
        this.transformerDebug = transformerDebug;
    }

    public void setAvmSnapShotTriggeredIndexingMethodInterceptor(AVMSnapShotTriggeredIndexingMethodInterceptor avmSnapShotTriggeredIndexingMethodInterceptor) {
        this.avmSnapShotTriggeredIndexingMethodInterceptor = avmSnapShotTriggeredIndexingMethodInterceptor;
    }

    @Override
    protected LuceneIndexer createIndexer(StoreRef storeRef, String deltaId) {
        AVMLuceneIndexerImpl indexer = AVMLuceneIndexerImpl.getUpdateIndexer(storeRef, deltaId, this);
        indexer.setDictionaryService(this.dictionaryService);
        indexer.setContentService(this.contentService);
        indexer.setTransactionService(this.transactionService);
        indexer.setMaxAtomicTransformationTime(this.getMaxTransformationTime());
        indexer.setAvmService(this.avmService);
        indexer.setAvmSyncService(this.avmSyncService);
        indexer.setContentStore(this.contentStore);
        indexer.setTransformerDebug(this.transformerDebug);
        indexer.setFullTextSearchIndexer(this.fullTextSearchIndexer);
        return indexer;
    }

    @Override
    protected List<StoreRef> getAllStores() {
        List<AVMStoreDescriptor> stores = this.avmService.getStores();
        ArrayList<StoreRef> storeRefs = new ArrayList<StoreRef>(stores.size());
        for (AVMStoreDescriptor storeDesc : stores) {
            StoreRef storeRef = AVMNodeConverter.ToStoreRef(storeDesc.getName());
            if (this.avmSnapShotTriggeredIndexingMethodInterceptor.getIndexMode(storeRef.getIdentifier()) == IndexMode.UNINDEXED) continue;
            storeRefs.add(storeRef);
        }
        return storeRefs;
    }

    @Override
    protected LuceneSearcher getSearcher(StoreRef storeRef, LuceneIndexer indexer) throws SearcherException {
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(storeRef, indexer, this);
        searcher.setNamespacePrefixResolver((NamespacePrefixResolver)this.nameSpaceService);
        searcher.setNodeService(this.nodeService);
        searcher.setTenantService(this.tenantService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setQueryRegister(this.getQueryRegister());
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setQueryLanguages(this.getQueryLanguages());
        return searcher;
    }

    @Override
    protected SearchService getNodeSearcher() throws SearcherException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFullTextSearchIndexer(FullTextSearchIndexer fullTextSearchIndexer) {
        this.fullTextSearchIndexer = fullTextSearchIndexer;
    }
}

