/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.search.impl.lucene.ADMLuceneSearcherImpl;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneQueryLanguage;
import org.alfresco.repo.search.impl.parsers.AlfrescoFunctionEvaluationContext;
import org.alfresco.repo.search.impl.parsers.FTSParser;
import org.alfresco.repo.search.impl.parsers.FTSQueryParser;
import org.alfresco.repo.search.impl.querymodel.Column;
import org.alfresco.repo.search.impl.querymodel.Constraint;
import org.alfresco.repo.search.impl.querymodel.Function;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.Order;
import org.alfresco.repo.search.impl.querymodel.Ordering;
import org.alfresco.repo.search.impl.querymodel.PropertyArgument;
import org.alfresco.repo.search.impl.querymodel.Query;
import org.alfresco.repo.search.impl.querymodel.QueryEngine;
import org.alfresco.repo.search.impl.querymodel.QueryEngineResults;
import org.alfresco.repo.search.impl.querymodel.QueryModelFactory;
import org.alfresco.repo.search.impl.querymodel.QueryOptions;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneAlfrescoFtsQueryLanguage
extends AbstractLuceneQueryLanguage {
    QueryEngine queryEngine;

    public LuceneAlfrescoFtsQueryLanguage() {
        this.setName("fts-alfresco");
    }

    public void setQueryEngine(QueryEngine queryEngine) {
        this.queryEngine = queryEngine;
    }

    @Override
    public ResultSet executeQuery(SearchParameters searchParameters, ADMLuceneSearcherImpl admLuceneSearcher) {
        String ftsExpression = searchParameters.getQuery();
        QueryModelFactory factory = this.queryEngine.getQueryModelFactory();
        AlfrescoFunctionEvaluationContext context = new AlfrescoFunctionEvaluationContext(admLuceneSearcher.getNamespacePrefixResolver(), admLuceneSearcher.getDictionaryService(), searchParameters.getNamespace());
        QueryOptions options = QueryOptions.create((SearchParameters)searchParameters);
        FTSParser.Mode mode = options.getDefaultFTSConnective() == QueryOptions.Connective.AND ? FTSParser.Mode.DEFAULT_CONJUNCTION : FTSParser.Mode.DEFAULT_DISJUNCTION;
        Constraint constraint = FTSQueryParser.buildFTS((String)ftsExpression, (QueryModelFactory)factory, (FunctionEvaluationContext)context, null, null, (FTSParser.Mode)mode, (QueryOptions.Connective)options.getDefaultFTSFieldConnective(), (Map)searchParameters.getQueryTemplates(), (String)options.getDefaultFieldName());
        Query query = factory.createQuery(null, null, constraint, this.buildOrderings(factory, searchParameters));
        QueryEngineResults results = this.queryEngine.executeQuery(query, options, (FunctionEvaluationContext)context);
        ResultSet resultSet = (ResultSet)results.getResults().values().iterator().next();
        return resultSet;
    }

    public List<Ordering> buildOrderings(QueryModelFactory factory, SearchParameters searchParameters) {
        ArrayList<Ordering> orderings = new ArrayList<Ordering>(searchParameters.getSortDefinitions().size());
        for (SearchParameters.SortDefinition sd : searchParameters.getSortDefinitions()) {
            Function function;
            if (sd.getSortType() == SearchParameters.SortDefinition.SortType.FIELD) {
                function = factory.getFunction("PropertyAccessor");
                PropertyArgument arg = factory.createPropertyArgument("Property", true, true, "", sd.getField());
                LinkedHashMap<String, PropertyArgument> functionArguments = new LinkedHashMap<String, PropertyArgument>();
                functionArguments.put(arg.getName(), arg);
                Column column = factory.createColumn(function, functionArguments, sd.getField());
                Order order = sd.isAscending() ? Order.ASCENDING : Order.DESCENDING;
                Ordering ordering = factory.createOrdering(column, order);
                orderings.add(ordering);
                continue;
            }
            if (sd.getSortType() == SearchParameters.SortDefinition.SortType.SCORE) {
                function = factory.getFunction("Score");
                LinkedHashMap functionArguments = new LinkedHashMap();
                Column column = factory.createColumn(function, functionArguments, "Score");
                Order order = sd.isAscending() ? Order.ASCENDING : Order.DESCENDING;
                Ordering ordering = factory.createOrdering(column, order);
                orderings.add(ordering);
                continue;
            }
            throw new UnsupportedOperationException("Unsupported Ordering " + sd.getSortType());
        }
        return orderings;
    }
}

