/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.node.NodeBulkLoader;
import org.alfresco.repo.search.AbstractResultSet;
import org.alfresco.repo.search.ResultSetRowIterator;
import org.alfresco.repo.search.SearcherException;
import org.alfresco.repo.search.SimpleResultSetMetaData;
import org.alfresco.repo.search.impl.lucene.ClosingIndexSearcher;
import org.alfresco.repo.search.impl.lucene.LuceneConfig;
import org.alfresco.repo.search.impl.lucene.LuceneResultSetRow;
import org.alfresco.repo.search.impl.lucene.LuceneResultSetRowIterator;
import org.alfresco.repo.search.impl.lucene.index.CachingIndexReader;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.PermissionEvaluationMode;
import org.alfresco.service.cmr.search.ResultSetMetaData;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.Searcher;

public class LuceneResultSet
extends AbstractResultSet {
    private static int DEFAULT_BULK_FETCH_SIZE = 1000;
    Hits hits;
    private Searcher searcher;
    private NodeService nodeService;
    private TenantService tenantService;
    private SearchParameters searchParameters;
    private LuceneConfig config;
    private BitSet prefetch;
    private boolean bulkFetch = true;
    private int bulkFetchSize = DEFAULT_BULK_FETCH_SIZE;

    public LuceneResultSet(Hits hits, Searcher searcher, NodeService nodeService, TenantService tenantService, SearchParameters searchParameters, LuceneConfig config) {
        this.hits = hits;
        this.searcher = searcher;
        this.nodeService = nodeService;
        this.tenantService = tenantService;
        this.searchParameters = searchParameters;
        this.config = config;
        this.prefetch = new BitSet(hits.length());
    }

    public ResultSetRowIterator iterator() {
        return new LuceneResultSetRowIterator(this);
    }

    public int length() {
        return this.hits.length();
    }

    public NodeRef getNodeRef(int n) {
        try {
            ClosingIndexSearcher cis;
            IndexReader reader;
            this.prefetch(n);
            if (this.searcher instanceof ClosingIndexSearcher && (reader = (cis = (ClosingIndexSearcher)this.searcher).getReader()) instanceof CachingIndexReader) {
                int id = this.hits.id(n);
                CachingIndexReader cir = (CachingIndexReader)reader;
                String sid = cir.getId(id);
                return this.tenantService.getBaseName(new NodeRef(sid));
            }
            Document doc = this.hits.doc(n);
            String id = doc.get("ID");
            return this.tenantService.getBaseName(new NodeRef(id));
        }
        catch (IOException e) {
            throw new SearcherException("IO Error reading reading node ref from the result set", e);
        }
    }

    public float getScore(int n) throws SearcherException {
        try {
            return this.hits.score(n);
        }
        catch (IOException e) {
            throw new SearcherException("IO Error reading score from the result set", e);
        }
    }

    public Document getDocument(int n) {
        try {
            this.prefetch(n);
            Document doc = this.hits.doc(n);
            return doc;
        }
        catch (IOException e) {
            throw new SearcherException("IO Error reading reading document from the result set", e);
        }
    }

    private void prefetch(int n) throws IOException {
        int next;
        NodeBulkLoader bulkLoader = this.config.getBulkLoader();
        if (!this.getBulkFetch() || bulkLoader == null) {
            return;
        }
        if (this.prefetch.get(n)) {
            return;
        }
        int bulkFetchSize = this.getBulkFetchSize();
        ArrayList<NodeRef> fetchList = new ArrayList<NodeRef>(bulkFetchSize);
        int totalHits = this.hits.length();
        for (int i = 0; i < bulkFetchSize && (next = n + i) < totalHits; ++i) {
            if (this.prefetch.get(next)) continue;
            this.prefetch.set(next);
            Document doc = this.hits.doc(next);
            String nodeRefStr = doc.get("ID");
            try {
                NodeRef nodeRef = this.tenantService.getBaseName(new NodeRef(nodeRefStr));
                fetchList.add(nodeRef);
                continue;
            }
            catch (AlfrescoRuntimeException e) {
                // empty catch block
            }
        }
        if (fetchList.size() > 1) {
            bulkLoader.cacheNodes(fetchList);
        }
    }

    public void close() {
        try {
            this.searcher.close();
        }
        catch (IOException e) {
            throw new SearcherException(e);
        }
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public ResultSetRow getRow(int i) {
        if (i < this.length()) {
            return new LuceneResultSetRow(this, i);
        }
        throw new SearcherException("Invalid row");
    }

    public ChildAssociationRef getChildAssocRef(int n) {
        return this.tenantService.getBaseName(this.getRow(n).getChildAssocRef());
    }

    public ResultSetMetaData getResultSetMetaData() {
        return new SimpleResultSetMetaData(LimitBy.UNLIMITED, PermissionEvaluationMode.EAGER, this.searchParameters);
    }

    public int getStart() {
        throw new UnsupportedOperationException();
    }

    public boolean hasMore() {
        throw new UnsupportedOperationException();
    }

    public TenantService getTenantService() {
        return this.tenantService;
    }

    public boolean setBulkFetch(boolean bulkFetch) {
        boolean oldBulkFetch = this.bulkFetch;
        this.bulkFetch = bulkFetch;
        return oldBulkFetch;
    }

    public boolean getBulkFetch() {
        return this.bulkFetch;
    }

    public int setBulkFetchSize(int bulkFetchSize) {
        int oldBulkFetchSize = this.bulkFetchSize;
        this.bulkFetchSize = bulkFetchSize;
        return oldBulkFetchSize;
    }

    public int getBulkFetchSize() {
        return this.bulkFetchSize;
    }

    public int doc(int index) {
        try {
            return this.hits.id(index);
        }
        catch (IOException e) {
            throw new SearcherException(e);
        }
    }
}

