/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.alfresco.repo.search.SimpleResultSetMetaData;
import org.alfresco.repo.search.impl.lucene.SolrJSONResultSetRow;
import org.alfresco.repo.search.impl.lucene.SolrJSONResultSetRowIterator;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.PermissionEvaluationMode;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetMetaData;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.util.Pair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolrJSONResultSet
implements ResultSet {
    private NodeService nodeService;
    private ArrayList<Pair<Long, Float>> page;
    private ResultSetMetaData rsmd;
    private Long status;
    private Long queryTime;
    private Long numberFound;
    private Long start;
    private Float maxScore;
    private SimpleResultSetMetaData resultSetMetaData;
    private HashMap<String, List<Pair<String, Integer>>> fieldFacets = new HashMap(1);

    public SolrJSONResultSet(JSONObject json, SearchParameters searchParameters, NodeService nodeService) {
        this.nodeService = nodeService;
        this.resultSetMetaData = new SimpleResultSetMetaData(LimitBy.UNLIMITED, PermissionEvaluationMode.EAGER, searchParameters);
        try {
            JSONObject facet_counts;
            JSONObject responseHeader = json.getJSONObject("responseHeader");
            this.status = responseHeader.getLong("status");
            this.queryTime = responseHeader.getLong("QTime");
            JSONObject response = json.getJSONObject("response");
            this.numberFound = response.getLong("numFound");
            this.start = response.getLong("start");
            this.maxScore = Float.valueOf(response.getString("maxScore"));
            JSONArray docs = response.getJSONArray("docs");
            int numDocs = docs.length();
            this.page = new ArrayList(numDocs);
            for (int i = 0; i < numDocs; ++i) {
                JSONObject doc = docs.getJSONObject(i);
                JSONArray dbids = doc.getJSONArray("DBID");
                Long dbid = dbids.getLong(0);
                Float score = Float.valueOf(doc.getString("score"));
                this.page.add((Pair<Long, Float>)new Pair((Object)dbid, (Object)score));
                Iterator it = doc.keys();
                while (it.hasNext()) {
                    String key = (String)it.next();
                }
            }
            if (json.has("facet_counts") && (facet_counts = json.getJSONObject("facet_counts")).has("facet_fields")) {
                JSONObject facet_fields = facet_counts.getJSONObject("facet_fields");
                Iterator it = facet_fields.keys();
                while (it.hasNext()) {
                    String fieldName = (String)it.next();
                    JSONArray facets = facet_fields.getJSONArray(fieldName);
                    int facetArraySize = facets.length();
                    ArrayList<Pair> facetValues = new ArrayList<Pair>(facetArraySize / 2);
                    for (int i = 0; i < facetArraySize; i += 2) {
                        String facetEntryName = facets.getString(i);
                        Integer facetEntryCount = Integer.parseInt(facets.getString(i + 1));
                        Pair pair = new Pair((Object)facetEntryName, (Object)facetEntryCount);
                        facetValues.add(pair);
                    }
                    this.fieldFacets.put(fieldName, facetValues);
                }
            }
        }
        catch (JSONException e) {
            // empty catch block
        }
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public void close() {
    }

    public boolean getBulkFetch() {
        return true;
    }

    public int getBulkFetchSize() {
        return Integer.MAX_VALUE;
    }

    public ChildAssociationRef getChildAssocRef(int n) {
        ChildAssociationRef primaryParentAssoc = this.nodeService.getPrimaryParent(this.getNodeRef(n));
        if (primaryParentAssoc != null) {
            return primaryParentAssoc;
        }
        return null;
    }

    public List<ChildAssociationRef> getChildAssocRefs() {
        ArrayList<ChildAssociationRef> refs = new ArrayList<ChildAssociationRef>(this.page.size());
        for (int i = 0; i < this.page.size(); ++i) {
            refs.add(this.getChildAssocRef(i));
        }
        return refs;
    }

    public NodeRef getNodeRef(int n) {
        NodeRef nodeRef = this.nodeService.getNodeRef((Long)this.page.get(n).getFirst());
        if (nodeRef != null) {
            return nodeRef;
        }
        return new NodeRef(new StoreRef("missing", "missing"), "missing");
    }

    public List<NodeRef> getNodeRefs() {
        ArrayList<NodeRef> refs = new ArrayList<NodeRef>(this.page.size());
        for (int i = 0; i < this.page.size(); ++i) {
            refs.add(this.getNodeRef(i));
        }
        return refs;
    }

    public ResultSetMetaData getResultSetMetaData() {
        return this.resultSetMetaData;
    }

    public ResultSetRow getRow(int i) {
        return new SolrJSONResultSetRow(this, i);
    }

    public float getScore(int n) {
        return ((Float)this.page.get(n).getSecond()).floatValue();
    }

    public int getStart() {
        return this.start.intValue();
    }

    public boolean hasMore() {
        return this.numberFound > this.start + (long)this.page.size() + 1L;
    }

    public int length() {
        return this.page.size();
    }

    public boolean setBulkFetch(boolean bulkFetch) {
        return bulkFetch;
    }

    public int setBulkFetchSize(int bulkFetchSize) {
        return bulkFetchSize;
    }

    public Iterator<ResultSetRow> iterator() {
        return new SolrJSONResultSetRowIterator(this);
    }

    public Long getQueryTime() {
        return this.queryTime;
    }

    public Long getNumberFound() {
        return this.numberFound;
    }

    public List<Pair<String, Integer>> getFieldFacet(String field) {
        List<Pair<String, Integer>> answer = this.fieldFacets.get(field);
        if (answer != null) {
            return answer;
        }
        return Collections.emptyList();
    }
}

