/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.noindex;

import java.util.HashMap;
import java.util.Set;
import org.alfresco.opencmis.dictionary.CMISDictionaryService;
import org.alfresco.opencmis.search.CMISQueryOptions;
import org.alfresco.opencmis.search.CMISQueryParser;
import org.alfresco.opencmis.search.CMISQueryService;
import org.alfresco.opencmis.search.CMISResultSet;
import org.alfresco.opencmis.search.CmisFunctionEvaluationContext;
import org.alfresco.repo.search.EmptyResultSet;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.Query;
import org.alfresco.repo.search.impl.querymodel.QueryModelFactory;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryModelFactory;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.ResultSet;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.CapabilityJoin;
import org.apache.chemistry.opencmis.commons.enums.CapabilityQuery;

public class NoIndexOpenCMISQueryServiceImpl
implements CMISQueryService {
    private NodeService nodeService;
    private DictionaryService alfrescoDictionaryService;
    private CMISDictionaryService cmisDictionaryService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setAlfrescoDictionaryService(DictionaryService alfrescoDictionaryService) {
        this.alfrescoDictionaryService = alfrescoDictionaryService;
    }

    public void setCmisDictionaryService(CMISDictionaryService cmisDictionaryService) {
        this.cmisDictionaryService = cmisDictionaryService;
    }

    public CMISResultSet query(CMISQueryOptions options) {
        EmptyResultSet rs = new EmptyResultSet();
        CapabilityJoin joinSupport = this.getJoinSupport();
        if (options.getQueryMode() == CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS) {
            joinSupport = CapabilityJoin.INNERONLY;
        }
        BaseTypeId[] validScopes = options.getQueryMode() == CMISQueryOptions.CMISQueryMode.CMS_STRICT ? CmisFunctionEvaluationContext.STRICT_SCOPES : CmisFunctionEvaluationContext.ALFRESCO_SCOPES;
        CmisFunctionEvaluationContext functionContext = new CmisFunctionEvaluationContext();
        functionContext.setCmisDictionaryService(this.cmisDictionaryService);
        functionContext.setNodeService(this.nodeService);
        functionContext.setValidScopes(validScopes);
        CMISQueryParser parser = new CMISQueryParser(options, this.cmisDictionaryService, joinSupport);
        Query query = parser.parse((QueryModelFactory)new LuceneQueryModelFactory(), (FunctionEvaluationContext)functionContext);
        HashMap<String, ResultSet> wrapped = new HashMap<String, ResultSet>();
        for (Set group : query.getSource().getSelectorGroups((FunctionEvaluationContext)functionContext)) {
            for (String selector : group) {
                wrapped.put(selector, rs);
            }
        }
        LimitBy limitBy = null;
        limitBy = rs.getResultSetMetaData().getLimitedBy();
        CMISResultSet cmis = new CMISResultSet(wrapped, options, limitBy, this.nodeService, query, this.cmisDictionaryService, this.alfrescoDictionaryService);
        return cmis;
    }

    public CMISResultSet query(String query, StoreRef storeRef) {
        CMISQueryOptions options = new CMISQueryOptions(query, storeRef);
        return this.query(options);
    }

    public boolean getPwcSearchable() {
        return true;
    }

    public boolean getAllVersionsSearchable() {
        return false;
    }

    public CapabilityQuery getQuerySupport() {
        return CapabilityQuery.BOTHCOMBINED;
    }

    public CapabilityJoin getJoinSupport() {
        return CapabilityJoin.NONE;
    }
}

