/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.httpclient.HttpClientFactory;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParserException;
import org.alfresco.repo.search.impl.lucene.SolrJSONResultSet;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.security.PermissionService;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolrQueryHTTPClient {
    static Log s_logger = LogFactory.getLog(SolrQueryHTTPClient.class);
    private NodeService nodeService;
    private PermissionService permissionService;
    private TenantService tenantService;
    private Map<String, String> languageMappings;
    private Map<String, String> storeMappings;
    private String baseUrl;
    private HttpClient httpClient;
    private HttpClientFactory httpClientFactory;

    public void init() {
        StringBuilder sb = new StringBuilder();
        sb.append("/solr");
        this.baseUrl = sb.toString();
        this.httpClient = this.httpClientFactory.getHttpClient();
        HttpClientParams params = this.httpClient.getParams();
        params.setBooleanParameter("http.authentication.preemptive", true);
        this.httpClient.getState().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials("admin", "admin"));
    }

    public void setHttpClientFactory(HttpClientFactory httpClientFactory) {
        this.httpClientFactory = httpClientFactory;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setLanguageMappings(Map<String, String> languageMappings) {
        this.languageMappings = languageMappings;
    }

    public void setStoreMappings(Map<String, String> storeMappings) {
        this.storeMappings = storeMappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultSet executeQuery(SearchParameters searchParameters, String language) {
        try {
            SolrJSONResultSet solrJSONResultSet;
            URLCodec encoder = new URLCodec();
            StringBuilder url = new StringBuilder();
            url.append(this.baseUrl);
            if (searchParameters.getStores().size() == 0) {
                throw new AlfrescoRuntimeException("No store for query");
            }
            String storeUrlFragment = this.storeMappings.get(((StoreRef)searchParameters.getStores().get(0)).toString());
            if (storeUrlFragment == null) {
                throw new AlfrescoRuntimeException("No solr query support for store " + ((StoreRef)searchParameters.getStores().get(0)).toString());
            }
            url.append("/").append(storeUrlFragment);
            String languageUrlFragment = this.languageMappings.get(language);
            if (languageUrlFragment == null) {
                throw new AlfrescoRuntimeException("No solr query support for language " + language);
            }
            url.append("/").append(languageUrlFragment);
            url.append("?q=");
            url.append(encoder.encode(searchParameters.getQuery(), "UTF-8"));
            url.append("&wt=").append(encoder.encode("json", "UTF-8"));
            url.append("&fl=").append(encoder.encode("*,score", "UTF-8"));
            if (searchParameters.getMaxItems() >= 0) {
                url.append("&rows=").append(encoder.encode("" + searchParameters.getMaxItems(), "UTF-8"));
            } else if (searchParameters.getLimitBy() == LimitBy.FINAL_SIZE) {
                url.append("&rows=").append(encoder.encode("" + searchParameters.getLimit(), "UTF-8"));
            } else {
                url.append("&rows=").append(encoder.encode("2147483647", "UTF-8"));
            }
            url.append("&df=").append(encoder.encode(searchParameters.getDefaultFieldName(), "UTF-8"));
            url.append("&start=").append(encoder.encode("" + searchParameters.getSkipCount(), "UTF-8"));
            Locale locale = I18NUtil.getLocale();
            if (searchParameters.getLocales().size() > 0) {
                locale = (Locale)searchParameters.getLocales().get(0);
            }
            url.append("&locale=");
            url.append(encoder.encode(locale.toString(), "UTF-8"));
            StringBuffer sortBuffer = new StringBuffer();
            for (SearchParameters.SortDefinition sortDefinition : searchParameters.getSortDefinitions()) {
                if (sortBuffer.length() == 0) {
                    sortBuffer.append("&sort=");
                } else {
                    sortBuffer.append(encoder.encode(", ", "UTF-8"));
                }
                sortBuffer.append(encoder.encode(sortDefinition.getField(), "UTF-8")).append(encoder.encode(" ", "UTF-8"));
                if (sortDefinition.isAscending()) {
                    sortBuffer.append(encoder.encode("asc", "UTF-8"));
                    continue;
                }
                sortBuffer.append(encoder.encode("desc", "UTF-8"));
            }
            url.append(sortBuffer);
            url.append("&fq=").append(encoder.encode("{!afts}AUTHORITY_FILTER_FROM_JSON", "UTF-8"));
            url.append("&fq=").append(encoder.encode("{!afts}TENANT_FILTER_FROM_JSON", "UTF-8"));
            if (searchParameters.getFieldFacets().size() > 0) {
                url.append("&facet=").append(encoder.encode("true", "UTF-8"));
                for (SearchParameters.FieldFacet facet : searchParameters.getFieldFacets()) {
                    url.append("&facet.field=").append(encoder.encode(facet.getField(), "UTF-8"));
                    if (facet.getEnumMethodCacheMinDF() != 0) {
                        url.append("&").append(encoder.encode("f." + facet.getField() + ".facet.enum.cache.minDf", "UTF-8")).append("=").append(encoder.encode("" + facet.getEnumMethodCacheMinDF(), "UTF-8"));
                    }
                    url.append("&").append(encoder.encode("f." + facet.getField() + ".facet.limit", "UTF-8")).append("=").append(encoder.encode("" + facet.getLimit(), "UTF-8"));
                    if (facet.getMethod() != null) {
                        url.append("&").append(encoder.encode("f." + facet.getField() + ".facet.method", "UTF-8")).append("=").append(encoder.encode(facet.getMethod() == SearchParameters.FieldFacetMethod.ENUM ? "enum" : "fc", "UTF-8"));
                    }
                    if (facet.getMinCount() != 0) {
                        url.append("&").append(encoder.encode("f." + facet.getField() + ".facet.mincount", "UTF-8")).append("=").append(encoder.encode("" + facet.getMinCount(), "UTF-8"));
                    }
                    if (facet.getOffset() != 0) {
                        url.append("&").append(encoder.encode("f." + facet.getField() + ".facet.offset", "UTF-8")).append("=").append(encoder.encode("" + facet.getOffset(), "UTF-8"));
                    }
                    if (facet.getPrefix() != null) {
                        url.append("&").append(encoder.encode("f." + facet.getField() + ".facet.prefix", "UTF-8")).append("=").append(encoder.encode("" + facet.getPrefix(), "UTF-8"));
                    }
                    if (facet.getSort() == null) continue;
                    url.append("&").append(encoder.encode("f." + facet.getField() + ".facet.sort", "UTF-8")).append("=").append(encoder.encode(facet.getSort() == SearchParameters.FieldFacetSort.COUNT ? "count" : "index", "UTF-8"));
                }
            }
            JSONObject body = new JSONObject();
            body.put("query", (Object)searchParameters.getQuery());
            JSONArray authorities = new JSONArray();
            for (String authority : this.permissionService.getAuthorisations()) {
                authorities.put((Object)authority);
            }
            body.put("authorities", (Object)authorities);
            JSONArray tenants = new JSONArray();
            tenants.put((Object)this.tenantService.getCurrentUserDomain());
            body.put("tenants", (Object)tenants);
            JSONArray locales = new JSONArray();
            for (Locale currentLocale : searchParameters.getLocales()) {
                locales.put(DefaultTypeConverter.INSTANCE.convert(String.class, (Object)currentLocale));
            }
            if (locales.length() == 0) {
                locales.put((Object)I18NUtil.getLocale());
            }
            body.put("locales", (Object)locales);
            JSONArray templates = new JSONArray();
            for (String templateName : searchParameters.getQueryTemplates().keySet()) {
                JSONObject template = new JSONObject();
                template.put("name", (Object)templateName);
                template.put("template", searchParameters.getQueryTemplates().get(templateName));
                templates.put((Object)template);
            }
            body.put("templates", (Object)templates);
            JSONArray allAttributes = new JSONArray();
            for (String attribute : searchParameters.getAllAttributes()) {
                allAttributes.put((Object)attribute);
            }
            body.put("allAttributes", (Object)allAttributes);
            body.put("defaultFTSOperator", (Object)searchParameters.getDefaultFTSOperator());
            body.put("defaultFTSFieldOperator", (Object)searchParameters.getDefaultFTSFieldOperator());
            if (searchParameters.getMlAnalaysisMode() != null) {
                body.put("mlAnalaysisMode", (Object)searchParameters.getMlAnalaysisMode().toString());
            }
            body.put("defaultNamespace", (Object)searchParameters.getNamespace());
            JSONArray textAttributes = new JSONArray();
            for (String attribute : searchParameters.getTextAttributes()) {
                textAttributes.put((Object)attribute);
            }
            body.put("textAttributes", (Object)textAttributes);
            PostMethod post = new PostMethod(url.toString());
            post.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(body.toString().getBytes("UTF-8"), "application/json"));
            try {
                Header locationHeader;
                this.httpClient.executeMethod((HttpMethod)post);
                if ((post.getStatusCode() == 301 || post.getStatusCode() == 302) && (locationHeader = post.getResponseHeader("location")) != null) {
                    String redirectLocation = locationHeader.getValue();
                    post.setURI(new URI(redirectLocation, true));
                    this.httpClient.executeMethod((HttpMethod)post);
                }
                if (post.getStatusCode() != 200) {
                    throw new LuceneQueryParserException("Request failed " + post.getStatusCode() + " " + url.toString());
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(post.getResponseBodyAsStream()));
                JSONObject json = new JSONObject(new JSONTokener((Reader)reader));
                SolrJSONResultSet results = new SolrJSONResultSet(json, searchParameters, this.nodeService);
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("Sent :" + url));
                    s_logger.debug((Object)("   with: " + body.toString()));
                    s_logger.debug((Object)("Got: " + results.getNumberFound() + " in " + results.getQueryTime() + " ms"));
                }
                solrJSONResultSet = results;
                Object var22_25 = null;
            }
            catch (Throwable throwable) {
                Object var22_26 = null;
                post.releaseConnection();
                throw throwable;
            }
            post.releaseConnection();
            return solrJSONResultSet;
        }
        catch (UnsupportedEncodingException e) {
            throw new LuceneQueryParserException("", (Throwable)e);
        }
        catch (HttpException e) {
            throw new LuceneQueryParserException("", (Throwable)e);
        }
        catch (IOException e) {
            throw new LuceneQueryParserException("", (Throwable)e);
        }
        catch (JSONException e) {
            throw new LuceneQueryParserException("", (Throwable)e);
        }
    }
}

