/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.results;

import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.alfresco.repo.search.SearcherException;
import org.alfresco.repo.search.impl.lucene.LuceneResultSetRow;
import org.alfresco.repo.search.results.SortedResultSetRow;
import org.alfresco.repo.search.results.SortedResultSetRowIterator;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetMetaData;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedResultSet
implements ResultSet {
    private ArrayList<NodeRefAndScore> nodeRefsAndScores;
    private NodeService nodeService;
    private ResultSet resultSet;
    private DictionaryService dictionaryService;
    private Locale locale;
    private Collator collator;

    public SortedResultSet(ResultSet resultSet, NodeService nodeService, SearchParameters searchParametersx, NamespacePrefixResolver namespacePrefixResolver, DictionaryService dictionaryService, Locale locale) {
        this(resultSet, nodeService, searchParametersx.getSortDefinitions(), namespacePrefixResolver, dictionaryService, locale);
    }

    public SortedResultSet(ResultSet resultSet, NodeService nodeService, List<SearchParameters.SortDefinition> sortDefinitions, NamespacePrefixResolver namespacePrefixResolver, DictionaryService dictionaryService, Locale locale) {
        this.nodeService = nodeService;
        this.resultSet = resultSet;
        this.dictionaryService = dictionaryService;
        this.locale = locale;
        this.collator = Collator.getInstance(this.locale);
        this.nodeRefsAndScores = new ArrayList(resultSet.length());
        for (ResultSetRow row : resultSet) {
            LuceneResultSetRow lrow = (LuceneResultSetRow)row;
            this.nodeRefsAndScores.add(new NodeRefAndScore(row.getNodeRef(), row.getScore(), lrow.doc()));
        }
        ArrayList<OrderDefinition> order = new ArrayList<OrderDefinition>();
        block6: for (SearchParameters.SortDefinition sd : sortDefinitions) {
            switch (sd.getSortType()) {
                case FIELD: {
                    String field = sd.getField();
                    if (field.startsWith("@")) {
                        PropertyDefinition propDef;
                        QName qname;
                        if (field.endsWith(".size") && (qname = this.expandAttributeFieldName(field.substring(0, field.length() - 5), namespacePrefixResolver)) != null && (propDef = dictionaryService.getProperty(qname)) != null && propDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT)) {
                            order.add(new ContentSizeOrder(qname, sd.isAscending(), nodeService));
                        }
                        if (field.endsWith(".mimetype") && (qname = this.expandAttributeFieldName(field.substring(0, field.length() - 9), namespacePrefixResolver)) != null && (propDef = dictionaryService.getProperty(qname)) != null && propDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT)) {
                            order.add(new ContentMimetypeOrder(qname, sd.isAscending(), nodeService, this.collator));
                        }
                        if ((qname = this.expandAttributeFieldName(field, namespacePrefixResolver)) == null) continue block6;
                        order.add(new AttributeOrder(qname, sd.isAscending(), nodeService, this.dictionaryService, this.collator, locale));
                        break;
                    }
                    if (field.equals("ID")) {
                        order.add(new IdOrder(sd.isAscending(), this.collator));
                        break;
                    }
                    if (field.equals("EXACTTYPE")) {
                        order.add(new TypeOrder(sd.isAscending(), nodeService, this.collator));
                        break;
                    }
                    if (!field.equals("PARENT")) break;
                    order.add(new ParentIdOrder(sd.isAscending(), nodeService, this.collator));
                    break;
                }
                case DOCUMENT: {
                    order.add(new DocumentOrder(sd.isAscending()));
                }
                case SCORE: {
                    order.add(new ScoreOrder(sd.isAscending()));
                }
            }
        }
        this.orderNodes(this.nodeRefsAndScores, order);
    }

    public void close() {
        this.resultSet.close();
    }

    public ChildAssociationRef getChildAssocRef(int n) {
        return this.nodeService.getPrimaryParent(this.nodeRefsAndScores.get((int)n).nodeRef);
    }

    public List<NodeRef> getNodeRefs() {
        ArrayList<NodeRef> nodeRefs = new ArrayList<NodeRef>(this.length());
        Iterator<ResultSetRow> i$ = this.iterator();
        while (i$.hasNext()) {
            ResultSetRow row = i$.next();
            nodeRefs.add(row.getNodeRef());
        }
        return nodeRefs;
    }

    public List<ChildAssociationRef> getChildAssocRefs() {
        ArrayList<ChildAssociationRef> cars = new ArrayList<ChildAssociationRef>(this.length());
        Iterator<ResultSetRow> i$ = this.iterator();
        while (i$.hasNext()) {
            ResultSetRow row = i$.next();
            cars.add(row.getChildAssocRef());
        }
        return cars;
    }

    public NodeRef getNodeRef(int n) {
        return this.nodeRefsAndScores.get((int)n).nodeRef;
    }

    public ResultSetMetaData getResultSetMetaData() {
        return this.resultSet.getResultSetMetaData();
    }

    public ResultSetRow getRow(int i) {
        if (i < this.length()) {
            return new SortedResultSetRow(this, i);
        }
        throw new SearcherException("Invalid row");
    }

    public float getScore(int n) {
        return this.nodeRefsAndScores.get((int)n).score;
    }

    public int length() {
        return this.nodeRefsAndScores.size();
    }

    public Iterator<ResultSetRow> iterator() {
        return new SortedResultSetRowIterator(this);
    }

    private void orderNodes(List<NodeRefAndScore> answer, List<OrderDefinition> order) {
        Collections.sort(answer, new NodeRefAndScoreComparator(order));
    }

    private QName expandAttributeFieldName(String field, NamespacePrefixResolver namespacePrefixResolver) {
        QName qname;
        if (field.charAt(1) != '{') {
            int colonPosition = field.indexOf(58);
            if (colonPosition == -1) {
                qname = QName.createQName((String)"", (String)field.substring(1));
            } else {
                String prefix = field.substring(1, colonPosition);
                String uri = namespacePrefixResolver.getNamespaceURI(prefix);
                if (uri == null) {
                    return null;
                }
                qname = QName.createQName((String)prefix, (String)field.substring(colonPosition + 1), (NamespacePrefixResolver)namespacePrefixResolver);
            }
        } else {
            qname = QName.createQName((String)field.substring(1));
        }
        return qname;
    }

    public int getStart() {
        throw new UnsupportedOperationException();
    }

    public boolean hasMore() {
        throw new UnsupportedOperationException();
    }

    public boolean setBulkFetch(boolean bulkFetch) {
        return this.resultSet.setBulkFetch(bulkFetch);
    }

    public boolean getBulkFetch() {
        return this.resultSet.getBulkFetch();
    }

    public int setBulkFetchSize(int bulkFetchSize) {
        return this.resultSet.setBulkFetchSize(bulkFetchSize);
    }

    public int getBulkFetchSize() {
        return this.resultSet.getBulkFetchSize();
    }

    public List<Pair<String, Integer>> getFieldFacet(String field) {
        return this.resultSet.getFieldFacet(field);
    }

    private static class NodeRefAndScore {
        NodeRef nodeRef;
        float score;
        int doc;

        NodeRefAndScore(NodeRef nodeRef, float score, int doc) {
            this.nodeRef = nodeRef;
            this.score = score;
            this.doc = doc;
        }
    }

    private static class ParentIdOrder
    implements OrderDefinition {
        boolean ascending;
        NodeService nodeService;
        Collator collator;

        ParentIdOrder(boolean ascending, NodeService nodeService, Collator collator) {
            this.ascending = ascending;
            this.nodeService = nodeService;
            this.collator = collator;
        }

        public int compare(NodeRefAndScore n1, NodeRefAndScore n2) {
            String o1 = null;
            try {
                ChildAssociationRef ca1 = this.nodeService.getPrimaryParent(n1.nodeRef);
                if (ca1 != null && ca1.getParentRef() != null) {
                    o1 = ca1.getParentRef().toString();
                }
            }
            catch (InvalidNodeRefException inre) {
                o1 = null;
            }
            String o2 = null;
            try {
                ChildAssociationRef ca2 = this.nodeService.getPrimaryParent(n2.nodeRef);
                if (ca2 != null && ca2.getParentRef() != null) {
                    o2 = ca2.getParentRef().toString();
                }
            }
            catch (InvalidNodeRefException inre) {
                o2 = null;
            }
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return this.ascending ? -1 : 1;
            }
            if (o2 == null) {
                return this.ascending ? 1 : -1;
            }
            int answer = (this.ascending ? 1 : -1) * this.collator.compare(o1, o2);
            return answer;
        }
    }

    private static class TypeOrder
    implements OrderDefinition {
        boolean ascending;
        NodeService nodeService;
        Collator collator;

        TypeOrder(boolean ascending, NodeService nodeService, Collator collator) {
            this.ascending = ascending;
            this.nodeService = nodeService;
            this.collator = collator;
        }

        public int compare(NodeRefAndScore n1, NodeRefAndScore n2) {
            String o2;
            String o1;
            try {
                o1 = this.nodeService.getType(n1.nodeRef).toString();
            }
            catch (InvalidNodeRefException inre) {
                o1 = null;
            }
            try {
                o2 = this.nodeService.getType(n2.nodeRef).toString();
            }
            catch (InvalidNodeRefException inre) {
                o2 = null;
            }
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return this.ascending ? -1 : 1;
            }
            if (o2 == null) {
                return this.ascending ? 1 : -1;
            }
            int answer = (this.ascending ? 1 : -1) * this.collator.compare(o1, o2);
            return answer;
        }
    }

    private static class DocumentOrder
    implements OrderDefinition {
        boolean ascending;

        DocumentOrder(boolean ascending) {
            this.ascending = ascending;
        }

        public int compare(NodeRefAndScore n1, NodeRefAndScore n2) {
            return (this.ascending ? 1 : -1) * Float.compare(n1.doc, n2.doc);
        }
    }

    private static class ScoreOrder
    implements OrderDefinition {
        boolean ascending;

        ScoreOrder(boolean ascending) {
            this.ascending = ascending;
        }

        public int compare(NodeRefAndScore n1, NodeRefAndScore n2) {
            return (this.ascending ? 1 : -1) * Float.compare(n1.score, n2.score);
        }
    }

    private static class IdOrder
    implements OrderDefinition {
        boolean ascending;
        Collator collator;

        IdOrder(boolean ascending, Collator collator) {
            this.ascending = ascending;
            this.collator = collator;
        }

        public int compare(NodeRefAndScore n1, NodeRefAndScore n2) {
            String o1 = n1.nodeRef.toString();
            String o2 = n2.nodeRef.toString();
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return this.ascending ? -1 : 1;
            }
            if (o2 == null) {
                return this.ascending ? 1 : -1;
            }
            int answer = (this.ascending ? 1 : -1) * this.collator.compare(o1, o2);
            return answer;
        }
    }

    private static class ContentMimetypeOrder
    implements OrderDefinition {
        QName attribute;
        boolean ascending;
        NodeService nodeService;
        Collator collator;

        ContentMimetypeOrder(QName attribute, boolean ascending, NodeService nodeService, Collator collator) {
            this.attribute = attribute;
            this.ascending = ascending;
            this.nodeService = nodeService;
            this.collator = collator;
        }

        public int compare(NodeRefAndScore n1, NodeRefAndScore n2) {
            Serializable o2;
            Serializable o1;
            try {
                o1 = this.nodeService.getProperty(n1.nodeRef, this.attribute);
            }
            catch (InvalidNodeRefException inre) {
                o1 = null;
            }
            try {
                o2 = this.nodeService.getProperty(n2.nodeRef, this.attribute);
            }
            catch (InvalidNodeRefException inre) {
                o2 = null;
            }
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return this.ascending ? -1 : 1;
            }
            if (o2 == null) {
                return this.ascending ? 1 : -1;
            }
            ContentData cd1 = (ContentData)DefaultTypeConverter.INSTANCE.convert(ContentData.class, (Object)o1);
            ContentData cd2 = (ContentData)DefaultTypeConverter.INSTANCE.convert(ContentData.class, (Object)o2);
            if (cd1 == null) {
                if (cd2 == null) {
                    return 0;
                }
                return this.ascending ? -1 : 1;
            }
            if (cd2 == null) {
                return this.ascending ? 1 : -1;
            }
            return (this.ascending ? 1 : -1) * this.collator.compare(cd1.getMimetype(), cd2.getMimetype());
        }
    }

    private static class ContentSizeOrder
    implements OrderDefinition {
        QName attribute;
        boolean ascending;
        NodeService nodeService;

        ContentSizeOrder(QName attribute, boolean ascending, NodeService nodeService) {
            this.attribute = attribute;
            this.ascending = ascending;
            this.nodeService = nodeService;
        }

        public int compare(NodeRefAndScore n1, NodeRefAndScore n2) {
            Serializable o2;
            Serializable o1;
            try {
                o1 = this.nodeService.getProperty(n1.nodeRef, this.attribute);
            }
            catch (InvalidNodeRefException inre) {
                o1 = null;
            }
            try {
                o2 = this.nodeService.getProperty(n2.nodeRef, this.attribute);
            }
            catch (InvalidNodeRefException inre) {
                o2 = null;
            }
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return this.ascending ? -1 : 1;
            }
            if (o2 == null) {
                return this.ascending ? 1 : -1;
            }
            ContentData cd1 = (ContentData)DefaultTypeConverter.INSTANCE.convert(ContentData.class, (Object)o1);
            ContentData cd2 = (ContentData)DefaultTypeConverter.INSTANCE.convert(ContentData.class, (Object)o2);
            if (cd1 == null) {
                if (cd2 == null) {
                    return 0;
                }
                return this.ascending ? -1 : 1;
            }
            if (cd2 == null) {
                return this.ascending ? 1 : -1;
            }
            return (this.ascending ? 1 : -1) * (int)(cd1.getSize() - cd2.getSize());
        }
    }

    private static class AttributeOrder
    implements OrderDefinition {
        QName attribute;
        boolean ascending;
        NodeService nodeService;
        DictionaryService dictionaryService;
        Collator collator;
        Locale locale;

        AttributeOrder(QName attribute, boolean ascending, NodeService nodeService, DictionaryService dictionaryService, Collator collator, Locale locale) {
            this.attribute = attribute;
            this.ascending = ascending;
            this.nodeService = nodeService;
            this.dictionaryService = dictionaryService;
            this.collator = collator;
            this.locale = locale;
        }

        public int compare(NodeRefAndScore n1, NodeRefAndScore n2) {
            Serializable o2;
            Serializable o1;
            try {
                o1 = this.nodeService.getProperty(n1.nodeRef, this.attribute);
            }
            catch (InvalidNodeRefException inre) {
                o1 = null;
            }
            try {
                o2 = this.nodeService.getProperty(n2.nodeRef, this.attribute);
            }
            catch (InvalidNodeRefException inre) {
                o2 = null;
            }
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return this.ascending ? -1 : 1;
            }
            if (o2 == null) {
                return this.ascending ? 1 : -1;
            }
            PropertyDefinition propertyDefinition = this.dictionaryService.getProperty(this.attribute);
            if (propertyDefinition != null) {
                DataTypeDefinition dataType = propertyDefinition.getDataType();
                if (dataType.getName().equals((Object)DataTypeDefinition.TEXT)) {
                    String s1 = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)o1);
                    String s2 = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)o2);
                    int answer = (this.ascending ? 1 : -1) * this.collator.compare(s1, s2);
                    return answer;
                }
                if (dataType.getName().equals((Object)DataTypeDefinition.MLTEXT)) {
                    String s1 = ((MLText)DefaultTypeConverter.INSTANCE.convert(MLText.class, (Object)o1)).getValue(this.locale);
                    String s2 = ((MLText)DefaultTypeConverter.INSTANCE.convert(MLText.class, (Object)o2)).getValue(this.locale);
                    if (s1 == null) {
                        if (s2 == null) {
                            return 0;
                        }
                        return this.ascending ? -1 : 1;
                    }
                    if (s2 == null) {
                        return this.ascending ? 1 : -1;
                    }
                    int answer = (this.ascending ? 1 : -1) * this.collator.compare(s1, s2);
                    return answer;
                }
                if (o1 instanceof Comparable && o2 instanceof Comparable) {
                    int answer = (this.ascending ? 1 : -1) * ((Comparable)((Object)o1)).compareTo((Comparable)((Object)o2));
                    return answer;
                }
                return 0;
            }
            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                int answer = (this.ascending ? 1 : -1) * ((Comparable)((Object)o1)).compareTo((Comparable)((Object)o2));
                return answer;
            }
            return 0;
        }
    }

    private static interface OrderDefinition {
        public int compare(NodeRefAndScore var1, NodeRefAndScore var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NodeRefAndScoreComparator
    implements Comparator<NodeRefAndScore> {
        private List<OrderDefinition> order;

        NodeRefAndScoreComparator(List<OrderDefinition> order) {
            this.order = order;
        }

        @Override
        public int compare(NodeRefAndScore n1, NodeRefAndScore n2) {
            for (OrderDefinition orderDefinition : this.order) {
                int answer = orderDefinition.compare(n1, n2);
                if (answer == 0) continue;
                return answer;
            }
            return 0;
        }
    }
}

