/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.GrantedAuthorityImpl;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.providers.dao.User;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.sync.UserRegistrySynchronizer;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAuthenticationComponent
implements AuthenticationComponent {
    private Boolean allowGuestLogin = null;
    private Set<String> defaultAdministratorUserNames = Collections.emptySet();
    private Set<String> defaultGuestUserNames = Collections.emptySet();
    private AuthenticationContext authenticationContext;
    private PersonService personService;
    private NodeService nodeService;
    private TransactionService transactionService;
    private UserRegistrySynchronizer userRegistrySynchronizer;
    private final Log logger = LogFactory.getLog(this.getClass());

    public void setAllowGuestLogin(Boolean allowGuestLogin) {
        this.allowGuestLogin = allowGuestLogin;
    }

    public void setAuthenticationContext(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setUserRegistrySynchronizer(UserRegistrySynchronizer userRegistrySynchronizer) {
        this.userRegistrySynchronizer = userRegistrySynchronizer;
    }

    public TransactionService getTransactionService() {
        return this.transactionService;
    }

    public Boolean getAllowGuestLogin() {
        return this.allowGuestLogin;
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    @Override
    public void authenticate(String userName, char[] password) throws AuthenticationException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Authenticating user \"" + userName + '\"'));
        }
        if (userName == null) {
            throw new AuthenticationException("Null user name");
        }
        if (this.isGuestUserName(userName)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("User \"" + userName + "\" recognized as a guest user"));
            }
            this.setGuestUserAsCurrentUser(this.getUserDomain(userName));
        } else {
            try {
                this.authenticateImpl(userName, password);
            }
            catch (RuntimeException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Failed to authenticate user \"" + userName + '\"'), (Throwable)e);
                }
                throw e;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("User \"" + userName + "\" authenticated successfully"));
        }
    }

    protected void authenticateImpl(String userName, char[] password) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Authentication setCurrentUser(String userName) throws AuthenticationException {
        return this.setCurrentUser(userName, AuthenticationComponent.UserNameValidationMode.CHECK_AND_FIX);
    }

    @Override
    public Authentication setCurrentUser(String userName, AuthenticationComponent.UserNameValidationMode validationMode) {
        Authentication authentication;
        CurrentUserCallback callback;
        if (validationMode == AuthenticationComponent.UserNameValidationMode.NONE || this.isSystemUserName(userName)) {
            return this.setCurrentUserImpl(userName);
        }
        CurrentUserCallback currentUserCallback = callback = validationMode == AuthenticationComponent.UserNameValidationMode.CHECK_AND_FIX ? new FixCurrentUserCallback(userName) : new CheckCurrentUserCallback(userName);
        if (this.transactionService.isReadOnly()) {
            authentication = this.transactionService.getRetryingTransactionHelper().doInTransaction(callback, true, false);
        } else {
            boolean readOnly = validationMode == AuthenticationComponent.UserNameValidationMode.CHECK;
            boolean requiresNew = !readOnly && AlfrescoTransactionSupport.getTransactionReadState() == AlfrescoTransactionSupport.TxnReadState.TXN_READ_ONLY;
            authentication = this.transactionService.getRetryingTransactionHelper().doInTransaction(callback, readOnly, requiresNew);
        }
        if (authentication == null || callback.ae != null) {
            throw callback.ae;
        }
        return authentication;
    }

    private Authentication setCurrentUserImpl(String userName) throws AuthenticationException {
        if (userName == null) {
            throw new AuthenticationException("Null user name");
        }
        if (this.isSystemUserName(userName)) {
            return this.setSystemUserAsCurrentUser(this.getUserDomain(userName));
        }
        try {
            UserDetails ud = null;
            if (this.isGuestUserName(userName)) {
                String tenantDomain = this.getUserDomain(userName);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Setting the current user to the guest user of tenant domain \"" + tenantDomain + '\"'));
                }
                GrantedAuthority[] gas = new GrantedAuthority[]{};
                ud = new User(this.getGuestUserName(tenantDomain), "", true, true, true, true, gas);
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Setting the current user to \"" + userName + '\"'));
                }
                if (!userName.equals((ud = this.getUserDetails(userName)).getUsername())) {
                    ud = new User(userName, ud.getPassword(), ud.isEnabled(), ud.isAccountNonExpired(), ud.isCredentialsNonExpired(), ud.isAccountNonLocked(), ud.getAuthorities());
                }
            }
            return this.setUserDetails(ud);
        }
        catch (net.sf.acegisecurity.AuthenticationException ae) {
            throw new AuthenticationException(ae.getMessage(), (Throwable)ae);
        }
    }

    protected UserDetails getUserDetails(String userName) {
        GrantedAuthority[] gas = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_AUTHENTICATED")};
        User ud = new User(userName, "", true, true, true, true, gas);
        return ud;
    }

    @Override
    public Authentication setCurrentAuthentication(Authentication authentication) {
        return this.authenticationContext.setCurrentAuthentication(authentication);
    }

    @Override
    public Authentication getCurrentAuthentication() throws AuthenticationException {
        return this.authenticationContext.getCurrentAuthentication();
    }

    @Override
    public String getCurrentUserName() throws AuthenticationException {
        return this.authenticationContext.getCurrentUserName();
    }

    @Override
    public Authentication setSystemUserAsCurrentUser() {
        return this.authenticationContext.setSystemUserAsCurrentUser();
    }

    @Override
    public String getSystemUserName() {
        return this.authenticationContext.getSystemUserName();
    }

    @Override
    public boolean isSystemUserName(String userName) {
        return this.authenticationContext.isSystemUserName(userName);
    }

    @Override
    public boolean isCurrentUserTheSystemUser() {
        return this.authenticationContext.isCurrentUserTheSystemUser();
    }

    @Override
    public String getGuestUserName() {
        return this.authenticationContext.getGuestUserName();
    }

    @Override
    public String getGuestUserName(String tenantDomain) {
        return this.authenticationContext.getGuestUserName(tenantDomain);
    }

    @Override
    public Authentication setGuestUserAsCurrentUser() throws AuthenticationException {
        return this.setGuestUserAsCurrentUser("");
    }

    private Authentication setGuestUserAsCurrentUser(String tenantDomain) throws AuthenticationException {
        if (this.allowGuestLogin == null) {
            if (this.implementationAllowsGuestLogin()) {
                return this.setCurrentUser(this.getGuestUserName(tenantDomain));
            }
            throw new AuthenticationException("Guest authentication is not allowed");
        }
        if (this.allowGuestLogin.booleanValue()) {
            return this.setCurrentUser(this.getGuestUserName(tenantDomain));
        }
        throw new AuthenticationException("Guest authentication is not allowed");
    }

    @Override
    public boolean isGuestUserName(String userName) {
        return this.authenticationContext.isGuestUserName(userName);
    }

    protected abstract boolean implementationAllowsGuestLogin();

    @Override
    public boolean guestUserAuthenticationAllowed() {
        if (this.allowGuestLogin == null) {
            return this.implementationAllowsGuestLogin();
        }
        return this.allowGuestLogin;
    }

    @Override
    public void clearCurrentSecurityContext() {
        this.authenticationContext.clearCurrentSecurityContext();
    }

    @Override
    public Set<String> getDefaultAdministratorUserNames() {
        return this.defaultAdministratorUserNames;
    }

    public void setDefaultAdministratorUserNames(Set<String> defaultAdministratorUserNames) {
        this.defaultAdministratorUserNames = defaultAdministratorUserNames;
    }

    public void setDefaultAdministratorUserNameList(String defaultAdministratorUserNames) {
        TreeSet<String> nameSet = new TreeSet<String>();
        if (defaultAdministratorUserNames.length() > 0) {
            nameSet.addAll(Arrays.asList(defaultAdministratorUserNames.split(",")));
        }
        this.setDefaultAdministratorUserNames(nameSet);
    }

    @Override
    public Set<String> getDefaultGuestUserNames() {
        return this.defaultGuestUserNames;
    }

    public void setDefaultGuestUserNames(Set<String> defaultGuestUserNames) {
        this.defaultGuestUserNames = defaultGuestUserNames;
    }

    public void setDefaultGuestUserNameList(String defaultGuestUserNames) {
        TreeSet<String> nameSet = new TreeSet<String>();
        if (defaultGuestUserNames.length() > 0) {
            nameSet.addAll(Arrays.asList(defaultGuestUserNames.split(",")));
        }
        this.setDefaultGuestUserNames(nameSet);
    }

    @Override
    public String getSystemUserName(String tenantDomain) {
        return this.authenticationContext.getSystemUserName(tenantDomain);
    }

    @Override
    public String getUserDomain(String userName) {
        return this.authenticationContext.getUserDomain(userName);
    }

    @Override
    public Authentication setSystemUserAsCurrentUser(String tenantDomain) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Setting the current user to the system user of tenant domain \"" + tenantDomain + '\"'));
        }
        return this.authenticationContext.setSystemUserAsCurrentUser(tenantDomain);
    }

    @Override
    public Authentication setUserDetails(UserDetails ud) {
        return this.authenticationContext.setUserDetails(ud);
    }

    class FixCurrentUserCallback
    extends CurrentUserCallback {
        FixCurrentUserCallback(String userName) {
            super(userName);
        }

        public Authentication execute() throws Throwable {
            try {
                return AbstractAuthenticationComponent.this.setCurrentUserImpl((String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

                    public String doWork() throws Exception {
                        if (!AbstractAuthenticationComponent.this.personService.personExists(FixCurrentUserCallback.this.userName)) {
                            if (AbstractAuthenticationComponent.this.logger.isDebugEnabled()) {
                                AbstractAuthenticationComponent.this.logger.debug((Object)("User \"" + FixCurrentUserCallback.this.userName + "\" does not exist in Alfresco. Attempting to import / create the user."));
                            }
                            if (!AbstractAuthenticationComponent.this.userRegistrySynchronizer.createMissingPerson(FixCurrentUserCallback.this.userName)) {
                                if (AbstractAuthenticationComponent.this.logger.isDebugEnabled()) {
                                    AbstractAuthenticationComponent.this.logger.debug((Object)("Failed to import / create user \"" + FixCurrentUserCallback.this.userName + '\"'));
                                }
                                throw new AuthenticationException("User \"" + FixCurrentUserCallback.this.userName + "\" does not exist in Alfresco");
                            }
                        }
                        NodeRef userNode = AbstractAuthenticationComponent.this.personService.getPerson(FixCurrentUserCallback.this.userName);
                        return (String)((Object)AbstractAuthenticationComponent.this.nodeService.getProperty(userNode, ContentModel.PROP_USERNAME));
                    }
                }, (String)AbstractAuthenticationComponent.this.getSystemUserName(AbstractAuthenticationComponent.this.getUserDomain(this.userName))));
            }
            catch (AuthenticationException ae) {
                this.ae = ae;
                return null;
            }
        }
    }

    class CheckCurrentUserCallback
    extends CurrentUserCallback {
        CheckCurrentUserCallback(String userName) {
            super(userName);
        }

        public Authentication execute() throws Throwable {
            try {
                Authentication authentication = AbstractAuthenticationComponent.this.setCurrentUserImpl(this.userName);
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        if (!AbstractAuthenticationComponent.this.personService.personExists(CheckCurrentUserCallback.this.userName) || !AbstractAuthenticationComponent.this.nodeService.getProperty(AbstractAuthenticationComponent.this.personService.getPerson(CheckCurrentUserCallback.this.userName), ContentModel.PROP_USERNAME).equals(CheckCurrentUserCallback.this.userName)) {
                            if (AbstractAuthenticationComponent.this.logger.isDebugEnabled()) {
                                AbstractAuthenticationComponent.this.logger.debug((Object)("User \"" + CheckCurrentUserCallback.this.userName + "\" does not exist in Alfresco. Failing validation."));
                            }
                            throw new AuthenticationException("User \"" + CheckCurrentUserCallback.this.userName + "\" does not exist in Alfresco");
                        }
                        return null;
                    }
                }, (String)AbstractAuthenticationComponent.this.getSystemUserName(AbstractAuthenticationComponent.this.getUserDomain(this.userName)));
                return authentication;
            }
            catch (AuthenticationException ae) {
                this.ae = ae;
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class CurrentUserCallback
    implements RetryingTransactionHelper.RetryingTransactionCallback<Authentication> {
        AuthenticationException ae = null;
        String userName;

        CurrentUserCallback(String userName) {
            this.userName = userName;
        }
    }
}

