/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions;

import java.util.Collection;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.DefaultIntroductionAdvisor;
import org.springframework.aop.support.DelegatingIntroductionInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface PermissionCheckedCollection<T> {
    public boolean isCutOff();

    public int sizeUnchecked();

    public int sizeOriginal();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PermissionCheckedCollectionMixin<T>
    extends DelegatingIntroductionInterceptor
    implements PermissionCheckedCollection<T> {
        private final boolean isCutOff;
        private final int sizeUnchecked;
        private final int sizeOriginal;

        private PermissionCheckedCollectionMixin(boolean isCutOff, int sizeUnchecked, int sizeOriginal) {
            this.isCutOff = isCutOff;
            this.sizeUnchecked = sizeUnchecked;
            this.sizeOriginal = sizeOriginal;
        }

        @Override
        public boolean isCutOff() {
            return this.isCutOff;
        }

        @Override
        public int sizeUnchecked() {
            return this.sizeUnchecked;
        }

        @Override
        public int sizeOriginal() {
            return this.sizeOriginal;
        }

        public static final <TT> Collection<TT> create(Collection<TT> collection, Collection<?> checkedSource) {
            if (checkedSource instanceof PermissionCheckedCollection) {
                PermissionCheckedCollection source = (PermissionCheckedCollection)((Object)checkedSource);
                return PermissionCheckedCollectionMixin.create(collection, source.isCutOff(), source.sizeUnchecked(), source.sizeOriginal());
            }
            return collection;
        }

        public static final <TT> Collection<TT> create(Collection<TT> collection, boolean isCutOff, int sizeUnchecked, int sizeOriginal) {
            PermissionCheckedCollectionMixin mixin = new PermissionCheckedCollectionMixin(isCutOff, sizeUnchecked, sizeOriginal);
            DefaultIntroductionAdvisor advisor = new DefaultIntroductionAdvisor(mixin, PermissionCheckedCollection.class);
            ProxyFactory pf = new ProxyFactory(collection);
            pf.addAdvisor((Advisor)advisor);
            Object proxiedObject = pf.getProxy();
            return (Collection)proxiedObject;
        }
    }
}

