/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl.acegi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.sf.acegisecurity.ConfigAttribute;
import net.sf.acegisecurity.ConfigAttributeDefinition;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.search.results.ChildAssocRefResultSet;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.PermissionCheckCollection;
import org.alfresco.repo.security.permissions.impl.AbstractPermissionTest;
import org.alfresco.repo.security.permissions.impl.SimplePermissionEntry;
import org.alfresco.repo.security.permissions.impl.acegi.ACLEntryAfterInvocationProvider;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.framework.adapter.AdvisorAdapterRegistry;
import org.springframework.aop.framework.adapter.GlobalAdvisorAdapterRegistry;
import org.springframework.aop.target.SingletonTargetSource;

public class ACLEntryAfterInvocationTest
extends AbstractPermissionTest {
    public void testBasicAllowNullNode() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("echoNodeRef", NodeRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("AFTER_ACL_NODE.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        Object answer = method.invoke(proxy, new Object[]{null});
        ACLEntryAfterInvocationTest.assertNull((Object)answer);
    }

    public void testBasicAllowNullStore() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("echoStoreRef", StoreRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("AFTER_ACL_NODE.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        Object answer = method.invoke(proxy, new Object[]{null});
        ACLEntryAfterInvocationTest.assertNull((Object)answer);
    }

    public void testBasicAllowUnrecognisedObject() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("echoObject", Object.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("AFTER_ACL_NODE.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        Object answer = method.invoke(proxy, "noodle");
        ACLEntryAfterInvocationTest.assertNotNull((Object)answer);
    }

    public void testBasicDenyInvalidNodeRef() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("echoNodeRef", NodeRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("AFTER_ACL_NODE.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        Object answer = method.invoke(proxy, this.rootNodeRef);
        ACLEntryAfterInvocationTest.assertEquals((String)"Value passed out must be valid", (Object)this.rootNodeRef, (Object)answer);
        NodeRef invalidNodeRef = new NodeRef("workspace://SpacesStore/noodle");
        answer = method.invoke(proxy, invalidNodeRef);
        method.invoke(proxy, invalidNodeRef);
        ACLEntryAfterInvocationTest.assertEquals((String)"Value passed out must be equal", (Object)invalidNodeRef, (Object)answer);
    }

    public void testBasicFilterInvalidNodeRefs() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("echoCollection", Collection.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("AFTER_ACL_NODE.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        List answer = (List)method.invoke(proxy, Collections.singletonList(this.rootNodeRef));
        ACLEntryAfterInvocationTest.assertEquals((String)"Collection must be intact", (int)1, (int)answer.size());
        NodeRef invalidNodeRef = new NodeRef("workspace://SpacesStore/noodle");
        answer = (List)method.invoke(proxy, Collections.singletonList(invalidNodeRef));
        ACLEntryAfterInvocationTest.assertEquals((String)"Invalid NodeRef should not have been filtered out", (int)1, (int)answer.size());
    }

    public void testBasicDenyStore() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("echoStoreRef", StoreRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("AFTER_ACL_NODE.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        try {
            Object answer = method.invoke(proxy, this.rootNodeRef.getStoreRef());
            ACLEntryAfterInvocationTest.assertNotNull((Object)answer);
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
    }

    public void testBasicDenyNode() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("echoNodeRef", NodeRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("AFTER_ACL_NODE.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        try {
            Object answer = method.invoke(proxy, this.rootNodeRef);
            ACLEntryAfterInvocationTest.assertNotNull((Object)answer);
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
    }

    public void testBasicAllowNode() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("echoNodeRef", NodeRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("AFTER_ACL_NODE.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        Object answer = method.invoke(proxy, this.rootNodeRef);
        ACLEntryAfterInvocationTest.assertEquals((Object)answer, (Object)this.rootNodeRef);
    }

    public void testBasicAllowNodePair() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("echoNodePair", NodeRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("AFTER_ACL_NODE.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        Pair rootNodePair = new Pair((Object)1L, (Object)this.rootNodeRef);
        Object answer = method.invoke(proxy, this.rootNodeRef);
        ACLEntryAfterInvocationTest.assertEquals((Object)rootNodePair, (Object)answer);
    }

    public void testBasicAllowStore() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("echoStoreRef", StoreRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("AFTER_ACL_NODE.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        Object answer = method.invoke(proxy, this.rootNodeRef.getStoreRef());
        ACLEntryAfterInvocationTest.assertEquals((Object)answer, (Object)this.rootNodeRef.getStoreRef());
    }

    public void testBasicAllowNodeParent() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("echoNodeRef", NodeRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("AFTER_ACL_PARENT.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        Object answer = method.invoke(proxy, this.rootNodeRef);
        ACLEntryAfterInvocationTest.assertEquals((Object)answer, (Object)this.rootNodeRef);
        try {
            answer = method.invoke(proxy, this.systemNodeRef);
            ACLEntryAfterInvocationTest.assertNotNull((Object)answer);
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        answer = method.invoke(proxy, this.systemNodeRef);
        ACLEntryAfterInvocationTest.assertEquals((Object)answer, (Object)this.systemNodeRef);
    }

    public void testBasicAllowNullChildAssociationRef1() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("echoChildAssocRef", ChildAssociationRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("AFTER_ACL_NODE.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        Object answer = method.invoke(proxy, new Object[]{null});
        ACLEntryAfterInvocationTest.assertNull((Object)answer);
    }

    public void testBasicAllowNullChildAssociationRef2() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("echoChildAssocRef", ChildAssociationRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("AFTER_ACL_PARENT.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        Object answer = method.invoke(proxy, new Object[]{null});
        ACLEntryAfterInvocationTest.assertNull((Object)answer);
    }

    public void testBasicDenyChildAssocRef1() throws Exception {
        Object answer;
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("echoChildAssocRef", ChildAssociationRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("AFTER_ACL_NODE.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        try {
            answer = method.invoke(proxy, this.nodeService.getPrimaryParent(this.rootNodeRef));
            ACLEntryAfterInvocationTest.assertNotNull((Object)answer);
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        try {
            answer = method.invoke(proxy, this.nodeService.getPrimaryParent(this.systemNodeRef));
            ACLEntryAfterInvocationTest.assertNotNull((Object)answer);
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
    }

    public void testBasicDenyChildAssocRef2() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("echoChildAssocRef", ChildAssociationRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("AFTER_ACL_PARENT.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        Object answer = method.invoke(proxy, this.nodeService.getPrimaryParent(this.rootNodeRef));
        ACLEntryAfterInvocationTest.assertNotNull((Object)answer);
        try {
            answer = method.invoke(proxy, this.nodeService.getPrimaryParent(this.systemNodeRef));
            ACLEntryAfterInvocationTest.assertNotNull((Object)answer);
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
    }

    public void testBasicAllowChildAssociationRef1() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("echoChildAssocRef", ChildAssociationRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("AFTER_ACL_NODE.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        Object answer = method.invoke(proxy, this.nodeService.getPrimaryParent(this.rootNodeRef));
        ACLEntryAfterInvocationTest.assertEquals((Object)answer, (Object)this.nodeService.getPrimaryParent(this.rootNodeRef));
        answer = method.invoke(proxy, this.nodeService.getPrimaryParent(this.systemNodeRef));
        ACLEntryAfterInvocationTest.assertEquals((Object)answer, (Object)this.nodeService.getPrimaryParent(this.systemNodeRef));
    }

    public void testBasicAllowChildAssociationRef2() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("echoChildAssocRef", ChildAssociationRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("AFTER_ACL_PARENT.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        Object answer = method.invoke(proxy, this.nodeService.getPrimaryParent(this.rootNodeRef));
        ACLEntryAfterInvocationTest.assertEquals((Object)answer, (Object)this.nodeService.getPrimaryParent(this.rootNodeRef));
        answer = method.invoke(proxy, this.nodeService.getPrimaryParent(this.systemNodeRef));
        ACLEntryAfterInvocationTest.assertEquals((Object)answer, (Object)this.nodeService.getPrimaryParent(this.systemNodeRef));
    }

    public void testBasicAllowNullResultSet() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method methodResultSet = o.getClass().getMethod("echoResultSet", ResultSet.class);
        Method methodCollection = o.getClass().getMethod("echoCollection", Collection.class);
        Method methodArray = o.getClass().getMethod("echoArray", Object[].class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("AFTER_ACL_NODE.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        ArrayList<NodeRef> nodeRefList = new ArrayList<NodeRef>();
        NodeRef[] nodeRefArray = new NodeRef[]{};
        HashSet nodeRefSet = new HashSet();
        ArrayList carList = new ArrayList();
        ChildAssociationRef[] carArray = new ChildAssociationRef[]{};
        HashSet carSet = new HashSet();
        ChildAssocRefResultSet rsIn = new ChildAssocRefResultSet(this.nodeService, nodeRefList, false);
        ACLEntryAfterInvocationTest.assertEquals((int)0, (int)rsIn.length());
        ResultSet answerResultSet = (ResultSet)methodResultSet.invoke(proxy, rsIn);
        ACLEntryAfterInvocationTest.assertEquals((int)0, (int)answerResultSet.length());
        Collection answerCollection = (Collection)methodCollection.invoke(proxy, nodeRefList);
        ACLEntryAfterInvocationTest.assertEquals((int)0, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, nodeRefSet);
        ACLEntryAfterInvocationTest.assertEquals((int)0, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, carList);
        ACLEntryAfterInvocationTest.assertEquals((int)0, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, carSet);
        ACLEntryAfterInvocationTest.assertEquals((int)0, (int)answerCollection.size());
        Object[] answerArray = (Object[])methodArray.invoke(proxy, new Object[]{nodeRefArray});
        ACLEntryAfterInvocationTest.assertEquals((int)0, (int)answerArray.length);
        answerArray = (Object[])methodArray.invoke(proxy, new Object[]{carArray});
        ACLEntryAfterInvocationTest.assertEquals((int)0, (int)answerArray.length);
        ACLEntryAfterInvocationTest.assertEquals((int)0, (int)rsIn.length());
        answerResultSet = (ResultSet)methodResultSet.invoke(proxy, new Object[]{null});
        ACLEntryAfterInvocationTest.assertNull((Object)answerResultSet);
        answerCollection = (Collection)methodCollection.invoke(proxy, new Object[]{null});
        ACLEntryAfterInvocationTest.assertNull((Object)answerCollection);
        answerArray = (Object[])methodArray.invoke(proxy, new Object[]{null});
        ACLEntryAfterInvocationTest.assertNull((Object)answerArray);
    }

    public void testResultSetFilterAll() throws Exception {
        this.runAs(AuthenticationUtil.getAdminUserName());
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method methodResultSet = o.getClass().getMethod("echoResultSet", ResultSet.class);
        Method methodCollection = o.getClass().getMethod("echoCollection", Collection.class);
        Method methodArray = o.getClass().getMethod("echoArray", Object[].class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("AFTER_ACL_NODE.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        ArrayList<NodeRef> nodeRefList = new ArrayList<NodeRef>();
        nodeRefList.add(this.rootNodeRef);
        nodeRefList.add(this.systemNodeRef);
        nodeRefList.add(n1);
        nodeRefList.add(n1);
        NodeRef[] nodeRefArray = nodeRefList.toArray(new NodeRef[0]);
        HashSet<NodeRef> nodeRefSet = new HashSet<NodeRef>();
        nodeRefSet.addAll(nodeRefList);
        ArrayList<ChildAssociationRef> carList = new ArrayList<ChildAssociationRef>();
        carList.add(this.nodeService.getPrimaryParent(this.rootNodeRef));
        carList.add(this.nodeService.getPrimaryParent(this.systemNodeRef));
        carList.add(this.nodeService.getPrimaryParent(n1));
        carList.add(this.nodeService.getPrimaryParent(n1));
        ChildAssociationRef[] carArray = carList.toArray(new ChildAssociationRef[0]);
        HashSet<ChildAssociationRef> carSet = new HashSet<ChildAssociationRef>();
        carSet.addAll(carList);
        ChildAssocRefResultSet rsIn = new ChildAssocRefResultSet(this.nodeService, nodeRefList, false);
        ACLEntryAfterInvocationTest.assertEquals((int)4, (int)rsIn.length());
        ResultSet answerResultSet = (ResultSet)methodResultSet.invoke(proxy, rsIn);
        ACLEntryAfterInvocationTest.assertEquals((int)0, (int)answerResultSet.length());
        Collection answerCollection = (Collection)methodCollection.invoke(proxy, nodeRefList);
        ACLEntryAfterInvocationTest.assertEquals((int)0, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, nodeRefSet);
        ACLEntryAfterInvocationTest.assertEquals((int)0, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, carList);
        ACLEntryAfterInvocationTest.assertEquals((int)0, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, carSet);
        ACLEntryAfterInvocationTest.assertEquals((int)0, (int)answerCollection.size());
        Object[] answerArray = (Object[])methodArray.invoke(proxy, new Object[]{nodeRefArray});
        ACLEntryAfterInvocationTest.assertEquals((int)0, (int)answerArray.length);
        answerArray = (Object[])methodArray.invoke(proxy, new Object[]{carArray});
        ACLEntryAfterInvocationTest.assertEquals((int)0, (int)answerArray.length);
    }

    public void testWhenNodesCheckedExceedsTargetResultCount() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        this.runAs(AuthenticationUtil.getAdminUserName());
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n2 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n3 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n4 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("All"), "andy", AccessStatus.DENIED));
        this.permissionService.setPermission(new SimplePermissionEntry(n4, this.getPermission("All"), "andy", AccessStatus.ALLOWED));
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method methodCollection = o.getClass().getMethod("echoCollection", Collection.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("AFTER_ACL_NODE.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        ArrayList<NodeRef> nodeRefList = new ArrayList<NodeRef>(Arrays.asList(n1, n2, n3, n4));
        Collection answerCollection = (Collection)methodCollection.invoke(proxy, PermissionCheckCollection.PermissionCheckCollectionMixin.create(nodeRefList, 3, 0L, 0));
        ACLEntryAfterInvocationTest.assertEquals((int)1, (int)answerCollection.size());
        ACLEntryAfterInvocationTest.assertEquals((Object)n4, answerCollection.iterator().next());
    }

    public void testResultSetFilterForNullParentOnly() throws Exception {
        this.runAs(AuthenticationUtil.getAdminUserName());
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method methodResultSet = o.getClass().getMethod("echoResultSet", ResultSet.class);
        Method methodCollection = o.getClass().getMethod("echoCollection", Collection.class);
        Method methodArray = o.getClass().getMethod("echoArray", Object[].class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("AFTER_ACL_PARENT.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        ArrayList<NodeRef> nodeRefList = new ArrayList<NodeRef>();
        nodeRefList.add(this.rootNodeRef);
        nodeRefList.add(this.systemNodeRef);
        nodeRefList.add(n1);
        nodeRefList.add(n1);
        NodeRef[] nodeRefArray = nodeRefList.toArray(new NodeRef[0]);
        HashSet<NodeRef> nodeRefSet = new HashSet<NodeRef>();
        nodeRefSet.addAll(nodeRefList);
        ArrayList<ChildAssociationRef> carList = new ArrayList<ChildAssociationRef>();
        carList.add(this.nodeService.getPrimaryParent(this.rootNodeRef));
        carList.add(this.nodeService.getPrimaryParent(this.systemNodeRef));
        carList.add(this.nodeService.getPrimaryParent(n1));
        carList.add(this.nodeService.getPrimaryParent(n1));
        ChildAssociationRef[] carArray = carList.toArray(new ChildAssociationRef[0]);
        HashSet<ChildAssociationRef> carSet = new HashSet<ChildAssociationRef>();
        carSet.addAll(carList);
        ChildAssocRefResultSet rsIn = new ChildAssocRefResultSet(this.nodeService, nodeRefList, false);
        ACLEntryAfterInvocationTest.assertEquals((int)4, (int)rsIn.length());
        ResultSet answerResultSet = (ResultSet)methodResultSet.invoke(proxy, rsIn);
        ACLEntryAfterInvocationTest.assertEquals((int)1, (int)answerResultSet.length());
        Collection answerCollection = (Collection)methodCollection.invoke(proxy, nodeRefList);
        ACLEntryAfterInvocationTest.assertEquals((int)1, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, nodeRefSet);
        ACLEntryAfterInvocationTest.assertEquals((int)1, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, carList);
        ACLEntryAfterInvocationTest.assertEquals((int)1, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, carSet);
        ACLEntryAfterInvocationTest.assertEquals((int)1, (int)answerCollection.size());
        Object[] answerArray = (Object[])methodArray.invoke(proxy, new Object[]{nodeRefArray});
        ACLEntryAfterInvocationTest.assertEquals((int)1, (int)answerArray.length);
        answerArray = (Object[])methodArray.invoke(proxy, new Object[]{carArray});
        ACLEntryAfterInvocationTest.assertEquals((int)1, (int)answerArray.length);
    }

    public void testResultSetFilterNone1() throws Exception {
        this.runAs(AuthenticationUtil.getAdminUserName());
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method methodResultSet = o.getClass().getMethod("echoResultSet", ResultSet.class);
        Method methodCollection = o.getClass().getMethod("echoCollection", Collection.class);
        Method methodArray = o.getClass().getMethod("echoArray", Object[].class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("AFTER_ACL_NODE.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        ArrayList<NodeRef> nodeRefList = new ArrayList<NodeRef>();
        nodeRefList.add(this.rootNodeRef);
        nodeRefList.add(this.systemNodeRef);
        nodeRefList.add(n1);
        nodeRefList.add(n1);
        ArrayList<Object> mixedRefList = new ArrayList<Object>();
        mixedRefList.add(this.rootNodeRef);
        mixedRefList.add(this.systemNodeRef);
        mixedRefList.add(n1);
        mixedRefList.add(n1);
        mixedRefList.add(this.rootNodeRef.getStoreRef());
        NodeRef[] nodeRefArray = nodeRefList.toArray(new NodeRef[0]);
        HashSet<NodeRef> nodeRefSet = new HashSet<NodeRef>();
        nodeRefSet.addAll(nodeRefList);
        HashSet<Object> mixedRefSet = new HashSet<Object>();
        mixedRefSet.addAll(mixedRefList);
        ArrayList<ChildAssociationRef> carList = new ArrayList<ChildAssociationRef>();
        carList.add(this.nodeService.getPrimaryParent(this.rootNodeRef));
        carList.add(this.nodeService.getPrimaryParent(this.systemNodeRef));
        carList.add(this.nodeService.getPrimaryParent(n1));
        carList.add(this.nodeService.getPrimaryParent(n1));
        ChildAssociationRef[] carArray = carList.toArray(new ChildAssociationRef[0]);
        HashSet<ChildAssociationRef> carSet = new HashSet<ChildAssociationRef>();
        carSet.addAll(carList);
        ChildAssocRefResultSet rsIn = new ChildAssocRefResultSet(this.nodeService, nodeRefList, false);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        ACLEntryAfterInvocationTest.assertEquals((int)4, (int)rsIn.length());
        ResultSet answerResultSet = (ResultSet)methodResultSet.invoke(proxy, rsIn);
        ACLEntryAfterInvocationTest.assertEquals((int)4, (int)answerResultSet.length());
        Collection answerCollection = (Collection)methodCollection.invoke(proxy, nodeRefList);
        ACLEntryAfterInvocationTest.assertEquals((int)4, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, mixedRefList);
        ACLEntryAfterInvocationTest.assertEquals((int)5, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, nodeRefSet);
        ACLEntryAfterInvocationTest.assertEquals((int)3, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, mixedRefSet);
        ACLEntryAfterInvocationTest.assertEquals((int)4, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, carList);
        ACLEntryAfterInvocationTest.assertEquals((int)4, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, carSet);
        ACLEntryAfterInvocationTest.assertEquals((int)3, (int)answerCollection.size());
        Object[] answerArray = (Object[])methodArray.invoke(proxy, new Object[]{nodeRefArray});
        ACLEntryAfterInvocationTest.assertEquals((int)4, (int)answerArray.length);
        answerArray = (Object[])methodArray.invoke(proxy, new Object[]{carArray});
        ACLEntryAfterInvocationTest.assertEquals((int)4, (int)answerArray.length);
        answerCollection = (Collection)methodCollection.invoke(proxy, PermissionCheckCollection.PermissionCheckCollectionMixin.create(new ArrayList<NodeRef>(nodeRefList), 1, 0L, 0));
        ACLEntryAfterInvocationTest.assertEquals((int)1, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, PermissionCheckCollection.PermissionCheckCollectionMixin.create(new ArrayList<NodeRef>(nodeRefList), 5, 0L, 2));
        ACLEntryAfterInvocationTest.assertEquals((int)2, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, PermissionCheckCollection.PermissionCheckCollectionMixin.create(new ArrayList<NodeRef>(nodeRefList), 5, 1L, 0));
        ACLEntryAfterInvocationTest.assertTrue((String)("Too many results: " + answerCollection.size()), (answerCollection.size() < 5 ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(n1, this.getPermission("Read"), "andy", AccessStatus.DENIED));
        ACLEntryAfterInvocationTest.assertEquals((int)4, (int)rsIn.length());
        answerResultSet = (ResultSet)methodResultSet.invoke(proxy, rsIn);
        ACLEntryAfterInvocationTest.assertEquals((int)2, (int)answerResultSet.length());
        answerCollection = (Collection)methodCollection.invoke(proxy, nodeRefList);
        ACLEntryAfterInvocationTest.assertEquals((int)2, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, mixedRefList);
        ACLEntryAfterInvocationTest.assertEquals((int)3, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, nodeRefSet);
        ACLEntryAfterInvocationTest.assertEquals((int)2, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, mixedRefSet);
        ACLEntryAfterInvocationTest.assertEquals((int)3, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, carList);
        ACLEntryAfterInvocationTest.assertEquals((int)2, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, carSet);
        ACLEntryAfterInvocationTest.assertEquals((int)2, (int)answerCollection.size());
        answerArray = (Object[])methodArray.invoke(proxy, new Object[]{nodeRefArray});
        ACLEntryAfterInvocationTest.assertEquals((int)2, (int)answerArray.length);
        answerArray = (Object[])methodArray.invoke(proxy, new Object[]{carArray});
        ACLEntryAfterInvocationTest.assertEquals((int)2, (int)answerArray.length);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.DENIED));
        ACLEntryAfterInvocationTest.assertEquals((int)4, (int)rsIn.length());
        answerResultSet = (ResultSet)methodResultSet.invoke(proxy, rsIn);
        ACLEntryAfterInvocationTest.assertEquals((int)0, (int)answerResultSet.length());
        answerCollection = (Collection)methodCollection.invoke(proxy, nodeRefList);
        ACLEntryAfterInvocationTest.assertEquals((int)0, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, mixedRefList);
        ACLEntryAfterInvocationTest.assertEquals((int)0, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, nodeRefSet);
        ACLEntryAfterInvocationTest.assertEquals((int)0, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, mixedRefSet);
        ACLEntryAfterInvocationTest.assertEquals((int)0, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, carList);
        ACLEntryAfterInvocationTest.assertEquals((int)0, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, carSet);
        ACLEntryAfterInvocationTest.assertEquals((int)0, (int)answerCollection.size());
        answerArray = (Object[])methodArray.invoke(proxy, new Object[]{nodeRefArray});
        ACLEntryAfterInvocationTest.assertEquals((int)0, (int)answerArray.length);
        answerArray = (Object[])methodArray.invoke(proxy, new Object[]{carArray});
        ACLEntryAfterInvocationTest.assertEquals((int)0, (int)answerArray.length);
    }

    public void testResultSetFilterNone2() throws Exception {
        this.runAs(AuthenticationUtil.getAdminUserName());
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method methodResultSet = o.getClass().getMethod("echoResultSet", ResultSet.class);
        Method methodCollection = o.getClass().getMethod("echoCollection", Collection.class);
        Method methodArray = o.getClass().getMethod("echoArray", Object[].class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("AFTER_ACL_PARENT.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        ArrayList<NodeRef> nodeRefList = new ArrayList<NodeRef>();
        nodeRefList.add(this.rootNodeRef);
        nodeRefList.add(this.systemNodeRef);
        nodeRefList.add(n1);
        nodeRefList.add(n1);
        ArrayList<Object> mixedRefList = new ArrayList<Object>();
        mixedRefList.add(this.rootNodeRef);
        mixedRefList.add(this.systemNodeRef);
        mixedRefList.add(n1);
        mixedRefList.add(n1);
        mixedRefList.add(this.rootNodeRef.getStoreRef());
        NodeRef[] nodeRefArray = nodeRefList.toArray(new NodeRef[0]);
        HashSet<NodeRef> nodeRefSet = new HashSet<NodeRef>();
        nodeRefSet.addAll(nodeRefList);
        HashSet<Object> mixedRefSet = new HashSet<Object>();
        mixedRefSet.addAll(mixedRefList);
        ArrayList<ChildAssociationRef> carList = new ArrayList<ChildAssociationRef>();
        carList.add(this.nodeService.getPrimaryParent(this.rootNodeRef));
        carList.add(this.nodeService.getPrimaryParent(this.systemNodeRef));
        carList.add(this.nodeService.getPrimaryParent(n1));
        carList.add(this.nodeService.getPrimaryParent(n1));
        ChildAssociationRef[] carArray = carList.toArray(new ChildAssociationRef[0]);
        HashSet<ChildAssociationRef> carSet = new HashSet<ChildAssociationRef>();
        carSet.addAll(carList);
        ChildAssocRefResultSet rsIn = new ChildAssocRefResultSet(this.nodeService, nodeRefList, false);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        ACLEntryAfterInvocationTest.assertEquals((int)4, (int)rsIn.length());
        ResultSet answerResultSet = (ResultSet)methodResultSet.invoke(proxy, rsIn);
        ACLEntryAfterInvocationTest.assertEquals((int)4, (int)answerResultSet.length());
        Collection answerCollection = (Collection)methodCollection.invoke(proxy, nodeRefList);
        ACLEntryAfterInvocationTest.assertEquals((int)4, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, mixedRefList);
        ACLEntryAfterInvocationTest.assertEquals((int)5, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, nodeRefSet);
        ACLEntryAfterInvocationTest.assertEquals((int)3, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, mixedRefSet);
        ACLEntryAfterInvocationTest.assertEquals((int)4, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, carList);
        ACLEntryAfterInvocationTest.assertEquals((int)4, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, carSet);
        ACLEntryAfterInvocationTest.assertEquals((int)3, (int)answerCollection.size());
        Object[] answerArray = (Object[])methodArray.invoke(proxy, new Object[]{nodeRefArray});
        ACLEntryAfterInvocationTest.assertEquals((int)4, (int)answerArray.length);
        answerArray = (Object[])methodArray.invoke(proxy, new Object[]{carArray});
        ACLEntryAfterInvocationTest.assertEquals((int)4, (int)answerArray.length);
        this.permissionService.setPermission(new SimplePermissionEntry(n1, this.getPermission("Read"), "andy", AccessStatus.DENIED));
        ACLEntryAfterInvocationTest.assertEquals((int)4, (int)rsIn.length());
        answerResultSet = (ResultSet)methodResultSet.invoke(proxy, rsIn);
        ACLEntryAfterInvocationTest.assertEquals((int)4, (int)answerResultSet.length());
        answerCollection = (Collection)methodCollection.invoke(proxy, nodeRefList);
        ACLEntryAfterInvocationTest.assertEquals((int)4, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, mixedRefList);
        ACLEntryAfterInvocationTest.assertEquals((int)5, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, nodeRefSet);
        ACLEntryAfterInvocationTest.assertEquals((int)3, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, mixedRefSet);
        ACLEntryAfterInvocationTest.assertEquals((int)4, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, carList);
        ACLEntryAfterInvocationTest.assertEquals((int)4, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, carSet);
        ACLEntryAfterInvocationTest.assertEquals((int)3, (int)answerCollection.size());
        answerArray = (Object[])methodArray.invoke(proxy, new Object[]{nodeRefArray});
        ACLEntryAfterInvocationTest.assertEquals((int)4, (int)answerArray.length);
        answerArray = (Object[])methodArray.invoke(proxy, new Object[]{carArray});
        ACLEntryAfterInvocationTest.assertEquals((int)4, (int)answerArray.length);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.DENIED));
        ACLEntryAfterInvocationTest.assertEquals((int)4, (int)rsIn.length());
        answerResultSet = (ResultSet)methodResultSet.invoke(proxy, rsIn);
        ACLEntryAfterInvocationTest.assertEquals((int)1, (int)answerResultSet.length());
        answerCollection = (Collection)methodCollection.invoke(proxy, nodeRefList);
        ACLEntryAfterInvocationTest.assertEquals((int)1, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, mixedRefList);
        ACLEntryAfterInvocationTest.assertEquals((int)2, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, nodeRefSet);
        ACLEntryAfterInvocationTest.assertEquals((int)1, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, mixedRefSet);
        ACLEntryAfterInvocationTest.assertEquals((int)2, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, carList);
        ACLEntryAfterInvocationTest.assertEquals((int)1, (int)answerCollection.size());
        answerCollection = (Collection)methodCollection.invoke(proxy, carSet);
        ACLEntryAfterInvocationTest.assertEquals((int)1, (int)answerCollection.size());
        answerArray = (Object[])methodArray.invoke(proxy, new Object[]{nodeRefArray});
        ACLEntryAfterInvocationTest.assertEquals((int)1, (int)answerArray.length);
        answerArray = (Object[])methodArray.invoke(proxy, new Object[]{carArray});
        ACLEntryAfterInvocationTest.assertEquals((int)1, (int)answerArray.length);
    }

    public class Interceptor
    implements MethodInterceptor {
        ConfigAttributeDefinition cad = new ConfigAttributeDefinition();

        Interceptor(final String config) {
            this.cad.addConfigAttribute(new ConfigAttribute(){
                private static final long serialVersionUID = 1L;

                public String getAttribute() {
                    return config;
                }
            });
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            ACLEntryAfterInvocationProvider after = new ACLEntryAfterInvocationProvider();
            after.setNamespacePrefixResolver(ACLEntryAfterInvocationTest.this.namespacePrefixResolver);
            after.setPermissionService(ACLEntryAfterInvocationTest.this.permissionService);
            after.setNodeService(ACLEntryAfterInvocationTest.this.nodeService);
            after.setAuthenticationService(ACLEntryAfterInvocationTest.this.authenticationService);
            after.setUnfilteredFor(Collections.singleton("{ns}ln"));
            after.afterPropertiesSet();
            Object returnObject = invocation.proceed();
            return after.decide(null, (Object)invocation, this.cad, returnObject);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassWithMethods {
        public Object echoObject(Object o) {
            return o;
        }

        public StoreRef echoStoreRef(StoreRef storeRef) {
            return storeRef;
        }

        public NodeRef echoNodeRef(NodeRef nodeRef) {
            return nodeRef;
        }

        public Pair<Long, NodeRef> echoNodePair(NodeRef nodeRef) {
            return new Pair((Object)1L, (Object)nodeRef);
        }

        public ChildAssociationRef echoChildAssocRef(ChildAssociationRef car) {
            return car;
        }

        public ResultSet echoResultSet(ResultSet rs) {
            return rs;
        }

        public <T> Collection<T> echoCollection(Collection<T> nrc) {
            return nrc;
        }

        public <T> T[] echoArray(T[] nra) {
            return nra;
        }
    }
}

