/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.person;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.person.HomeFolderProvider;
import org.alfresco.repo.security.person.HomeFolderProviderSynchronizer;
import org.alfresco.repo.security.person.PermissionsManager;
import org.alfresco.repo.security.person.PersonServiceImpl;
import org.alfresco.repo.security.person.PortableHomeFolderManager;
import org.alfresco.repo.security.person.RegexHomeFolderProvider;
import org.alfresco.repo.security.person.UIDBasedHomeFolderProvider;
import org.alfresco.repo.tenant.Tenant;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.PropertyMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ComparisonFailure;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HomeFolderProviderSynchronizerTest {
    private static final QName PROP_PARENT_PATH = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"parentPath");
    private static ApplicationContext applicationContext;
    private static ServiceRegistry serviceRegistry;
    private static TransactionService transactionService;
    private static FileFolderService fileFolderService;
    private static PersonServiceImpl personService;
    private static NodeService nodeService;
    private static ContentService contentService;
    private static AuthorityService authorityService;
    private static TenantAdminService tenantAdminService;
    private static TenantService tenantService;
    private static PortableHomeFolderManager homeFolderManager;
    private static RegexHomeFolderProvider largeHomeFolderProvider;
    private static String largeHomeFolderProviderName;
    private static RegexHomeFolderProvider testHomeFolderProvider;
    private static String testHomeFolderProviderName;
    private static String storeUrl;
    private static String origRootPath;
    private static NodeRef rootNodeRef;
    private static HomeFolderProviderSynchronizer homeFolderProviderSynchronizer;
    private static boolean firstTest;
    private UserTransaction trans;

    @BeforeClass
    public static void classSetup() throws Exception {
        applicationContext = ApplicationContextHelper.getApplicationContext();
        serviceRegistry = (ServiceRegistry)applicationContext.getBean("ServiceRegistry");
        transactionService = (TransactionService)applicationContext.getBean("transactionService");
        fileFolderService = (FileFolderService)applicationContext.getBean("fileFolderService");
        personService = (PersonServiceImpl)applicationContext.getBean("personService");
        nodeService = (NodeService)applicationContext.getBean("nodeService");
        contentService = (ContentService)applicationContext.getBean("contentService");
        authorityService = (AuthorityService)applicationContext.getBean("authorityService");
        tenantAdminService = (TenantAdminService)applicationContext.getBean("tenantAdminService");
        tenantService = (TenantService)applicationContext.getBean("tenantService");
        homeFolderManager = (PortableHomeFolderManager)applicationContext.getBean("homeFolderManager");
        largeHomeFolderProvider = (RegexHomeFolderProvider)applicationContext.getBean("largeHomeFolderProvider");
        largeHomeFolderProviderName = largeHomeFolderProvider.getName();
        storeUrl = largeHomeFolderProvider.getStoreUrl();
        origRootPath = largeHomeFolderProvider.getRootPath();
        personService.setCreateMissingPeople(true);
        testHomeFolderProvider = new RegexHomeFolderProvider(){

            @Override
            public List<String> getHomeFolderPath(NodeRef person) {
                String parentPath = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)nodeService.getProperty(person, PROP_PARENT_PATH));
                String propPath = (parentPath == null || parentPath.length() == 0 ? "" : parentPath + '/') + homeFolderManager.getPersonProperty(person, ContentModel.PROP_USERNAME);
                return Arrays.asList(propPath.split("/"));
            }
        };
        testHomeFolderProvider.setPropertyName(ContentModel.PROP_USERNAME.getLocalName());
        testHomeFolderProvider.setPattern("(..)");
        testHomeFolderProvider.setBeanName("testHomeFolderProvider");
        testHomeFolderProvider.setHomeFolderManager(homeFolderManager);
        testHomeFolderProvider.setRootPath(origRootPath);
        testHomeFolderProvider.setStoreUrl(storeUrl);
        testHomeFolderProvider.setOnCreatePermissionsManager((PermissionsManager)applicationContext.getBean("defaultOnCreatePermissionsManager"));
        testHomeFolderProvider.setOnCreatePermissionsManager((PermissionsManager)applicationContext.getBean("defaultOnCreatePermissionsManager"));
        testHomeFolderProvider.setOnReferencePermissionsManager((PermissionsManager)applicationContext.getBean("defaultOnReferencePermissionsManager"));
        testHomeFolderProviderName = testHomeFolderProvider.getName();
        homeFolderManager.addProvider(testHomeFolderProvider);
        homeFolderProviderSynchronizer = new HomeFolderProviderSynchronizer(transactionService, authorityService, personService, fileFolderService, nodeService, homeFolderManager, tenantAdminService);
    }

    @Before
    public void setUp() throws Exception {
        homeFolderProviderSynchronizer.setEnabled("true");
        homeFolderProviderSynchronizer.setOverrideHomeFolderProviderName(null);
        homeFolderProviderSynchronizer.setKeepEmptyParents("false");
        largeHomeFolderProvider.setPattern("^(..)");
        testHomeFolderProvider.setRootPath(origRootPath);
        largeHomeFolderProvider.setRootPath(origRootPath);
        if (firstTest) {
            firstTest = false;
            AuthenticationUtil.setRunAsUserSystem();
            this.trans = transactionService.getUserTransaction();
            this.trans.begin();
            rootNodeRef = homeFolderManager.getRootPathNodeRef(largeHomeFolderProvider);
            this.trans.commit();
            this.trans = null;
            this.tearDown();
        }
        AuthenticationUtil.setRunAsUserSystem();
        this.trans = transactionService.getUserTransaction();
        this.trans.begin();
    }

    @After
    public void tearDown() throws Exception {
        block3: {
            if (this.trans != null) {
                try {
                    this.trans.commit();
                }
                catch (Exception e) {
                    if (this.trans.getStatus() != 0 && this.trans.getStatus() != 1) break block3;
                    this.trans.rollback();
                    this.trans = null;
                }
            }
        }
        this.trans = transactionService.getUserTransaction();
        this.trans.begin();
        Set<NodeRef> adminGuestUserHomeFolders = this.deleteNonAdminGuestUsers();
        this.deleteNonAdminGuestFolders(adminGuestUserHomeFolders);
        this.deleteAllTenants();
        this.trans.commit();
        this.trans = null;
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<NodeRef> deleteNonAdminGuestUsers() {
        final HashSet<NodeRef> adminGuestUserHomeFolders = new HashSet<NodeRef>();
        for (final NodeRef nodeRef : personService.getAllPeople()) {
            Object var10_9;
            final String username = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)nodeService.getProperty(nodeRef, ContentModel.PROP_USERNAME));
            final String domainUsername = tenantService.getBaseNameUser(username);
            String tenantDomain = tenantService.getUserDomain(username);
            String systemUser = tenantAdminService.getDomainUser(AuthenticationUtil.getSystemUserName(), tenantDomain);
            boolean disabled = !"".equals(tenantDomain) && !tenantAdminService.isEnabledTenant(tenantDomain);
            try {
                if (disabled) {
                    tenantAdminService.enableTenant(tenantDomain);
                }
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        HomeFolderProviderSynchronizerTest.this.deleteUser(adminGuestUserHomeFolders, nodeRef, username, domainUsername);
                        return null;
                    }
                }, (String)systemUser);
                var10_9 = null;
                if (!disabled) continue;
                tenantAdminService.disableTenant(tenantDomain);
            }
            catch (Throwable throwable) {
                var10_9 = null;
                if (disabled) {
                    tenantAdminService.disableTenant(tenantDomain);
                }
                throw throwable;
            }
        }
        return adminGuestUserHomeFolders;
    }

    private void deleteUser(Set<NodeRef> adminGuestUserHomeFolders, NodeRef person, String username, String domainUsername) {
        if (!domainUsername.equals("admin") && !domainUsername.equals("guest")) {
            personService.deletePerson(person);
            System.out.println("deleted user " + username);
        } else {
            NodeRef homeFolder = (NodeRef)DefaultTypeConverter.INSTANCE.convert(NodeRef.class, (Object)nodeService.getProperty(person, ContentModel.PROP_HOMEFOLDER));
            adminGuestUserHomeFolders.add(homeFolder);
        }
    }

    private void deleteNonAdminGuestFolders(Set<NodeRef> adminGuestUserHomeFolders) {
        for (ChildAssociationRef childAssocs : nodeService.getChildAssocs(rootNodeRef)) {
            NodeRef nodeRef = childAssocs.getChildRef();
            if (adminGuestUserHomeFolders.contains(nodeRef)) continue;
            System.out.println("TearDown remove '" + childAssocs.getQName().getLocalName() + "' from under the home folder root.");
            nodeService.deleteNode(nodeRef);
        }
    }

    private NodeRef createUser(String parentPath, String username) throws Exception {
        return this.createUser("", parentPath, username);
    }

    private NodeRef createUser(String parentPath, String username, String homeFolderProviderName, boolean createHomeDirectory) throws Exception {
        return this.createUser("", parentPath, username, homeFolderProviderName, createHomeDirectory);
    }

    private NodeRef createUser(String tenantDomain, String parentPath, String username) throws Exception {
        return this.createUser(tenantDomain, parentPath, username, largeHomeFolderProviderName, true);
    }

    private NodeRef createUser(String tenantDomain, final String parentPath, final String username, final String homeFolderProviderName, final boolean createHomeDirectory) throws Exception {
        final String domainUsername = tenantService.getDomainUser(username, tenantDomain);
        String systemUser = tenantAdminService.getDomainUser(AuthenticationUtil.getSystemUserName(), tenantDomain);
        return (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                String firstName = username;
                String lastName = "Smith";
                String emailAddress = String.format("%s.%s@xyz.com", firstName, lastName);
                PropertyMap properties = new PropertyMap();
                properties.put(ContentModel.PROP_USERNAME, domainUsername);
                properties.put(ContentModel.PROP_FIRSTNAME, firstName);
                properties.put(ContentModel.PROP_LASTNAME, lastName);
                properties.put(ContentModel.PROP_EMAIL, emailAddress);
                properties.put(ContentModel.PROP_HOME_FOLDER_PROVIDER, testHomeFolderProviderName);
                properties.put(PROP_PARENT_PATH, parentPath);
                personService.setHomeFolderCreationEager(createHomeDirectory);
                NodeRef person = personService.createPerson(properties);
                Assert.assertNotNull((String)("The person nodeRef for " + domainUsername + " should have been created"), (Object)person);
                NodeRef homeFolder = (NodeRef)DefaultTypeConverter.INSTANCE.convert(NodeRef.class, (Object)nodeService.getProperty(person, ContentModel.PROP_HOMEFOLDER));
                if (createHomeDirectory) {
                    Assert.assertNotNull((String)("The homeFolder for " + domainUsername + " should have been created"), (Object)homeFolder);
                } else {
                    Assert.assertNull((String)("The homeFolder for " + domainUsername + " should NOT have been created"), (Object)homeFolder);
                }
                if (!testHomeFolderProviderName.equals(homeFolderProviderName)) {
                    if (homeFolderProviderName == null) {
                        nodeService.removeProperty(person, ContentModel.PROP_HOME_FOLDER_PROVIDER);
                    } else {
                        nodeService.setProperty(person, ContentModel.PROP_HOME_FOLDER_PROVIDER, (Serializable)((Object)homeFolderProviderName));
                    }
                }
                return person;
            }
        }, (String)systemUser);
    }

    private NodeRef createFolder(String path) throws Exception {
        NodeRef parent = rootNodeRef;
        if (path.length() > 0) {
            StringBuilder currentPath = new StringBuilder();
            for (String pathElement : path.split("/")) {
                if (currentPath.length() > 0) {
                    currentPath.append("/");
                }
                currentPath.append(pathElement);
                NodeRef nodeRef = nodeService.getChildByName(parent, ContentModel.ASSOC_CONTAINS, pathElement);
                if (nodeRef == null) {
                    parent = fileFolderService.create(parent, pathElement, ContentModel.TYPE_FOLDER).getNodeRef();
                    continue;
                }
                Assert.assertTrue((String)("Expected " + currentPath + " to be a folder"), (boolean)fileFolderService.getFileInfo(nodeRef).isFolder());
                parent = nodeRef;
            }
        }
        return parent;
    }

    private NodeRef createContent(String parentPath, String name) throws Exception {
        NodeRef parent = this.createFolder(parentPath);
        PropertyMap propertyMap = new PropertyMap();
        propertyMap.put(ContentModel.PROP_CONTENT, new ContentData(null, "text/plain", 0L, "UTF-16", Locale.ENGLISH));
        propertyMap.put(ContentModel.PROP_NAME, name);
        NodeRef content = nodeService.createNode(parent, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)name), ContentModel.TYPE_CONTENT, (Map)propertyMap).getChildRef();
        ContentWriter writer = contentService.getWriter(content, ContentModel.TYPE_CONTENT, true);
        writer.putContent("The cat sat on the mat.");
        return content;
    }

    private String toPath(NodeRef root, NodeRef homeFolder) {
        int i;
        int homeFolderSize;
        if (root == null || homeFolder == null) {
            return null;
        }
        Path rootPath = nodeService.getPath(root);
        Path homeFolderPath = nodeService.getPath(homeFolder);
        int rootSize = rootPath.size();
        if (rootSize >= (homeFolderSize = homeFolderPath.size())) {
            return null;
        }
        StringBuilder sb = new StringBuilder("");
        for (i = 0; i < rootSize; ++i) {
            if (rootPath.get(i).equals(homeFolderPath.get(i))) continue;
            return null;
        }
        for (i = rootSize; i < homeFolderSize; ++i) {
            Path.Element element = homeFolderPath.get(i);
            if (!(element instanceof Path.ChildAssocElement)) {
                return null;
            }
            QName folderQName = ((Path.ChildAssocElement)element).getRef().getQName();
            if (sb.length() > 0) {
                sb.append('/');
            }
            sb.append(folderQName.getLocalName());
        }
        return sb.toString();
    }

    private void createTenant(final String tenantDomain) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                if (!tenantAdminService.existsTenant(tenantDomain)) {
                    tenantAdminService.createTenant(tenantDomain, ("admin " + tenantDomain).toCharArray(), null);
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private void deleteAllTenants() throws Exception {
        List<Tenant> tenants = tenantAdminService.getAllTenants();
        for (Tenant tenant : tenants) {
            this.deleteTenant(tenant.getTenantDomain());
        }
    }

    private void deleteTenant(final String tenantDomain) throws Exception {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                if (tenantAdminService.existsTenant(tenantDomain) && tenantAdminService.isEnabledTenant(tenantDomain)) {
                    tenantAdminService.disableTenant(tenantDomain);
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private void assertHomeFolderLocation(String username, String expectedPath) throws Exception {
        this.assertHomeFolderLocation("", username, expectedPath);
    }

    private void assertHomeFolderLocation(String tenantDomain, String username, final String expectedPath) throws Exception {
        try {
            final String domainUsername = tenantService.getDomainUser(username, tenantDomain);
            String systemUser = tenantAdminService.getDomainUser(AuthenticationUtil.getSystemUserName(), tenantDomain);
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                public NodeRef doWork() throws Exception {
                    NodeRef person = personService.getPerson(domainUsername, false);
                    NodeRef homeFolder = (NodeRef)DefaultTypeConverter.INSTANCE.convert(NodeRef.class, (Object)nodeService.getProperty(person, ContentModel.PROP_HOMEFOLDER));
                    Assert.assertNotNull((String)("User: " + domainUsername + " home folder should exist"), (Object)homeFolder);
                    NodeRef rootPath = homeFolderManager.getRootPathNodeRef(largeHomeFolderProvider);
                    String actualPath = HomeFolderProviderSynchronizerTest.this.toPath(rootPath, homeFolder);
                    Assert.assertEquals((String)("User: " + domainUsername + " home folder location"), (Object)expectedPath, (Object)actualPath);
                    return null;
                }
            }, (String)systemUser);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ComparisonFailure || cause instanceof AssertionError) {
                throw (ComparisonFailure)cause;
            }
            throw e;
        }
    }

    private boolean exists(String path) throws Exception {
        NodeRef parent = rootNodeRef;
        boolean exists = true;
        for (String pathElement : path.split("/")) {
            NodeRef nodeRef = nodeService.getChildByName(parent, ContentModel.ASSOC_CONTAINS, pathElement);
            if (nodeRef == null) {
                exists = false;
                break;
            }
            parent = nodeRef;
        }
        return exists;
    }

    private void moveUserHomeFolders() throws Exception {
        this.trans.commit();
        this.trans = null;
        homeFolderProviderSynchronizer.onBootstrap(null);
        this.trans = transactionService.getUserTransaction();
        this.trans.begin();
    }

    @Test
    public void testCorrectLocation() throws Exception {
        this.createUser("te", "tess");
        this.moveUserHomeFolders();
        this.assertHomeFolderLocation("tess", "te/tess");
    }

    @Test
    public void testCreateParentFolder() throws Exception {
        this.createUser("", "fred");
        this.moveUserHomeFolders();
        this.assertHomeFolderLocation("fred", "fr/fred");
    }

    @Test
    public void testNotEnabled() throws Exception {
        this.createUser("", "fred");
        homeFolderProviderSynchronizer.setEnabled("false");
        this.moveUserHomeFolders();
        personService.getPerson("fred");
        this.assertHomeFolderLocation("fred", "fred");
    }

    @Test
    public void testHomeFolderNotYetCreated() throws Exception {
        NodeRef person = this.createUser("", "fred", largeHomeFolderProviderName, false);
        this.moveUserHomeFolders();
        NodeRef homeFolder = (NodeRef)DefaultTypeConverter.INSTANCE.convert(NodeRef.class, (Object)nodeService.getProperty(person, ContentModel.PROP_HOMEFOLDER));
        Assert.assertNull((String)"The homeFolder should NOT have been created", (Object)homeFolder);
        person = personService.getPerson("fred");
        homeFolder = (NodeRef)DefaultTypeConverter.INSTANCE.convert(NodeRef.class, (Object)nodeService.getProperty(person, ContentModel.PROP_HOMEFOLDER));
        Assert.assertNotNull((String)"The homeFolder should have been created", (Object)homeFolder);
    }

    @Test
    public void testCreateMultipleParentFolders() throws Exception {
        largeHomeFolderProvider.setPattern("^(.?)(.?)(.?)(.?)(.?)");
        this.createUser("", "fred");
        this.createUser("", "peter");
        this.createUser("", "tess");
        this.moveUserHomeFolders();
        this.assertHomeFolderLocation("fred", "f/r/e/d/fred");
        this.assertHomeFolderLocation("peter", "p/e/t/e/r/peter");
        this.assertHomeFolderLocation("tess", "t/e/s/s/tess");
    }

    @Test
    public void testMoveToRoot() throws Exception {
        largeHomeFolderProvider.setPattern("");
        this.createUser("fr", "fred");
        this.moveUserHomeFolders();
        this.assertHomeFolderLocation("fred", "fred");
    }

    @Test
    public void testRemoveEmptyParents() throws Exception {
        this.createUser("a/bb/ccc", "peter");
        this.moveUserHomeFolders();
        this.assertHomeFolderLocation("peter", "pe/peter");
        Assert.assertFalse((String)"Expected the empty parent 'a' to have been removed.", (boolean)this.exists("a"));
    }

    @Test
    public void testKeepEmptyParents() throws Exception {
        this.createUser("a/bb/ccc", "peter");
        homeFolderProviderSynchronizer.setKeepEmptyParents("true");
        this.moveUserHomeFolders();
        this.assertHomeFolderLocation("peter", "pe/peter");
        Assert.assertTrue((String)"Expected the empty parent 'a/bb/ccc' to still exist as global property was set.", (boolean)this.exists("a/bb/ccc"));
    }

    @Test
    public void testKeepNonEmptyParents() throws Exception {
        this.createUser("a/bb/ccc", "peter");
        this.createFolder("a/bb/ddd");
        this.moveUserHomeFolders();
        this.assertHomeFolderLocation("peter", "pe/peter");
        Assert.assertFalse((String)"Expected the empty parent 'a/bb/ccc' to have been removed.", (boolean)this.exists("a/bb/ccc"));
        Assert.assertTrue((String)"Expected the non empty parent 'a/bb' to have been kept.", (boolean)this.exists("a/bb/ddd"));
    }

    @Test
    public void testPathAlreadyInUseByFolder() throws Exception {
        this.createUser("", "fred");
        this.createFolder("fr");
        this.moveUserHomeFolders();
        this.assertHomeFolderLocation("fred", "fr/fred");
    }

    @Test
    public void testPathAlreadyInUseByContent() throws Exception {
        this.createUser("", "fred");
        this.createContent("", "fr");
        this.moveUserHomeFolders();
        this.assertHomeFolderLocation("fred", "fred");
        Assert.assertFalse((String)"Did not expect there to be a folder in the prefered location.", (boolean)this.exists("fr/fred"));
        Assert.assertTrue((String)"Expected the content to still exist.", (boolean)this.exists("fr"));
    }

    @Test
    public void testPathInUseByUser() throws Exception {
        this.createUser("", "fr");
        this.createUser("", "fred");
        this.createUser("", "peter");
        this.createUser("", "pe");
        this.moveUserHomeFolders();
        this.assertHomeFolderLocation("fr", "fr/fr");
        this.assertHomeFolderLocation("fred", "fr/fred");
        this.assertHomeFolderLocation("peter", "pe/peter");
        this.assertHomeFolderLocation("pe", "pe/pe");
        Assert.assertFalse((String)"The Temporary1 folder should have been removed", (boolean)this.exists("Temporary1"));
    }

    @Test
    public void testUseFirstAvailableTemporaryFolder() throws Exception {
        this.createUser("", "fr");
        this.createUser("", "fred");
        this.createFolder("Temporary1");
        this.createFolder("Temporary2");
        this.createFolder("Temporary3");
        homeFolderProviderSynchronizer.setKeepEmptyParents("true");
        this.moveUserHomeFolders();
        Assert.assertTrue((String)"The existing Temporary1 folder should still exist", (boolean)this.exists("Temporary1"));
        Assert.assertTrue((String)"The existing Temporary2 folder should still exist", (boolean)this.exists("Temporary2"));
        Assert.assertTrue((String)"The existing Temporary3 folder should still exist", (boolean)this.exists("Temporary3"));
        Assert.assertTrue((String)"The existing Temporary4 folder should still exist", (boolean)this.exists("Temporary4"));
    }

    @Test
    public void testException() throws Exception {
        this.createUser("", "fr");
        this.createUser("", "fred");
        for (int i = 1; i <= 100; ++i) {
            this.createFolder("Temporary" + i);
        }
        this.moveUserHomeFolders();
        this.assertHomeFolderLocation("fred", "fred");
    }

    @Test
    public void testMultipleRoots() throws Exception {
        this.createFolder("root");
        String rootPath = origRootPath + "/cm:root";
        testHomeFolderProvider.setRootPath(rootPath);
        this.createUser("a/b/c", "tess", testHomeFolderProviderName, true);
        this.createUser("a/b/c", "fred", largeHomeFolderProviderName, true);
        this.moveUserHomeFolders();
        this.assertHomeFolderLocation("fred", "fr/fred");
        this.assertHomeFolderLocation("tess", "root/a/b/c/tess");
    }

    @Test
    public void testPathNotUnderRoot() throws Exception {
        this.createUser("a/b/c", "fred");
        this.createFolder("root");
        String rootPath = origRootPath + "/cm:root";
        largeHomeFolderProvider.setRootPath(rootPath);
        this.assertHomeFolderLocation("fred", null);
        this.moveUserHomeFolders();
        this.assertHomeFolderLocation("fred", "fr/fred");
    }

    @Test
    public void testMultipleUsers() throws Exception {
        String name;
        int i;
        int userCount = 110;
        for (i = 1; i <= userCount; ++i) {
            name = "f" + i + "red";
            this.createUser("", name);
        }
        this.moveUserHomeFolders();
        for (i = 1; i <= userCount; ++i) {
            name = "f" + i + "red";
            this.assertHomeFolderLocation(name, name.substring(0, 2) + '/' + name);
        }
    }

    @Test
    public void testOverrideProvider() throws Exception {
        NodeRef person = this.createUser("a/b/c", "fred");
        this.moveUserHomeFolders();
        this.assertHomeFolderLocation("fred", "fr/fred");
        homeFolderProviderSynchronizer.setOverrideHomeFolderProviderName(testHomeFolderProviderName);
        this.moveUserHomeFolders();
        this.assertHomeFolderLocation("fred", "a/b/c/fred");
        String providerName = (String)((Object)nodeService.getProperty(person, ContentModel.PROP_HOME_FOLDER_PROVIDER));
        Assert.assertEquals((Object)testHomeFolderProviderName, (Object)providerName);
    }

    @Test
    public void testNoOriginalProvider() throws Exception {
        this.createUser("a/b/c", "fred", null, true);
        homeFolderProviderSynchronizer.setOverrideHomeFolderProviderName(largeHomeFolderProviderName);
        this.moveUserHomeFolders();
        this.assertHomeFolderLocation("fred", "fr/fred");
        Assert.assertTrue((String)"Expected the empty parent 'a/b/c' to still exist as original root was unknown, because the original home folder provider was not set.", (boolean)this.exists("a/b/c"));
    }

    @Test
    public void testVersion1HomeFolderProvider() throws Exception {
        String name = "v1Provider";
        HomeFolderProvider v1Provider = new HomeFolderProvider(){

            public void onCreateNode(ChildAssociationRef childAssocRef) {
            }

            public String getName() {
                return "v1Provider";
            }
        };
        homeFolderManager.addProvider(v1Provider);
        this.createUser("a/b/c", "fred");
        homeFolderProviderSynchronizer.setOverrideHomeFolderProviderName("v1Provider");
        this.moveUserHomeFolders();
        this.assertHomeFolderLocation("fred", "a/b/c/fred");
    }

    @Test
    public void testExtendsAbstractHomeFolderProvider() throws Exception {
        String name = "v1Provider";
        UIDBasedHomeFolderProvider v1Provider = new UIDBasedHomeFolderProvider();
        v1Provider.setBeanName("v1Provider");
        v1Provider.setHomeFolderManager(homeFolderManager);
        v1Provider.setOnCreatePermissionsManager(largeHomeFolderProvider.getOnCreatePermissionsManager());
        v1Provider.setOnReferencePermissionsManager(largeHomeFolderProvider.getOnReferencePermissionsManager());
        v1Provider.setOwnerOnCreate(largeHomeFolderProvider.getOwner());
        v1Provider.setPath(largeHomeFolderProvider.getRootPath());
        v1Provider.setServiceRegistry(serviceRegistry);
        v1Provider.setStoreUrl(largeHomeFolderProvider.getStoreUrl());
        v1Provider.setTenantService(tenantService);
        v1Provider.afterPropertiesSet();
        this.createUser("a/b/c", "fred");
        homeFolderProviderSynchronizer.setOverrideHomeFolderProviderName("v1Provider");
        this.moveUserHomeFolders();
        this.assertHomeFolderLocation("fred", "fred");
    }

    @Test
    public void testTenantService() throws Exception {
        if (tenantAdminService.isEnabled()) {
            long time = System.currentTimeMillis();
            String tenant1 = time + ".tenant1";
            String tenant2 = time + ".tenant2";
            this.createTenant(tenant1);
            this.createTenant(tenant2);
            this.createUser("", "fred");
            this.createUser(tenant1, "", "fred");
            this.createUser(tenant2, "", "fred");
            this.moveUserHomeFolders();
            this.assertHomeFolderLocation("fred", "fr/fred");
            this.assertHomeFolderLocation(tenant1, "fred", "fr/" + tenantService.getDomainUser("fred", tenant1));
            this.assertHomeFolderLocation(tenant2, "fred", "fr/" + tenantService.getDomainUser("fred", tenant2));
        }
    }

    static {
        firstTest = true;
    }
}

