/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.person;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.person.AbstractHomeFolderProvider;
import org.alfresco.repo.security.person.HomeFolderManager;
import org.alfresco.repo.security.person.HomeFolderProvider;
import org.alfresco.repo.security.person.HomeFolderProvider2;
import org.alfresco.repo.security.person.HomeSpaceNodeRef;
import org.alfresco.repo.security.person.PermissionsManager;
import org.alfresco.repo.security.person.PersonException;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileFolderUtil;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortableHomeFolderManager
implements HomeFolderManager {
    private NodeService nodeService;
    private FileFolderService fileFolderService;
    private NamespaceService namespaceService;
    private SearchService searchService;
    private TenantService tenantService;
    private HomeFolderProvider2 defaultProvider;
    private Map<String, HomeFolderProvider> v1Providers = new HashMap<String, HomeFolderProvider>();
    private Map<String, HomeFolderProvider2> v2Providers = new HashMap<String, HomeFolderProvider2>();
    private Map<String, Map<String, NodeRef>> rootPathNodeRefMaps = new ConcurrentHashMap<String, Map<String, NodeRef>>();

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void addProvider(HomeFolderProvider provider) {
        this.v1Providers.put(provider.getName(), provider);
    }

    public void addProvider(HomeFolderProvider2 provider) {
        this.v2Providers.put(provider.getName(), provider);
    }

    public HomeFolderProvider getHomeFolderProvider1(String providerName) {
        return this.v1Providers.get(providerName);
    }

    public HomeFolderProvider2 getHomeFolderProvider2(String providerName) {
        return this.v2Providers.get(providerName);
    }

    public void setDefaultProvider(HomeFolderProvider2 defaultProvider) {
        this.defaultProvider = defaultProvider;
    }

    @Override
    public void makeHomeFolder(ChildAssociationRef childAssocRef) {
        HomeFolderProvider2 v2Provider = this.defaultProvider;
        HomeFolderProvider v1Provider = null;
        String providerName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(childAssocRef.getChildRef(), ContentModel.PROP_HOME_FOLDER_PROVIDER));
        if (providerName != null) {
            v2Provider = this.getHomeFolderProvider2(providerName);
            if (v2Provider == null && (v1Provider = this.getHomeFolderProvider1(providerName)) == null) {
                v2Provider = this.defaultProvider;
            }
        } else {
            providerName = this.defaultProvider.getName();
            this.nodeService.setProperty(childAssocRef.getChildRef(), ContentModel.PROP_HOME_FOLDER_PROVIDER, (Serializable)((Object)providerName));
        }
        if (v2Provider != null) {
            if (v2Provider instanceof AbstractHomeFolderProvider.V2Adaptor) {
                ((AbstractHomeFolderProvider.V2Adaptor)v2Provider).onCreateNode(childAssocRef);
            } else {
                this.homeFolderCreateAndSetPermissions(v2Provider, childAssocRef.getChildRef());
            }
        } else if (v1Provider != null) {
            v1Provider.onCreateNode(childAssocRef);
        }
    }

    void homeFolderCreateAndSetPermissions(HomeFolderProvider2 provider, NodeRef personNodeRef) {
        HomeSpaceNodeRef homeFolder = provider.getHomeFolder(personNodeRef);
        if (homeFolder.getNodeRef() != null) {
            String providerSuppliedOwner;
            String owner;
            String uid = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(personNodeRef, ContentModel.PROP_USERNAME));
            if (homeFolder.getStatus() != HomeSpaceNodeRef.Status.VALID) {
                this.nodeService.setProperty(personNodeRef, ContentModel.PROP_HOMEFOLDER, (Serializable)homeFolder.getNodeRef());
            }
            String string = owner = (providerSuppliedOwner = provider.getOwner()) == null ? uid : providerSuppliedOwner;
            if (homeFolder.getStatus() == HomeSpaceNodeRef.Status.CREATED) {
                PermissionsManager onCreatePermissionsManager = provider.getOnCreatePermissionsManager();
                if (onCreatePermissionsManager != null) {
                    onCreatePermissionsManager.setPermissions(homeFolder.getNodeRef(), owner, uid);
                }
            } else {
                PermissionsManager onReferencePermissionsManager = provider.getOnReferencePermissionsManager();
                if (onReferencePermissionsManager != null) {
                    onReferencePermissionsManager.setPermissions(homeFolder.getNodeRef(), owner, uid);
                }
            }
        }
    }

    private StoreRef getStoreRef(HomeFolderProvider2 provider) {
        return new StoreRef(provider.getStoreUrl());
    }

    public String getPersonProperty(NodeRef person, QName name) {
        String value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(person, name));
        if (value == null || value.length() == 0) {
            throw new PersonException("Can not create a home folder when the " + name + " property is null or empty");
        }
        return value;
    }

    void clearCaches(HomeFolderProvider2 provider) {
        this.getRootPathNodeRefMap(provider).clear();
    }

    NodeRef getRootPathNodeRef(HomeFolderProvider2 provider) {
        String rootPath = provider.getRootPath();
        String tenantDomain = this.tenantService != null ? this.tenantService.getCurrentUserDomain() : "";
        Map<String, NodeRef> rootPathNodeRefMap = this.getRootPathNodeRefMap(provider);
        NodeRef rootPathNodeRef = rootPathNodeRefMap.get(tenantDomain);
        if (rootPathNodeRef == null) {
            rootPathNodeRef = this.resolvePath(provider, rootPath);
            rootPathNodeRefMap.put(tenantDomain, rootPathNodeRef);
        }
        return rootPathNodeRef;
    }

    private Map<String, NodeRef> getRootPathNodeRefMap(HomeFolderProvider2 provider) {
        String name = provider.getName();
        Map<String, NodeRef> rootPathNodeRefMap = this.rootPathNodeRefMaps.get(name);
        if (rootPathNodeRefMap == null) {
            rootPathNodeRefMap = new ConcurrentHashMap<String, NodeRef>();
            this.rootPathNodeRefMaps.put(name, rootPathNodeRefMap);
        }
        return rootPathNodeRefMap;
    }

    NodeRef resolvePath(HomeFolderProvider2 provider, String pathToResolve) {
        List refs = this.searchService.selectNodes(this.nodeService.getRootNode(this.getStoreRef(provider)), pathToResolve, null, (NamespacePrefixResolver)this.namespaceService, false);
        if (refs.size() != 1) {
            throw new IllegalStateException("Non-unique path: found : " + pathToResolve + " " + refs.size());
        }
        return (NodeRef)refs.get(0);
    }

    public HomeSpaceNodeRef getHomeFolder(HomeFolderProvider2 provider, NodeRef person, boolean referenceRootNode) {
        HomeSpaceNodeRef homeSpaceNodeRef = null;
        NodeRef existingHomeFolder = (NodeRef)DefaultTypeConverter.INSTANCE.convert(NodeRef.class, (Object)this.nodeService.getProperty(person, ContentModel.PROP_HOMEFOLDER));
        if (existingHomeFolder != null) {
            homeSpaceNodeRef = new HomeSpaceNodeRef(existingHomeFolder, HomeSpaceNodeRef.Status.VALID);
        } else if (referenceRootNode) {
            homeSpaceNodeRef = new HomeSpaceNodeRef(this.getRootPathNodeRef(provider), HomeSpaceNodeRef.Status.REFERENCED);
        } else {
            List<String> homeFolderPath = provider.getHomeFolderPath(person);
            NodeRef existing = this.getExisting(provider, this.fileFolderService, homeFolderPath);
            FileInfo fileInfo = existing != null ? this.fileFolderService.getFileInfo(existing) : this.createTree(provider, this.getRootPathNodeRef(provider), homeFolderPath, provider.getTemplateNodeRef(), this.fileFolderService);
            NodeRef homeFolderNodeRef = fileInfo.getNodeRef();
            return new HomeSpaceNodeRef(homeFolderNodeRef, HomeSpaceNodeRef.Status.CREATED);
        }
        return homeSpaceNodeRef;
    }

    private NodeRef getExisting(HomeFolderProvider2 provider, FileFolderService fileFolderService, List<String> homeFolderPath) {
        NodeRef existing;
        try {
            FileInfo existingFileInfo = fileFolderService.resolveNamePath(this.getRootPathNodeRef(provider), homeFolderPath);
            existing = existingFileInfo.getNodeRef();
        }
        catch (FileNotFoundException fnfe) {
            existing = null;
        }
        return existing;
    }

    private FileInfo createTree(HomeFolderProvider2 provider, NodeRef root, List<String> homeFolderPath, NodeRef templateNodeRef, FileFolderService fileFolderService) {
        FileInfo fileInfo;
        NodeRef newParent = this.createNewParentIfRequired(root, homeFolderPath, fileFolderService);
        String homeFolderName = homeFolderPath.get(homeFolderPath.size() - 1);
        if (templateNodeRef == null) {
            fileInfo = fileFolderService.create(newParent, homeFolderName, ContentModel.TYPE_FOLDER);
        } else {
            try {
                fileInfo = fileFolderService.copy(templateNodeRef, newParent, homeFolderName);
            }
            catch (FileNotFoundException e) {
                throw new PersonException("Invalid template to create home space");
            }
        }
        return fileInfo;
    }

    private NodeRef createNewParentIfRequired(NodeRef root, List<String> homeFolderPath, FileFolderService fileFolderService) {
        if (homeFolderPath.size() > 1) {
            ArrayList<String> parentPath = new ArrayList<String>(homeFolderPath);
            parentPath.remove(parentPath.size() - 1);
            return FileFolderUtil.makeFolders(fileFolderService, root, parentPath, ContentModel.TYPE_FOLDER).getNodeRef();
        }
        return root;
    }
}

