/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.site;

import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.repo.site.SiteServiceException;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;

public class SiteAspect
implements NodeServicePolicies.OnMoveNodePolicy {
    private DictionaryService dictionaryService;
    private PolicyComponent policyComponent;
    private NodeService nodeService;

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnMoveNodePolicy.QNAME, SiteModel.TYPE_SITE, (Behaviour)new JavaBehaviour(this, "onMoveNode", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnMoveNodePolicy.QNAME, SiteModel.ASPECT_SITE_CONTAINER, (Behaviour)new JavaBehaviour(this, "onMoveNode", Behaviour.NotificationFrequency.EVERY_EVENT));
    }

    public void onMoveNode(ChildAssociationRef oldChildAssocRef, ChildAssociationRef newChildAssocRef) {
        NodeRef newParent;
        NodeRef oldParent = oldChildAssocRef.getParentRef();
        if (oldParent.equals((Object)(newParent = newChildAssocRef.getParentRef()))) {
            QName type = this.nodeService.getType(oldChildAssocRef.getChildRef());
            if (this.dictionaryService.isSubClass(type, SiteModel.TYPE_SITE)) {
                throw new SiteServiceException("Sites can not be renamed.");
            }
            throw new SiteServiceException("Site containers can not be renamed.");
        }
    }
}

