/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.site;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteInfoImpl
implements SiteInfo {
    private NodeRef nodeRef;
    private String sitePreset;
    private String shortName;
    private String title;
    private String description;
    private SiteVisibility visibility;
    private Map<QName, Serializable> customProperties = new HashMap<QName, Serializable>(1);

    SiteInfoImpl(String sitePreset, String shortName, String title, String description, SiteVisibility visibility, Map<QName, Serializable> customProperties, NodeRef nodeRef) {
        this(sitePreset, shortName, title, description, visibility, customProperties);
        this.nodeRef = nodeRef;
    }

    SiteInfoImpl(String sitePreset, String shortName, String title, String description, SiteVisibility visibility, Map<QName, Serializable> customProperties) {
        this.sitePreset = sitePreset;
        this.shortName = shortName;
        this.title = title;
        this.description = description;
        this.visibility = visibility;
        if (customProperties != null) {
            this.customProperties = customProperties;
        }
    }

    @Override
    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    @Override
    public String getSitePreset() {
        return this.sitePreset;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getTitle() {
        return this.title != null ? this.title : "";
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setIsPublic(boolean isPublic) {
        if (isPublic) {
            this.setVisibility(SiteVisibility.PUBLIC);
        } else {
            this.setVisibility(SiteVisibility.PRIVATE);
        }
    }

    @Override
    public boolean getIsPublic() {
        boolean result = false;
        if (SiteVisibility.PUBLIC.equals((Object)this.visibility)) {
            result = true;
        }
        return result;
    }

    @Override
    public SiteVisibility getVisibility() {
        return this.visibility;
    }

    @Override
    public void setVisibility(SiteVisibility visibility) {
        this.visibility = visibility;
    }

    @Override
    public Map<QName, Serializable> getCustomProperties() {
        return this.customProperties;
    }

    @Override
    public Serializable getCustomProperty(QName name) {
        Serializable result = null;
        if (this.customProperties != null) {
            result = this.customProperties.get(name);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SiteInfoImpl) {
            SiteInfoImpl that = (SiteInfoImpl)obj;
            return this.shortName.equals(that.shortName);
        }
        return false;
    }

    public int hashCode() {
        return this.shortName.hashCode();
    }

    public String toString() {
        return this.visibility.name() + " Site " + this.shortName + " (" + this.title + ")" + " @ " + this.nodeRef.toString();
    }
}

