/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.site;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ForumModel;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.repo.admin.SysAdminParamsImpl;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Property;
import org.alfresco.repo.dictionary.M2Type;
import org.alfresco.repo.jscript.ClasspathScriptLocation;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authority.UnknownAuthorityException;
import org.alfresco.repo.site.SiteInfoImpl;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.repo.site.SiteServiceException;
import org.alfresco.repo.site.SiteServiceImpl;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.ScriptService;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.mockito.Mockito;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteServiceImplTest
extends BaseAlfrescoSpringTest {
    private static final String TEST_SITE_PRESET = "testSitePreset";
    private static final String TEST_SITE_PRESET_2 = "testSitePreset2";
    private static final String TEST_TITLE = "TitleTest This is my title";
    private static final String TEST_DESCRIPTION = "DescriptionTest This is my description";
    private static final String USER_ONE = "UserOne_SiteServiceImplTest";
    private static final String USER_TWO = "UserTwo_SiteServiceImplTest";
    private static final String USER_THREE = "UserThree_SiteServiceImplTest";
    private static final String USER_FOUR = "UserFour_SiteServiceImplTest";
    private static final String GROUP_ONE = "GrpOne_SiteServiceImplTest";
    private static final String GROUP_TWO = "GrpTwo_SiteServiceImplTest";
    private static final String GROUP_THREE = "GrpThree_SiteServiceImplTest";
    private static final String GROUP_FOUR = "GrpFour_SiteServiceImplTest";
    private static final String GROUP_ONE_DISPLAY = "DisplayOfGrpOne-SiteServiceImplTest";
    private static final String GROUP_TWO_DISPLAY = "DisplayOfGrpTwo-SiteServiceImplTest";
    private CopyService copyService;
    private ScriptService scriptService;
    private NodeService nodeService;
    private NamespaceService namespaceService;
    private DictionaryService dictionaryService;
    private AuthenticationComponent authenticationComponent;
    private TaggingService taggingService;
    private PersonService personService;
    private AuthorityService authorityService;
    private FileFolderService fileFolderService;
    private NodeArchiveService nodeArchiveService;
    private PermissionService permissionService;
    private SiteService siteService;
    private SiteServiceImpl siteServiceImpl;
    private SysAdminParams sysAdminParams;
    private String groupOne;
    private String groupTwo;
    private String groupThree;
    private String groupFour;

    @Override
    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        this.copyService = (CopyService)this.applicationContext.getBean("CopyService");
        this.scriptService = (ScriptService)this.applicationContext.getBean("ScriptService");
        this.nodeService = (NodeService)this.applicationContext.getBean("NodeService");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.taggingService = (TaggingService)this.applicationContext.getBean("TaggingService");
        this.personService = (PersonService)this.applicationContext.getBean("PersonService");
        this.authorityService = (AuthorityService)this.applicationContext.getBean("AuthorityService");
        this.fileFolderService = (FileFolderService)this.applicationContext.getBean("FileFolderService");
        this.nodeArchiveService = (NodeArchiveService)this.applicationContext.getBean("nodeArchiveService");
        this.permissionService = (PermissionService)this.applicationContext.getBean("PermissionService");
        this.dictionaryService = (DictionaryService)this.applicationContext.getBean("DictionaryService");
        this.namespaceService = (NamespaceService)this.applicationContext.getBean("namespaceService");
        this.siteService = (SiteService)this.applicationContext.getBean("SiteService");
        this.siteServiceImpl = (SiteServiceImpl)this.applicationContext.getBean("siteService");
        this.sysAdminParams = (SysAdminParams)this.applicationContext.getBean("sysAdminParams");
        this.createUser(USER_ONE, "UserOne");
        this.createUser(USER_TWO, "UserTwo");
        this.createUser(USER_THREE, "UsRthree");
        this.createUser(USER_FOUR, "UsRFoUr");
        this.groupOne = this.authorityService.createAuthority(AuthorityType.GROUP, GROUP_ONE, GROUP_ONE_DISPLAY, null);
        this.authorityService.addAuthority(this.groupOne, USER_TWO);
        this.groupTwo = this.authorityService.createAuthority(AuthorityType.GROUP, GROUP_TWO, GROUP_TWO_DISPLAY, null);
        this.authorityService.addAuthority(this.groupTwo, USER_TWO);
        this.authorityService.addAuthority(this.groupTwo, USER_THREE);
        this.groupThree = this.authorityService.createAuthority(AuthorityType.GROUP, GROUP_THREE);
        this.authorityService.addAuthority(this.groupThree, USER_TWO);
        this.authorityService.addAuthority(this.groupThree, USER_THREE);
        this.groupFour = this.authorityService.createAuthority(AuthorityType.GROUP, GROUP_FOUR);
        this.authorityService.addAuthority(this.groupThree, this.groupFour);
        this.authorityService.addAuthority(this.groupFour, USER_FOUR);
        this.authenticationComponent.setCurrentUser(USER_ONE);
    }

    @Override
    protected void onTearDownInTransaction() throws Exception {
        super.onTearDownInTransaction();
        this.siteServiceImpl.setSysAdminParams(this.sysAdminParams);
    }

    private void createUser(String userName, String nameSuffix) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "PWD".toCharArray());
            PropertyMap ppOne = new PropertyMap(4);
            ppOne.put(ContentModel.PROP_USERNAME, userName);
            ppOne.put(ContentModel.PROP_FIRSTNAME, "firstName" + nameSuffix);
            ppOne.put(ContentModel.PROP_LASTNAME, "lastName" + nameSuffix);
            ppOne.put(ContentModel.PROP_EMAIL, "email" + nameSuffix + "@email.com");
            ppOne.put(ContentModel.PROP_JOBTITLE, "jobTitle");
            this.personService.createPerson(ppOne);
        }
    }

    public void testCreateSite() throws Exception {
        SiteInfo siteInfo = this.siteService.createSite(TEST_SITE_PRESET, "mySiteTest", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        this.checkSiteInfo(siteInfo, TEST_SITE_PRESET, "mySiteTest", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        String name = "!\u00c2\u00a3$%^&*()_+=-[]{}";
        siteInfo = this.siteService.createSite(TEST_SITE_PRESET, name, TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        this.checkSiteInfo(siteInfo, TEST_SITE_PRESET, name, TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        siteInfo = this.siteService.getSite(name);
        this.checkSiteInfo(siteInfo, TEST_SITE_PRESET, name, TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        name = "\u00c3\u00a9\u00c3\u00ad\u00c3\u00b3\u00c3\u00ba\u00c3\ufffd\u00c3\u2030\u00c3\ufffd\u00c3\u201c\u00c3\u0161";
        siteInfo = this.siteService.createSite(TEST_SITE_PRESET, name, TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        this.checkSiteInfo(siteInfo, TEST_SITE_PRESET, name, TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        siteInfo = this.siteService.getSite(name);
        this.checkSiteInfo(siteInfo, TEST_SITE_PRESET, name, TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        try {
            this.siteService.createSite(TEST_SITE_PRESET, "mySiteTest", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
            SiteServiceImplTest.fail((String)"Shouldn't allow duplicate site short names.");
        }
        catch (AlfrescoRuntimeException alfrescoRuntimeException) {
            // empty catch block
        }
    }

    public void testETHREEOH_2133() throws Exception {
        this.siteService.createSite(TEST_SITE_PRESET, "wibble", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PRIVATE);
        this.authenticationComponent.setCurrentUser(USER_THREE);
        try {
            this.siteService.createSite(TEST_SITE_PRESET, "wibble", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PRIVATE);
            SiteServiceImplTest.fail((String)"Shouldn't allow duplicate site short names.");
        }
        catch (AlfrescoRuntimeException alfrescoRuntimeException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConfigurableSitePublicGroup() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        ChildApplicationContextFactory sysAdminSubsystem = (ChildApplicationContextFactory)this.applicationContext.getBean("sysAdmin");
        String sitePublicGroupPropName = "site.public.group";
        String originalSitePublicGroup = "GROUP_EVERYONE";
        try {
            String groupName = sysAdminSubsystem.getProperty("site.public.group");
            SiteServiceImplTest.assertEquals((String)"site.public.group was not the pristine value", (String)"GROUP_EVERYONE", (String)groupName);
            SiteInfo unconfiguredSite = this.siteService.createSite(TEST_SITE_PRESET, "unconfigured", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
            SiteServiceImplTest.assertTrue((boolean)this.containsConsumerPermission("GROUP_EVERYONE", unconfiguredSite));
            String newGroupName = ((Object)((Object)this)).getClass().getSimpleName() + System.currentTimeMillis();
            String prefixedNewGroupName = "GROUP_" + newGroupName;
            sysAdminSubsystem.stop();
            sysAdminSubsystem.setProperty("site.public.group", prefixedNewGroupName);
            sysAdminSubsystem.start();
            boolean expectedExceptionThrown = false;
            try {
                this.siteService.createSite(TEST_SITE_PRESET, "thisShouldFail", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
            }
            catch (SiteServiceException expected) {
                expectedExceptionThrown = true;
            }
            if (!expectedExceptionThrown) {
                SiteServiceImplTest.fail((String)"Expected exception on createSite with non-existent group was not thrown.");
            }
            this.authorityService.createAuthority(AuthorityType.GROUP, newGroupName);
            SiteInfo configuredSite = this.siteService.createSite(TEST_SITE_PRESET, "configured", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
            SiteServiceImplTest.assertTrue((String)"The configured site should not have GROUP_EVERYONE as SiteContributor", (!this.containsConsumerPermission("GROUP_EVERYONE", configuredSite) ? 1 : 0) != 0);
            SiteServiceImplTest.assertTrue((String)"The configured site should have (newGroupName) as SiteContributor", (boolean)this.containsConsumerPermission(prefixedNewGroupName, configuredSite));
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            sysAdminSubsystem.stop();
            sysAdminSubsystem.setProperty("site.public.group", "GROUP_EVERYONE");
            sysAdminSubsystem.start();
            throw throwable;
        }
        sysAdminSubsystem.stop();
        sysAdminSubsystem.setProperty("site.public.group", "GROUP_EVERYONE");
        sysAdminSubsystem.start();
    }

    private boolean containsConsumerPermission(String groupName, SiteInfo unconfiguredSite) {
        boolean result = false;
        Set perms = this.permissionService.getAllSetPermissions(unconfiguredSite.getNodeRef());
        for (AccessPermission p : perms) {
            if (!p.getAuthority().equals(groupName) || !p.getPermission().equals("SiteConsumer")) continue;
            result = true;
        }
        return result;
    }

    public void testETHREEOH_15() throws Exception {
        SiteInfo siteInfo = this.siteService.createSite(TEST_SITE_PRESET, "mySiteTest", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        this.checkSiteInfo(siteInfo, TEST_SITE_PRESET, "mySiteTest", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        this.siteService.setMembership(siteInfo.getShortName(), USER_TWO, "SiteManager");
        this.authenticationComponent.setCurrentUser(USER_TWO);
        this.siteService.setMembership(siteInfo.getShortName(), USER_THREE, "SiteContributor");
        this.siteService.removeMembership(siteInfo.getShortName(), USER_THREE);
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        this.siteService.removeMembership(siteInfo.getShortName(), USER_TWO);
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.siteService.setMembership(siteInfo.getShortName(), USER_THREE, "SiteContributor");
        this.authenticationComponent.setCurrentUser(USER_THREE);
        try {
            this.siteService.setMembership(siteInfo.getShortName(), USER_TWO, "SiteContributor");
            SiteServiceImplTest.fail((String)"Shouldn't be able to do this cos you don't have permissions");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.siteService.removeMembership(siteInfo.getShortName(), USER_ONE);
            SiteServiceImplTest.fail((String)"Shouldn't be able to do this cos you don't have permissions");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.siteService.removeMembership(siteInfo.getShortName(), USER_THREE);
    }

    private void checkSiteInfo(SiteInfo siteInfo, String expectedSitePreset, String expectedShortName, String expectedTitle, String expectedDescription, SiteVisibility expectedVisibility) {
        SiteServiceImplTest.assertNotNull((Object)siteInfo);
        SiteServiceImplTest.assertEquals((String)expectedSitePreset, (String)siteInfo.getSitePreset());
        SiteServiceImplTest.assertEquals((String)expectedShortName, (String)siteInfo.getShortName());
        SiteServiceImplTest.assertEquals((String)expectedTitle, (String)siteInfo.getTitle());
        SiteServiceImplTest.assertEquals((String)expectedDescription, (String)siteInfo.getDescription());
        SiteServiceImplTest.assertEquals((Object)((Object)expectedVisibility), (Object)((Object)siteInfo.getVisibility()));
        SiteServiceImplTest.assertNotNull((Object)siteInfo.getNodeRef());
        SiteServiceImplTest.assertTrue((boolean)this.taggingService.isTagScope(siteInfo.getNodeRef()));
    }

    public void testListSites() throws Exception {
        String shortName;
        String testTitlePrefix = TEST_TITLE.substring(0, 9);
        List<SiteInfo> sites = this.siteService.listSites(null, null);
        SiteServiceImplTest.assertNotNull((String)"sites list was null.", sites);
        int preexistingSitesCount = sites.size();
        this.siteService.createSite(TEST_SITE_PRESET, "mySiteOne", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        this.siteService.createSite(TEST_SITE_PRESET, "mySiteTwo", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PRIVATE);
        this.siteService.createSite(TEST_SITE_PRESET_2, "mySiteThree", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        this.siteService.createSite(TEST_SITE_PRESET_2, "mySiteFour", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PRIVATE);
        this.siteService.createSite(TEST_SITE_PRESET_2, "mySiteFive", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.MODERATED);
        sites = this.siteService.listSites(null, null);
        SiteServiceImplTest.assertNotNull(sites);
        SiteServiceImplTest.assertEquals((int)(preexistingSitesCount + 5), (int)sites.size());
        List<SiteInfo> sitesFromFind = this.siteService.findSites(null, null, 100);
        SiteServiceImplTest.assertEquals((int)(preexistingSitesCount + 5), (int)sitesFromFind.size());
        sites = this.siteService.listSites("mySiteO", null);
        SiteServiceImplTest.assertNotNull(sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites named 'mySiteO*'", (int)1, (int)sites.size());
        sitesFromFind = this.siteService.findSites("One", null, 100);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites named 'One'", (int)1, (int)sitesFromFind.size());
        sites = this.siteService.listSites(testTitlePrefix, null);
        SiteServiceImplTest.assertNotNull(sites);
        SiteServiceImplTest.assertEquals((String)("Matched wrong number of sites starting with '" + testTitlePrefix + "'"), (int)5, (int)sites.size());
        sitesFromFind = this.siteService.findSites("title", null, 100);
        SiteServiceImplTest.assertEquals((String)("Matched wrong number of sites containing 'title'\n" + sitesFromFind), (int)5, (int)sitesFromFind.size());
        sites = this.siteService.listSites("description", null);
        SiteServiceImplTest.assertNotNull(sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites named 'description'", (int)5, (int)sites.size());
        sitesFromFind = this.siteService.findSites("description", null, 100);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites named 'description'", (int)5, (int)sitesFromFind.size());
        sites = this.siteService.listSites(null, TEST_SITE_PRESET);
        SiteServiceImplTest.assertNotNull(sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites with PRESET", (int)2, (int)sites.size());
        sites = this.siteService.listSites(null, TEST_SITE_PRESET_2);
        SiteServiceImplTest.assertNotNull(sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites with PRESET_2", (int)3, (int)sites.size());
        for (SiteInfo site : sites) {
            shortName = site.getShortName();
            if (shortName.equals("mySiteOne")) {
                this.checkSiteInfo(site, TEST_SITE_PRESET, "mySiteOne", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
                continue;
            }
            if (shortName.equals("mySiteTwo")) {
                this.checkSiteInfo(site, TEST_SITE_PRESET, "mySiteTwo", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PRIVATE);
                continue;
            }
            if (shortName.equals("mySiteThree")) {
                this.checkSiteInfo(site, TEST_SITE_PRESET_2, "mySiteThree", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
                continue;
            }
            if (shortName.equals("mySiteFour")) {
                this.checkSiteInfo(site, TEST_SITE_PRESET_2, "mySiteFour", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PRIVATE);
                continue;
            }
            if (shortName.equals("mySiteFive")) {
                this.checkSiteInfo(site, TEST_SITE_PRESET_2, "mySiteFive", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.MODERATED);
                continue;
            }
            SiteServiceImplTest.fail((String)("The shortname " + shortName + " is not recognised"));
        }
        sites = this.siteService.listSites(USER_TWO);
        SiteServiceImplTest.assertNotNull(sites);
        SiteServiceImplTest.assertEquals((int)0, (int)sites.size());
        this.siteService.setMembership("mySiteOne", USER_TWO, "SiteConsumer");
        this.siteService.setMembership("mySiteTwo", USER_TWO, "SiteConsumer");
        sites = this.siteService.listSites(USER_TWO);
        SiteServiceImplTest.assertNotNull(sites);
        SiteServiceImplTest.assertEquals((int)2, (int)sites.size());
        sites = this.siteService.listSites(USER_ONE);
        SiteServiceImplTest.assertNotNull(sites);
        SiteServiceImplTest.assertEquals((int)5, (int)sites.size());
        sites = this.siteService.listSites("mySiteOne", null, 10);
        SiteServiceImplTest.assertNotNull(sites);
        SiteServiceImplTest.assertEquals((int)1, (int)sites.size());
        sitesFromFind = this.siteService.findSites("One", null, 100);
        SiteServiceImplTest.assertEquals((int)1, (int)sitesFromFind.size());
        sitesFromFind = this.siteService.findSites("ite", null, 100);
        SiteServiceImplTest.assertEquals((int)5, (int)sitesFromFind.size());
        this.authenticationComponent.setCurrentUser(USER_TWO);
        sitesFromFind = this.siteService.findSites("ite", null, 100);
        SiteServiceImplTest.assertEquals((int)4, (int)sitesFromFind.size());
        for (SiteInfo site : sites) {
            shortName = site.getShortName();
            if (shortName.equals("mySiteOne")) {
                this.checkSiteInfo(site, TEST_SITE_PRESET, "mySiteOne", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
                continue;
            }
            if (shortName.equals("mySiteTwo")) {
                this.checkSiteInfo(site, TEST_SITE_PRESET, "mySiteTwo", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PRIVATE);
                continue;
            }
            if (shortName.equals("mySiteThree")) {
                this.checkSiteInfo(site, TEST_SITE_PRESET_2, "mySiteThree", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
                continue;
            }
            if (shortName.equals("mySiteFour")) {
                SiteServiceImplTest.fail((String)"Can see private site mySiteFour");
                continue;
            }
            if (shortName.equals("mySiteFive")) {
                this.checkSiteInfo(site, TEST_SITE_PRESET_2, "mySiteFive", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.MODERATED);
                continue;
            }
            SiteServiceImplTest.fail((String)("The shortname " + shortName + " is not recognised"));
        }
        this.authenticationComponent.setCurrentUser(USER_THREE);
        sitesFromFind = this.siteService.findSites("ite", null, 100);
        SiteServiceImplTest.assertEquals((int)3, (int)sitesFromFind.size());
        for (SiteInfo site : sites) {
            shortName = site.getShortName();
            if (shortName.equals("mySiteOne")) {
                this.checkSiteInfo(site, TEST_SITE_PRESET, "mySiteOne", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
                continue;
            }
            if (shortName.equals("mySiteTwo")) {
                SiteServiceImplTest.fail((String)"Can see private site mySiteTwo");
                continue;
            }
            if (shortName.equals("mySiteThree")) {
                this.checkSiteInfo(site, TEST_SITE_PRESET_2, "mySiteThree", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
                continue;
            }
            if (shortName.equals("mySiteFour")) {
                SiteServiceImplTest.fail((String)"Can see private site mySiteFour");
                continue;
            }
            if (shortName.equals("mySiteFive")) {
                this.checkSiteInfo(site, TEST_SITE_PRESET_2, "mySiteFive", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.MODERATED);
                continue;
            }
            SiteServiceImplTest.fail((String)("The shortname " + shortName + " is not recognised"));
        }
    }

    public void testfindSitesWithWildcardTitles() throws Exception {
        List<SiteInfo> preexistingSites = this.siteService.findSites(null, null, 0);
        int preexistingSitesCount = preexistingSites.size();
        this.siteService.createSite(TEST_SITE_PRESET, "siteAlpha", "asterix", TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        this.siteService.createSite(TEST_SITE_PRESET, "siteBeta", "asterix*obelix", TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        List<SiteInfo> sites = this.siteService.findSites("asterix", null, 0);
        SiteServiceImplTest.assertNotNull(sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites with title equal to 'asterix'", (int)2, (int)sites.size());
        sites = this.siteService.findSites("*", null, 0);
        SiteServiceImplTest.assertNotNull(sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites using '*'", (int)(preexistingSitesCount + 2), (int)sites.size());
        sites = this.siteService.findSites("as?erix", null, 0);
        SiteServiceImplTest.assertNotNull(sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites using '?'", (int)2, (int)sites.size());
    }

    public void testGetSite() {
        SiteInfo siteInfo = this.siteService.getSite("testGetSite");
        SiteServiceImplTest.assertNull((Object)siteInfo);
        this.siteService.createSite(TEST_SITE_PRESET, "testGetSite", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        siteInfo = this.siteService.getSite("testGetSite");
        SiteServiceImplTest.assertNotNull((Object)siteInfo);
        this.checkSiteInfo(siteInfo, TEST_SITE_PRESET, "testGetSite", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        NodeRef container = this.siteService.createContainer(siteInfo.getShortName(), "folder.component", ContentModel.TYPE_FOLDER, null);
        NodeRef content = this.nodeService.createNode(container, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS, ContentModel.TYPE_CONTENT).getChildRef();
        siteInfo = this.siteService.getSite(content);
        this.checkSiteInfo(siteInfo, TEST_SITE_PRESET, "testGetSite", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
    }

    public void testUpdateSite() {
        SiteInfo siteInfo = new SiteInfoImpl(TEST_SITE_PRESET, "testUpdateSite", "changedTitle", "changedDescription", SiteVisibility.PRIVATE, null);
        try {
            this.siteService.updateSite(siteInfo);
            SiteServiceImplTest.fail((String)"Shouldn't be able to update a site that does not exist");
        }
        catch (AlfrescoRuntimeException alfrescoRuntimeException) {
            // empty catch block
        }
        this.siteService.createSite(TEST_SITE_PRESET, "testUpdateSite", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        this.siteService.updateSite(siteInfo);
        siteInfo = this.siteService.getSite("testUpdateSite");
        this.checkSiteInfo(siteInfo, TEST_SITE_PRESET, "testUpdateSite", "changedTitle", "changedDescription", SiteVisibility.PRIVATE);
        siteInfo.setVisibility(SiteVisibility.PUBLIC);
        this.siteService.updateSite(siteInfo);
        this.checkSiteInfo(siteInfo, TEST_SITE_PRESET, "testUpdateSite", "changedTitle", "changedDescription", SiteVisibility.PUBLIC);
    }

    public void testDeleteSite() {
        SiteService smallSiteService = (SiteService)this.applicationContext.getBean("siteService");
        try {
            this.siteService.deleteSite("testDeleteSite");
            SiteServiceImplTest.fail((String)"Shouldn't be able to delete a site that does not exist");
        }
        catch (AlfrescoRuntimeException exception) {
            // empty catch block
        }
        final String testGroupName = "siteServiceImplTestGroup_" + GUID.generate();
        String testGroup = (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                return SiteServiceImplTest.this.authorityService.createAuthority(AuthorityType.GROUP, testGroupName);
            }
        }, (String)AuthenticationUtil.getAdminUserName());
        String siteShortName = "testUpdateSite";
        this.siteService.createSite(TEST_SITE_PRESET, siteShortName, TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        SiteInfo siteInfo = this.siteService.getSite(siteShortName);
        SiteServiceImplTest.assertNotNull((Object)siteInfo);
        this.siteService.setMembership(siteShortName, testGroup, "SiteContributor");
        try {
            this.nodeService.deleteNode(siteInfo.getNodeRef());
            SiteServiceImplTest.fail((String)"Shouldn't be able to delete a site via the nodeService");
        }
        catch (AlfrescoRuntimeException expected) {
            // empty catch block
        }
        this.siteService.deleteSite(siteShortName);
        SiteServiceImplTest.assertNull((Object)this.siteService.getSite(siteShortName));
        NodeRef archivedNodeRef = this.nodeArchiveService.getArchivedNode(siteInfo.getNodeRef());
        SiteServiceImplTest.assertTrue((String)"Deleted sites can be recovered from the Trash.", (boolean)this.nodeService.exists(archivedNodeRef));
        SiteServiceImplTest.assertFalse((boolean)this.authorityService.authorityExists(((SiteServiceImpl)smallSiteService).getSiteGroup(siteShortName, true)));
        Set permissions = this.permissionService.getSettablePermissions(SiteModel.TYPE_SITE);
        for (String permission : permissions) {
            String siteRoleGroup = ((SiteServiceImpl)smallSiteService).getSiteRoleGroup(siteShortName, permission, true);
            SiteServiceImplTest.assertFalse((boolean)this.authorityService.authorityExists(siteRoleGroup));
        }
        SiteServiceImplTest.assertTrue((boolean)this.authorityService.authorityExists(testGroup));
    }

    public void testIsPublic() {
        List<SiteInfo> sites = this.siteService.listSites(null, null);
        SiteServiceImplTest.assertNotNull((String)"initial sites list was null.", sites);
        int preexistingSiteCount = sites.size();
        this.siteService.createSite(TEST_SITE_PRESET, "isPublicTrue", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        this.siteService.createSite(TEST_SITE_PRESET, "isPublicFalse", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PRIVATE);
        sites = this.siteService.listSites(null, null);
        SiteServiceImplTest.assertNotNull(sites);
        SiteServiceImplTest.assertEquals((int)(preexistingSiteCount + 2), (int)sites.size());
        this.authenticationComponent.setCurrentUser(USER_TWO);
        sites = this.siteService.listSites(null, null);
        SiteServiceImplTest.assertNotNull(sites);
        SiteServiceImplTest.assertEquals((int)(preexistingSiteCount + 1), (int)sites.size());
        SiteInfo userTwoSite = this.siteService.getSite("isPublicTrue");
        this.checkSiteInfo(userTwoSite, TEST_SITE_PRESET, "isPublicTrue", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        this.authenticationComponent.setCurrentUser(USER_ONE);
        this.siteService.setMembership("isPublicFalse", USER_TWO, "SiteConsumer");
        this.authenticationComponent.setCurrentUser(USER_TWO);
        sites = this.siteService.listSites(null, null);
        SiteServiceImplTest.assertNotNull(sites);
        SiteServiceImplTest.assertEquals((int)(preexistingSiteCount + 2), (int)sites.size());
    }

    public void testMembership() {
        this.siteService.createSite(TEST_SITE_PRESET, "testMembership", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PRIVATE);
        Map<String, String> members = this.siteService.listMembers("testMembership", null, null, 0);
        SiteServiceImplTest.assertNotNull(members);
        SiteServiceImplTest.assertEquals((int)1, (int)members.size());
        SiteServiceImplTest.assertTrue((boolean)members.containsKey(USER_ONE));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)members.get(USER_ONE));
        this.siteService.setMembership("testMembership", USER_TWO, "SiteConsumer");
        this.siteService.setMembership("testMembership", USER_THREE, "SiteCollaborator");
        members = this.siteService.listMembers("testMembership", null, null, 0);
        SiteServiceImplTest.assertNotNull(members);
        SiteServiceImplTest.assertEquals((int)3, (int)members.size());
        SiteServiceImplTest.assertTrue((boolean)members.containsKey(USER_ONE));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)members.get(USER_ONE));
        SiteServiceImplTest.assertTrue((boolean)members.containsKey(USER_TWO));
        SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)members.get(USER_TWO));
        SiteServiceImplTest.assertTrue((boolean)members.containsKey(USER_THREE));
        SiteServiceImplTest.assertEquals((String)"SiteCollaborator", (String)members.get(USER_THREE));
        members = this.siteService.listMembers("testMembership", null, "SiteManager", 0);
        SiteServiceImplTest.assertNotNull(members);
        SiteServiceImplTest.assertEquals((int)1, (int)members.size());
        SiteServiceImplTest.assertTrue((boolean)members.containsKey(USER_ONE));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)members.get(USER_ONE));
        members = this.siteService.listMembers("testMembership", USER_TWO, null, 0);
        SiteServiceImplTest.assertNotNull(members);
        SiteServiceImplTest.assertEquals((int)1, (int)members.size());
        SiteServiceImplTest.assertTrue((boolean)members.containsKey(USER_TWO));
        SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)members.get(USER_TWO));
        this.siteService.setMembership("testMembership", USER_TWO, "SiteCollaborator");
        members = this.siteService.listMembers("testMembership", null, null, 0);
        SiteServiceImplTest.assertNotNull(members);
        SiteServiceImplTest.assertEquals((int)3, (int)members.size());
        SiteServiceImplTest.assertTrue((boolean)members.containsKey(USER_ONE));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)members.get(USER_ONE));
        SiteServiceImplTest.assertTrue((boolean)members.containsKey(USER_TWO));
        SiteServiceImplTest.assertEquals((String)"SiteCollaborator", (String)members.get(USER_TWO));
        SiteServiceImplTest.assertTrue((boolean)members.containsKey(USER_THREE));
        SiteServiceImplTest.assertEquals((String)"SiteCollaborator", (String)members.get(USER_THREE));
        this.siteService.removeMembership("testMembership", USER_TWO);
        members = this.siteService.listMembers("testMembership", null, null, 0);
        SiteServiceImplTest.assertNotNull(members);
        SiteServiceImplTest.assertEquals((int)2, (int)members.size());
        SiteServiceImplTest.assertTrue((boolean)members.containsKey(USER_ONE));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)members.get(USER_ONE));
        SiteServiceImplTest.assertTrue((boolean)members.containsKey(USER_THREE));
        SiteServiceImplTest.assertEquals((String)"SiteCollaborator", (String)members.get(USER_THREE));
        members = this.siteService.listMembers("testMembership", null, null, 1);
        SiteServiceImplTest.assertNotNull(members);
        SiteServiceImplTest.assertEquals((int)1, (int)members.size());
        members = this.siteService.listMembers("testMembership", null, null, 2);
        SiteServiceImplTest.assertNotNull(members);
        SiteServiceImplTest.assertEquals((int)2, (int)members.size());
        SiteServiceImplTest.assertTrue((boolean)members.containsKey(USER_ONE));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)members.get(USER_ONE));
        SiteServiceImplTest.assertTrue((boolean)members.containsKey(USER_THREE));
        SiteServiceImplTest.assertEquals((String)"SiteCollaborator", (String)members.get(USER_THREE));
        this.authenticationComponent.setCurrentUser(USER_TWO);
        try {
            this.siteService.setMembership("testMembership", USER_TWO, "SiteCollaborator");
            SiteServiceImplTest.fail((String)"A non member shouldnt be able to set memberships");
        }
        catch (AlfrescoRuntimeException e) {
            // empty catch block
        }
        try {
            this.siteService.removeMembership("testMembership", USER_THREE);
            SiteServiceImplTest.fail((String)"A non member shouldnt be able to remove a membership");
        }
        catch (AlfrescoRuntimeException e) {
            // empty catch block
        }
        this.authenticationComponent.setCurrentUser(USER_THREE);
        try {
            this.siteService.setMembership("testMembership", USER_TWO, "SiteCollaborator");
            SiteServiceImplTest.fail((String)"A member who isn't a manager shouldnt be able to set memberships");
        }
        catch (AlfrescoRuntimeException e) {
            // empty catch block
        }
        this.siteService.removeMembership("testMembership", USER_THREE);
        this.authenticationComponent.setCurrentUser(USER_ONE);
        this.siteService.setMembership("testMembership", USER_TWO, "SiteManager");
        this.siteService.setMembership("testMembership", USER_TWO, "SiteCollaborator");
        try {
            this.siteService.setMembership("testMembership", USER_ONE, "SiteCollaborator");
            SiteServiceImplTest.fail((String)"You can not change the role of the last site memnager");
        }
        catch (AlfrescoRuntimeException exception) {
            // empty catch block
        }
        this.siteService.setMembership("testMembership", USER_TWO, "SiteManager");
        this.siteService.removeMembership("testMembership", USER_ONE);
        try {
            this.siteService.removeMembership("testMembership", USER_TWO);
            SiteServiceImplTest.fail((String)"You can not remove the last site memnager from a site");
        }
        catch (AlfrescoRuntimeException alfrescoRuntimeException) {
            // empty catch block
        }
    }

    public void testJoinLeave() {
        this.siteService.createSite(TEST_SITE_PRESET, "testMembership", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        this.siteService.createSite(TEST_SITE_PRESET, "testMembershipPrivate", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PRIVATE);
        this.authenticationComponent.setCurrentUser(USER_TWO);
        try {
            this.siteService.setMembership("testMembership", USER_TWO, "SiteCollaborator");
            SiteServiceImplTest.fail((String)"This should have failed because you don't have permissions");
        }
        catch (AlfrescoRuntimeException exception) {
            // empty catch block
        }
        this.siteService.setMembership("testMembership", USER_TWO, "SiteConsumer");
        try {
            this.siteService.setMembership("testMembershipPrivate", USER_TWO, "SiteConsumer");
            SiteServiceImplTest.fail((String)"This should have failed because you can't do this to a private site unless you are site manager");
        }
        catch (AlfrescoRuntimeException exception) {
            // empty catch block
        }
        try {
            this.siteService.setMembership("testMembership", USER_THREE, "SiteConsumer");
            SiteServiceImplTest.fail((String)"This should have failed because you can't add another user as a consumer of a public site");
        }
        catch (AlfrescoRuntimeException exception) {
            // empty catch block
        }
        this.authenticationComponent.setCurrentUser(USER_ONE);
        this.siteService.setMembership("testMembership", USER_THREE, "SiteCollaborator");
        this.siteService.setMembership("testMembershipPrivate", USER_TWO, "SiteConsumer");
        this.authenticationComponent.setCurrentUser(USER_TWO);
        try {
            this.siteService.removeMembership("testMembership", USER_THREE);
            SiteServiceImplTest.fail((String)"Cannot remove membership");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.siteService.removeMembership("testMembership", USER_TWO);
    }

    public void testContainer() {
        SiteInfo siteInfo = this.siteService.createSite(TEST_SITE_PRESET, "testContainer", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        boolean hasContainer = this.siteService.hasContainer(siteInfo.getShortName(), "folder.component");
        SiteServiceImplTest.assertFalse((boolean)hasContainer);
        NodeRef container1 = this.siteService.getContainer(siteInfo.getShortName(), "folder.component");
        SiteServiceImplTest.assertNull((Object)container1);
        container1 = this.siteService.createContainer(siteInfo.getShortName(), "folder.component", null, null);
        SiteServiceImplTest.assertTrue((boolean)this.taggingService.isTagScope(container1));
        NodeRef container2 = this.siteService.getContainer(siteInfo.getShortName(), "folder.component");
        SiteServiceImplTest.assertNotNull((Object)container2);
        SiteServiceImplTest.assertTrue((boolean)this.taggingService.isTagScope(container2));
        SiteServiceImplTest.assertTrue((boolean)container1.equals((Object)container2));
        boolean hasContainer2 = this.siteService.hasContainer(siteInfo.getShortName(), "folder.component");
        SiteServiceImplTest.assertTrue((boolean)hasContainer2);
        boolean hasContainer3 = this.siteService.hasContainer(siteInfo.getShortName(), "folder.component2");
        SiteServiceImplTest.assertFalse((boolean)hasContainer3);
        NodeRef container3 = this.siteService.getContainer(siteInfo.getShortName(), "folder.component2");
        SiteServiceImplTest.assertNull((Object)container3);
        container3 = this.siteService.createContainer(siteInfo.getShortName(), "folder.component2", null, null);
        SiteServiceImplTest.assertNotNull((Object)container3);
        SiteServiceImplTest.assertTrue((boolean)this.taggingService.isTagScope(container3));
        SiteServiceImplTest.assertFalse((boolean)container1.equals((Object)container3));
        boolean hasContainer4 = this.siteService.hasContainer(siteInfo.getShortName(), "folder.component2");
        SiteServiceImplTest.assertTrue((boolean)hasContainer4);
        boolean hasContainer5 = this.siteService.hasContainer(siteInfo.getShortName(), "folder.component3");
        SiteServiceImplTest.assertFalse((boolean)hasContainer5);
        NodeRef container5 = this.siteService.getContainer(siteInfo.getShortName(), "folder.component3");
        SiteServiceImplTest.assertNull((Object)container5);
        container5 = this.siteService.createContainer(siteInfo.getShortName(), "folder.component3", ContentModel.TYPE_FOLDER, null);
        SiteServiceImplTest.assertNotNull((Object)container5);
        NodeRef container6 = this.siteService.getContainer(siteInfo.getShortName(), "folder.component3");
        SiteServiceImplTest.assertNotNull((Object)container6);
        container6 = this.siteService.createContainer(siteInfo.getShortName(), "folder.component3", null, null);
        SiteServiceImplTest.assertNotNull((Object)container6);
        SiteServiceImplTest.assertTrue((boolean)container5.equals((Object)container6));
        SiteServiceImplTest.assertEquals((Object)ContentModel.TYPE_FOLDER, (Object)this.nodeService.getType(container6));
        NodeRef container7 = this.siteService.getContainer(siteInfo.getShortName(), "folder.component3");
        SiteServiceImplTest.assertNotNull((Object)container7);
        container7 = this.siteService.createContainer(siteInfo.getShortName(), "folder.component3", ForumModel.TYPE_FORUM, null);
        SiteServiceImplTest.assertNotNull((Object)container7);
        SiteServiceImplTest.assertTrue((boolean)container5.equals((Object)container7));
        SiteServiceImplTest.assertEquals((Object)ContentModel.TYPE_FOLDER, (Object)this.nodeService.getType(container7));
        NodeRef container8 = this.siteService.getContainer(siteInfo.getShortName(), "folder.component4");
        SiteServiceImplTest.assertNull((Object)container8);
        container8 = this.siteService.createContainer(siteInfo.getShortName(), "folder.component4", ForumModel.TYPE_FORUM, null);
        SiteServiceImplTest.assertNotNull((Object)container8);
        SiteServiceImplTest.assertEquals((Object)ForumModel.TYPE_FORUM, (Object)this.nodeService.getType(container8));
    }

    public void testSiteGetRoles() {
        List<String> roles = this.siteService.getSiteRoles();
        SiteServiceImplTest.assertNotNull(roles);
        SiteServiceImplTest.assertFalse((boolean)roles.isEmpty());
        SiteServiceImplTest.assertEquals((int)4, (int)roles.size());
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteConsumer"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteContributor"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteCollaborator"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteManager"));
    }

    public void testCustomSiteProperties() {
        QName additionalInformationQName = QName.createQName((String)"http://www.alfresco.org/model/sitecustomproperty/1.0", (String)"additionalInformation");
        SiteInfo siteInfo = this.siteService.createSite(TEST_SITE_PRESET, "mySiteTest", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        this.checkSiteInfo(siteInfo, TEST_SITE_PRESET, "mySiteTest", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        SiteServiceImplTest.assertNull((Object)siteInfo.getCustomProperty(additionalInformationQName));
        SiteServiceImplTest.assertNotNull(siteInfo.getCustomProperties());
        SiteServiceImplTest.assertTrue((boolean)siteInfo.getCustomProperties().isEmpty());
        NodeRef siteNodeRef = siteInfo.getNodeRef();
        HashMap<QName, String> properties = new HashMap<QName, String>(1);
        properties.put(additionalInformationQName, "information");
        this.nodeService.addAspect(siteNodeRef, QName.createQName((String)"http://www.alfresco.org/model/site/1.0", (String)"customSiteProperties"), properties);
        siteInfo = this.siteService.getSite("mySiteTest");
        SiteServiceImplTest.assertNotNull((Object)siteInfo);
        SiteServiceImplTest.assertEquals((Object)"information", (Object)siteInfo.getCustomProperty(additionalInformationQName));
        SiteServiceImplTest.assertNotNull(siteInfo.getCustomProperties());
        SiteServiceImplTest.assertFalse((boolean)siteInfo.getCustomProperties().isEmpty());
        SiteServiceImplTest.assertEquals((int)1, (int)siteInfo.getCustomProperties().size());
        SiteServiceImplTest.assertEquals((Object)"information", (Object)siteInfo.getCustomProperties().get(additionalInformationQName));
    }

    public void testCustomSiteType() {
        String CS_URI = "http://example.com/site";
        String CS_PFX = "cs";
        DictionaryDAO dictionaryDAO = (DictionaryDAO)this.applicationContext.getBean("dictionaryDAO");
        M2Model model = M2Model.createModel((String)"cm:CustomSiteModel");
        model.createNamespace("http://example.com/site", "cs");
        model.createImport("http://www.alfresco.org/model/content/1.0", "cm");
        model.createImport("http://www.alfresco.org/model/dictionary/1.0", "d");
        model.createImport("http://www.alfresco.org/model/site/1.0", "st");
        M2Type customType = model.createType("cs:customSite");
        customType.setTitle("customSite");
        customType.setParentName("st:" + SiteModel.TYPE_SITE.getLocalName());
        M2Property customProp = customType.createProperty("cs:customSiteProp");
        customProp.setTitle("customSiteProp");
        customProp.setType("d:text");
        dictionaryDAO.putModel(model);
        QName customTypeQ = QName.createQName((String)"cs", (String)"customSite", (NamespacePrefixResolver)this.namespaceService);
        TypeDefinition td = this.dictionaryService.getType(customTypeQ);
        SiteServiceImplTest.assertNotNull((Object)td);
        SiteInfo site = this.siteService.createSite("custom", "custom", "Custom", "Custom", SiteVisibility.PUBLIC);
        List<String> roles = this.siteService.getSiteRoles();
        SiteServiceImplTest.assertEquals((int)4, (int)roles.size());
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteConsumer"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteContributor"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteCollaborator"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteManager"));
        roles = this.siteService.getSiteRoles(site.getShortName());
        SiteServiceImplTest.assertEquals((int)4, (int)roles.size());
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteConsumer"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteContributor"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteCollaborator"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteManager"));
        this.nodeService.setType(site.getNodeRef(), customTypeQ);
        roles = this.siteService.getSiteRoles();
        SiteServiceImplTest.assertEquals((int)4, (int)roles.size());
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteConsumer"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteContributor"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteCollaborator"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteManager"));
        roles = this.siteService.getSiteRoles(site.getShortName());
        SiteServiceImplTest.assertEquals((int)4, (int)roles.size());
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteConsumer"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteContributor"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteCollaborator"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteManager"));
        PermissionService testPermissionService = (PermissionService)Mockito.spy((Object)((PermissionService)this.applicationContext.getBean("permissionServiceImpl")));
        HashSet<String> customPerms = new HashSet<String>();
        customPerms.add("SiteManager");
        customPerms.add("CUSTOM");
        Mockito.when((Object)testPermissionService.getSettablePermissions(customTypeQ)).thenReturn(customPerms);
        SiteServiceImpl siteServiceImpl = (SiteServiceImpl)this.applicationContext.getBean("siteService");
        siteServiceImpl.setPermissionService(testPermissionService);
        roles = this.siteService.getSiteRoles();
        SiteServiceImplTest.assertEquals((int)4, (int)roles.size());
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteConsumer"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteContributor"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteCollaborator"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteManager"));
        roles = this.siteService.getSiteRoles(site.getShortName());
        SiteServiceImplTest.assertEquals((int)2, (int)roles.size());
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("CUSTOM"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteManager"));
        siteServiceImpl.setPermissionService(this.permissionService);
        roles = this.siteService.getSiteRoles();
        SiteServiceImplTest.assertEquals((int)4, (int)roles.size());
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteConsumer"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteContributor"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteCollaborator"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteManager"));
        roles = this.siteService.getSiteRoles(site.getShortName());
        SiteServiceImplTest.assertEquals((int)4, (int)roles.size());
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteConsumer"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteContributor"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteCollaborator"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteManager"));
    }

    public void testGroupMembership() {
        this.siteService.createSite(TEST_SITE_PRESET, "testMembership", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PRIVATE);
        Map<String, String> members = this.siteService.listMembers("testMembership", null, null, 0);
        SiteServiceImplTest.assertNotNull(members);
        SiteServiceImplTest.assertEquals((int)1, (int)members.size());
        SiteServiceImplTest.assertTrue((boolean)members.containsKey(USER_ONE));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)members.get(USER_ONE));
        SiteServiceImplTest.assertTrue((boolean)this.siteService.isMember("testMembership", USER_ONE));
        SiteServiceImplTest.assertTrue((!this.siteService.isMember("testMembership", USER_TWO) ? 1 : 0) != 0);
        SiteServiceImplTest.assertTrue((!this.siteService.isMember("testMembership", USER_THREE) ? 1 : 0) != 0);
        this.siteService.setMembership("testMembership", this.groupTwo, "SiteConsumer");
        members = this.siteService.listMembers("testMembership", null, null, 0);
        SiteServiceImplTest.assertNotNull(members);
        SiteServiceImplTest.assertEquals((int)2, (int)members.size());
        SiteServiceImplTest.assertTrue((boolean)members.containsKey(USER_ONE));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)members.get(USER_ONE));
        SiteServiceImplTest.assertTrue((boolean)members.containsKey(this.groupTwo));
        SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)members.get(this.groupTwo));
        members = this.siteService.listMembers("testMembership", null, null, 0, true);
        SiteServiceImplTest.assertNotNull(members);
        SiteServiceImplTest.assertEquals((int)3, (int)members.size());
        SiteServiceImplTest.assertTrue((boolean)members.containsKey(USER_ONE));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)members.get(USER_ONE));
        SiteServiceImplTest.assertTrue((boolean)members.containsKey(USER_TWO));
        SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)members.get(USER_TWO));
        SiteServiceImplTest.assertTrue((boolean)members.containsKey(USER_THREE));
        SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)members.get(USER_THREE));
        SiteServiceImplTest.assertTrue((boolean)this.siteService.isMember("testMembership", USER_ONE));
        SiteServiceImplTest.assertTrue((boolean)this.siteService.isMember("testMembership", USER_TWO));
        SiteServiceImplTest.assertTrue((boolean)this.siteService.isMember("testMembership", USER_THREE));
        SiteServiceImplTest.assertTrue((boolean)this.siteService.isMember("testMembership", this.groupTwo));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)this.siteService.getMembersRole("testMembership", USER_ONE));
        SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)this.siteService.getMembersRole("testMembership", USER_TWO));
        SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)this.siteService.getMembersRole("testMembership", USER_THREE));
        SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)this.siteService.getMembersRole("testMembership", this.groupTwo));
        members = this.siteService.listMembers("testMembership", null, "SiteManager", 0, true);
        SiteServiceImplTest.assertNotNull(members);
        SiteServiceImplTest.assertEquals((int)1, (int)members.size());
        SiteServiceImplTest.assertTrue((boolean)members.containsKey(USER_ONE));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)members.get(USER_ONE));
        members = this.siteService.listMembers("testMembership", null, "SiteConsumer", 0, true);
        SiteServiceImplTest.assertNotNull(members);
        SiteServiceImplTest.assertEquals((int)2, (int)members.size());
        SiteServiceImplTest.assertTrue((boolean)members.containsKey(USER_TWO));
        SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)members.get(USER_TWO));
        SiteServiceImplTest.assertTrue((boolean)members.containsKey(USER_THREE));
        SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)members.get(USER_THREE));
        members = this.siteService.listMembers("testMembership", "UserOne", null, 0, true);
        SiteServiceImplTest.assertNotNull(members);
        SiteServiceImplTest.assertEquals((int)1, (int)members.size());
        SiteServiceImplTest.assertTrue((boolean)members.containsKey(USER_ONE));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)members.get(USER_ONE));
        members = this.siteService.listMembers("testMembership", "UserTwo", null, 0, true);
        SiteServiceImplTest.assertNotNull(members);
        SiteServiceImplTest.assertEquals((int)1, (int)members.size());
        SiteServiceImplTest.assertTrue((boolean)members.containsKey(USER_TWO));
        SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)members.get(USER_TWO));
        members = this.siteService.listMembers("testMembership", "UserTwo", null, 0, false);
        SiteServiceImplTest.assertNotNull(members);
        SiteServiceImplTest.assertEquals((int)0, (int)members.size());
        members = this.siteService.listMembers("testMembership", GROUP_TWO, null, 0, false);
        SiteServiceImplTest.assertNotNull(members);
        SiteServiceImplTest.assertEquals((int)1, (int)members.size());
        SiteServiceImplTest.assertTrue((boolean)members.containsKey(this.groupTwo));
        SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)members.get(this.groupTwo));
        members = this.siteService.listMembers("testMembership", GROUP_TWO_DISPLAY, null, 0, false);
        SiteServiceImplTest.assertNotNull(members);
        SiteServiceImplTest.assertEquals((int)1, (int)members.size());
        SiteServiceImplTest.assertTrue((boolean)members.containsKey(this.groupTwo));
        SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)members.get(this.groupTwo));
        members = this.siteService.listMembers("testMembership", GROUP_TWO, null, 0, true);
        SiteServiceImplTest.assertNotNull(members);
        SiteServiceImplTest.assertEquals((int)0, (int)members.size());
        this.siteService.setMembership("testMembership", USER_THREE, "SiteCollaborator");
        members = this.siteService.listMembers("testMembership", null, null, 0);
        SiteServiceImplTest.assertNotNull(members);
        SiteServiceImplTest.assertEquals((int)3, (int)members.size());
        SiteServiceImplTest.assertTrue((boolean)members.containsKey(USER_ONE));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)members.get(USER_ONE));
        SiteServiceImplTest.assertTrue((boolean)members.containsKey(USER_THREE));
        SiteServiceImplTest.assertEquals((String)"SiteCollaborator", (String)members.get(USER_THREE));
        SiteServiceImplTest.assertTrue((boolean)members.containsKey(this.groupTwo));
        SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)members.get(this.groupTwo));
        members = this.siteService.listMembers("testMembership", null, null, 0, true);
        SiteServiceImplTest.assertNotNull(members);
        SiteServiceImplTest.assertEquals((int)3, (int)members.size());
        SiteServiceImplTest.assertTrue((boolean)members.containsKey(USER_ONE));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)members.get(USER_ONE));
        SiteServiceImplTest.assertTrue((boolean)members.containsKey(USER_TWO));
        SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)members.get(USER_TWO));
        SiteServiceImplTest.assertTrue((boolean)members.containsKey(USER_THREE));
        SiteServiceImplTest.assertEquals((String)"SiteCollaborator", (String)members.get(USER_THREE));
        SiteServiceImplTest.assertTrue((boolean)this.siteService.isMember("testMembership", USER_ONE));
        SiteServiceImplTest.assertTrue((boolean)this.siteService.isMember("testMembership", USER_TWO));
        SiteServiceImplTest.assertTrue((boolean)this.siteService.isMember("testMembership", USER_THREE));
        SiteServiceImplTest.assertTrue((!this.siteService.isMember("testMembership", USER_FOUR) ? 1 : 0) != 0);
        SiteServiceImplTest.assertTrue((boolean)this.siteService.isMember("testMembership", this.groupTwo));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)this.siteService.getMembersRole("testMembership", USER_ONE));
        SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)this.siteService.getMembersRole("testMembership", USER_TWO));
        SiteServiceImplTest.assertEquals((String)"SiteCollaborator", (String)this.siteService.getMembersRole("testMembership", USER_THREE));
        SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)this.siteService.getMembersRole("testMembership", this.groupTwo));
        this.siteService.setMembership("testMembership", USER_THREE, "SiteContributor");
        this.siteService.setMembership("testMembership", this.groupThree, "SiteManager");
        SiteServiceImplTest.assertTrue((boolean)this.siteService.isMember("testMembership", USER_ONE));
        SiteServiceImplTest.assertTrue((boolean)this.siteService.isMember("testMembership", USER_TWO));
        SiteServiceImplTest.assertTrue((boolean)this.siteService.isMember("testMembership", USER_THREE));
        SiteServiceImplTest.assertTrue((boolean)this.siteService.isMember("testMembership", USER_FOUR));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)this.siteService.getMembersRole("testMembership", USER_ONE));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)this.siteService.getMembersRole("testMembership", USER_TWO));
        SiteServiceImplTest.assertEquals((String)"SiteContributor", (String)this.siteService.getMembersRole("testMembership", USER_THREE));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)this.siteService.getMembersRole("testMembership", this.groupThree));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)this.siteService.getMembersRole("testMembership", USER_FOUR));
        try {
            this.siteService.setMembership("testMembership", this.groupThree, "rubbish");
        }
        catch (UnknownAuthorityException expected) {
            return;
        }
        SiteServiceImplTest.fail((String)"Expected exception not thrown.");
    }

    public void testSiteVisibility() {
        SiteInfo siteInfo = this.createTestSiteWithContent("testSiteVisibilityPublicSite", "testComp", SiteVisibility.PUBLIC);
        SiteServiceImplTest.assertEquals((Object)SiteVisibility.PUBLIC.toString(), (Object)this.nodeService.getProperty(siteInfo.getNodeRef(), SiteModel.PROP_SITE_VISIBILITY));
        this.checkSiteInfo(siteInfo, TEST_SITE_PRESET, "testSiteVisibilityPublicSite", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        siteInfo = this.siteService.getSite("testSiteVisibilityPublicSite");
        this.checkSiteInfo(siteInfo, TEST_SITE_PRESET, "testSiteVisibilityPublicSite", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        this.testVisibilityPermissions("Testing visibility of public site", USER_TWO, siteInfo, true, true);
        siteInfo = this.createTestSiteWithContent("testSiteVisibilityModeratedSite", "testComp", SiteVisibility.MODERATED);
        SiteServiceImplTest.assertEquals((Object)SiteVisibility.MODERATED.toString(), (Object)this.nodeService.getProperty(siteInfo.getNodeRef(), SiteModel.PROP_SITE_VISIBILITY));
        this.checkSiteInfo(siteInfo, TEST_SITE_PRESET, "testSiteVisibilityModeratedSite", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.MODERATED);
        siteInfo = this.siteService.getSite("testSiteVisibilityModeratedSite");
        this.checkSiteInfo(siteInfo, TEST_SITE_PRESET, "testSiteVisibilityModeratedSite", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.MODERATED);
        this.testVisibilityPermissions("Testing visibility of moderated site", USER_TWO, siteInfo, true, false);
        siteInfo = this.createTestSiteWithContent("testSiteVisibilityPrivateSite", "testComp", SiteVisibility.PRIVATE);
        SiteServiceImplTest.assertEquals((Object)SiteVisibility.PRIVATE.toString(), (Object)this.nodeService.getProperty(siteInfo.getNodeRef(), SiteModel.PROP_SITE_VISIBILITY));
        this.checkSiteInfo(siteInfo, TEST_SITE_PRESET, "testSiteVisibilityPrivateSite", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PRIVATE);
        siteInfo = this.siteService.getSite("testSiteVisibilityPrivateSite");
        this.checkSiteInfo(siteInfo, TEST_SITE_PRESET, "testSiteVisibilityPrivateSite", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PRIVATE);
        this.testVisibilityPermissions("Testing visibility of private site", USER_TWO, siteInfo, false, false);
        SiteInfo changeSite = this.createTestSiteWithContent("testSiteVisibilityChangeSite", "testComp", SiteVisibility.PUBLIC);
        changeSite.setVisibility(SiteVisibility.MODERATED);
        this.siteService.updateSite(changeSite);
        siteInfo = this.siteService.getSite("testSiteVisibilityChangeSite");
        this.checkSiteInfo(siteInfo, TEST_SITE_PRESET, "testSiteVisibilityChangeSite", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.MODERATED);
        this.testVisibilityPermissions("Testing visibility of moderated site", USER_TWO, siteInfo, true, false);
        changeSite.setVisibility(SiteVisibility.PRIVATE);
        this.siteService.updateSite(changeSite);
        siteInfo = this.siteService.getSite("testSiteVisibilityChangeSite");
        this.checkSiteInfo(siteInfo, TEST_SITE_PRESET, "testSiteVisibilityChangeSite", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PRIVATE);
        this.testVisibilityPermissions("Testing visibility of moderated site", USER_TWO, siteInfo, false, false);
        changeSite.setVisibility(SiteVisibility.PUBLIC);
        this.siteService.updateSite(changeSite);
        siteInfo = this.siteService.getSite("testSiteVisibilityChangeSite");
        this.checkSiteInfo(siteInfo, TEST_SITE_PRESET, "testSiteVisibilityChangeSite", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        this.testVisibilityPermissions("Testing visibility of moderated site", USER_TWO, siteInfo, true, true);
    }

    private Map<String, String> getAllowedPermissionsMap(SiteInfo site) {
        HashMap<String, String> perms = new HashMap<String, String>();
        for (AccessPermission ap : this.permissionService.getAllSetPermissions(site.getNodeRef())) {
            if (ap.getAccessStatus() != AccessStatus.ALLOWED) continue;
            perms.put(ap.getAuthority(), ap.getPermission());
        }
        return perms;
    }

    public void testNonDefaultPublicGroupPermissions() throws Exception {
        SiteServiceImplTest.assertEquals((String)"GROUP_EVERYONE", (String)this.sysAdminParams.getSitePublicGroup());
        SysAdminParamsImpl sp = new SysAdminParamsImpl();
        sp.setSitePublicGroup(this.groupFour);
        this.siteServiceImpl.setSysAdminParams(sp);
        SiteInfo s1 = this.siteService.createSite(TEST_SITE_PRESET, "SiteTest_priv", "priv", "priv", SiteVisibility.PRIVATE);
        SiteInfo s2 = this.siteService.createSite(TEST_SITE_PRESET, "SiteTest_mod", "mod", "mod", SiteVisibility.MODERATED);
        SiteInfo s3 = this.siteService.createSite(TEST_SITE_PRESET, "SiteTest_pub", "pub", "pub", SiteVisibility.PUBLIC);
        SiteServiceImplTest.assertEquals((String)"ReadPermissions", (String)this.getAllowedPermissionsMap(s1).get("GROUP_EVERYONE"));
        SiteServiceImplTest.assertEquals((String)"ReadPermissions", (String)this.getAllowedPermissionsMap(s2).get("GROUP_EVERYONE"));
        SiteServiceImplTest.assertEquals((String)"ReadPermissions", (String)this.getAllowedPermissionsMap(s3).get("GROUP_EVERYONE"));
        SiteServiceImplTest.assertEquals(null, (String)this.getAllowedPermissionsMap(s1).get(this.groupFour));
        SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)this.getAllowedPermissionsMap(s2).get(this.groupFour));
        SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)this.getAllowedPermissionsMap(s3).get(this.groupFour));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)this.siteService.getMembersRole(s1.getShortName(), USER_ONE));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)this.siteService.getMembersRole(s2.getShortName(), USER_ONE));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)this.siteService.getMembersRole(s3.getShortName(), USER_ONE));
        s1.setVisibility(SiteVisibility.PUBLIC);
        s2.setVisibility(SiteVisibility.PUBLIC);
        s3.setVisibility(SiteVisibility.PRIVATE);
        this.siteService.updateSite(s1);
        this.siteService.updateSite(s2);
        this.siteService.updateSite(s3);
        SiteServiceImplTest.assertEquals((String)"ReadPermissions", (String)this.getAllowedPermissionsMap(s1).get("GROUP_EVERYONE"));
        SiteServiceImplTest.assertEquals((String)"ReadPermissions", (String)this.getAllowedPermissionsMap(s2).get("GROUP_EVERYONE"));
        SiteServiceImplTest.assertEquals((String)"ReadPermissions", (String)this.getAllowedPermissionsMap(s3).get("GROUP_EVERYONE"));
        SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)this.getAllowedPermissionsMap(s1).get(this.groupFour));
        SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)this.getAllowedPermissionsMap(s2).get(this.groupFour));
        SiteServiceImplTest.assertEquals(null, (String)this.getAllowedPermissionsMap(s3).get(this.groupFour));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)this.siteService.getMembersRole(s1.getShortName(), USER_ONE));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)this.siteService.getMembersRole(s2.getShortName(), USER_ONE));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)this.siteService.getMembersRole(s3.getShortName(), USER_ONE));
        s1.setVisibility(SiteVisibility.PRIVATE);
        s2.setVisibility(SiteVisibility.MODERATED);
        s3.setVisibility(SiteVisibility.PUBLIC);
        this.siteService.updateSite(s1);
        this.siteService.updateSite(s2);
        this.siteService.updateSite(s3);
        SiteServiceImplTest.assertEquals((String)"ReadPermissions", (String)this.getAllowedPermissionsMap(s1).get("GROUP_EVERYONE"));
        SiteServiceImplTest.assertEquals((String)"ReadPermissions", (String)this.getAllowedPermissionsMap(s2).get("GROUP_EVERYONE"));
        SiteServiceImplTest.assertEquals((String)"ReadPermissions", (String)this.getAllowedPermissionsMap(s3).get("GROUP_EVERYONE"));
        SiteServiceImplTest.assertEquals(null, (String)this.getAllowedPermissionsMap(s1).get(this.groupFour));
        SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)this.getAllowedPermissionsMap(s2).get(this.groupFour));
        SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)this.getAllowedPermissionsMap(s3).get(this.groupFour));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)this.siteService.getMembersRole(s1.getShortName(), USER_ONE));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)this.siteService.getMembersRole(s2.getShortName(), USER_ONE));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)this.siteService.getMembersRole(s3.getShortName(), USER_ONE));
    }

    private SiteInfo createTestSiteWithContent(String siteShortName, String componentId, SiteVisibility visibility) {
        return this.createTestSiteWithContent(siteShortName, componentId, visibility, "");
    }

    private SiteInfo createTestSiteWithContent(String siteShortName, String componentId, SiteVisibility visibility, String fileFolderPrefix) {
        SiteInfo siteInfo = this.siteService.createSite(TEST_SITE_PRESET, siteShortName, TEST_TITLE, TEST_DESCRIPTION, visibility);
        NodeRef siteContainer = this.siteService.createContainer(siteShortName, componentId, ContentModel.TYPE_FOLDER, null);
        FileInfo fileInfo = this.fileFolderService.create(siteContainer, fileFolderPrefix + "file.txt", ContentModel.TYPE_CONTENT);
        ContentWriter writer = this.fileFolderService.getWriter(fileInfo.getNodeRef());
        writer.putContent("Just some old content that doesn't mean anything");
        FileInfo folder1Info = this.fileFolderService.create(siteContainer, fileFolderPrefix + "folder", ContentModel.TYPE_FOLDER);
        FileInfo fileInfo2 = this.fileFolderService.create(folder1Info.getNodeRef(), fileFolderPrefix + "fileInFolder.txt", ContentModel.TYPE_CONTENT);
        ContentWriter writer2 = this.fileFolderService.getWriter(fileInfo2.getNodeRef());
        writer2.putContent("Just some old content that doesn't mean anything");
        FileInfo folder2Info = this.fileFolderService.create(folder1Info.getNodeRef(), fileFolderPrefix + "subfolder", ContentModel.TYPE_FOLDER);
        FileInfo fileInfo3 = this.fileFolderService.create(folder2Info.getNodeRef(), fileFolderPrefix + "fileInSubfolder.txt", ContentModel.TYPE_CONTENT);
        ContentWriter writer3 = this.fileFolderService.getWriter(fileInfo3.getNodeRef());
        writer3.putContent("Just some old content that doesn't mean anything");
        return siteInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testVisibilityPermissions(String message, String userName, SiteInfo siteInfo, boolean listSite, boolean readSite) {
        String holdUser = this.authenticationComponent.getCurrentUserName();
        this.authenticationComponent.setCurrentUser(userName);
        try {
            block9: {
                List<SiteInfo> sites = this.siteService.listSites(null, null);
                boolean siteInList = sites.contains(siteInfo);
                if (listSite && !siteInList) {
                    SiteServiceImplTest.fail((String)(message + ":  The site '" + siteInfo.getShortName() + "' was expected in the list of sites for user '" + userName + "'"));
                } else if (!listSite && siteInList) {
                    SiteServiceImplTest.fail((String)(message + ":  The site '" + siteInfo.getShortName() + "' was NOT expected in the list of sites for user '" + userName + "'"));
                }
                if (siteInList) {
                    try {
                        NodeRef folder = this.siteService.getContainer(siteInfo.getShortName(), "testComp");
                        List<FileInfo> files = null;
                        files = this.fileFolderService.listFiles(folder);
                        if (!readSite) {
                            SiteServiceImplTest.fail((String)(message + ":  Content of the site '" + siteInfo.getShortName() + "' was NOT expected to be read by user '" + userName + "'"));
                        }
                    }
                    catch (Exception exception) {
                        if (!readSite) break block9;
                        SiteServiceImplTest.fail((String)(message + ":  Content of the site '" + siteInfo.getShortName() + "' was expected to be read by user '" + userName + "'"));
                    }
                }
            }
            Object var12_12 = null;
            this.authenticationComponent.setCurrentUser(holdUser);
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            this.authenticationComponent.setCurrentUser(holdUser);
            throw throwable;
        }
    }

    public void testALFCOM_3109() {
        String siteName = "testALFCOM_3019";
        this.siteService.createSite(TEST_SITE_PRESET, siteName, TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.MODERATED);
        Map<String, String> members = this.siteService.listMembers(siteName, null, null, 0);
        String managerName = members.keySet().iterator().next();
        this.siteService.setMembership(siteName, this.groupTwo, "SiteManager");
        this.siteService.setMembership(siteName, managerName, "SiteContributor");
        try {
            this.siteService.setMembership(siteName, this.groupTwo, "SiteContributor");
            SiteServiceImplTest.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.siteService.setMembership(siteName, managerName, "SiteManager");
        this.siteService.setMembership(siteName, this.groupTwo, "SiteContributor");
        try {
            this.siteService.setMembership(siteName, managerName, "SiteContributor");
            SiteServiceImplTest.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testALFCOM_3111() {
        String siteName = "testALFCOM_3019";
        this.siteService.createSite(TEST_SITE_PRESET, siteName, TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.MODERATED);
        Map<String, String> members = this.siteService.listMembers(siteName, null, null, 0);
        String managerName = members.keySet().iterator().next();
        this.siteService.setMembership(siteName, this.groupTwo, "SiteManager");
        this.siteService.removeMembership(siteName, managerName);
        try {
            this.siteService.removeMembership(siteName, this.groupTwo);
            SiteServiceImplTest.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.siteService.setMembership(siteName, managerName, "SiteManager");
        this.siteService.removeMembership(siteName, this.groupTwo);
        try {
            this.siteService.removeMembership(siteName, managerName);
            SiteServiceImplTest.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testETHREEOH_1268() {
        String siteName = "testALFCOM_XXXX";
        this.siteService.createSite(TEST_SITE_PRESET, siteName, TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PRIVATE);
        SiteInfo si = this.siteService.getSite(siteName);
        SiteServiceImplTest.assertNotNull((String)"site info is null", (Object)si);
        this.authenticationComponent.setCurrentUser(USER_TWO);
        si = this.siteService.getSite(siteName);
        SiteServiceImplTest.assertNull((String)"site info is not null", (Object)si);
    }

    public void testALF_3200() throws Exception {
        String siteName = "testALF_3200";
        SiteInfo siteInfo = this.siteService.createSite(TEST_SITE_PRESET, siteName, TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.MODERATED);
        NodeRef siteNodeRef = siteInfo.getNodeRef();
        try {
            this.fileFolderService.rename(siteNodeRef, "RenamedName");
            SiteServiceImplTest.fail((String)"Shouldn't be able to rename a site but did");
        }
        catch (SiteServiceException e) {
            // empty catch block
        }
        SiteServiceImplTest.assertEquals((Object)TEST_TITLE, (Object)this.nodeService.getProperty(siteNodeRef, ContentModel.PROP_TITLE));
        String newName = "ChangedTitleName";
        String newName2 = "Changed2Title2Name";
        this.nodeService.setProperty(siteNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)newName));
        SiteServiceImplTest.assertEquals((Object)newName, (Object)this.nodeService.getProperty(siteNodeRef, ContentModel.PROP_TITLE));
        siteInfo = this.siteService.getSite(siteNodeRef);
        SiteServiceImplTest.assertEquals((String)newName, (String)siteInfo.getTitle());
        siteInfo.setTitle(newName2);
        this.siteService.updateSite(siteInfo);
        SiteServiceImplTest.assertEquals((String)newName2, (String)siteInfo.getTitle());
        SiteServiceImplTest.assertEquals((Object)newName2, (Object)this.nodeService.getProperty(siteNodeRef, ContentModel.PROP_TITLE));
    }

    public void testALF_5556() throws Exception {
        String siteName = "testALF_5556";
        SiteInfo siteInfo = this.siteService.createSite(TEST_SITE_PRESET, siteName, TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.MODERATED);
        NodeRef container = this.siteService.createContainer(siteInfo.getShortName(), "folder.component", null, null);
        try {
            this.fileFolderService.rename(container, "RenamedContainer");
            SiteServiceImplTest.fail((String)"Shouldn't be able to rename a container but was able to");
        }
        catch (SiteServiceException e) {
            // empty catch block
        }
    }

    public void testALF8036_PermissionsAfterCopyingFolderBetweenSites() throws Exception {
        this.alf8036Impl(true);
    }

    private void alf8036Impl(boolean copyNotMove) {
        SiteInfo fromSite = this.createTestSiteWithContent("fromSite", "doclib", SiteVisibility.PUBLIC, "FROM");
        SiteInfo toSite = this.createTestSiteWithContent("toSite", "doclib", SiteVisibility.PUBLIC, "TO");
        NodeRef fromDoclibContainer = this.nodeService.getChildByName(fromSite.getNodeRef(), ContentModel.ASSOC_CONTAINS, "doclib");
        SiteServiceImplTest.assertNotNull((Object)fromDoclibContainer);
        NodeRef fromFolder = this.nodeService.getChildByName(fromDoclibContainer, ContentModel.ASSOC_CONTAINS, "FROMfolder");
        SiteServiceImplTest.assertNotNull((Object)fromFolder);
        NodeRef fromSubFolder = this.nodeService.getChildByName(fromFolder, ContentModel.ASSOC_CONTAINS, "FROMsubfolder");
        SiteServiceImplTest.assertNotNull((Object)fromSubFolder);
        this.permissionService.setPermission(fromFolder, this.siteServiceImpl.getSiteRoleGroup(fromSite.getShortName(), "SiteContributor", true), "SiteConsumer", false);
        this.permissionService.setPermission(fromSubFolder, this.siteServiceImpl.getSiteRoleGroup(fromSite.getShortName(), "SiteCollaborator", true), "SiteConsumer", false);
        NodeRef toDoclibContainer = this.nodeService.getChildByName(toSite.getNodeRef(), ContentModel.ASSOC_CONTAINS, "doclib");
        SiteServiceImplTest.assertNotNull((Object)toDoclibContainer);
        NodeRef toFolder = this.nodeService.getChildByName(toDoclibContainer, ContentModel.ASSOC_CONTAINS, "TOfolder");
        SiteServiceImplTest.assertNotNull((Object)toFolder);
        NodeRef relocatedNode = copyNotMove ? this.copyService.copy(fromFolder, toFolder, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS, true) : this.nodeService.moveNode(fromFolder, toDoclibContainer, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS).getChildRef();
        this.siteService.cleanSitePermissions(relocatedNode, null);
        HashMap<String, String> expectedPermissions = new HashMap<String, String>();
        expectedPermissions.put(this.siteService.getSiteRoleGroup(toSite.getShortName(), "SiteManager"), "SiteManager");
        expectedPermissions.put(this.siteService.getSiteRoleGroup(toSite.getShortName(), "SiteCollaborator"), "SiteCollaborator");
        expectedPermissions.put(this.siteService.getSiteRoleGroup(toSite.getShortName(), "SiteContributor"), "SiteContributor");
        expectedPermissions.put(this.siteService.getSiteRoleGroup(toSite.getShortName(), "SiteConsumer"), "SiteConsumer");
        this.validatePermissionsOnRelocatedNode(fromSite, toSite, relocatedNode, expectedPermissions);
        NodeRef copyOfSubFolder = this.nodeService.getChildByName(relocatedNode, ContentModel.ASSOC_CONTAINS, "FROMsubfolder");
        SiteServiceImplTest.assertNotNull((Object)copyOfSubFolder);
        this.validatePermissionsOnRelocatedNode(fromSite, toSite, copyOfSubFolder, expectedPermissions);
    }

    public void testALF_1017_nonSitesInSitesSpace() throws Exception {
        String testTitlePrefix = TEST_TITLE.substring(0, 9);
        List<SiteInfo> sites = this.siteService.listSites(null, null);
        SiteServiceImplTest.assertNotNull((String)"sites list was null.", sites);
        int preexistingSitesCount = sites.size();
        SiteInfo site1 = this.siteService.createSite(TEST_SITE_PRESET, "mySiteOne", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        SiteInfo site2 = this.siteService.createSite(TEST_SITE_PRESET, "mySiteTwo", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PRIVATE);
        sites = this.siteService.listSites(null, null);
        SiteServiceImplTest.assertNotNull((String)"sites list was null.", sites);
        SiteServiceImplTest.assertEquals((int)(preexistingSitesCount + 2), (int)sites.size());
        final NodeRef sitesSpace = this.nodeService.getPrimaryParent(site1.getNodeRef()).getParentRef();
        NodeRef folder = (NodeRef)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                return SiteServiceImplTest.this.nodeService.createNode(sitesSpace, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"Folder"), ContentModel.TYPE_FOLDER).getChildRef();
            }
        });
        NodeRef document = (NodeRef)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                return SiteServiceImplTest.this.nodeService.createNode(sitesSpace, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"Document"), ContentModel.TYPE_CONTENT).getChildRef();
            }
        });
        sites = this.siteService.listSites(null, null);
        SiteServiceImplTest.assertNotNull((String)"sites list was null.", sites);
        SiteServiceImplTest.assertEquals((int)(preexistingSitesCount + 2), (int)sites.size());
        this.siteService.deleteSite(site2.getShortName());
        sites = this.siteService.listSites(null, null);
        SiteServiceImplTest.assertNotNull((String)"sites list was null.", sites);
        SiteServiceImplTest.assertEquals((int)(preexistingSitesCount + 1), (int)sites.size());
        this.nodeService.deleteNode(folder);
        this.nodeService.deleteNode(document);
        sites = this.siteService.listSites(null, null);
        SiteServiceImplTest.assertNotNull((String)"sites list was null.", sites);
        SiteServiceImplTest.assertEquals((int)(preexistingSitesCount + 1), (int)sites.size());
    }

    private void validatePermissionsOnRelocatedNode(SiteInfo fromSite, SiteInfo toSite, NodeRef relocatedNode, Map<String, String> expectedPermissions) {
        Set permissions = this.permissionService.getAllSetPermissions(relocatedNode);
        for (String sitePermission : SiteModel.STANDARD_PERMISSIONS) {
            String siteRoleGroup = this.siteServiceImpl.getSiteRoleGroup(fromSite.getShortName(), sitePermission, true);
            AccessPermission ap = this.getPermission(permissions, siteRoleGroup);
            SiteServiceImplTest.assertNull((String)("Permission " + siteRoleGroup + " was unexpectedly present"), (Object)ap);
        }
        for (String authority : expectedPermissions.keySet()) {
            AccessPermission ap = this.getPermission(permissions, authority);
            SiteServiceImplTest.assertNotNull((String)("Permission " + authority + " missing"), (Object)ap);
            SiteServiceImplTest.assertEquals((String)authority, (String)ap.getAuthority());
            SiteServiceImplTest.assertEquals((String)("Wrong permission for " + authority), (String)expectedPermissions.get(authority), (String)ap.getPermission());
            SiteServiceImplTest.assertTrue((boolean)ap.isInherited());
        }
    }

    private AccessPermission getPermission(Set<AccessPermission> permissions, String expectedAuthority) {
        AccessPermission result = null;
        for (AccessPermission ap : permissions) {
            if (!expectedAuthority.equals(ap.getAuthority())) continue;
            result = ap;
        }
        return result;
    }

    public void testPermissionsAfterMovingFolderBetweenSites() throws Exception {
        this.alf8036Impl(false);
    }

    public void testJSAPI() throws Exception {
        SiteInfo siteInfo = this.siteService.createSite(TEST_SITE_PRESET, "mySiteWithCustomProperty", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        NodeRef siteNodeRef = siteInfo.getNodeRef();
        HashMap<QName, String> properties = new HashMap<QName, String>(1);
        properties.put(QName.createQName((String)"http://www.alfresco.org/model/sitecustomproperty/1.0", (String)"additionalInformation"), "information");
        this.nodeService.addAspect(siteNodeRef, QName.createQName((String)"http://www.alfresco.org/model/site/1.0", (String)"customSiteProperties"), properties);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("customSiteName", "mySiteWithCustomProperty");
        model.put("preexistingSiteCount", this.siteService.listSites(null, null).size());
        ClasspathScriptLocation location = new ClasspathScriptLocation("org/alfresco/repo/site/script/test_siteService.js");
        this.scriptService.executeScript(location, model);
    }
}

