/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.site.script;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.site.script.Site;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.surf.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptSiteService
extends BaseScopableProcessorExtension {
    public static final String PUBLIC_SITE = "PUBLIC";
    public static final String MODERATED_SITE = "MODERATED";
    public static final String PRIVATE_SITE = "PRIVATE";
    private ServiceRegistry serviceRegistry;
    private SiteService siteService;

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public Site createSite(String sitePreset, String shortName, String title, String description, boolean isPublic) {
        SiteInfo siteInfo = this.siteService.createSite(sitePreset, shortName, title, description, isPublic);
        return new Site(siteInfo, this.serviceRegistry, this.siteService, this.getScope());
    }

    public Site createSite(String sitePreset, String shortName, String title, String description, String visibility) {
        ParameterCheck.mandatoryString((String)"visibility", (String)visibility);
        SiteVisibility siteVisibility = SiteVisibility.valueOf(visibility);
        SiteInfo siteInfo = this.siteService.createSite(sitePreset, shortName, title, description, siteVisibility);
        return new Site(siteInfo, this.serviceRegistry, this.siteService, this.getScope());
    }

    public Site createSite(String sitePreset, String shortName, String title, String description, String visibility, String siteType) {
        ParameterCheck.mandatoryString((String)"visibility", (String)visibility);
        SiteVisibility siteVisibility = SiteVisibility.valueOf(visibility);
        QName siteTypeQName = QName.createQName((String)siteType);
        SiteInfo siteInfo = this.siteService.createSite(sitePreset, shortName, title, description, siteVisibility, siteTypeQName);
        return new Site(siteInfo, this.serviceRegistry, this.siteService, this.getScope());
    }

    public boolean hasCreateSitePermissions() {
        return this.siteService.hasCreateSitePermissions();
    }

    public boolean isSiteManager(String siteId) {
        String role = this.siteService.getMembersRole(siteId, AuthenticationUtil.getFullyAuthenticatedUser());
        return "SiteManager".equals(role);
    }

    public Site[] getSites(String filter, String sitePresetFilter, int size) {
        if (filter != null && (filter.length() == 0 || filter.equals("*"))) {
            filter = null;
        }
        if (filter != null && filter.startsWith("*")) {
            filter = filter.substring(1, filter.length());
            return this.findSites(filter, sitePresetFilter, size);
        }
        return this.listSites(filter, sitePresetFilter, size);
    }

    public Site[] listSites(String filter, String sitePresetFilter) {
        return this.listSites(filter, sitePresetFilter, -1);
    }

    public Site[] listSites(String filter, String sitePresetFilter, int size) {
        List<SiteInfo> siteInfos = this.siteService.listSites(filter, sitePresetFilter, size);
        return this.makeSitesArray(siteInfos);
    }

    public Site[] findSites(String filter, String sitePresetFilter, int size) {
        List<SiteInfo> siteInfos = this.siteService.findSites(filter, sitePresetFilter, size);
        return this.makeSitesArray(siteInfos);
    }

    protected Site[] makeSitesArray(List<SiteInfo> siteInfos) {
        ArrayList<Site> sites = new ArrayList<Site>(siteInfos.size());
        for (SiteInfo siteInfo : siteInfos) {
            sites.add(new Site(siteInfo, this.serviceRegistry, this.siteService, this.getScope()));
        }
        return sites.toArray(new Site[sites.size()]);
    }

    public Site[] listUserSites(String userName, int size) {
        List<SiteInfo> siteInfos = this.siteService.listSites(userName, size);
        ArrayList<Site> sites = new ArrayList<Site>(siteInfos.size());
        for (SiteInfo siteInfo : siteInfos) {
            sites.add(new Site(siteInfo, this.serviceRegistry, this.siteService, this.getScope()));
        }
        return sites.toArray(new Site[sites.size()]);
    }

    public Site[] listUserSites(String userName) {
        return this.listUserSites(userName, 0);
    }

    public Site getSite(String shortName) {
        Site site = null;
        SiteInfo siteInfo = this.siteService.getSite(shortName);
        if (siteInfo != null) {
            site = new Site(siteInfo, this.serviceRegistry, this.siteService, this.getScope());
        }
        return site;
    }

    public String[] listSiteRoles() {
        List<String> roles = this.siteService.getSiteRoles();
        return roles.toArray(new String[roles.size()]);
    }

    public void cleanSitePermissions(NodeRef targetNode) {
        this.siteService.cleanSitePermissions(targetNode, null);
    }

    public void cleanSitePermissions(ScriptNode targetNode) {
        this.cleanSitePermissions(targetNode.getNodeRef());
    }

    public String[] listSiteRoles(String shortName) {
        List<String> roles = this.siteService.getSiteRoles(shortName);
        return roles.toArray(new String[roles.size()]);
    }
}

