/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tagging;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionModel;
import org.alfresco.repo.action.AsynchronousActionExecutionQueuePolicies;
import org.alfresco.repo.jscript.ClasspathScriptLocation;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tagging.TagScopePropertyMethodInterceptor;
import org.alfresco.repo.tagging.UpdateTagScopesActionExecuter;
import org.alfresco.repo.tagging.UpdateTagScopesQuartzJob;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.ActionTrackingService;
import org.alfresco.service.cmr.action.ExecutionSummary;
import org.alfresco.service.cmr.audit.AuditService;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.ScriptService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.tagging.TagDetails;
import org.alfresco.service.cmr.tagging.TagScope;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ConfigurableApplicationContext;

public class TaggingServiceImplTest
extends TestCase {
    private static ConfigurableApplicationContext ctx = (ConfigurableApplicationContext)ApplicationContextHelper.getApplicationContext();
    private static final Log logger = LogFactory.getLog(TaggingServiceImplTest.class);
    private TaggingService taggingService;
    private NodeService nodeService;
    private CopyService copyService;
    private CheckOutCheckInService checkOutCheckInService;
    private ScriptService scriptService;
    private AuditService auditService;
    private ActionService actionService;
    private ActionTrackingService actionTrackingService;
    private TransactionService transactionService;
    private AuthenticationComponent authenticationComponent;
    private PersonService personService;
    private PermissionService permissionService;
    private MutableAuthenticationService authenticationService;
    private AsyncOccurs asyncOccurs;
    private static StoreRef storeRef;
    private static NodeRef rootNode;
    private NodeRef folder;
    private NodeRef subFolder;
    private NodeRef document;
    private NodeRef subDocument;
    private static final String TAG_1 = "tag one";
    private static final String TAG_2 = "tag two";
    private static final String TAG_3 = "Tag Three";
    private static final String TAG_4 = "tag four";
    private static final String TAG_5 = "tag five";
    private static final String TAG_I18N = "\u00e0\u00e2\u00e6\u00e7\u00e9\u00e8\u00ea\u00eb\u00ee\u00ef\u00f4\u0153\u00f9\u00fb\u00fc\u00ff\u00f1";
    private static final String UPPER_TAG = "House";
    private static final String LOWER_TAG = "house";
    private static boolean init;

    protected void setUp() throws Exception {
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            throw new IllegalStateException("There should not be any transactions when starting test: " + AlfrescoTransactionSupport.getTransactionId() + " started at " + new Date(AlfrescoTransactionSupport.getTransactionStartTime()));
        }
        this.taggingService = (TaggingService)ctx.getBean("TaggingService");
        this.nodeService = (NodeService)ctx.getBean("NodeService");
        this.copyService = (CopyService)ctx.getBean("CopyService");
        this.checkOutCheckInService = (CheckOutCheckInService)ctx.getBean("CheckoutCheckinService");
        this.actionService = (ActionService)ctx.getBean("ActionService");
        this.transactionService = (TransactionService)ctx.getBean("transactionComponent");
        this.auditService = (AuditService)ctx.getBean("auditService");
        this.scriptService = (ScriptService)ctx.getBean("scriptService");
        this.actionTrackingService = (ActionTrackingService)ctx.getBean("actionTrackingService");
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.personService = (PersonService)ctx.getBean("PersonService");
        this.permissionService = (PermissionService)ctx.getBean("PermissionService");
        this.authenticationService = (MutableAuthenticationService)ctx.getBean("authenticationService");
        if (!init) {
            this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                @Override
                public Void execute() throws Throwable {
                    TaggingServiceImplTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                    storeRef = TaggingServiceImplTest.this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
                    rootNode = TaggingServiceImplTest.this.nodeService.getRootNode(storeRef);
                    NodeRef catContainer = TaggingServiceImplTest.this.nodeService.createNode(rootNode, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"categoryContainer"), ContentModel.TYPE_CONTAINER).getChildRef();
                    NodeRef catRoot = TaggingServiceImplTest.this.nodeService.createNode(catContainer, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"categoryRoot"), ContentModel.TYPE_CATEGORYROOT).getChildRef();
                    TaggingServiceImplTest.this.nodeService.createNode(catRoot, ContentModel.ASSOC_CATEGORIES, ContentModel.ASPECT_TAGGABLE, ContentModel.TYPE_CATEGORY).getChildRef();
                    init = true;
                    return null;
                }
            });
        }
        this.asyncOccurs = new AsyncOccurs();
        ((PolicyComponent)ctx.getBean("policyComponent")).bindClassBehaviour(AsynchronousActionExecutionQueuePolicies.OnAsyncActionExecute.QNAME, ActionModel.TYPE_ACTION, (Behaviour)new JavaBehaviour(this.asyncOccurs, "onAsyncActionExecute", Behaviour.NotificationFrequency.EVERY_EVENT));
        UpdateTagScopesActionExecuter updateTagsAction = (UpdateTagScopesActionExecuter)ctx.getBean("update-tagscope");
        updateTagsAction.setTrackStatus(true);
        this.createTestDocumentsAndFolders();
    }

    protected void tearDown() throws Exception {
        this.removeTestDocumentsAndFolders();
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            TaggingServiceImplTest.fail((String)"Test is not transaction-safe.  Fix up transaction handling and re-test.");
        }
    }

    private void createTestDocumentsAndFolders() throws Exception {
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                String guid = GUID.generate();
                HashMap<QName, String> folderProps = new HashMap<QName, String>(1);
                folderProps.put(ContentModel.PROP_NAME, "testFolder" + guid);
                TaggingServiceImplTest.this.folder = TaggingServiceImplTest.this.nodeService.createNode(rootNode, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("testFolder" + guid)), ContentModel.TYPE_FOLDER, folderProps).getChildRef();
                HashMap<QName, String> docProps = new HashMap<QName, String>(1);
                docProps.put(ContentModel.PROP_NAME, "testDocument" + guid + ".txt");
                TaggingServiceImplTest.this.document = TaggingServiceImplTest.this.nodeService.createNode(TaggingServiceImplTest.this.folder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("testDocument" + guid + ".txt")), ContentModel.TYPE_CONTENT, docProps).getChildRef();
                HashMap<QName, String> props = new HashMap<QName, String>(1);
                props.put(ContentModel.PROP_NAME, "subFolder" + guid);
                TaggingServiceImplTest.this.subFolder = TaggingServiceImplTest.this.nodeService.createNode(TaggingServiceImplTest.this.folder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("subFolder" + guid)), ContentModel.TYPE_FOLDER, props).getChildRef();
                props = new HashMap(1);
                props.put(ContentModel.PROP_NAME, "subDocument" + guid + ".txt");
                TaggingServiceImplTest.this.subDocument = TaggingServiceImplTest.this.nodeService.createNode(TaggingServiceImplTest.this.subFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("subDocument" + guid + ".txt")), ContentModel.TYPE_CONTENT, props).getChildRef();
                return null;
            }
        });
    }

    private void removeTestDocumentsAndFolders() throws Exception {
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                NodeRef[] nodes;
                TaggingServiceImplTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                for (NodeRef nodeRef : nodes = new NodeRef[]{TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.this.subFolder, TaggingServiceImplTest.this.document, TaggingServiceImplTest.this.folder}) {
                    if (!TaggingServiceImplTest.this.taggingService.isTagScope(nodeRef)) continue;
                    TaggingServiceImplTest.this.taggingService.removeTagScope(nodeRef);
                }
                for (NodeRef nodeRef : nodes) {
                    TaggingServiceImplTest.this.nodeService.deleteNode(nodeRef);
                }
                TaggingServiceImplTest.this.auditService.clearAudit("Alfresco Tagging Service", 0L, System.currentTimeMillis() + 1L);
                return null;
            }
        });
    }

    public void testTagCRUD() throws Exception {
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                List<String> tags = TaggingServiceImplTest.this.taggingService.getTags(storeRef);
                Assert.assertNotNull(tags);
                Assert.assertEquals((int)0, (int)tags.size());
                TaggingServiceImplTest.this.taggingService.createTag(storeRef, TaggingServiceImplTest.TAG_1);
                TaggingServiceImplTest.this.taggingService.createTag(storeRef, TaggingServiceImplTest.UPPER_TAG);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                List<String> tags = TaggingServiceImplTest.this.taggingService.getTags(storeRef);
                Assert.assertNotNull(tags);
                Assert.assertEquals((int)2, (int)tags.size());
                Assert.assertTrue((boolean)tags.contains(TaggingServiceImplTest.TAG_1));
                Assert.assertTrue((boolean)tags.contains(TaggingServiceImplTest.LOWER_TAG));
                Assert.assertFalse((boolean)TaggingServiceImplTest.this.taggingService.isTag(storeRef, TaggingServiceImplTest.TAG_2));
                Assert.assertTrue((boolean)TaggingServiceImplTest.this.taggingService.isTag(storeRef, TaggingServiceImplTest.TAG_1));
                Assert.assertTrue((boolean)TaggingServiceImplTest.this.taggingService.isTag(storeRef, TaggingServiceImplTest.UPPER_TAG));
                Assert.assertTrue((boolean)TaggingServiceImplTest.this.taggingService.isTag(storeRef, TaggingServiceImplTest.LOWER_TAG));
                TaggingServiceImplTest.this.taggingService.deleteTag(storeRef, TaggingServiceImplTest.UPPER_TAG);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                List<String> tags = TaggingServiceImplTest.this.taggingService.getTags(storeRef);
                Assert.assertNotNull(tags);
                Assert.assertEquals((int)1, (int)tags.size());
                Assert.assertTrue((boolean)tags.contains(TaggingServiceImplTest.TAG_1));
                Assert.assertFalse((boolean)tags.contains(TaggingServiceImplTest.LOWER_TAG));
                Assert.assertFalse((boolean)TaggingServiceImplTest.this.taggingService.isTag(storeRef, TaggingServiceImplTest.TAG_2));
                Assert.assertTrue((boolean)TaggingServiceImplTest.this.taggingService.isTag(storeRef, TaggingServiceImplTest.TAG_1));
                Assert.assertFalse((boolean)TaggingServiceImplTest.this.taggingService.isTag(storeRef, TaggingServiceImplTest.UPPER_TAG));
                Assert.assertFalse((boolean)TaggingServiceImplTest.this.taggingService.isTag(storeRef, TaggingServiceImplTest.LOWER_TAG));
                return null;
            }
        });
    }

    public void testAddRemoveTag() throws Exception {
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                List<String> tags = TaggingServiceImplTest.this.taggingService.getTags(TaggingServiceImplTest.this.document);
                Assert.assertNotNull(tags);
                Assert.assertTrue((boolean)tags.isEmpty());
                Assert.assertFalse((boolean)TaggingServiceImplTest.this.taggingService.hasTag(TaggingServiceImplTest.this.document, TaggingServiceImplTest.TAG_1));
                Assert.assertTrue((boolean)TaggingServiceImplTest.this.taggingService.isTag(storeRef, TaggingServiceImplTest.TAG_1));
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.document, TaggingServiceImplTest.TAG_1);
                tags = TaggingServiceImplTest.this.taggingService.getTags(TaggingServiceImplTest.this.document);
                Assert.assertNotNull(tags);
                Assert.assertEquals((int)1, (int)tags.size());
                Assert.assertTrue((boolean)tags.contains(TaggingServiceImplTest.TAG_1));
                Assert.assertTrue((boolean)TaggingServiceImplTest.this.taggingService.hasTag(TaggingServiceImplTest.this.document, TaggingServiceImplTest.TAG_1));
                Assert.assertFalse((boolean)TaggingServiceImplTest.this.taggingService.isTag(storeRef, TaggingServiceImplTest.TAG_2));
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.document, TaggingServiceImplTest.TAG_2);
                Assert.assertTrue((boolean)TaggingServiceImplTest.this.taggingService.isTag(storeRef, TaggingServiceImplTest.TAG_2));
                tags = TaggingServiceImplTest.this.taggingService.getTags(TaggingServiceImplTest.this.document);
                Assert.assertNotNull(tags);
                Assert.assertEquals((int)2, (int)tags.size());
                Assert.assertTrue((boolean)tags.contains(TaggingServiceImplTest.TAG_1));
                Assert.assertTrue((boolean)tags.contains(TaggingServiceImplTest.TAG_2));
                Assert.assertTrue((boolean)TaggingServiceImplTest.this.taggingService.hasTag(TaggingServiceImplTest.this.document, TaggingServiceImplTest.TAG_1));
                Assert.assertTrue((boolean)TaggingServiceImplTest.this.taggingService.hasTag(TaggingServiceImplTest.this.document, TaggingServiceImplTest.TAG_2));
                TaggingServiceImplTest.this.taggingService.removeTag(TaggingServiceImplTest.this.document, TaggingServiceImplTest.TAG_1);
                tags = TaggingServiceImplTest.this.taggingService.getTags(TaggingServiceImplTest.this.document);
                Assert.assertNotNull(tags);
                Assert.assertEquals((int)1, (int)tags.size());
                Assert.assertFalse((boolean)tags.contains(TaggingServiceImplTest.TAG_1));
                Assert.assertFalse((boolean)TaggingServiceImplTest.this.taggingService.hasTag(TaggingServiceImplTest.this.document, TaggingServiceImplTest.TAG_1));
                Assert.assertTrue((boolean)tags.contains(TaggingServiceImplTest.TAG_2));
                Assert.assertTrue((boolean)TaggingServiceImplTest.this.taggingService.hasTag(TaggingServiceImplTest.this.document, TaggingServiceImplTest.TAG_2));
                ArrayList<String> setTags = new ArrayList<String>(2);
                setTags.add(TaggingServiceImplTest.TAG_3);
                setTags.add(TaggingServiceImplTest.TAG_1);
                TaggingServiceImplTest.this.taggingService.setTags(TaggingServiceImplTest.this.document, setTags);
                tags = TaggingServiceImplTest.this.taggingService.getTags(TaggingServiceImplTest.this.document);
                Assert.assertNotNull(tags);
                Assert.assertEquals((int)2, (int)tags.size());
                Assert.assertTrue((boolean)tags.contains(TaggingServiceImplTest.TAG_1));
                Assert.assertFalse((boolean)tags.contains(TaggingServiceImplTest.TAG_2));
                Assert.assertTrue((boolean)tags.contains(TaggingServiceImplTest.TAG_3.toLowerCase()));
                TaggingServiceImplTest.this.taggingService.clearTags(TaggingServiceImplTest.this.document);
                tags = TaggingServiceImplTest.this.taggingService.getTags(TaggingServiceImplTest.this.document);
                Assert.assertNotNull(tags);
                Assert.assertTrue((boolean)tags.isEmpty());
                return null;
            }
        });
    }

    public void testTagScopeFindAddRemove() throws Exception {
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TagScope tagScope = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.subDocument);
                Assert.assertNull((Object)tagScope);
                List<TagScope> tagScopes = TaggingServiceImplTest.this.taggingService.findAllTagScopes(TaggingServiceImplTest.this.subDocument);
                Assert.assertNotNull(tagScopes);
                Assert.assertEquals((int)0, (int)tagScopes.size());
                TaggingServiceImplTest.this.taggingService.addTagScope(TaggingServiceImplTest.this.folder);
                TaggingServiceImplTest.this.taggingService.addTagScope(TaggingServiceImplTest.this.subFolder);
                tagScope = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.subDocument);
                Assert.assertNotNull((Object)tagScope);
                tagScopes = TaggingServiceImplTest.this.taggingService.findAllTagScopes(TaggingServiceImplTest.this.subDocument);
                Assert.assertNotNull(tagScopes);
                Assert.assertEquals((int)2, (int)tagScopes.size());
                tagScope = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.subFolder);
                Assert.assertNotNull((Object)tagScope);
                tagScopes = TaggingServiceImplTest.this.taggingService.findAllTagScopes(TaggingServiceImplTest.this.subFolder);
                Assert.assertNotNull(tagScopes);
                Assert.assertEquals((int)2, (int)tagScopes.size());
                tagScope = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.folder);
                Assert.assertNotNull((Object)tagScope);
                tagScopes = TaggingServiceImplTest.this.taggingService.findAllTagScopes(TaggingServiceImplTest.this.folder);
                Assert.assertNotNull(tagScopes);
                Assert.assertEquals((int)1, (int)tagScopes.size());
                TaggingServiceImplTest.this.taggingService.removeTagScope(TaggingServiceImplTest.this.folder);
                tagScope = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.subDocument);
                Assert.assertNotNull((Object)tagScope);
                tagScopes = TaggingServiceImplTest.this.taggingService.findAllTagScopes(TaggingServiceImplTest.this.subDocument);
                Assert.assertNotNull(tagScopes);
                Assert.assertEquals((int)1, (int)tagScopes.size());
                tagScope = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.subFolder);
                Assert.assertNotNull((Object)tagScope);
                tagScopes = TaggingServiceImplTest.this.taggingService.findAllTagScopes(TaggingServiceImplTest.this.subFolder);
                Assert.assertNotNull(tagScopes);
                Assert.assertEquals((int)1, (int)tagScopes.size());
                tagScope = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.folder);
                Assert.assertNull((Object)tagScope);
                tagScopes = TaggingServiceImplTest.this.taggingService.findAllTagScopes(TaggingServiceImplTest.this.folder);
                Assert.assertNotNull(tagScopes);
                Assert.assertEquals((int)0, (int)tagScopes.size());
                return null;
            }
        });
    }

    public void testTagScope() throws Exception {
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTagScope(TaggingServiceImplTest.this.folder);
                TaggingServiceImplTest.this.taggingService.addTagScope(TaggingServiceImplTest.this.subFolder);
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_1);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_2);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_3);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subFolder, TaggingServiceImplTest.TAG_1);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subFolder, TaggingServiceImplTest.TAG_2);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.folder, TaggingServiceImplTest.TAG_2);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TagScope ts1 = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.subDocument);
                TagScope ts2 = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.folder);
                Assert.assertEquals((String)("Wrong tags on sub folder: " + ts1.getTags()), (int)3, (int)ts1.getTags().size());
                Assert.assertEquals((String)("Wrong tags on main folder: " + ts2.getTags()), (int)3, (int)ts2.getTags().size());
                Assert.assertEquals((int)2, (int)ts1.getTags().get(0).getCount());
                Assert.assertEquals((int)2, (int)ts1.getTags().get(1).getCount());
                Assert.assertEquals((int)1, (int)ts1.getTags().get(2).getCount());
                Assert.assertEquals((String)TaggingServiceImplTest.TAG_1, (String)ts1.getTags().get(0).getName());
                Assert.assertEquals((String)TaggingServiceImplTest.TAG_2, (String)ts1.getTags().get(1).getName());
                Assert.assertEquals((String)TaggingServiceImplTest.TAG_3.toLowerCase(), (String)ts1.getTags().get(2).getName());
                Assert.assertEquals((int)3, (int)ts2.getTags().get(0).getCount());
                Assert.assertEquals((int)2, (int)ts2.getTags().get(1).getCount());
                Assert.assertEquals((int)1, (int)ts2.getTags().get(2).getCount());
                Assert.assertEquals((String)TaggingServiceImplTest.TAG_2, (String)ts2.getTags().get(0).getName());
                Assert.assertEquals((String)TaggingServiceImplTest.TAG_1, (String)ts2.getTags().get(1).getName());
                Assert.assertEquals((String)TaggingServiceImplTest.TAG_3.toLowerCase(), (String)ts2.getTags().get(2).getName());
                TaggingServiceImplTest.this.taggingService.removeTag(TaggingServiceImplTest.this.folder, TaggingServiceImplTest.TAG_2);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.removeTag(TaggingServiceImplTest.this.subFolder, TaggingServiceImplTest.TAG_2);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.removeTag(TaggingServiceImplTest.this.subFolder, TaggingServiceImplTest.TAG_1);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.removeTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_1);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.folder, TaggingServiceImplTest.TAG_3);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TagScope ts1 = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.subDocument);
                TagScope ts2 = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.folder);
                Assert.assertEquals((String)("Wrong tags on sub folder: " + ts1.getTags()), (int)2, (int)ts1.getTags().size());
                Assert.assertEquals((String)("Wrong tags on main folder: " + ts2.getTags()), (int)2, (int)ts2.getTags().size());
                Assert.assertEquals((int)1, (int)ts1.getTags().get(0).getCount());
                Assert.assertEquals((int)1, (int)ts1.getTags().get(1).getCount());
                Assert.assertEquals((String)TaggingServiceImplTest.TAG_2, (String)ts1.getTags().get(0).getName());
                Assert.assertEquals((String)TaggingServiceImplTest.TAG_3.toLowerCase(), (String)ts1.getTags().get(1).getName());
                Assert.assertEquals((int)2, (int)ts2.getTags().get(0).getCount());
                Assert.assertEquals((int)1, (int)ts2.getTags().get(1).getCount());
                Assert.assertEquals((String)TaggingServiceImplTest.TAG_3.toLowerCase(), (String)ts2.getTags().get(0).getName());
                Assert.assertEquals((String)TaggingServiceImplTest.TAG_2, (String)ts2.getTags().get(1).getName());
                return null;
            }
        });
    }

    public void testTagScopeSummary() throws Exception {
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTagScope(TaggingServiceImplTest.this.folder);
                TaggingServiceImplTest.this.taggingService.addTagScope(TaggingServiceImplTest.this.subFolder);
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_1);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_2);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_3);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subFolder, TaggingServiceImplTest.TAG_1);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subFolder, TaggingServiceImplTest.TAG_2);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.folder, TaggingServiceImplTest.TAG_2);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TagScopePropertyMethodInterceptor.setEnabled(Boolean.TRUE);
                Serializable summaryObj = TaggingServiceImplTest.this.nodeService.getProperty(TaggingServiceImplTest.this.folder, ContentModel.PROP_TAGSCOPE_SUMMARY);
                Assert.assertTrue((String)("TagScopeSummary value on main folder is not of correct class: " + summaryObj.getClass().getName()), (boolean)List.class.isAssignableFrom(summaryObj.getClass()));
                Assert.assertEquals((int)3, (int)((List)((Object)summaryObj)).size());
                Serializable summaryObj2 = TaggingServiceImplTest.this.nodeService.getProperty(TaggingServiceImplTest.this.folder, ContentModel.PROP_TAGSCOPE_SUMMARY);
                Assert.assertTrue((String)"TagScopeSummary value on main folder did not come from the cache", (summaryObj == summaryObj2 ? 1 : 0) != 0);
                Map props = TaggingServiceImplTest.this.nodeService.getProperties(TaggingServiceImplTest.this.subFolder);
                Assert.assertTrue((String)"Properties of subfolder do not include tagScopeSummary", (boolean)props.containsKey(ContentModel.PROP_TAGSCOPE_SUMMARY));
                summaryObj = (Serializable)props.get(ContentModel.PROP_TAGSCOPE_SUMMARY);
                Assert.assertTrue((String)("TagScopeSummary value on subfolder is not of correct class: " + summaryObj.getClass().getName()), (boolean)List.class.isAssignableFrom(summaryObj.getClass()));
                Assert.assertEquals((int)3, (int)((List)((Object)summaryObj)).size());
                TagScopePropertyMethodInterceptor.setEnabled(Boolean.FALSE);
                summaryObj = TaggingServiceImplTest.this.nodeService.getProperty(TaggingServiceImplTest.this.folder, ContentModel.PROP_TAGSCOPE_SUMMARY);
                Assert.assertNull((String)("TagScopeSummary value on main folder should be null: " + summaryObj), (Object)summaryObj);
                props = TaggingServiceImplTest.this.nodeService.getProperties(TaggingServiceImplTest.this.subFolder);
                Assert.assertFalse((String)"Properties of subfolder should not contain tagScopeProperty", (boolean)props.containsKey(ContentModel.PROP_TAGSCOPE_SUMMARY));
                return null;
            }
        });
    }

    public void testTagScopeRefresh() throws Exception {
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_1);
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_2);
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_3);
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subFolder, TaggingServiceImplTest.TAG_1);
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subFolder, TaggingServiceImplTest.TAG_2);
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.folder, TaggingServiceImplTest.TAG_2);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTagScope(TaggingServiceImplTest.this.folder);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TagScope tagScope = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.folder);
                Assert.assertNotNull((Object)tagScope);
                Assert.assertEquals((int)3, (int)tagScope.getTags().size());
                Assert.assertEquals((int)3, (int)tagScope.getTag(TaggingServiceImplTest.TAG_2).getCount());
                Assert.assertEquals((int)2, (int)tagScope.getTag(TaggingServiceImplTest.TAG_1).getCount());
                Assert.assertEquals((int)1, (int)tagScope.getTag(TaggingServiceImplTest.TAG_3.toLowerCase()).getCount());
                return null;
            }
        });
    }

    public void testTagScopeSetUpdate() throws Exception {
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTagScope(TaggingServiceImplTest.this.folder);
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.folder, TaggingServiceImplTest.TAG_1);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.document, TaggingServiceImplTest.TAG_1);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.document, TaggingServiceImplTest.TAG_2);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_1);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_2);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_3);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subFolder, TaggingServiceImplTest.TAG_1);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TagScope ts1 = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.folder);
                Assert.assertEquals((String)("Wrong tags on folder tagscope: " + ts1.getTags()), (int)3, (int)ts1.getTags().size());
                Assert.assertEquals((int)4, (int)ts1.getTag(TaggingServiceImplTest.TAG_1).getCount());
                Assert.assertEquals((int)2, (int)ts1.getTag(TaggingServiceImplTest.TAG_2).getCount());
                Assert.assertEquals((int)1, (int)ts1.getTag(TaggingServiceImplTest.TAG_3.toLowerCase()).getCount());
                ArrayList<String> tags = new ArrayList<String>(3);
                tags.add(TaggingServiceImplTest.TAG_2);
                tags.add(TaggingServiceImplTest.TAG_3);
                tags.add(TaggingServiceImplTest.TAG_4);
                TaggingServiceImplTest.this.taggingService.setTags(TaggingServiceImplTest.this.subDocument, tags);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TagScope ts1 = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.folder);
                Assert.assertEquals((int)3, (int)ts1.getTag(TaggingServiceImplTest.TAG_1).getCount());
                Assert.assertEquals((int)2, (int)ts1.getTag(TaggingServiceImplTest.TAG_2).getCount());
                Assert.assertEquals((int)1, (int)ts1.getTag(TaggingServiceImplTest.TAG_3.toLowerCase()).getCount());
                Assert.assertEquals((int)1, (int)ts1.getTag(TaggingServiceImplTest.TAG_4).getCount());
                return null;
            }
        });
    }

    public void testETHREEOH_220() throws Exception {
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTagScope(TaggingServiceImplTest.this.folder);
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.folder, TaggingServiceImplTest.TAG_I18N);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                List<String> tags = TaggingServiceImplTest.this.taggingService.getTags(TaggingServiceImplTest.this.folder);
                Assert.assertNotNull(tags);
                Assert.assertEquals((int)1, (int)tags.size());
                Assert.assertEquals((String)TaggingServiceImplTest.TAG_I18N, (String)tags.get(0));
                TagScope tagScope = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.folder);
                Assert.assertNotNull((Object)tagScope);
                Assert.assertEquals((int)1, (int)tagScope.getTags().size());
                TagDetails tagDetails = tagScope.getTag(TaggingServiceImplTest.TAG_I18N);
                Assert.assertNotNull((Object)tagDetails);
                Assert.assertEquals((String)TaggingServiceImplTest.TAG_I18N, (String)tagDetails.getName());
                Assert.assertEquals((int)1, (int)tagDetails.getCount());
                return null;
            }
        });
    }

    public void testTagScopeUpdateViaNodePolicies() throws Exception {
        class TestData {
            public NodeRef tagFoo1;
            public NodeRef tagFoo2;
            public NodeRef tagFoo3;
            public NodeRef tagBar;
            public NodeRef container1;
            public NodeRef container2;
            public NodeRef taggedFolder;
            public NodeRef taggedFolder2;
            public NodeRef taggedDoc;
            public NodeRef taggedDoc2;
            public NodeRef checkedOutDoc;

            TestData() {
            }
        }
        final TestData testData = new TestData();
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                testData.tagFoo1 = TaggingServiceImplTest.this.taggingService.createTag(TaggingServiceImplTest.this.folder.getStoreRef(), "Foo1");
                testData.tagFoo2 = TaggingServiceImplTest.this.taggingService.createTag(TaggingServiceImplTest.this.folder.getStoreRef(), "Foo2");
                testData.tagFoo3 = TaggingServiceImplTest.this.taggingService.createTag(TaggingServiceImplTest.this.folder.getStoreRef(), "Foo3");
                testData.tagBar = TaggingServiceImplTest.this.taggingService.createTag(TaggingServiceImplTest.this.folder.getStoreRef(), "Bar");
                ArrayList tagsList = new ArrayList();
                HashMap<QName, String> container1Props = new HashMap<QName, String>(1);
                container1Props.put(ContentModel.PROP_NAME, "Container1");
                testData.container1 = TaggingServiceImplTest.this.nodeService.createNode(TaggingServiceImplTest.this.folder, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_FOLDER, container1Props).getChildRef();
                Assert.assertEquals((int)0, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container1).size());
                HashMap container2Props = new HashMap(1);
                container1Props.put(ContentModel.PROP_NAME, "Container2");
                testData.container2 = TaggingServiceImplTest.this.nodeService.createNode(TaggingServiceImplTest.this.folder, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_FOLDER, container2Props).getChildRef();
                Assert.assertEquals((int)0, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container2).size());
                TaggingServiceImplTest.this.taggingService.addTagScope(testData.container1);
                TaggingServiceImplTest.this.taggingService.addTagScope(testData.container2);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                Assert.assertTrue((boolean)TaggingServiceImplTest.this.taggingService.isTagScope(testData.container1));
                Assert.assertTrue((boolean)TaggingServiceImplTest.this.taggingService.isTagScope(testData.container2));
                Assert.assertEquals((int)0, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTags().size());
                Assert.assertEquals((int)0, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTags().size());
                HashMap<QName, String> taggedFolderProps = new HashMap<QName, String>(1);
                taggedFolderProps.put(ContentModel.PROP_NAME, "Folder");
                testData.taggedFolder = TaggingServiceImplTest.this.nodeService.createNode(testData.container1, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_FOLDER, taggedFolderProps).getChildRef();
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                Assert.assertEquals((int)0, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTags().size());
                Assert.assertEquals((int)0, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTags().size());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container1).size());
                HashMap<QName, Serializable> taggedFolderProps = new HashMap<QName, Serializable>(1);
                ArrayList<NodeRef> tagsList = new ArrayList<NodeRef>();
                tagsList.add(testData.tagFoo1);
                tagsList.add(testData.tagFoo3);
                taggedFolderProps.put(ContentModel.ASPECT_TAGGABLE, tagsList);
                TaggingServiceImplTest.this.nodeService.addProperties(testData.taggedFolder, taggedFolderProps);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                Assert.assertEquals((String)("Unexpected tags " + TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTags()), (int)2, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTags().size());
                Assert.assertEquals((String)("Unexpected tags " + TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTags()), (int)0, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTags().size());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo1").getCount());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo3").getCount());
                ArrayList<NodeRef> tagsList = new ArrayList<NodeRef>();
                tagsList.add(testData.tagFoo1);
                tagsList.add(testData.tagFoo2);
                HashMap<QName, Object> taggedDocProps = new HashMap<QName, Object>(1);
                taggedDocProps.put(ContentModel.PROP_NAME, "Document");
                taggedDocProps.put(ContentModel.ASPECT_TAGGABLE, tagsList);
                testData.taggedDoc = TaggingServiceImplTest.this.nodeService.createNode(testData.taggedFolder, ContentModel.ASSOC_CONTAINS, ContentModel.ASPECT_TAGGABLE, ContentModel.TYPE_CONTENT, taggedDocProps).getChildRef();
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                Assert.assertEquals((int)3, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTags().size());
                Assert.assertEquals((int)0, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTags().size());
                Assert.assertEquals((int)2, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo1").getCount());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo2").getCount());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo3").getCount());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container1).size());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.taggedFolder).size());
                testData.checkedOutDoc = TaggingServiceImplTest.this.checkOutCheckInService.checkout(testData.taggedDoc);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                Assert.assertEquals((int)3, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTags().size());
                Assert.assertEquals((int)0, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTags().size());
                Assert.assertEquals((int)3, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo1").getCount());
                Assert.assertEquals((int)2, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo2").getCount());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo3").getCount());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container1).size());
                Assert.assertEquals((int)2, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.taggedFolder).size());
                TaggingServiceImplTest.this.checkOutCheckInService.checkin(testData.checkedOutDoc, null);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                Assert.assertEquals((int)3, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTags().size());
                Assert.assertEquals((int)0, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTags().size());
                Assert.assertEquals((int)2, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo1").getCount());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo2").getCount());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo3").getCount());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container1).size());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.taggedFolder).size());
                HashMap<QName, String> taggedDocProps = new HashMap<QName, String>(1);
                taggedDocProps.put(ContentModel.PROP_NAME, "CopyDoc");
                Assert.assertEquals((int)0, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container2).size());
                testData.taggedDoc2 = TaggingServiceImplTest.this.nodeService.createNode(testData.container2, ContentModel.ASSOC_CONTAINS, ContentModel.ASPECT_TAGGABLE, ContentModel.TYPE_CONTENT, taggedDocProps).getChildRef();
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                Assert.assertEquals((int)3, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTags().size());
                Assert.assertEquals((int)0, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTags().size());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container2).size());
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.copyService.copy(testData.taggedDoc, testData.taggedDoc2);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                Assert.assertEquals((int)3, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTags().size());
                Assert.assertEquals((int)2, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTags().size());
                Assert.assertEquals((int)2, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo1").getCount());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo2").getCount());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo3").getCount());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo1").getCount());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo2").getCount());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container2).size());
                Assert.assertEquals((Object)testData.container2, (Object)TaggingServiceImplTest.this.nodeService.getPrimaryParent(testData.taggedDoc2).getParentRef());
                Assert.assertEquals((Object)testData.container2, (Object)TaggingServiceImplTest.this.taggingService.findTagScope(testData.taggedDoc2).getNodeRef());
                testData.taggedFolder2 = TaggingServiceImplTest.this.copyService.copy(testData.taggedFolder, testData.container2, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CHILDREN, true);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                Assert.assertEquals((int)3, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTags().size());
                Assert.assertEquals((int)3, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTags().size());
                Assert.assertEquals((int)2, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container2).size());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.taggedFolder2).size());
                Assert.assertEquals((int)2, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo1").getCount());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo2").getCount());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo3").getCount());
                Assert.assertEquals((int)3, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo1").getCount());
                Assert.assertEquals((int)2, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo2").getCount());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo3").getCount());
                ArrayList<NodeRef> tagsList = new ArrayList<NodeRef>();
                tagsList.add(testData.tagBar);
                HashMap<QName, Object> taggedDocProps = new HashMap<QName, Object>(1);
                taggedDocProps.put(ContentModel.ASPECT_TAGGABLE, tagsList);
                taggedDocProps.put(ContentModel.PROP_NAME, "UpdatedDocument");
                TaggingServiceImplTest.this.nodeService.addProperties(testData.taggedDoc, taggedDocProps);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                Assert.assertEquals((int)3, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTags().size());
                Assert.assertEquals((int)3, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTags().size());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo1").getCount());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo3").getCount());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("bar").getCount());
                Assert.assertEquals((int)3, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo1").getCount());
                Assert.assertEquals((int)2, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo2").getCount());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo3").getCount());
                testData.taggedDoc = TaggingServiceImplTest.this.nodeService.moveNode(testData.taggedDoc, testData.container2, ContentModel.ASSOC_CONTAINS, ContentModel.ASPECT_TAGGABLE).getChildRef();
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                Assert.assertEquals((int)2, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTags().size());
                Assert.assertEquals((int)4, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTags().size());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo1").getCount());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo3").getCount());
                Assert.assertEquals((int)3, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo1").getCount());
                Assert.assertEquals((int)2, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo2").getCount());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo3").getCount());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("bar").getCount());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container1).size());
                Assert.assertEquals((int)3, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container2).size());
                Assert.assertEquals((Object)testData.container2, (Object)TaggingServiceImplTest.this.nodeService.getPrimaryParent(testData.taggedDoc).getParentRef());
                Assert.assertEquals((Object)testData.container2, (Object)TaggingServiceImplTest.this.taggingService.findTagScope(testData.taggedDoc).getNodeRef());
                Assert.assertEquals((Object)testData.container2, (Object)TaggingServiceImplTest.this.nodeService.getPrimaryParent(testData.taggedDoc2).getParentRef());
                Assert.assertEquals((Object)testData.container2, (Object)TaggingServiceImplTest.this.taggingService.findTagScope(testData.taggedDoc2).getNodeRef());
                TaggingServiceImplTest.this.nodeService.deleteNode(testData.taggedDoc);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                Assert.assertEquals((int)2, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTags().size());
                Assert.assertEquals((int)3, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTags().size());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container1).size());
                Assert.assertEquals((int)2, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container2).size());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo1").getCount());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo3").getCount());
                Assert.assertEquals((int)3, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo1").getCount());
                Assert.assertEquals((int)2, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo2").getCount());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo3").getCount());
                Assert.assertEquals(null, (Object)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("bar"));
                TaggingServiceImplTest.this.nodeService.deleteNode(testData.taggedDoc2);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                Assert.assertEquals((int)2, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTags().size());
                Assert.assertEquals((int)3, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTags().size());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container1).size());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container2).size());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo1").getCount());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo3").getCount());
                Assert.assertEquals((int)2, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo1").getCount());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo2").getCount());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo3").getCount());
                Assert.assertEquals(null, (Object)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("bar"));
                TaggingServiceImplTest.this.nodeService.deleteNode(testData.taggedFolder);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                Assert.assertEquals((int)0, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTags().size());
                Assert.assertEquals((int)3, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTags().size());
                Assert.assertEquals((int)0, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container1).size());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container2).size());
                Assert.assertEquals((int)2, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo1").getCount());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo2").getCount());
                Assert.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo3").getCount());
                TaggingServiceImplTest.this.nodeService.deleteNode(testData.taggedFolder2);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                Assert.assertEquals((int)0, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTags().size());
                Assert.assertEquals((int)0, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTags().size());
                Assert.assertEquals((int)0, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container1).size());
                Assert.assertEquals((int)0, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container2).size());
                return null;
            }
        });
    }

    public void testPermissionsAndPolicies() throws Exception {
        class TestData {
            public NodeRef taggedNode;
            public NodeRef auditableFolder;
            public Date origModified;

            TestData() {
            }
        }
        final TestData testData = new TestData();
        String USER_1 = "User1";
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                if (TaggingServiceImplTest.this.authenticationService.authenticationExists("User1")) {
                    TaggingServiceImplTest.this.authenticationService.deleteAuthentication("User1");
                }
                if (TaggingServiceImplTest.this.personService.personExists("User1")) {
                    TaggingServiceImplTest.this.personService.deletePerson("User1");
                }
                TaggingServiceImplTest.this.authenticationService.createAuthentication("User1", "PWD".toCharArray());
                PropertyMap personProperties = new PropertyMap();
                personProperties.put(ContentModel.PROP_USERNAME, "User1");
                personProperties.put(ContentModel.PROP_AUTHORITY_DISPLAY_NAME, "titleUser1");
                personProperties.put(ContentModel.PROP_FIRSTNAME, "firstName");
                personProperties.put(ContentModel.PROP_LASTNAME, "lastName");
                personProperties.put(ContentModel.PROP_EMAIL, "User1@example.com");
                personProperties.put(ContentModel.PROP_JOBTITLE, "jobTitle");
                TaggingServiceImplTest.this.personService.createPerson(personProperties);
                NodeRef tn = TaggingServiceImplTest.this.taggingService.createTag(TaggingServiceImplTest.this.folder.getStoreRef(), "Testing");
                NodeRef tr = TaggingServiceImplTest.this.nodeService.getPrimaryParent(tn).getParentRef();
                TaggingServiceImplTest.this.permissionService.setPermission(tr, "User1", "Editor", true);
                TaggingServiceImplTest.this.permissionService.setPermission(tr, "User1", "Contributor", true);
                TaggingServiceImplTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                testData.auditableFolder = TaggingServiceImplTest.this.nodeService.createNode(TaggingServiceImplTest.this.folder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"Folder"), ContentModel.TYPE_FOLDER).getChildRef();
                TaggingServiceImplTest.this.nodeService.addAspect(testData.auditableFolder, ContentModel.ASPECT_AUDITABLE, null);
                TaggingServiceImplTest.this.taggingService.addTagScope(testData.auditableFolder);
                TaggingServiceImplTest.this.permissionService.setPermission(testData.auditableFolder, "User1", "Consumer", true);
                Assert.assertEquals((Object)"System", (Object)TaggingServiceImplTest.this.nodeService.getProperty(testData.auditableFolder, ContentModel.PROP_CREATOR));
                Assert.assertEquals((Object)"System", (Object)TaggingServiceImplTest.this.nodeService.getProperty(testData.auditableFolder, ContentModel.PROP_MODIFIER));
                testData.taggedNode = TaggingServiceImplTest.this.nodeService.createNode(testData.auditableFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"Tagged"), ContentModel.TYPE_CONTENT).getChildRef();
                TaggingServiceImplTest.this.permissionService.setPermission(testData.taggedNode, "User1", "Editor", true);
                TaggingServiceImplTest.this.authenticationComponent.setCurrentUser("User1");
                Assert.assertEquals((int)0, (int)TaggingServiceImplTest.this.taggingService.getTags(testData.taggedNode).size());
                TaggingServiceImplTest.this.nodeService.setProperty(testData.taggedNode, ContentModel.PROP_TITLE, (Serializable)((Object)"To ensure we're allowed to write"));
                TaggingServiceImplTest.this.taggingService.addTag(testData.taggedNode, TaggingServiceImplTest.TAG_1);
                TaggingServiceImplTest.this.taggingService.addTag(testData.taggedNode, TaggingServiceImplTest.TAG_2);
                Assert.assertEquals((int)2, (int)TaggingServiceImplTest.this.taggingService.getTags(testData.taggedNode).size());
                TagScope ts = TaggingServiceImplTest.this.taggingService.findTagScope(testData.taggedNode);
                Assert.assertEquals((Object)testData.auditableFolder, (Object)ts.getNodeRef());
                Assert.assertEquals((int)0, (int)ts.getTags().size());
                Assert.assertEquals((Object)"System", (Object)TaggingServiceImplTest.this.nodeService.getProperty(testData.auditableFolder, ContentModel.PROP_CREATOR));
                Assert.assertEquals((Object)"System", (Object)TaggingServiceImplTest.this.nodeService.getProperty(ts.getNodeRef(), ContentModel.PROP_MODIFIER));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                testData.origModified = (Date)TaggingServiceImplTest.this.nodeService.getProperty(testData.auditableFolder, ContentModel.PROP_MODIFIED);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                TagScope ts = TaggingServiceImplTest.this.taggingService.findTagScope(testData.taggedNode);
                Assert.assertEquals((Object)testData.auditableFolder, (Object)ts.getNodeRef());
                Assert.assertEquals((int)2, (int)ts.getTags().size());
                Assert.assertEquals((int)1, (int)ts.getTag(TaggingServiceImplTest.TAG_1).getCount());
                Assert.assertEquals((int)1, (int)ts.getTag(TaggingServiceImplTest.TAG_2).getCount());
                Assert.assertEquals((Object)"System", (Object)TaggingServiceImplTest.this.nodeService.getProperty(testData.auditableFolder, ContentModel.PROP_CREATOR));
                Assert.assertEquals((Object)"System", (Object)TaggingServiceImplTest.this.nodeService.getProperty(ts.getNodeRef(), ContentModel.PROP_MODIFIER));
                Assert.assertEquals((long)testData.origModified.getTime(), (long)((Date)TaggingServiceImplTest.this.nodeService.getProperty(testData.auditableFolder, ContentModel.PROP_MODIFIED)).getTime());
                TaggingServiceImplTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                TaggingServiceImplTest.this.authenticationService.deleteAuthentication("User1");
                TaggingServiceImplTest.this.personService.deletePerson("User1");
                return null;
            }
        });
    }

    public void testJSAPI() throws Exception {
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                HashMap<String, Object> model = new HashMap<String, Object>(0);
                model.put("folder", TaggingServiceImplTest.this.folder);
                model.put("subFolder", TaggingServiceImplTest.this.subFolder);
                model.put("document", TaggingServiceImplTest.this.document);
                model.put("subDocument", TaggingServiceImplTest.this.subDocument);
                model.put("tagScopeTest", false);
                ClasspathScriptLocation location = new ClasspathScriptLocation("org/alfresco/repo/tagging/script/test_taggingService.js");
                TaggingServiceImplTest.this.scriptService.executeScript(location, model);
                return null;
            }
        });
    }

    public void testJSTagScope() throws Exception {
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.createTag(storeRef, "alpha");
                TaggingServiceImplTest.this.taggingService.createTag(storeRef, "alpha double");
                TaggingServiceImplTest.this.taggingService.createTag(storeRef, "beta");
                TaggingServiceImplTest.this.taggingService.createTag(storeRef, "gamma");
                TaggingServiceImplTest.this.taggingService.createTag(storeRef, "delta");
                TaggingServiceImplTest.this.taggingService.addTagScope(TaggingServiceImplTest.this.folder);
                TaggingServiceImplTest.this.taggingService.addTagScope(TaggingServiceImplTest.this.subFolder);
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_1);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_2);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_3);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subFolder, TaggingServiceImplTest.TAG_1);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subFolder, TaggingServiceImplTest.TAG_2);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.document, TaggingServiceImplTest.TAG_1);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.document, TaggingServiceImplTest.TAG_2);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.folder, TaggingServiceImplTest.TAG_1);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                HashMap<String, Object> model = new HashMap<String, Object>(0);
                model.put("folder", TaggingServiceImplTest.this.folder);
                model.put("subFolder", TaggingServiceImplTest.this.subFolder);
                model.put("document", TaggingServiceImplTest.this.document);
                model.put("subDocument", TaggingServiceImplTest.this.subDocument);
                model.put("tagScopeTest", true);
                model.put("store", storeRef.toString());
                ClasspathScriptLocation location = new ClasspathScriptLocation("org/alfresco/repo/tagging/script/test_taggingService.js");
                TaggingServiceImplTest.this.scriptService.executeScript(location, model);
                return null;
            }
        });
    }

    public void testOnStartupJob() throws Exception {
        final UpdateTagScopesActionExecuter updateTagsAction = (UpdateTagScopesActionExecuter)ctx.getBean("update-tagscope");
        class TestData {
            public String lockF;
            public String lockSF;

            TestData() {
            }
        }
        final TestData testData = new TestData();
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                Assert.assertEquals((int)0, (int)updateTagsAction.searchForTagScopesPendingUpdates().size());
                testData.lockF = updateTagsAction.lockTagScope(TaggingServiceImplTest.this.folder);
                testData.lockSF = updateTagsAction.lockTagScope(TaggingServiceImplTest.this.subFolder);
                TaggingServiceImplTest.this.taggingService.addTagScope(TaggingServiceImplTest.this.folder);
                TaggingServiceImplTest.this.taggingService.addTagScope(TaggingServiceImplTest.this.subFolder);
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_1);
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_2);
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subFolder, TaggingServiceImplTest.TAG_1);
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.document, TaggingServiceImplTest.TAG_1);
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.folder, TaggingServiceImplTest.TAG_1);
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.folder, TaggingServiceImplTest.TAG_3);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                TagScope ts1 = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.folder);
                TagScope ts2 = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.subFolder);
                Assert.assertEquals((String)("Wrong tags on folder tagscope: " + ts1.getTags()), (int)0, (int)ts1.getTags().size());
                Assert.assertEquals((String)("Wrong tags on folder tagscope: " + ts1.getTags()), (int)0, (int)ts2.getTags().size());
                Assert.assertEquals((int)2, (int)updateTagsAction.searchForTagScopesPendingUpdates().size());
                List<NodeRef> pendingScopes = updateTagsAction.searchForTagScopesPendingUpdates();
                Assert.assertTrue((String)("Not found in " + pendingScopes), (boolean)pendingScopes.contains(TaggingServiceImplTest.this.folder));
                Assert.assertTrue((String)("Not found in " + pendingScopes), (boolean)pendingScopes.contains(TaggingServiceImplTest.this.subFolder));
                updateTagsAction.updateTagScopeLock(TaggingServiceImplTest.this.folder, testData.lockF);
                updateTagsAction.updateTagScopeLock(TaggingServiceImplTest.this.subFolder, testData.lockSF);
                UpdateTagScopesQuartzJob job = new UpdateTagScopesQuartzJob();
                job.execute(TaggingServiceImplTest.this.actionService, updateTagsAction);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                Assert.assertEquals((int)2, (int)updateTagsAction.searchForTagScopesPendingUpdates().size());
                List<NodeRef> pendingScopes = updateTagsAction.searchForTagScopesPendingUpdates();
                Assert.assertTrue((String)("Not found in " + pendingScopes), (boolean)pendingScopes.contains(TaggingServiceImplTest.this.folder));
                Assert.assertTrue((String)("Not found in " + pendingScopes), (boolean)pendingScopes.contains(TaggingServiceImplTest.this.subFolder));
                return null;
            }
        });
        updateTagsAction.unlockTagScope(this.folder, testData.lockF);
        updateTagsAction.unlockTagScope(this.subFolder, testData.lockSF);
        UpdateTagScopesQuartzJob job = new UpdateTagScopesQuartzJob();
        job.execute(this.actionService, updateTagsAction);
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                Assert.assertEquals((int)0, (int)updateTagsAction.searchForTagScopesPendingUpdates().size());
                TagScope ts1 = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.folder);
                TagScope ts2 = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.subFolder);
                Assert.assertEquals((String)("Wrong tags on folder tagscope: " + ts1.getTags()), (int)3, (int)ts1.getTags().size());
                Assert.assertEquals((String)("Wrong tags on folder tagscope: " + ts1.getTags()), (int)2, (int)ts2.getTags().size());
                Assert.assertEquals((int)4, (int)ts1.getTag(TaggingServiceImplTest.TAG_1).getCount());
                Assert.assertEquals((int)1, (int)ts1.getTag(TaggingServiceImplTest.TAG_2).getCount());
                Assert.assertEquals((int)1, (int)ts1.getTag(TaggingServiceImplTest.TAG_3.toLowerCase()).getCount());
                Assert.assertEquals((int)2, (int)ts2.getTag(TaggingServiceImplTest.TAG_1).getCount());
                Assert.assertEquals((int)1, (int)ts2.getTag(TaggingServiceImplTest.TAG_2).getCount());
                return null;
            }
        });
    }

    public void testMultiThreaded() throws Exception {
        String[] tags;
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTagScope(TaggingServiceImplTest.this.folder);
                TaggingServiceImplTest.this.taggingService.addTagScope(TaggingServiceImplTest.this.subFolder);
                return null;
            }
        });
        this.asyncOccurs.wantedActionsCount = 0;
        ArrayList<Thread> threads = new ArrayList<Thread>();
        String[] arr$ = tags = new String[]{TAG_1, TAG_2, TAG_3, TAG_4, TAG_5, "testTag06", "testTag07", "testTag08", "testTag09", "testTag10", "testTag11", "testTag12", "testTag13", "testTag14", "testTag15", "testTag16", "testTag17", "testTag18", "testTag19", "testTag20"};
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String tmpTag;
            final String tag = tmpTag = arr$[i$];
            Thread t = new Thread(new Runnable(){

                public synchronized void run() {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    logger.debug((Object)(Thread.currentThread() + " - About to start tagging for " + tag));
                    AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
                    RetryingTransactionHelper.RetryingTransactionCallback<Void> txnCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                        @Override
                        public Void execute() throws Throwable {
                            TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.folder, tag);
                            TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subFolder, tag);
                            TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, tag);
                            logger.debug((Object)(Thread.currentThread() + " - Tagging for " + tag));
                            return null;
                        }
                    };
                    try {
                        TaggingServiceImplTest.this.transactionService.getRetryingTransactionHelper().doInTransaction(txnCallback);
                    }
                    catch (Throwable e) {
                        logger.error((Object)("Tagging failed: " + e));
                    }
                    logger.debug((Object)(Thread.currentThread() + " - Done tagging for " + tag));
                    try {
                        Thread.sleep(150L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            threads.add(t);
            t.start();
        }
        logger.info((Object)"Releasing tagging threads");
        for (Thread t : threads) {
            t.interrupt();
        }
        for (Thread t : threads) {
            t.join();
        }
        logger.info((Object)"All threads should have finished");
        Thread.sleep(150L);
        for (int i = 0; i < 600; ++i) {
            try {
                if (this.asyncOccurs.wantedActionsCount < tags.length) {
                    if (i % 50 == 0) {
                        logger.info((Object)("Done " + this.asyncOccurs.wantedActionsCount + " of " + tags.length));
                    }
                    Thread.sleep(100L);
                    continue;
                }
                if (this.actionTrackingService.getAllExecutingActions().size() <= 0) break;
                if (i % 50 == 0) {
                    List<ExecutionSummary> actions = this.actionTrackingService.getAllExecutingActions();
                    logger.info((Object)("Waiting on " + actions.size() + " actions: " + actions));
                }
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        Thread.sleep(175L);
        System.out.println("Done waiting for tagging, now checking");
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TagScope ts1 = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.folder);
                TagScope ts2 = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.subFolder);
                Assert.assertEquals((String)("Wrong tags on folder tagscope: " + ts1.getTags()), (int)tags.length, (int)ts1.getTags().size());
                Assert.assertEquals((String)("Wrong tags on subfolder tagscope: " + ts2.getTags()), (int)tags.length, (int)ts2.getTags().size());
                for (String tag : tags) {
                    Assert.assertEquals((int)3, (int)ts1.getTag(tag.toLowerCase()).getCount());
                    Assert.assertEquals((int)2, (int)ts2.getTag(tag.toLowerCase()).getCount());
                }
                return null;
            }
        });
    }

    static {
        init = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AsyncOccurs
    implements AsynchronousActionExecutionQueuePolicies.OnAsyncActionExecute {
        private Object waitForExecutionLock = new Object();
        private static final long waitTime = 3500L;
        private static final String ACTION_TYPE = "update-tagscope";
        private int wantedActionsCount = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAsyncActionExecute(Action action, NodeRef actionedUponNodeRef) {
            if (action.getActionDefinitionName().equals(ACTION_TYPE)) {
                ++this.wantedActionsCount;
                Object object = this.waitForExecutionLock;
                synchronized (object) {
                    try {
                        this.waitForExecutionLock.notify();
                    }
                    catch (IllegalMonitorStateException e) {
                        // empty catch block
                    }
                }
            }
            System.out.println("Ignoring unexpected async action:" + action);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T awaitExecution(RetryingTransactionHelper.RetryingTransactionCallback<T> callback) throws Exception {
            T returnVal = TaggingServiceImplTest.this.transactionService.getRetryingTransactionHelper().doInTransaction(callback);
            Object object = this.waitForExecutionLock;
            synchronized (object) {
                this.waitForExecutionLock.wait(100L);
                if (TaggingServiceImplTest.this.actionTrackingService.getExecutingActions(ACTION_TYPE).size() > 0) {
                    long now = System.currentTimeMillis();
                    this.waitForExecutionLock.wait(3500L);
                    if (System.currentTimeMillis() - now >= 3500L) {
                        System.err.println("Warning - trigger wasn't received");
                    }
                }
            }
            for (int i = 0; i < 50 && TaggingServiceImplTest.this.actionTrackingService.getExecutingActions(ACTION_TYPE).size() != 0; ++i) {
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            return returnVal;
        }
    }
}

