/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.io.File;
import javax.transaction.UserTransaction;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transfer.TransferFatalException;
import org.alfresco.repo.transfer.TransferModel;
import org.alfresco.repo.transfer.TransferProcessingException;
import org.alfresco.repo.transfer.TransferProgressMonitor;
import org.alfresco.repo.transfer.manifest.TransferManifestDeletedNode;
import org.alfresco.repo.transfer.manifest.TransferManifestHeader;
import org.alfresco.repo.transfer.manifest.TransferManifestNode;
import org.alfresco.repo.transfer.manifest.TransferManifestNormalNode;
import org.alfresco.repo.transfer.manifest.TransferManifestProcessor;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.cmr.transfer.TransferProgress;
import org.alfresco.service.cmr.transfer.TransferReceiver;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractManifestProcessorBase
implements TransferManifestProcessor {
    private static final Log log = LogFactory.getLog(AbstractManifestProcessorBase.class);
    private static final String MSG_ERROR_WHILE_COMMITTING_TRANSFER = "transfer_service.receiver.error_committing_transfer";
    private TransferReceiver receiver;
    private String transferId;
    private int targetEndProgress;
    private int currProgress;

    public AbstractManifestProcessorBase(TransferReceiver receiver, String transferId) {
        this.receiver = receiver;
        this.transferId = transferId;
    }

    public final void endTransferManifest() {
        this.receiver.getProgressMonitor().updateProgress(this.transferId, this.targetEndProgress);
        try {
            this.endManifest();
        }
        catch (Throwable ex) {
            this.handleException(null, ex);
        }
    }

    protected abstract void endManifest();

    public final void processTransferManifestNode(TransferManifestNormalNode node) {
        this.incrementNodeCounter();
        try {
            this.processNode(node);
        }
        catch (Throwable ex) {
            this.handleException(node, ex);
        }
    }

    protected abstract void processNode(TransferManifestNormalNode var1) throws TransferProcessingException;

    public final void processTransferManifestNode(TransferManifestDeletedNode node) {
        this.incrementNodeCounter();
        try {
            this.processNode(node);
        }
        catch (Throwable ex) {
            this.handleException(node, ex);
        }
    }

    protected abstract void processNode(TransferManifestDeletedNode var1) throws TransferProcessingException;

    public final void processTransferManifiestHeader(TransferManifestHeader header) {
        TransferProgressMonitor progressMonitor = this.receiver.getProgressMonitor();
        TransferProgress progress = progressMonitor.getProgress(this.transferId);
        int newEndPos = progress.getEndPosition() + header.getNodeCount();
        progressMonitor.updateProgress(this.transferId, progress.getCurrentPosition(), newEndPos);
        this.targetEndProgress = newEndPos;
        this.currProgress = progress.getCurrentPosition();
        try {
            this.processHeader(header);
        }
        catch (Throwable ex) {
            this.handleException(null, ex);
        }
    }

    protected abstract void processHeader(TransferManifestHeader var1);

    public final void startTransferManifest() {
        try {
            this.startManifest();
        }
        catch (Throwable ex) {
            this.handleException(null, ex);
        }
    }

    protected abstract void startManifest();

    private void incrementNodeCounter() {
        ++this.currProgress;
        if (this.currProgress % 20 == 0) {
            this.receiver.getProgressMonitor().updateProgress(this.transferId, this.currProgress);
        }
    }

    protected ChildAssociationRef getTemporaryLocation(NodeRef nodeRef) {
        NodeRef parentNodeRef = this.receiver.getTempFolder(this.transferId);
        QName parentAssocType = TransferModel.ASSOC_TRANSFER_ORPHAN;
        QName parentAssocName = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)nodeRef.getId());
        return new ChildAssociationRef(parentAssocType, parentNodeRef, parentAssocName, nodeRef, true, -1);
    }

    protected File getStagingFolder() {
        return this.receiver.getStagingFolder(this.transferId);
    }

    protected TransferReceiver getReceiver() {
        return this.receiver;
    }

    protected String getTransferId() {
        return this.transferId;
    }

    private void handleException(TransferManifestNode node, Throwable ex) {
        try {
            UserTransaction tx = RetryingTransactionHelper.getActiveUserTransaction();
            if (tx != null) {
                tx.setRollbackOnly();
                log.debug((Object)"Successfully marked transaction for rollback.");
            }
        }
        catch (Throwable e) {
            log.warn((Object)"Failed to mark transaction as rollback-only in response to an error", e);
        }
        try {
            TransferProgressMonitor monitor = this.receiver.getProgressMonitor();
            String message = node != null ? "Error while processing incoming node " + node.getNodeRef() : "Error processing commit";
            monitor.logException(this.transferId, message, ex);
        }
        catch (Throwable t) {
            log.warn((Object)"Failed to record exception in transfer log due to an exception", t);
        }
        if (TransferFatalException.class.isAssignableFrom(ex.getClass())) {
            this.callLocalExceptionHandler(node, ex);
            throw (TransferFatalException)((Object)ex);
        }
        if (!TransferException.class.isAssignableFrom(ex.getClass())) {
            this.callLocalExceptionHandler(node, ex);
            throw new TransferFatalException(MSG_ERROR_WHILE_COMMITTING_TRANSFER, ex);
        }
    }

    private void callLocalExceptionHandler(TransferManifestNode node, Throwable ex) {
        try {
            this.localHandleException(node, ex);
        }
        catch (Throwable t) {
            log.warn((Object)"Caught and discarded exception thrown from custom exception handler", t);
        }
    }

    protected void localHandleException(TransferManifestNode node, Throwable ex) {
    }

    protected void logComment(String message) {
        this.receiver.getProgressMonitor().logComment(this.transferId, message);
    }

    protected void logCreated(NodeRef sourceNode, NodeRef destNode, NodeRef newParentNode, String parentPath, boolean orphan) {
        this.receiver.getProgressMonitor().logCreated(this.transferId, sourceNode, destNode, newParentNode, parentPath, orphan);
    }

    protected void logDeleted(NodeRef sourceNode, NodeRef destNode, String parentPath) {
        this.receiver.getProgressMonitor().logDeleted(this.transferId, sourceNode, destNode, parentPath);
    }

    protected void logUpdated(NodeRef sourceNode, NodeRef destNode, String newPath) {
        this.receiver.getProgressMonitor().logUpdated(this.transferId, sourceNode, destNode, newPath);
    }

    protected void logMoved(NodeRef sourceNode, NodeRef destNode, String oldPath, NodeRef newParent, String newPath) {
        this.receiver.getProgressMonitor().logMoved(this.transferId, sourceNode, destNode, oldPath, newParent, newPath);
    }
}

