/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.io.Writer;
import java.util.Map;
import java.util.TreeMap;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transfer.TransferDestinationReportWriter;
import org.alfresco.repo.transfer.TransferProgressMonitor;
import org.alfresco.repo.transfer.reportd.XMLTransferDestinationReportWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.cmr.transfer.TransferProgress;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractTransferProgressMonitor
implements TransferProgressMonitor {
    private static final Log log = LogFactory.getLog(AbstractTransferProgressMonitor.class);
    protected static final String MSG_TRANSFER_NOT_FOUND = "transfer_service.receiver.transfer_not_found";
    protected static final String MSG_TRANSFER_CANCELLED = "transfer_service.receiver.transfer_cancelled";
    private Map<String, TransferDestinationReportWriter> transferLogWriters = new TreeMap<String, TransferDestinationReportWriter>();
    private TransactionService transactionService;

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public TransferProgress getProgress(final String transferId) throws TransferException {
        return this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<TransferProgress>(){

            @Override
            public TransferProgress execute() throws Throwable {
                return AbstractTransferProgressMonitor.this.getProgressInternal(transferId);
            }
        }, false, true);
    }

    protected abstract TransferProgress getProgressInternal(String var1);

    public void updateProgress(final String transferId, final int currPos, final int endPos) throws TransferException {
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                AbstractTransferProgressMonitor.this.updateProgressInternal(transferId, currPos, endPos);
                return null;
            }
        }, false, true);
    }

    protected abstract void updateProgressInternal(String var1, int var2, int var3);

    public void updateProgress(final String transferId, final int currPos) throws TransferException {
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                AbstractTransferProgressMonitor.this.updateProgressInternal(transferId, currPos);
                return null;
            }
        }, false, true);
    }

    protected abstract void updateProgressInternal(String var1, int var2);

    public final void updateStatus(final String transferId, final TransferProgress.Status status) throws TransferException {
        TransferProgress.Status currentStatus = this.getProgress(transferId).getStatus();
        if (!TransferProgress.getTerminalStatuses().contains((Object)currentStatus)) {
            this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                @Override
                public Void execute() throws Throwable {
                    TransferDestinationReportWriter writer = AbstractTransferProgressMonitor.this.getLogWriter(transferId);
                    writer.writeChangeState(status.toString());
                    AbstractTransferProgressMonitor.this.updateStatusInternal(transferId, status);
                    if (TransferProgress.getTerminalStatuses().contains((Object)status)) {
                        log.debug((Object)"closing destination transfer report");
                        writer.endTransferReport();
                        AbstractTransferProgressMonitor.this.transferLogWriters.remove(transferId);
                    }
                    return null;
                }
            }, false, true);
        }
    }

    protected abstract void updateStatusInternal(String var1, TransferProgress.Status var2);

    public void logComment(String transferId, Object obj) {
        TransferDestinationReportWriter writer = this.getLogWriter(transferId);
        writer.writeComment(obj.toString());
    }

    public void logException(final String transferId, Object obj, final Throwable ex) {
        TransferDestinationReportWriter writer = this.getLogWriter(transferId);
        writer.writeComment(obj.toString());
        if (ex != null) {
            this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                @Override
                public Void execute() throws Throwable {
                    AbstractTransferProgressMonitor.this.storeError(transferId, ex);
                    return null;
                }
            }, false, true);
            writer.writeException(ex);
        }
    }

    protected abstract void storeError(String var1, Throwable var2);

    public void logCreated(String transferId, NodeRef sourceNode, NodeRef destNode, NodeRef parentNodeRef, String parentPath, boolean orphan) {
        TransferDestinationReportWriter writer = this.getLogWriter(transferId);
        writer.writeCreated(sourceNode, destNode, parentNodeRef, parentPath);
    }

    public void logUpdated(String transferId, NodeRef sourceNodeRef, NodeRef destNodeRef, String path) {
        TransferDestinationReportWriter writer = this.getLogWriter(transferId);
        writer.writeUpdated(sourceNodeRef, destNodeRef, path);
    }

    public void logMoved(String transferId, NodeRef sourceNodeRef, NodeRef destNodeRef, String oldPath, NodeRef newParentNodeRef, String newPath) {
        TransferDestinationReportWriter writer = this.getLogWriter(transferId);
        writer.writeMoved(sourceNodeRef, destNodeRef, oldPath, newParentNodeRef, newPath);
    }

    public void logDeleted(String transferId, NodeRef sourceNodeRef, NodeRef destNodeRef, String oldPath) {
        TransferDestinationReportWriter writer = this.getLogWriter(transferId);
        writer.writeDeleted(sourceNodeRef, destNodeRef, oldPath);
    }

    private TransferDestinationReportWriter getLogWriter(String transferId) {
        TransferDestinationReportWriter writer = this.transferLogWriters.get(transferId);
        if (writer == null) {
            writer = new XMLTransferDestinationReportWriter();
            writer.startTransferReport("UTF-8", this.createUnderlyingLogWriter(transferId));
            this.transferLogWriters.put(transferId, writer);
        }
        return writer;
    }

    protected abstract Writer createUnderlyingLogWriter(String var1);
}

