/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.alfresco.repo.transfer.AbstractManifestProcessorBase;
import org.alfresco.repo.transfer.CorrespondingNodeResolver;
import org.alfresco.repo.transfer.TransferCommons;
import org.alfresco.repo.transfer.TransferModel;
import org.alfresco.repo.transfer.manifest.TransferManifestDeletedNode;
import org.alfresco.repo.transfer.manifest.TransferManifestHeader;
import org.alfresco.repo.transfer.manifest.TransferManifestNormalNode;
import org.alfresco.repo.transfer.requisite.TransferRequsiteWriter;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.transfer.TransferReceiver;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepoRequisiteManifestProcessorImpl
extends AbstractManifestProcessorBase {
    private NodeService nodeService;
    private CorrespondingNodeResolver nodeResolver;
    private TransferRequsiteWriter out;
    private static final Log log = LogFactory.getLog(RepoRequisiteManifestProcessorImpl.class);

    public RepoRequisiteManifestProcessorImpl(TransferReceiver receiver, String transferId, TransferRequsiteWriter out) {
        super(receiver, transferId);
        this.out = out;
    }

    protected void endManifest() {
        log.debug((Object)"End Requsite");
        this.out.endTransferRequsite();
    }

    protected void processNode(TransferManifestDeletedNode node) {
    }

    protected void processNode(TransferManifestNormalNode node) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing node with incoming noderef of " + node.getNodeRef()));
        }
        this.logComment("Requisite Processing incoming node: " + node.getNodeRef() + " --  Source path = " + node.getParentPath() + "/" + node.getPrimaryParentAssoc().getQName());
        ChildAssociationRef primaryParentAssoc = node.getPrimaryParentAssoc();
        CorrespondingNodeResolver.ResolvedParentChildPair resolvedNodes = this.nodeResolver.resolveCorrespondingNode(node.getNodeRef(), primaryParentAssoc, node.getParentPath());
        if (resolvedNodes.resolvedChild != null) {
            NodeRef destinationNode = resolvedNodes.resolvedChild;
            Map destinationProps = this.nodeService.getProperties(destinationNode);
            for (Map.Entry<QName, Serializable> propEntry : node.getProperties().entrySet()) {
                ContentData srcContent;
                Serializable value = propEntry.getValue();
                QName propName = propEntry.getKey();
                if (log.isDebugEnabled() && value == null) {
                    log.debug((Object)("Received a null value for property " + propName));
                }
                if (value == null || !ContentData.class.isAssignableFrom(value.getClass()) || (srcContent = (ContentData)value).getContentUrl() == null || srcContent.getContentUrl().isEmpty()) continue;
                String partName = TransferCommons.URLToPartName(srcContent.getContentUrl());
                Serializable destSer = (Serializable)destinationProps.get(propName);
                if (destSer != null && ContentData.class.isAssignableFrom(destSer.getClass())) {
                    ContentData destContent = (ContentData)destSer;
                    Serializable destFromContents = (Serializable)destinationProps.get(TransferModel.PROP_FROM_CONTENT);
                    if (destFromContents != null && Collection.class.isAssignableFrom(destFromContents.getClass())) {
                        Collection contents = (Collection)((Object)destFromContents);
                        if (contents.contains(partName)) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("part already transferred, no need to send it again, partName:" + partName + ", nodeRef:" + node.getNodeRef()));
                            continue;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("part name not transferred, requesting new content item partName:" + partName + ", nodeRef:" + node.getNodeRef()));
                        }
                        this.out.missingContent(node.getNodeRef(), propEntry.getKey(), TransferCommons.URLToPartName(srcContent.getContentUrl()));
                        continue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("from contents is null, requesting new content item partName:" + partName + ", nodeRef:" + node.getNodeRef()));
                    }
                    this.out.missingContent(node.getNodeRef(), propEntry.getKey(), TransferCommons.URLToPartName(srcContent.getContentUrl()));
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("no content on destination, all content is required" + propEntry.getKey() + srcContent.getContentUrl()));
                }
                this.out.missingContent(node.getNodeRef(), propEntry.getKey(), TransferCommons.URLToPartName(srcContent.getContentUrl()));
            }
        } else {
            log.debug((Object)("Node does not exist on destination nodeRef:" + node.getNodeRef()));
            for (Map.Entry<QName, Serializable> propEntry : node.getProperties().entrySet()) {
                ContentData srcContent;
                Serializable value = propEntry.getValue();
                if (log.isDebugEnabled() && value == null) {
                    log.debug((Object)("Received a null value for property " + propEntry.getKey()));
                }
                if (value == null || !ContentData.class.isAssignableFrom(value.getClass()) || (srcContent = (ContentData)value).getContentUrl() == null || srcContent.getContentUrl().isEmpty()) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("no node on destination, content is required" + propEntry.getKey() + srcContent.getContentUrl()));
                }
                this.out.missingContent(node.getNodeRef(), propEntry.getKey(), TransferCommons.URLToPartName(srcContent.getContentUrl()));
            }
        }
    }

    protected void processHeader(TransferManifestHeader header) {
    }

    protected void startManifest() {
        log.debug((Object)"Start Requsite");
        this.out.startTransferRequsite();
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setNodeResolver(CorrespondingNodeResolver nodeResolver) {
        this.nodeResolver = nodeResolver;
    }
}

