/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import org.alfresco.repo.transfer.TransferVersionChecker;
import org.alfresco.service.cmr.transfer.TransferVersion;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransferVersionCheckerImpl
implements TransferVersionChecker {
    private static Log logger = LogFactory.getLog(TransferVersionCheckerImpl.class);

    public boolean checkTransferVersions(TransferVersion from, TransferVersion to) {
        logger.debug((Object)("checkTransferVersions from:" + from + ", to:" + to));
        if (from == null || to == null || to.getEdition() == null || to.getVersionMajor() == null || to.getVersionMinor() == null) {
            return false;
        }
        if (!from.getEdition().equalsIgnoreCase(to.getEdition())) {
            return false;
        }
        if (!from.getVersionMajor().equalsIgnoreCase(to.getVersionMajor())) {
            return false;
        }
        return from.getVersionMinor().equalsIgnoreCase(to.getVersionMinor());
    }
}

