/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version.common;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.alfresco.repo.version.VersionBaseModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.TypeConverter;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionServiceException;
import org.alfresco.service.cmr.version.VersionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionImpl
implements Version {
    private static final long serialVersionUID = 3257567304324888881L;
    private static final String ERR_NO_NODE_REF = "A valid node reference must be supplied when creating a verison.";
    private Map<String, Serializable> versionProperties = null;
    private NodeRef nodeRef = null;

    public VersionImpl(Map<String, Serializable> versionProperties, NodeRef nodeRef) {
        if (nodeRef == null) {
            throw new VersionServiceException(ERR_NO_NODE_REF);
        }
        this.versionProperties = versionProperties;
        this.nodeRef = nodeRef;
    }

    public String toString() {
        return this.versionProperties.toString();
    }

    @Override
    public Date getFrozenModifiedDate() {
        Date modifiedDate = (Date)this.versionProperties.get("frozenModified");
        if (modifiedDate == null) {
            modifiedDate = (Date)this.versionProperties.get(VersionBaseModel.PROP_CREATED_DATE);
        }
        return modifiedDate;
    }

    @Override
    public String getFrozenModifier() {
        String modifier = (String)((Object)this.versionProperties.get("frozenModifier"));
        if (modifier == null) {
            modifier = (String)((Object)this.versionProperties.get(VersionBaseModel.PROP_CREATOR));
        }
        return modifier;
    }

    @Override
    public Date getCreatedDate() {
        return this.getFrozenModifiedDate();
    }

    @Override
    public String getCreator() {
        return this.getFrozenModifier();
    }

    @Override
    public String getVersionLabel() {
        return (String)((Object)this.versionProperties.get("versionLabel"));
    }

    @Override
    public VersionType getVersionType() {
        return (VersionType)((Object)DefaultTypeConverter.INSTANCE.convert(VersionType.class, (Object)this.versionProperties.get("versionType")));
    }

    @Override
    public String getDescription() {
        return (String)((Object)this.versionProperties.get("description"));
    }

    @Override
    public Map<String, Serializable> getVersionProperties() {
        return this.versionProperties;
    }

    @Override
    public Serializable getVersionProperty(String name) {
        Serializable result = null;
        if (this.versionProperties != null) {
            result = this.versionProperties.get(name);
        }
        return result;
    }

    @Override
    public NodeRef getVersionedNodeRef() {
        NodeRef versionedNodeRef = null;
        if (this.nodeRef.getStoreRef().getIdentifier().equals("version2Store")) {
            versionedNodeRef = (NodeRef)this.versionProperties.get("frozenNodeRef");
        } else if (this.nodeRef.getStoreRef().getIdentifier().equals("lightWeightVersionStore")) {
            String storeProtocol = (String)((Object)this.versionProperties.get("frozenNodeStoreProtocol"));
            String storeId = (String)((Object)this.versionProperties.get("frozenNodeStoreId"));
            String nodeId = (String)((Object)this.versionProperties.get("frozenNodeId"));
            versionedNodeRef = new NodeRef(new StoreRef(storeProtocol, storeId), nodeId);
        }
        return versionedNodeRef;
    }

    @Override
    public NodeRef getFrozenStateNodeRef() {
        return this.nodeRef;
    }

    static {
        DefaultTypeConverter.INSTANCE.addConverter(String.class, VersionType.class, (TypeConverter.Converter)new TypeConverter.Converter<String, VersionType>(){

            public VersionType convert(String source) {
                return VersionType.valueOf(source);
            }
        });
        DefaultTypeConverter.INSTANCE.addConverter(VersionType.class, String.class, (TypeConverter.Converter)new TypeConverter.Converter<VersionType, String>(){

            public String convert(VersionType source) {
                return source.toString();
            }
        });
    }
}

