/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version.common;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.version.Version2Model;
import org.alfresco.repo.version.VersionBaseModel;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.version.ReservedVersionNameException;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionUtil {
    public static final String[] RESERVED_PROPERTY_NAMES = new String[]{"frozenNodeId", "frozenNodeStoreId", "frozenNodeStoreProtocol", "frozenNodeType", "frozenAspects", VersionBaseModel.PROP_CREATED_DATE, "versionLabel", "versionNumber", "versionDescription", "frozenNodeDbId", "frozenCreated", "frozenCreator", "frozenModified", "frozenModifier", "frozenAccessed"};

    public static void checkVersionPropertyNames(Collection<String> names) throws ReservedVersionNameException {
        for (String name : RESERVED_PROPERTY_NAMES) {
            if (!names.contains(name)) continue;
            throw new ReservedVersionNameException(name);
        }
    }

    public static StoreRef convertStoreRef(StoreRef storeRef) {
        return new StoreRef("workspace", storeRef.getIdentifier());
    }

    public static NodeRef convertNodeRef(NodeRef nodeRef) {
        return new NodeRef(VersionUtil.convertStoreRef(nodeRef.getStoreRef()), nodeRef.getId());
    }

    public static void convertFrozenToOriginalProps(Map<QName, Serializable> props) throws InvalidNodeRefException {
        if (props != null) {
            props.remove(Version2Model.PROP_QNAME_VERSION_DESCRIPTION);
            props.remove(Version2Model.PROP_QNAME_VERSION_NUMBER);
            HashSet<QName> keys = new HashSet<QName>(props.keySet());
            for (QName key : keys) {
                String keyName = key.getLocalName();
                int idx = keyName.indexOf("metadata-");
                if (idx != 0) continue;
                props.remove(key);
            }
            String versionLabel = (String)((Object)props.get(Version2Model.PROP_QNAME_VERSION_LABEL));
            props.put(ContentModel.PROP_VERSION_LABEL, (Serializable)((Object)versionLabel));
            props.remove(Version2Model.PROP_QNAME_VERSION_LABEL);
            NodeRef nodeRef = (NodeRef)props.get(Version2Model.PROP_QNAME_FROZEN_NODE_REF);
            if (nodeRef != null) {
                props.put(ContentModel.PROP_STORE_PROTOCOL, (Serializable)((Object)nodeRef.getStoreRef().getProtocol()));
                props.put(ContentModel.PROP_STORE_IDENTIFIER, (Serializable)((Object)nodeRef.getStoreRef().getIdentifier()));
                props.put(ContentModel.PROP_NODE_UUID, (Serializable)((Object)nodeRef.getId()));
            }
            props.remove(Version2Model.PROP_QNAME_FROZEN_NODE_REF);
            Long dbid = (Long)props.get(Version2Model.PROP_QNAME_FROZEN_NODE_DBID);
            props.put(ContentModel.PROP_NODE_DBID, dbid);
            props.remove(Version2Model.PROP_QNAME_FROZEN_NODE_DBID);
            String creator = (String)((Object)props.get(Version2Model.PROP_QNAME_FROZEN_CREATOR));
            if (creator != null) {
                props.put(ContentModel.PROP_CREATOR, (Serializable)((Object)creator));
            }
            props.remove(Version2Model.PROP_QNAME_FROZEN_CREATOR);
            Date created = (Date)props.get(Version2Model.PROP_QNAME_FROZEN_CREATED);
            if (created != null) {
                props.put(ContentModel.PROP_CREATED, created);
            }
            props.remove(Version2Model.PROP_QNAME_FROZEN_CREATED);
            String modifier = (String)((Object)props.get(Version2Model.PROP_QNAME_FROZEN_MODIFIER));
            if (modifier != null) {
                props.put(ContentModel.PROP_MODIFIER, (Serializable)((Object)modifier));
            }
            props.remove(Version2Model.PROP_QNAME_FROZEN_MODIFIER);
            Date modified = (Date)props.get(Version2Model.PROP_QNAME_FROZEN_MODIFIED);
            if (modified != null) {
                props.put(ContentModel.PROP_MODIFIED, modified);
            }
            props.remove(Version2Model.PROP_QNAME_FROZEN_MODIFIED);
            Date accessed = (Date)props.get(Version2Model.PROP_QNAME_FROZEN_ACCESSED);
            if (accessed != null) {
                props.put(ContentModel.PROP_ACCESSED, accessed);
            }
            props.remove(Version2Model.PROP_QNAME_FROZEN_ACCESSED);
        }
    }
}

