/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.alfresco.service.cmr.workflow.WorkflowAdminService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowAdminServiceImpl
implements WorkflowAdminService {
    public static final String NAME = "workflowAdminService";
    public static final String ENGINE = "engineId";
    public static final String ENABLED = "enabled";
    public static final String VISIBLE = "visible";
    private Set<String> enabledEngines = new HashSet<String>();
    private Set<String> visibleEngines = new HashSet<String>();

    @Override
    public boolean isEngineEnabled(String engineId) {
        return this.enabledEngines.contains(engineId);
    }

    public void setEngineEnabled(String engineId, boolean isEnabled) {
        if (isEnabled) {
            this.enabledEngines.add(engineId);
        } else {
            this.enabledEngines.remove(engineId);
        }
    }

    @Override
    public boolean isEngineVisible(String engineId) {
        return this.isEngineEnabled(engineId) && this.visibleEngines.contains(engineId);
    }

    public void setEngineVisibility(String engineId, boolean isVisible) {
        if (isVisible) {
            this.visibleEngines.add(engineId);
        } else {
            this.visibleEngines.remove(engineId);
        }
    }

    public void setEnabledEngines(Collection<String> engines) {
        if (!this.enabledEngines.isEmpty()) {
            this.enabledEngines.clear();
        }
        this.enabledEngines.addAll(engines);
    }

    public Set<String> getEnabledEngines() {
        return new HashSet<String>(this.enabledEngines);
    }

    public void setVisibleEngines(Collection<String> engines) {
        if (!this.visibleEngines.isEmpty()) {
            this.visibleEngines.clear();
        }
        this.visibleEngines.addAll(engines);
    }

    public Set<String> getVisibleEngines() {
        return new HashSet<String>(this.visibleEngines);
    }

    public void setWorkflowEngineConfigurations(List<Properties> props) {
        for (Properties prop : props) {
            String isVisible;
            String engineId = prop.getProperty(ENGINE);
            String isEnabled = (String)prop.get(ENABLED);
            if (isEnabled != null) {
                this.setEngineEnabled(engineId, Boolean.valueOf(isEnabled));
            }
            if ((isVisible = (String)prop.get(VISIBLE)) == null) continue;
            this.setEngineVisibility(engineId, Boolean.valueOf(isVisible));
        }
    }
}

