/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow;

import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.alfresco.service.Auditable;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowDeployment;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskDefinition;
import org.alfresco.service.cmr.workflow.WorkflowTimer;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface WorkflowComponent {
    public WorkflowDeployment deployDefinition(InputStream var1, String var2);

    public WorkflowDeployment deployDefinition(InputStream var1, String var2, String var3);

    public boolean isDefinitionDeployed(InputStream var1, String var2);

    public void undeployDefinition(String var1);

    public List<WorkflowDefinition> getDefinitions();

    @Auditable
    public List<WorkflowDefinition> getAllDefinitions();

    public WorkflowDefinition getDefinitionById(String var1);

    public WorkflowDefinition getDefinitionByName(String var1);

    @Auditable(parameters={"workflowName"})
    public List<WorkflowDefinition> getAllDefinitionsByName(String var1);

    @Auditable(parameters={"workflowDefinitionId"})
    public byte[] getDefinitionImage(String var1);

    @Auditable(parameters={"workflowDefinitionId"})
    public List<WorkflowTaskDefinition> getTaskDefinitions(String var1);

    public WorkflowPath startWorkflow(String var1, Map<QName, Serializable> var2);

    public List<WorkflowInstance> getActiveWorkflows(String var1);

    public List<WorkflowInstance> getCompletedWorkflows(String var1);

    public List<WorkflowInstance> getWorkflows(String var1);

    public List<WorkflowInstance> getActiveWorkflows();

    public List<WorkflowInstance> getCompletedWorkflows();

    public List<WorkflowInstance> getWorkflows();

    public WorkflowInstance getWorkflowById(String var1);

    public List<WorkflowPath> getWorkflowPaths(String var1);

    public Map<QName, Serializable> getPathProperties(String var1);

    public WorkflowInstance cancelWorkflow(String var1);

    public WorkflowInstance deleteWorkflow(String var1);

    public WorkflowPath signal(String var1, String var2);

    public WorkflowPath fireEvent(String var1, String var2);

    public List<WorkflowTask> getTasksForWorkflowPath(String var1);

    public List<WorkflowTimer> getTimers(String var1);

    public boolean hasWorkflowImage(String var1);

    public InputStream getWorkflowImage(String var1);
}

